/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class EnemyHudClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve("enemy_hud_client.json");
    public boolean showHealthbarOnNearbyHpChanges = true;
    private static EnemyHudClientConfig INSTANCE;

    private EnemyHudClientConfig() {
    }

    public static synchronized EnemyHudClientConfig get() {
        if (INSTANCE == null) {
            boolean needSave = false;
            try {
                if (Files.exists(FILE, new LinkOption[0])) {
                    INSTANCE = (EnemyHudClientConfig)GSON.fromJson(Files.readString(FILE), EnemyHudClientConfig.class);
                    if (INSTANCE == null) {
                        INSTANCE = new EnemyHudClientConfig();
                        needSave = true;
                    }
                } else {
                    INSTANCE = new EnemyHudClientConfig();
                    needSave = true;
                }
            }
            catch (Exception e) {
                INSTANCE = new EnemyHudClientConfig();
                needSave = true;
            }
            if (needSave) {
                EnemyHudClientConfig.save();
            }
        }
        return INSTANCE;
    }

    public static void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            Files.writeString(FILE, (CharSequence)GSON.toJson((Object)EnemyHudClientConfig.get()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

