/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy.configui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.pixeldreamstudios.rpgsystems.client.enemy.config.DamageTypeConfig;

@Environment(value=EnvType.CLIENT)
public final class DamageTypeConfigScreen
extends class_437 {
    private final class_437 parent;
    private DamageTypeList list;
    private class_4185 saveButton;
    private class_4185 backButton;

    public DamageTypeConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Damage Types"));
        this.parent = parent;
    }

    protected void method_25426() {
        int top = 56;
        int bottomPad = 48;
        int listHeight = this.field_22790 - top - bottomPad;
        if (this.list == null) {
            this.list = new DamageTypeList(this.field_22787, this.field_22789, listHeight, top, 28);
            this.populateEntries();
        } else {
            this.list.method_57714(this.field_22789, listHeight, top);
        }
        this.method_37063((class_364)this.list);
        int cx = this.field_22789 / 2;
        int y = this.field_22790 - 32;
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.applyAndSave();
            this.field_22787.method_1507(this.parent);
        }).method_46434(cx - 120, y, 100, 20).method_46431();
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> this.field_22787.method_1507(this.parent)).method_46434(cx + 20, y, 100, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.backButton);
    }

    private void populateEntries() {
        this.list.wipe();
        DamageTypeConfig cfg = DamageTypeConfig.get();
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        ids.addAll(cfg.showByDamageType.keySet());
        ids.addAll(cfg.colorByDamageType.keySet());
        ArrayList sorted = new ArrayList(ids);
        sorted.sort(Comparator.naturalOrder());
        for (String id : sorted) {
            boolean show = cfg.showByDamageType.getOrDefault(id, true);
            String color = cfg.colorByDamageType.getOrDefault(id, "");
            this.list.addRow(id, show, color);
        }
    }

    private void applyAndSave() {
        DamageTypeConfig cfg = DamageTypeConfig.get();
        cfg.showByDamageType.clear();
        cfg.colorByDamageType.clear();
        for (DamageTypeList.Entry e : this.list.method_25396()) {
            cfg.showByDamageType.put(e.id, e.checkbox.method_20372());
            String raw = e.colorField.method_1882().trim();
            if (raw.isEmpty()) continue;
            cfg.colorByDamageType.put(e.id, raw);
        }
        DamageTypeConfig.save();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_25300(this.field_22793, "Damage Types", this.field_22789 / 2, 20, 0xFFFFFF);
        ctx.method_25300(this.field_22793, "Toggle visibility and set optional color overrides", this.field_22789 / 2, 36, 0xAAAAAA);
    }

    private static final class DamageTypeList
    extends class_350<Entry> {
        private class_342 focusedField;

        DamageTypeList(class_310 client, int width, int height, int top, int itemHeight) {
            super(client, width, height, top, itemHeight);
        }

        public void wipe() {
            this.method_25339();
            this.focusedField = null;
        }

        public void addRow(String id, boolean show, String color) {
            this.method_25321(new Entry(id, show, color));
        }

        public int method_25322() {
            return Math.min(480, this.field_22758 - 24);
        }

        protected void method_47399(class_6382 builder) {
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.focusedField != null && this.focusedField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            if (this.focusedField != null && this.focusedField.method_25400(chr, modifiers)) {
                return true;
            }
            return super.method_25400(chr, modifiers);
        }

        void setFocusedField(class_342 field) {
            if (this.focusedField != null && this.focusedField != field) {
                this.focusedField.method_25365(false);
            }
            this.focusedField = field;
            if (this.focusedField != null) {
                this.focusedField.method_25365(true);
            }
        }

        final class Entry
        extends class_350.class_351<Entry> {
            final String id;
            final class_4286 checkbox;
            final class_342 colorField;

            Entry(String id, boolean show, String color) {
                this.id = id;
                class_327 tr = class_310.method_1551().field_1772;
                this.checkbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)tr).method_54789(0, 0).method_54794(show).method_54788();
                this.colorField = new class_342(tr, 0, 0, 120, 20, (class_2561)class_2561.method_43470((String)""));
                this.colorField.method_1852(color == null ? "" : color);
                this.colorField.method_1880(16);
                this.colorField.method_47404((class_2561)class_2561.method_43470((String)"Hex (e.g. FF0000)"));
            }

            public void method_25343(class_332 ctx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                int left;
                int checkX = left = x + 6;
                int labelX = checkX + 18;
                int fieldW = 120;
                int fieldX = x + entryWidth - fieldW - 12;
                int fieldY = y + 4;
                this.checkbox.method_48229(checkX, y + 5);
                this.checkbox.method_25394(ctx, mouseX, mouseY, tickDelta);
                class_327 tr = class_310.method_1551().field_1772;
                ctx.method_25303(tr, this.id, labelX, y + 8, 0xFFFFFF);
                this.colorField.method_46421(fieldX);
                this.colorField.method_46419(fieldY);
                this.colorField.method_25358(fieldW);
                this.colorField.method_25394(ctx, mouseX, mouseY, tickDelta);
                Integer rgb = this.previewColor();
                if (rgb != null) {
                    int swatch = 12;
                    int sx1 = fieldX - 16;
                    int sy1 = y + 6;
                    ctx.method_25294(sx1, sy1, sx1 + swatch, sy1 + swatch, 0xFF000000 | rgb & 0xFFFFFF);
                }
            }

            private Integer previewColor() {
                try {
                    String s = this.colorField.method_1882();
                    if (s == null) {
                        return null;
                    }
                    if ((s = s.trim()).isEmpty()) {
                        return null;
                    }
                    if (s.startsWith("#")) {
                        s = s.substring(1);
                    }
                    if (s.startsWith("0x") || s.startsWith("0X")) {
                        s = s.substring(2);
                    }
                    int rgb = (int)Long.parseLong(s, 16);
                    return rgb & 0xFFFFFF;
                }
                catch (Exception e) {
                    return null;
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.colorField.method_25402(mouseX, mouseY, button)) {
                    DamageTypeList.this.setFocusedField(this.colorField);
                    return true;
                }
                if (this.checkbox.method_25402(mouseX, mouseY, button)) {
                    DamageTypeList.this.setFocusedField(null);
                    return true;
                }
                if (button == 0 && this.method_25405(mouseX, mouseY)) {
                    this.checkbox.method_20372();
                    DamageTypeList.this.setFocusedField(null);
                    return true;
                }
                return false;
            }

            public boolean method_25406(double mouseX, double mouseY, int button) {
                if (this.colorField.method_25406(mouseX, mouseY, button)) {
                    return true;
                }
                return this.checkbox.method_25406(mouseX, mouseY, button);
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                return this.colorField.method_25404(keyCode, scanCode, modifiers);
            }

            public boolean method_25400(char chr, int modifiers) {
                return this.colorField.method_25400(chr, modifiers);
            }
        }
    }
}

