/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;

@Environment(value=EnvType.CLIENT)
public final class ClientPartyHighlighter {
    private static final class_310 MC = class_310.method_1551();
    private static boolean enabled = false;
    private static final Map<UUID, Integer> COLOR_CACHE = new HashMap<UUID, Integer>();

    private ClientPartyHighlighter() {
    }

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!enabled) {
                return;
            }
            class_746 self = ClientPartyHighlighter.MC.field_1724;
            if (self == null) {
                return;
            }
            COLOR_CACHE.keySet().removeIf(u -> !ClientPartyHudData.isMember(u));
        });
    }

    public static void toggle() {
        enabled = !enabled;
        class_746 p = ClientPartyHighlighter.MC.field_1724;
        if (p != null) {
            p.method_7353((class_2561)class_2561.method_43470((String)(enabled ? "Party highlight: ON" : "Party highlight: OFF")), true);
        }
    }

    public static void disable() {
        enabled = false;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean shouldGlow(class_1297 e) {
        if (!enabled) {
            return false;
        }
        if (!(e instanceof class_1657)) {
            return false;
        }
        if (MC == null || ClientPartyHighlighter.MC.field_1724 == null) {
            return false;
        }
        if (e.method_5628() == ClientPartyHighlighter.MC.field_1724.method_5628()) {
            return false;
        }
        return ClientPartyHudData.isMember(e.method_5667());
    }

    public static int getColor(class_1297 e) {
        UUID id = e.method_5667();
        return COLOR_CACHE.computeIfAbsent(id, ClientPartyHighlighter::colorForUuid);
    }

    private static int colorForUuid(UUID u) {
        long hbits = u.getMostSignificantBits() ^ u.getLeastSignificantBits();
        float hue = (float)((hbits & 0xFFFFFFFFL) % 360L) / 360.0f;
        float sat = 0.8f;
        float lit = 0.55f;
        return ClientPartyHighlighter.hslToRgb(hue, sat, lit);
    }

    private static int hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ClientPartyHighlighter.hue2rgb(p, q, h + 0.33333334f);
            g = ClientPartyHighlighter.hue2rgb(p, q, h);
            b = ClientPartyHighlighter.hue2rgb(p, q, h - 0.33333334f);
        }
        int R = Math.min(255, Math.max(0, Math.round(r * 255.0f)));
        int G = Math.min(255, Math.max(0, Math.round(g * 255.0f)));
        int B = Math.min(255, Math.max(0, Math.round(b * 255.0f)));
        return R << 16 | G << 8 | B;
    }

    private static float hue2rgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }
}

