/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class PartyHudClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "rpgsystems_partyhud_client.json";
    private static PartyHudClientConfig INSTANCE;
    public boolean hudEnabled = true;
    public boolean showArrows = true;
    public boolean showHpBar = true;
    public boolean showHungerBar = true;
    public boolean showStaminaBar = false;
    public boolean showManaBar = false;
    public boolean showRpgManaBar = false;
    public int partyHudX = -2;
    public int partyHudY = 10;
    public float hudScale = 1.0f;
    public int maxVisiblePartyHuds = -1;
    public HudStyle hudStyle = HudStyle.ORIGINAL;

    private static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve(FILE_NAME);
    }

    public static synchronized PartyHudClientConfig get() {
        if (INSTANCE == null) {
            PartyHudClientConfig.load();
        }
        return INSTANCE;
    }

    public static synchronized void load() {
        Path p = PartyHudClientConfig.path();
        boolean needSave = false;
        PartyHudClientConfig loaded = null;
        if (Files.exists(p, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(p);){
                loaded = (PartyHudClientConfig)GSON.fromJson((Reader)r, PartyHudClientConfig.class);
            }
            catch (Throwable t) {
                try {
                    Files.move(p, p.resolveSibling("rpgsystems_partyhud_client.json.bak"), new CopyOption[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                needSave = true;
            }
        } else {
            needSave = true;
        }
        PartyHudClientConfig partyHudClientConfig = INSTANCE = loaded != null ? loaded : new PartyHudClientConfig();
        if (INSTANCE.enforceMaxThreeBars()) {
            needSave = true;
        }
        if (INSTANCE.normalizeVisibilityLimit()) {
            needSave = true;
        }
        if (INSTANCE.normalizeScale()) {
            needSave = true;
        }
        if (PartyHudClientConfig.INSTANCE.hudStyle == null) {
            PartyHudClientConfig.INSTANCE.hudStyle = HudStyle.ORIGINAL;
            needSave = true;
        }
        if (needSave) {
            PartyHudClientConfig.save();
        }
    }

    public static synchronized void save() {
        if (INSTANCE == null) {
            INSTANCE = new PartyHudClientConfig();
        }
        Path p = PartyHudClientConfig.path();
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(p, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean enforceMaxThreeBars() {
        int count = 0;
        if (this.showHpBar) {
            ++count;
        }
        if (this.showHungerBar) {
            ++count;
        }
        if (this.showStaminaBar) {
            ++count;
        }
        if (this.showManaBar) {
            ++count;
        }
        if (this.showRpgManaBar) {
            ++count;
        }
        boolean changed = false;
        if (count > 3 && this.showRpgManaBar) {
            this.showRpgManaBar = false;
            changed = true;
            --count;
        }
        if (count > 3 && this.showManaBar) {
            this.showManaBar = false;
            changed = true;
            --count;
        }
        if (count > 3 && this.showStaminaBar) {
            this.showStaminaBar = false;
            changed = true;
            --count;
        }
        if (count > 3 && this.showHungerBar) {
            this.showHungerBar = false;
            changed = true;
            --count;
        }
        if (count > 3 && this.showHpBar) {
            this.showHpBar = false;
            changed = true;
        }
        return changed;
    }

    public boolean normalizeVisibilityLimit() {
        int prev = this.maxVisiblePartyHuds;
        if (this.maxVisiblePartyHuds < -1) {
            this.maxVisiblePartyHuds = -1;
        }
        return prev != this.maxVisiblePartyHuds;
    }

    public boolean normalizeScale() {
        float prev = this.hudScale;
        if (this.hudScale <= 0.0f) {
            this.hudScale = 1.0f;
        }
        if (this.hudScale < 0.1f) {
            this.hudScale = 0.1f;
        }
        return Float.compare(prev, this.hudScale) != 0;
    }

    public static enum HudStyle {
        ORIGINAL,
        SIMPLE;

    }
}

