/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.configui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.pixeldreamstudios.rpgsystems.client.party.config.PartyHudClientConfig;

@Environment(value=EnvType.CLIENT)
public final class PartyHudOptionsScreen
extends class_437 {
    private final class_437 parent;
    private class_4286 showRpgMana;
    private boolean rpgManaAvailable;
    private class_4286 hudEnabled;
    private class_4286 showArrows;
    private class_4286 showHp;
    private class_4286 showHunger;
    private class_4286 showStamina;
    private class_4286 showMana;
    private class_4185 styleButton;
    private PartyHudClientConfig.HudStyle localStyle;
    private class_342 hudXField;
    private class_342 hudYField;
    private class_342 hudScaleField;
    private class_342 maxHudCountField;
    private int yMaxHuds;
    private boolean staminaAvailable;
    private boolean manaAvailable;
    private String warning = "";
    private int yStart;
    private int formHeight;
    private double scroll;
    private int contentHeight;
    private int yHudEnabled;
    private int yShowArrows;
    private int yHudStyle;
    private int yHudX;
    private int yHudY;
    private int yHudScale;
    private int yShowHp;
    private int yShowHunger;
    private int yShowStamina;
    private int yShowMana;
    private int yShowRpgMana;

    public PartyHudOptionsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Party HUD Options"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.method_37067();
        int centerX = this.field_22789 / 2;
        int w = 280;
        int h = 20;
        this.yStart = 56;
        int buttonsPad = 70;
        this.formHeight = Math.max(60, this.field_22790 - this.yStart - buttonsPad);
        this.staminaAvailable = FabricLoader.getInstance().isModLoaded("staminaattributes");
        this.manaAvailable = FabricLoader.getInstance().isModLoaded("manaattributes");
        this.rpgManaAvailable = FabricLoader.getInstance().isModLoaded("rpgmana");
        PartyHudClientConfig cfg = PartyHudClientConfig.get();
        this.localStyle = cfg.hudStyle;
        int y = this.yStart;
        this.hudEnabled = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Enable Party HUD"), (class_327)this.field_22793).method_54789(centerX - w / 2, y).method_54794(cfg.hudEnabled).method_54788();
        this.yHudEnabled = y;
        this.showArrows = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Directional Arrows"), (class_327)this.field_22793).method_54789(centerX - w / 2, y += 24).method_54794(cfg.showArrows).method_54788();
        this.yShowArrows = y;
        this.styleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("HUD Style: " + this.localStyle.name())), b -> {
            this.localStyle = this.localStyle == PartyHudClientConfig.HudStyle.ORIGINAL ? PartyHudClientConfig.HudStyle.SIMPLE : PartyHudClientConfig.HudStyle.ORIGINAL;
            this.styleButton.method_25355((class_2561)class_2561.method_43470((String)("HUD Style: " + this.localStyle.name())));
        }).method_46437(180, h).method_46433(centerX - w / 2, y += 24).method_46431();
        this.yHudStyle = y;
        int fieldW = 100;
        this.hudXField = new class_342(this.field_22793, centerX - w / 2 + w - fieldW, y += 28, fieldW, h, (class_2561)class_2561.method_43470((String)""));
        this.hudXField.method_1852(String.valueOf(cfg.partyHudX));
        this.yHudX = y;
        this.method_37063((class_364)this.hudXField);
        this.hudYField = new class_342(this.field_22793, centerX - w / 2 + w - fieldW, y += 24, fieldW, h, (class_2561)class_2561.method_43470((String)""));
        this.hudYField.method_1852(String.valueOf(cfg.partyHudY));
        this.yHudY = y;
        this.method_37063((class_364)this.hudYField);
        this.hudScaleField = new class_342(this.field_22793, centerX - w / 2 + w - fieldW, y += 24, fieldW, h, (class_2561)class_2561.method_43470((String)""));
        this.hudScaleField.method_1852(PartyHudOptionsScreen.trimFloat(cfg.hudScale));
        this.yHudScale = y;
        this.method_37063((class_364)this.hudScaleField);
        this.maxHudCountField = new class_342(this.field_22793, centerX - w / 2 + w - fieldW, y += 28, fieldW, h, (class_2561)class_2561.method_43470((String)""));
        this.maxHudCountField.method_1852(String.valueOf(cfg.maxVisiblePartyHuds));
        this.yMaxHuds = y;
        this.method_37063((class_364)this.maxHudCountField);
        this.showHp = class_4286.method_54787((class_2561)class_2561.method_43470((String)"HP Bar"), (class_327)this.field_22793).method_54789(centerX - w / 2, y += 24).method_54794(cfg.showHpBar).method_54788();
        this.yShowHp = y;
        this.showHunger = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Hunger Bar"), (class_327)this.field_22793).method_54789(centerX - w / 2, y += 24).method_54794(cfg.showHungerBar).method_54788();
        this.yShowHunger = y;
        this.showStamina = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Stamina Bar (TheRedBrain)"), (class_327)this.field_22793).method_54789(centerX - w / 2, y += 24).method_54794(cfg.showStaminaBar && this.staminaAvailable).method_54788();
        this.showStamina.field_22763 = this.staminaAvailable;
        this.yShowStamina = y;
        this.showMana = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Mana Bar (TheRedBrain)"), (class_327)this.field_22793).method_54789(centerX - w / 2, y += 24).method_54794(cfg.showManaBar && this.manaAvailable).method_54788();
        this.showMana.field_22763 = this.manaAvailable;
        this.yShowMana = y;
        this.showRpgMana = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Mana (RPGMana)"), (class_327)this.field_22793).method_54789(centerX - w / 2, y += 24).method_54794(cfg.showRpgManaBar && this.rpgManaAvailable).method_54788();
        this.showRpgMana.field_22763 = this.rpgManaAvailable;
        this.yShowRpgMana = y;
        y += 24;
        this.method_37063((class_364)this.styleButton);
        this.method_37063((class_364)this.hudEnabled);
        this.method_37063((class_364)this.showArrows);
        this.method_37063((class_364)this.showHp);
        this.method_37063((class_364)this.showHunger);
        this.method_37063((class_364)this.showStamina);
        this.method_37063((class_364)this.showMana);
        this.method_37063((class_364)this.showRpgMana);
        this.contentHeight = y - this.yStart;
        int btnY = this.yStart + this.formHeight + 16;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.applyAndSave();
            this.field_22787.method_1507(this.parent);
        }).method_46437(100, h).method_46433(centerX - 110, btnY).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46437(100, h).method_46433(centerX + 10, btnY).method_46431());
        this.applyScroll();
    }

    public boolean method_25401(double mouseX, double mouseY, double horiz, double vert) {
        if (mouseY >= (double)this.yStart && mouseY <= (double)(this.yStart + this.formHeight)) {
            this.scroll = this.clampScroll(this.scroll - vert * 18.0);
            this.applyScroll();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horiz, vert);
    }

    private double clampScroll(double s) {
        int max = Math.max(0, this.contentHeight - this.formHeight);
        if (s < 0.0) {
            return 0.0;
        }
        if (s > (double)max) {
            return max;
        }
        return s;
    }

    private boolean inViewportY(int widgetY, int height) {
        int top = this.yStart;
        int bottom = this.yStart + this.formHeight;
        int y1 = widgetY + height;
        return y1 > top && widgetY < bottom;
    }

    private void setVis(class_339 w, boolean v) {
        w.field_22764 = v;
    }

    private void applyScroll() {
        int off = (int)Math.round(this.scroll);
        this.hudEnabled.method_46419(this.yHudEnabled - off);
        this.showArrows.method_46419(this.yShowArrows - off);
        this.styleButton.method_46419(this.yHudStyle - off);
        this.hudXField.method_46419(this.yHudX - off);
        this.hudYField.method_46419(this.yHudY - off);
        this.hudScaleField.method_46419(this.yHudScale - off);
        this.maxHudCountField.method_46419(this.yMaxHuds - off);
        this.showHp.method_46419(this.yShowHp - off);
        this.showHunger.method_46419(this.yShowHunger - off);
        this.showStamina.method_46419(this.yShowStamina - off);
        this.showMana.method_46419(this.yShowMana - off);
        this.showRpgMana.method_46419(this.yShowRpgMana - off);
        int rowH = 20;
        this.setVis((class_339)this.hudEnabled, this.inViewportY(this.hudEnabled.method_46427(), rowH));
        this.setVis((class_339)this.showArrows, this.inViewportY(this.showArrows.method_46427(), rowH));
        this.setVis((class_339)this.styleButton, this.inViewportY(this.styleButton.method_46427(), rowH));
        this.setVis((class_339)this.hudXField, this.inViewportY(this.hudXField.method_46427(), rowH));
        this.setVis((class_339)this.hudYField, this.inViewportY(this.hudYField.method_46427(), rowH));
        this.setVis((class_339)this.hudScaleField, this.inViewportY(this.hudScaleField.method_46427(), rowH));
        this.setVis((class_339)this.maxHudCountField, this.inViewportY(this.maxHudCountField.method_46427(), rowH));
        this.setVis((class_339)this.showHp, this.inViewportY(this.showHp.method_46427(), rowH));
        this.setVis((class_339)this.showHunger, this.inViewportY(this.showHunger.method_46427(), rowH));
        this.setVis((class_339)this.showStamina, this.inViewportY(this.showStamina.method_46427(), rowH));
        this.setVis((class_339)this.showMana, this.inViewportY(this.showMana.method_46427(), rowH));
        this.setVis((class_339)this.showRpgMana, this.inViewportY(this.showRpgMana.method_46427(), rowH));
        this.showStamina.field_22763 = this.staminaAvailable && this.showStamina.field_22764;
        this.showMana.field_22763 = this.manaAvailable && this.showMana.field_22764;
        this.showRpgMana.field_22763 = this.rpgManaAvailable && this.showRpgMana.field_22764;
    }

    private static int parseIntSafe(class_342 f, int fallback) {
        try {
            return Integer.parseInt(f.method_1882().trim());
        }
        catch (Throwable t) {
            return fallback;
        }
    }

    private static float parseFloatSafe(class_342 f, float fallback) {
        try {
            return Float.parseFloat(f.method_1882().trim());
        }
        catch (Throwable t) {
            return fallback;
        }
    }

    private static String trimFloat(float f) {
        String s = Float.toString(f);
        if (s.contains(".")) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    private void applyAndSave() {
        PartyHudClientConfig cfg = PartyHudClientConfig.get();
        cfg.hudEnabled = this.hudEnabled.method_20372();
        cfg.showArrows = this.showArrows.method_20372();
        cfg.showHpBar = this.showHp.method_20372();
        cfg.showHungerBar = this.showHunger.method_20372();
        cfg.showStaminaBar = this.showStamina.method_20372() && this.staminaAvailable;
        cfg.showManaBar = this.showMana.method_20372() && this.manaAvailable;
        cfg.showRpgManaBar = this.showRpgMana.method_20372() && this.rpgManaAvailable;
        cfg.hudStyle = this.localStyle;
        cfg.partyHudX = PartyHudOptionsScreen.parseIntSafe(this.hudXField, cfg.partyHudX);
        cfg.partyHudY = PartyHudOptionsScreen.parseIntSafe(this.hudYField, cfg.partyHudY);
        float parsedScale = PartyHudOptionsScreen.parseFloatSafe(this.hudScaleField, cfg.hudScale);
        if (Float.isNaN(parsedScale) || Float.isInfinite(parsedScale)) {
            parsedScale = cfg.hudScale;
        }
        cfg.hudScale = Math.max(parsedScale, 0.1f);
        int parsedLimit = PartyHudOptionsScreen.parseIntSafe(this.maxHudCountField, cfg.maxVisiblePartyHuds);
        if (parsedLimit < -1) {
            parsedLimit = -1;
        }
        cfg.maxVisiblePartyHuds = parsedLimit;
        cfg.normalizeVisibilityLimit();
        cfg.enforceMaxThreeBars();
        PartyHudClientConfig.save();
    }

    private int currentBarCount() {
        int c = 0;
        if (this.showHp.method_20372()) {
            ++c;
        }
        if (this.showHunger.method_20372()) {
            ++c;
        }
        if (this.showStamina.method_20372()) {
            ++c;
        }
        if (this.showMana.method_20372()) {
            ++c;
        }
        if (this.showRpgMana.method_20372() && this.rpgManaAvailable) {
            ++c;
        }
        return c;
    }

    private boolean wouldExceedIfToggled(class_4286 cb) {
        boolean turningOn;
        boolean bl = turningOn = !cb.method_20372();
        if (!turningOn) {
            return false;
        }
        int projected = this.currentBarCount() + 1;
        return projected > 3;
    }

    private boolean interceptIfLimitHit(double mouseX, double mouseY) {
        if (this.showHp.method_25405(mouseX, mouseY) && this.wouldExceedIfToggled(this.showHp)) {
            this.warning = "You can enable at most 3 bars";
            return true;
        }
        if (this.showHunger.method_25405(mouseX, mouseY) && this.wouldExceedIfToggled(this.showHunger)) {
            this.warning = "You can enable at most 3 bars";
            return true;
        }
        if (this.showStamina.method_25405(mouseX, mouseY) && this.wouldExceedIfToggled(this.showStamina)) {
            this.warning = "You can enable at most 3 bars";
            return true;
        }
        if (this.showMana.method_25405(mouseX, mouseY) && this.wouldExceedIfToggled(this.showMana)) {
            this.warning = "You can enable at most 3 bars";
            return true;
        }
        if (this.showRpgMana.method_25405(mouseX, mouseY) && this.wouldExceedIfToggled(this.showRpgMana)) {
            this.warning = "You can enable at most 3 bars";
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.interceptIfLimitHit(mouseX, mouseY)) {
            return true;
        }
        this.warning = "";
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx, mouseX, mouseY, delta);
        super.method_25394(ctx, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        int w = 280;
        int labelX = centerX - w / 2;
        int labelColor = 0xAAAAAA;
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"At most 3 bars can be active"), this.field_22789 / 2, 36, 0xAAAAAA);
        int off = (int)Math.round(this.scroll);
        int xLabelY = this.yHudX - off;
        int yLabelY = this.yHudY - off;
        int sLabelY = this.yHudScale - off;
        ctx.method_44379(0, this.yStart, this.field_22789, this.yStart + this.formHeight);
        ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"HUD X (from left)"), labelX, xLabelY + 4, labelColor, false);
        ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"HUD Y (from top)"), labelX, yLabelY + 4, labelColor, false);
        ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"HUD Scale (> 0.1)"), labelX, sLabelY + 4, labelColor, false);
        int limitLabelY = this.yMaxHuds - off;
        ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Max visible HUDs (-1 = infinite)"), labelX, limitLabelY + 4, labelColor, false);
        ctx.method_44380();
        if (!this.warning.isEmpty()) {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.warning), this.field_22789 / 2, this.field_22790 - 40, 0xFF5555);
        }
    }
}

