/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9779;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyStatusEffects;
import net.pixeldreamstudios.rpgsystems.client.party.config.PartyHudClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyHud;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyHudRenderer;
import org.joml.Quaternionf;
import org.joml.Vector3f;

final class OriginalHud
implements PartyHudRenderer {
    private static final boolean DEBUG_BOXES = false;
    private static final int PANEL_W = 128;
    private static final int PANEL_H = 32;
    private static final int ROW_GAP = 1;
    private static final float BG_SCALE = 0.75f;
    private static final int PLATE_W = 20;
    private static final int PLATE_INSET = 5;
    private static final int NAME_CHAR_MAX = 20;
    private static final int NAME_PAD_X = 2;
    private static final int NAME_PAD_Y = 1;
    private static final float TEXT_SCALE = 0.25f;
    private static final float PLATE_SHIFT_X = -13.5f;
    private static final int PLATE_SHIFT_Y = -2;
    private static final float LVL_INSET_X = -0.3f;
    private static final int LVL_INSET_Y = 3;
    private static final int LVL_SLOT_W = 14;
    private static final int LVL_PAD_Y = 1;
    private static final int MODEL_LEFT_MARGIN = 15;
    private static final int MODEL_SIZE = 4;
    private static final int BAR_GAP_FROM_MODEL = 3;
    private static final int BAR_RIGHT_PAD = 6;
    private static final int BAR_END_SHORTEN = 20;
    private static final int BAR_H_BASE = 3;
    private static final int BAR_HP_FILL = -13710223;
    private static final int BAR_HUNGER_FILL = -1654272;
    private static final int BAR_STAM_FILL = -1654272;
    private static final int BAR_MANA_FILL = -13330213;
    private static final int BAR_RPGMANA_FILL = -13330213;

    OriginalHud() {
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, PartyHudClientConfig cfg) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1690.field_1842 || mc.field_1724 == null) {
            return;
        }
        PartyHud.ensureBgNearest();
        PartyHud.ensureHudBarTexturesNearest();
        int xAnchor = cfg.partyHudX;
        int yAnchorStart = cfg.partyHudY;
        float hudScale = cfg.hudScale;
        if (hudScale <= 0.1f) {
            hudScale = 0.1f;
        }
        int unscaledRowStep = Math.round(24.0f) + 1;
        int rowStep = Math.round((float)unscaledRowStep * hudScale);
        List<ClientPartyHudData.Member> list = PartyHud.partyMembers();
        if (list.isEmpty()) {
            return;
        }
        int yScreen = yAnchorStart;
        for (ClientPartyHudData.Member m : list) {
            class_4587 mtx = ctx.method_51448();
            mtx.method_22903();
            mtx.method_46416((float)xAnchor, (float)yScreen, 0.0f);
            mtx.method_22905(hudScale, hudScale, 1.0f);
            this.drawRow(ctx, 0, 0, m.uuid, m.name, m.totalLevel, cfg);
            mtx.method_22909();
            yScreen += rowStep;
        }
    }

    private void drawRow(class_332 ctx, int x, int y, UUID uuid, String name, int level, PartyHudClientConfig cfg) {
        List<class_2960> theirEffects;
        class_2960 arrow;
        String display;
        class_2960 bg = PartyHud.isLeader(uuid) ? PartyHud.PARTY_BG_LEADER : PartyHud.PARTY_BG;
        PartyHud.drawTextureScaled(ctx, bg, x, y, 128, 32, 128, 32, 0.75f);
        int scaledW = Math.round(96.0f);
        int scaledH = Math.round(24.0f);
        class_327 tr = class_310.method_1551().field_1772;
        int modelCenterX = x + 15;
        int modelBottomY = y + scaledH / 2 + 2 + 2;
        this.drawMemberModel(ctx, modelCenterX, modelBottomY, 4, uuid, name);
        float lvlSlotXf = (float)x + -0.3f;
        float lvlSlotYf = y + 3;
        int lvlSlotW = 14;
        Objects.requireNonNull(tr);
        int lvlSlotH = Math.max(1, Math.round(9.0f * 0.25f)) + 2;
        Object lvlText = level >= 0 ? "" + level : "?";
        int lvlTextW = Math.round((float)tr.method_1727((String)lvlText) * 0.25f);
        Objects.requireNonNull(tr);
        int lvlTextH = Math.max(1, Math.round(9.0f * 0.25f));
        float lvlTextX = lvlSlotXf + (float)(14 - lvlTextW) / 2.0f;
        float lvlTextY = lvlSlotYf + (float)(lvlSlotH - lvlTextH) / 2.0f;
        PartyHud.drawScaledTextF(ctx, tr, (String)lvlText, lvlTextX, lvlTextY, -1, 0.25f);
        float slotXF = (float)(x + Math.round(96.0f) - 5 - 20) + -13.5f;
        float slotYF = y + 5 + -2;
        String string = display = name == null ? "Unknown" : name;
        if (display.length() > 20) {
            display = display.substring(0, 20);
        }
        int innerMaxPx = Math.max(0, 16);
        display = PartyHud.ellipsizeScaled(tr, display, innerMaxPx, 0.25f);
        int textW = Math.round((float)tr.method_1727(display) * 0.25f);
        Objects.requireNonNull(tr);
        int textH = Math.max(1, Math.round(9.0f * 0.25f));
        float textXF = slotXF + (float)(20 - textW) / 2.0f;
        Objects.requireNonNull(tr);
        float textYF = slotYF + (float)(Math.max(1, Math.round(9.0f * 0.25f)) + 2 - textH) / 2.0f;
        PartyHud.drawScaledTextF(ctx, tr, display, textXF, textYF, -1, 0.25f);
        int modelRight = modelCenterX + 2;
        int barX = modelRight + 3;
        int barRight = x + scaledW - 6 - 20;
        int barW = Math.max(0, barRight - barX);
        int barH = Math.max(1, Math.round(2.25f));
        List<PartyHud.RenderBar> bars = PartyHud.collectBars(uuid, cfg, -13710223, -1654272, -1654272, -13330213, -13330213);
        if (bars.size() > 3) {
            bars = bars.subList(0, 3);
        }
        if (barW > 0 && !bars.isEmpty()) {
            int totalH = bars.size() * (barH + 1) - 1;
            int topY = y + (scaledH - totalH) / 2 + 1;
            for (int i = 0; i < bars.size(); ++i) {
                PartyHud.RenderBar b = bars.get(i);
                int by = topY + i * (barH + 1);
                PartyHud.drawHudBarSmart(ctx, barX, by, barW, barH, b);
                String txt = b.text;
                int tW = Math.round((float)tr.method_1727(txt) * 0.25f);
                Objects.requireNonNull(tr);
                int tH = Math.max(1, Math.round(9.0f * 0.25f));
                int tX = barX + barW - 1 - tW;
                int tY = by + (barH - tH) / 2;
                PartyHud.drawScaledText(ctx, tr, txt, tX, tY, -1, 0.25f);
            }
        }
        if (cfg.showArrows && (arrow = PartyHud.pickArrow(uuid)) != null) {
            int aw = Math.round(8.25f);
            int ah = Math.round(8.25f);
            int ax = x + scaledW - 3 - aw - 15;
            int ay = y + scaledH - 3 - ah;
            PartyHud.drawTextureScaled(ctx, arrow, ax - 1, ay + 3, 11, 11, 11, 11, 0.75f);
        }
        if ((theirEffects = ClientPartyStatusEffects.get(uuid)) != null && !theirEffects.isEmpty()) {
            float anchorX = (float)(x + scaledW) - 18.0f - 3.0f;
            float boxH = scaledH;
            this.drawMemberEffectIcons(ctx, anchorX, y, boxH, theirEffects);
        }
    }

    private void drawMemberModel(class_332 ctx, int centerX, int bottomY, int size, UUID uuid, String fallbackName) {
        class_1657 pe = PartyHud.getRenderablePlayer(uuid, fallbackName);
        if (pe == null) {
            return;
        }
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
        Quaternionf rotation = new Quaternionf().rotationZ((float)Math.PI);
        Quaternionf bodyRot = new Quaternionf();
        class_490.method_48472((class_332)ctx, (float)centerX, (float)bottomY, (float)size, (Vector3f)translation, (Quaternionf)rotation, (Quaternionf)bodyRot, (class_1309)pe);
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
        ctx.method_51448().method_22909();
    }

    private void drawMemberEffectIcons(class_332 ctx, float anchorX, float topY, float boxHeight, List<class_2960> effectIds) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        int total = effectIds.size();
        if (total <= 0) {
            return;
        }
        int z = 400;
        int index = 0;
        int col = 0;
        float EFFECT_ICON_SIZE = 3.0f;
        float EFFECT_ICON_GAP = 2.0f;
        int EFFECTS_PER_COLUMN = 2;
        int EFFECT_BASE_PX = 18;
        while (index < total) {
            int remaining = total - index;
            int thisColCount = Math.min(EFFECTS_PER_COLUMN, remaining);
            float colHeight = (float)thisColCount * EFFECT_ICON_SIZE + (float)(thisColCount - 1) * EFFECT_ICON_GAP;
            float startY = topY + (boxHeight - colHeight) / 2.0f;
            float startX = anchorX + (float)col * (EFFECT_ICON_SIZE + EFFECT_ICON_GAP);
            for (int r = 0; r < thisColCount; ++r) {
                class_1058 sprite;
                class_6880 entry;
                class_1291 effect;
                class_2960 id;
                if ((id = effectIds.get(index++)) == null || (effect = (class_1291)class_7923.field_41174.method_10223(id)) == null || (entry = class_7923.field_41174.method_47983((Object)effect)) == null || (sprite = mc.method_18505().method_18663(entry)) == null) continue;
                float x = startX;
                float y = startY + (float)r * (EFFECT_ICON_SIZE + EFFECT_ICON_GAP);
                class_4587 m = ctx.method_51448();
                m.method_22903();
                m.method_46416(x, y, 0.0f);
                float s = EFFECT_ICON_SIZE / (float)EFFECT_BASE_PX;
                m.method_22905(s, s, 1.0f);
                ctx.method_25298(0, 0, z, EFFECT_BASE_PX, EFFECT_BASE_PX, sprite);
                m.method_22909();
            }
            ++col;
        }
    }
}

