/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.hud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.pixeldreamstudios.rpgsystems.client.config.MiscClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyInvites;
import net.pixeldreamstudios.rpgsystems.mixin.client.ScreenAccessor;

@Environment(value=EnvType.CLIENT)
public final class PartyInviteInventoryUi {
    private static final class_2960 TEX_PLATE = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_accept_decline.png");
    private static final class_2960 TEX_ACC_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_invite_accept_normal.png");
    private static final class_2960 TEX_ACC_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_invite_accept_hover.png");
    private static final class_2960 TEX_DEC_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_invite_decline_normal.png");
    private static final class_2960 TEX_DEC_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_invite_decline_hover.png");

    private PartyInviteInventoryUi() {
    }

    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, w, h) -> {
            if (!(screen instanceof class_490)) {
                return;
            }
            int PLATE_W = 96;
            int PLATE_H = 64;
            int BTN_W = 14;
            int BTN_H = 14;
            int PAD = 6;
            int STACK_GAP = 6;
            MiscClientConfig cfg = MiscClientConfig.get();
            int plateBaseX = cfg.inviteInventoryX;
            int plateBaseBottom = h - cfg.inviteInventoryY;
            class_4068 plateDrawable = (ctx, mx, my, dt) -> {
                Collection<ClientPartyInvites.Invite> invites = ClientPartyInvites.invites();
                if (invites.isEmpty()) {
                    return;
                }
                int i = 0;
                for (ClientPartyInvites.Invite inv : invites) {
                    int pyBottom = plateBaseBottom - i * 70;
                    int py = pyBottom - 64;
                    ctx.method_25290(TEX_PLATE, plateBaseX, py, 0.0f, 0.0f, 96, 64, 96, 64);
                    String partyName = inv.partyName == null || inv.partyName.isBlank() ? "Party" : inv.partyName;
                    PartyInviteInventoryUi.drawCenteredScaled(ctx, partyName, plateBaseX, py + 64 - 33, 96, 0.5f);
                    long ttl = ClientPartyInvites.inviteTtlMs();
                    long now = System.currentTimeMillis();
                    long rem = Math.max(0L, ttl - (now - inv.createdAt));
                    PartyInviteInventoryUi.drawCenteredScaled(ctx, PartyInviteInventoryUi.formatMmSs(rem), plateBaseX, py + 64 - 15, 96, 0.5f);
                    ++i;
                }
            };
            ScreenAccessor acc = (ScreenAccessor)screen;
            acc.rpgsystems$addDrawable(plateDrawable);
            ArrayList liveButtons = new ArrayList();
            ArrayList<UUID> lastInviteIds = new ArrayList<UUID>();
            Runnable rebuildButtons = () -> {
                for (class_339 wgt : liveButtons) {
                    if (wgt == null) continue;
                    wgt.field_22764 = false;
                    wgt.field_22763 = false;
                    acc.rpgsystems$remove((class_364)wgt);
                }
                liveButtons.clear();
                ArrayList<ClientPartyInvites.Invite> invites = new ArrayList<ClientPartyInvites.Invite>(ClientPartyInvites.invites());
                if (invites.isEmpty()) {
                    return;
                }
                for (int i = 0; i < invites.size(); ++i) {
                    ClientPartyInvites.Invite inv = invites.get(i);
                    int pyBottom = plateBaseBottom - i * 70;
                    int py = pyBottom - 64;
                    int accX = plateBaseX + 6;
                    int accY = py + 64 - 6 - 14;
                    int decX = plateBaseX + 96 - 6 - 14;
                    int decY = accY;
                    ScaledIconButton accBtn = new ScaledIconButton(accX, accY, 14, 14, 0.75f, TEX_ACC_NORMAL, TEX_ACC_HOVER, b -> {
                        ClientPartyInvites.sendResponse(inv.partyId, true);
                        b.field_22764 = false;
                        b.field_22763 = false;
                    });
                    ScaledIconButton decBtn = new ScaledIconButton(decX, decY, 14, 14, 0.75f, TEX_DEC_NORMAL, TEX_DEC_HOVER, b -> {
                        ClientPartyInvites.sendResponse(inv.partyId, false);
                        b.field_22764 = false;
                        b.field_22763 = false;
                    });
                    acc.rpgsystems$addDrawableChild(accBtn);
                    acc.rpgsystems$addDrawableChild(decBtn);
                    liveButtons.add(accBtn);
                    liveButtons.add(decBtn);
                }
            };
            List<UUID> ids = ClientPartyInvites.invites().stream().map(inv -> inv.partyId).toList();
            lastInviteIds.clear();
            lastInviteIds.addAll(ids);
            rebuildButtons.run();
            ScreenEvents.beforeRender((class_437)screen).register((scr, ctx, mx, my, dt) -> {
                List<UUID> idsNow = ClientPartyInvites.invites().stream().map(inv -> inv.partyId).toList();
                if (!idsNow.equals(lastInviteIds)) {
                    lastInviteIds.clear();
                    lastInviteIds.addAll(idsNow);
                    rebuildButtons.run();
                }
            });
        });
    }

    private static void drawCenteredScaled(class_332 ctx, String text, int x, int y, int plateW, float scale) {
        class_310 mc = class_310.method_1551();
        int twScaled = Math.round((float)mc.field_1772.method_1727(text) * scale);
        int tx = x + Math.max(4, (plateW - twScaled) / 2);
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)tx, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(mc.field_1772, text, 0, 0, 0xFFFFFF, false);
        m.method_22909();
    }

    private static String formatMmSs(long ms) {
        long sec = Math.max(0L, (ms + 999L) / 1000L);
        long m = sec / 60L;
        long s = sec % 60L;
        return m + ":" + (String)(s < 10L ? "0" + s : String.valueOf(s));
    }

    private static final class ScaledIconButton
    extends class_4185 {
        private final class_2960 normal;
        private final class_2960 hover;
        private final float scale;

        ScaledIconButton(int x, int y, int w, int h, float scale, class_2960 normal, class_2960 hover, class_4185.class_4241 onPress) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), onPress, class_4185.field_40754);
            this.normal = normal;
            this.hover = hover;
            this.scale = scale;
        }

        protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
            boolean isHover = this.method_25405(mouseX, mouseY);
            class_2960 tex = isHover ? this.hover : this.normal;
            int w = this.method_25368();
            int h = this.method_25364();
            int ox = this.method_46426() + Math.round(((float)w - (float)w * this.scale) / 2.0f);
            int oy = this.method_46427() + Math.round(((float)h - (float)h * this.scale) / 2.0f);
            class_4587 m = ctx.method_51448();
            m.method_22903();
            m.method_46416((float)ox, (float)oy, 0.0f);
            m.method_22905(this.scale, this.scale, 1.0f);
            ctx.method_25290(tex, 0, 0, 0.0f, 0.0f, w, h, w, h);
            m.method_22909();
        }
    }
}

