/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.hud;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_8685;
import net.minecraft.class_9779;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.config.PartyHudClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyHud;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyHudRenderer;

final class SimpleHud
implements PartyHudRenderer {
    private static final int PANEL_W = 128;
    private static final float BG_SCALE = 0.75f;
    private static final int ICON_SIZE = 14;
    private static final int ICON_LEFT = 6;
    private static final int ICON_TOP = 6;
    private static final int NAME_LEFT = 24;
    private static final int NAME_TOP = 6;
    private static final float NAME_SCALE = 0.55f;
    private static final int NAME_COLOR = -1253170;
    private static final int BAR_LEFT = 24;
    private static final int BAR_RIGHT_PAD = 6;
    private static final int BAR_H = 4;
    private static final int BAR_GAP = 2;
    private static final int BAR_HP_FILL = -2475196;
    private static final int BAR_HUNGER_FILL = -1654272;
    private static final int BAR_STAM_FILL = -1654272;
    private static final int BAR_MANA_FILL = -11622657;
    private static final int BAR_RPGMANA_FILL = -11622657;
    private static final float VALUE_SCALE = 0.3f;
    private static final int VALUE_COLOR = -1;

    SimpleHud() {
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, PartyHudClientConfig cfg) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1690.field_1842 || mc.field_1724 == null) {
            return;
        }
        PartyHud.ensureBgNearest();
        PartyHud.ensureHudBarTexturesNearest();
        int xAnchor = cfg.partyHudX;
        int yAnchorStart = cfg.partyHudY;
        float hudScale = cfg.hudScale;
        if (hudScale <= 0.1f) {
            hudScale = 0.1f;
        }
        int rowStepUnscaled = 24;
        int rowStep = Math.round((float)rowStepUnscaled * hudScale);
        List<ClientPartyHudData.Member> list = PartyHud.partyMembers();
        if (list.isEmpty()) {
            return;
        }
        int yScreen = yAnchorStart;
        for (ClientPartyHudData.Member m : list) {
            class_4587 mtx = ctx.method_51448();
            mtx.method_22903();
            mtx.method_46416((float)xAnchor, (float)yScreen, 0.0f);
            mtx.method_22905(hudScale, hudScale, 1.0f);
            this.drawRow(ctx, 0, 0, m.uuid, m.name, m.totalLevel, cfg);
            mtx.method_22909();
            yScreen += rowStep;
        }
    }

    private void drawRow(class_332 ctx, int x, int y, UUID uuid, String name, int level, PartyHudClientConfig cfg) {
        int scaledW = Math.round(96.0f);
        int bgX = x + 2;
        int bgY = y + 6 - 2;
        int bgW = scaledW - 4;
        int bgH = 18;
        this.drawSoftBg(ctx, bgX, bgY, bgW, bgH);
        class_327 tr = class_310.method_1551().field_1772;
        this.drawHead(ctx, x + 6, y + 6, 14, uuid, name);
        String title = (level >= 0 ? level : 0) + " | " + (name == null ? "Unknown" : name);
        int titleX = x + 24;
        int titleY = y + 6 - 1;
        PartyHud.drawScaledText(ctx, tr, title, titleX, titleY, -1253170, 0.55f);
        int barX = x + 24;
        int barRight = x + scaledW - 6;
        int barW = Math.max(0, barRight - barX);
        List<PartyHud.RenderBar> bars = PartyHud.collectBars(uuid, cfg, -2475196, -1654272, -1654272, -11622657, -11622657);
        if (bars.size() > 2) {
            bars = bars.subList(0, 2);
        }
        int by = y + 10;
        int drawn = 0;
        for (PartyHud.RenderBar b : bars) {
            if (drawn >= 2) break;
            PartyHud.drawHudBarSmart(ctx, barX, by, barW, 4, b);
            String val = b.text;
            float tW = (float)class_310.method_1551().field_1772.method_1727(val) * 0.3f;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            float tH = 9.0f * 0.3f;
            float tX = (float)barX + ((float)barW - tW) / 2.0f;
            float tY = (float)by + (4.0f - tH) / 2.0f;
            PartyHud.drawScaledTextF(ctx, tr, val, tX, tY, -1, 0.3f);
            by += 6;
            ++drawn;
        }
        if (PartyHud.isLeader(uuid)) {
            int crownW = 9;
            int crownH = 7;
            int ax = x + scaledW - crownW - 8;
            int ay = y + 4;
            PartyHud.drawTextureScaled(ctx, PartyHud.LEADER_ICON, ax, ay, crownW, crownH, crownW, crownH, 1.0f);
        }
    }

    private void drawHead(class_332 ctx, int x, int y, int size, UUID uuid, String fallbackName) {
        class_1657 player = PartyHud.getRenderablePlayer(uuid, fallbackName);
        class_310 mc = class_310.method_1551();
        if (player == null || mc == null) {
            return;
        }
        class_1071 provider = mc.method_1582();
        class_8685 textures = provider.method_52862(player.method_7334());
        class_2960 skin = textures != null ? textures.comp_1626() : class_1068.method_4649();
        class_1060 tm = mc.method_1531();
        class_1044 tex = tm.method_4619(skin);
        if (tex != null) {
            tex.method_4527(false, false);
        }
        int texW = 64;
        int texH = 64;
        int headU = 8;
        int headV = 8;
        int headSize = 8;
        int hatU = 40;
        int hatV = 8;
        int hatSize = 8;
        ctx.method_25293(skin, x, y, size, size, (float)headU, (float)headV, headSize, headSize, texW, texH);
        ctx.method_25293(skin, x, y, size, size, (float)hatU, (float)hatV, hatSize, hatSize, texW, texH);
    }

    private void drawSoftBg(class_332 ctx, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        int bg = -1609560048;
        ctx.method_25294(x, y, x + w, y + h, bg);
        PartyHud.drawTextureScaled(ctx, PartyHud.SIMPLE_OUTLINE, x, y, w, h, 92, 18, 1.0f);
    }
}

