/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.screen.box;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyChat;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyMemberInfoBox;

@Environment(value=EnvType.CLIENT)
public final class PartyChatBox
implements PartyBox {
    private static final boolean DEBUG_BOX = false;
    private static final int TL_BOX_W = 120;
    private static final int TL_BOX_MARGIN = 8;
    private static final int TL_BOX_OFFSET_Y = 15;
    private static final int GAP_FROM_LEFT_COLUMN = 12;
    private static final int SHIFT_LEFT = 60;
    private static final int BOX_W = 255;
    private static final int BOX_H = 201;
    private static final int PAD = 6;
    private static final float LOG_TEXT_SCALE = 0.65f;
    private static final float INPUT_TEXT_SCALE = 0.7f;
    private static final int BG_COLOR = 1075943155;
    private static final int BORDER_COLOR = -14575885;
    private static final int TEXT_COLOR = -1;
    private static final int PLACEHOLDER_COLOR = -4276546;
    private static final int INPUT_PAD_V = 4;
    private static final int INPUT_PAD_H = 4;
    private static final int INPUT_BG = 0x40101010;
    private static final int INPUT_BORDER = -2130706433;
    private static final int SELECTION_BG = -2144097537;
    private static final String PLACEHOLDER = "Type a message\u2026";
    private static final int BUBBLE_PAD_H = 4;
    private static final int BUBBLE_PAD_V = 2;
    private static final int BUBBLE_GAP = 4;
    private static final int NAME_GAP = 2;
    private static final int LINE_GAP = 1;
    private static final int BUBBLE_RADIUS = 3;
    private static final int BUBBLE_SELF = -1875601189;
    private static final int BUBBLE_OTHER = -1875692749;
    private static final double WRAP_FRACTION = 0.6666666666666666;
    private static final int PIN_BG = 0x66336699;
    private static final int PIN_TEXT = -1;
    private static final int PIN_PAD_H = 4;
    private static final int PIN_PAD_V = 3;
    private static final int SUG_BG = -1442840576;
    private static final int SUG_TEXT = 12648416;
    private static final int SUG_PAD = 4;
    private static final int SUG_MAX = 6;
    private static final String[] P_COMMANDS = new String[]{"/p help", "/p info", "/p sharepos", "/p promote ", "/p pin ", "/p unpin"};
    private boolean focused = false;
    private final StringBuilder input = new StringBuilder();
    private int caret = 0;
    private int selAnchor = -1;
    private long lastBlinkMs = 0L;
    private boolean blinkOn = true;
    private int scrollPx = 0;
    private int inputScrollPx = 0;
    private static final class_2960 PIN_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/pin.png");
    private static final int PIN_ICON_W = 8;
    private static final int PIN_ICON_H = 8;
    private static final int PIN_ICON_GAP = 4;

    @Override
    public void render(class_332 ctx, class_327 tr, int canvasX, int canvasY, int canvasW, int canvasH) {
        List<String> sug;
        int totalH;
        int maxScroll;
        int lineH;
        int contentLeft = canvasX + 8 + 18;
        int infoTop = canvasY + 8 + 15;
        int xLeftCol = contentLeft + 120;
        int x = xLeftCol + 12 - 60;
        int y = infoTop + PartyMemberInfoBox.getPreferredHeight() + 4;
        int w = 255;
        int h = 201;
        Objects.requireNonNull(tr);
        int inputTextH = Math.round(9.0f * 0.7f);
        int inputH = inputTextH + 8;
        int logTop = y + 6;
        int logBottom = y + h - 6 - inputH - 4;
        if (logBottom < logTop) {
            logBottom = logTop;
        }
        int inputTop = y + h - 6 - inputH;
        int inputLeft = x + 6;
        int inputRight = x + w - 6;
        int innerLeft = x + 6;
        int innerRight = x + w - 6;
        int innerW = innerRight - innerLeft;
        int visibleH = Math.max(0, logBottom - logTop);
        List<ClientPartyChat.Msg> msgs = ClientPartyChat.all();
        UUID self = class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5667() : null;
        Objects.requireNonNull(tr);
        int nameH = lineH = Math.round(9.0f * 0.65f);
        int wrapTextPx = Math.max(20, (int)Math.floor((double)innerW * 0.6666666666666666) - 8);
        int bubbleMaxW = Math.max(40, (int)Math.floor((double)innerW * 0.82));
        String pinned = ClientPartyChat.Pinned.text();
        int pinBoxH = 0;
        if (pinned != null && !pinned.isBlank()) {
            int textWrapW = innerW - 8 - 12;
            List<String> pinLines = PartyChatBox.wrapLines(tr, pinned, Math.max(8, textWrapW));
            Objects.requireNonNull(tr);
            int lineHpx = Math.round(9.0f * 0.65f);
            int textH = pinLines.size() * lineHpx + (pinLines.size() - 1) * 1;
            int contentH = Math.max(8, textH);
            pinBoxH = 6 + contentH;
            ctx.method_25294(innerLeft, logTop, innerRight, logTop + pinBoxH, 0x66336699);
            int ix = innerLeft + 4;
            int iy = logTop + 3 + (contentH - 8) / 2;
            ctx.method_25290(PIN_ICON, ix, iy, 0.0f, 0.0f, 8, 8, 8, 8);
            int tx = ix + 8 + 4;
            int ty = logTop + 3 + (contentH - textH) / 2;
            for (int i = 0; i < pinLines.size(); ++i) {
                PartyChatBox.drawScaledText(ctx, tr, pinLines.get(i), tx, ty, -1, 0.65f);
                if (i + 1 >= pinLines.size()) continue;
                ty += lineHpx + 1;
            }
            visibleH = Math.max(0, logBottom - (logTop += pinBoxH + 2));
        }
        if (this.scrollPx > (maxScroll = Math.max(0, (totalH = PartyChatBox.measureTotalHeightWrapped(tr, msgs, wrapTextPx, bubbleMaxW, lineH, nameH)) - visibleH))) {
            this.scrollPx = maxScroll;
        }
        if (this.scrollPx < 0) {
            this.scrollPx = 0;
        }
        ctx.method_44379(innerLeft, logTop, innerRight, logBottom);
        int cursorY = logBottom + this.scrollPx;
        for (int i = msgs.size() - 1; i >= 0; --i) {
            int nameX;
            ClientPartyChat.Msg m = msgs.get(i);
            String msgText = m.text == null ? "" : m.text;
            String who = m.name == null ? "Unknown" : m.name;
            boolean isSelf = self != null && m.sender != null && self.equals(m.sender);
            List<String> lines = PartyChatBox.wrapLines(tr, msgText, wrapTextPx);
            int widestScaled = 0;
            for (String ln : lines) {
                widestScaled = Math.max(widestScaled, Math.round((float)tr.method_1727(ln) * 0.65f));
            }
            int bubbleW = Math.min(bubbleMaxW, widestScaled + 8);
            int bubbleH = lines.size() * lineH + (lines.size() - 1) * 1 + 4;
            int nameW = Math.round((float)tr.method_1727(who) * 0.65f);
            int blockH = nameH + 2 + bubbleH + 4;
            int blockTop = cursorY - blockH;
            int bubbleTop = blockTop + nameH + 2;
            int bubbleLeft = isSelf ? innerRight - bubbleW : innerLeft;
            int nameY = blockTop + (nameH - lineH);
            int n = nameX = isSelf ? bubbleLeft + bubbleW - nameW : bubbleLeft;
            if (bubbleTop < logBottom && bubbleTop + bubbleH > logTop) {
                PartyChatBox.drawSoftRounded(ctx, bubbleLeft, bubbleTop, bubbleW, bubbleH, 3, isSelf ? -1875601189 : -1875692749);
                PartyChatBox.drawScaledText(ctx, tr, who, nameX, nameY, -1, 0.65f);
                int textX = bubbleLeft + 4;
                int textY = bubbleTop + 2;
                for (int li = 0; li < lines.size(); ++li) {
                    PartyChatBox.drawScaledText(ctx, tr, lines.get(li), textX, textY, -1, 0.65f);
                    textY += li == lines.size() - 1 ? 0 : lineH + 1;
                }
            }
            if ((cursorY = blockTop) <= logTop) break;
        }
        ctx.method_44380();
        ctx.method_25294(inputLeft, inputTop, inputRight, inputTop + inputH, 0x40101010);
        PartyChatBox.drawBorder(ctx, inputLeft, inputTop, inputRight - inputLeft, inputH, -2130706433);
        int inputInnerLeft = inputLeft + 4;
        int inputInnerRight = inputRight - 4;
        int inputClipTop = inputTop + 1;
        int inputClipBot = inputTop + inputH - 1;
        int inputTextX = inputInnerLeft;
        int inputTextY = inputTop + 4;
        int visibleInputW = Math.max(0, inputInnerRight - inputInnerLeft);
        int caretXScaled = PartyChatBox.scaledWidth(tr, this.input.substring(0, Math.min(this.caret, this.input.length())), 0.7f);
        int totalTextScaled = PartyChatBox.scaledWidth(tr, this.input.toString(), 0.7f);
        this.ensureCaretVisible(caretXScaled, totalTextScaled, visibleInputW);
        ctx.method_44379(inputInnerLeft, inputClipTop, inputInnerRight, inputClipBot);
        if (this.hasSelection()) {
            int a = this.selMin();
            int b = this.selMax();
            int selStartScaled = PartyChatBox.scaledWidth(tr, this.input.substring(0, a), 0.7f);
            int selEndScaled = PartyChatBox.scaledWidth(tr, this.input.substring(0, b), 0.7f);
            int sx = inputTextX - this.inputScrollPx + selStartScaled;
            int ex = inputTextX - this.inputScrollPx + selEndScaled;
            Objects.requireNonNull(tr);
            int ch = Math.round(9.0f * 0.7f);
            if (ex > sx) {
                ctx.method_25294(sx, inputTextY, ex, inputTextY + ch, -2144097537);
            }
        }
        if (this.input.length() == 0 && !this.focused) {
            PartyChatBox.drawScaledText(ctx, tr, PLACEHOLDER, inputTextX, inputTextY, -4276546, 0.7f);
        } else {
            PartyChatBox.drawScaledText(ctx, tr, this.input.toString(), inputTextX - this.inputScrollPx, inputTextY, -1, 0.7f);
            long now = System.currentTimeMillis();
            if (now - this.lastBlinkMs > 500L) {
                this.lastBlinkMs = now;
                boolean bl = this.blinkOn = !this.blinkOn;
            }
            if (this.focused && this.blinkOn && !this.hasSelection()) {
                Objects.requireNonNull(tr);
                int ch = Math.round(9.0f * 0.7f);
                int caretDrawX = inputTextX - this.inputScrollPx + caretXScaled;
                ctx.method_25294(caretDrawX, inputTextY, caretDrawX + 1, inputTextY + ch, -1);
            }
        }
        ctx.method_44380();
        if (msgs.isEmpty()) {
            String none = "Do -/p help- for party chat commands";
            int tw = Math.round((float)tr.method_1727(none) * 0.65f);
            int tx = x + (w - tw) / 2;
            Objects.requireNonNull(tr);
            int ty = logTop + Math.max(0, (visibleH - Math.round(9.0f * 0.65f)) / 2);
            PartyChatBox.drawScaledText(ctx, tr, none, tx, ty, -4276546, 0.65f);
        }
        if (this.inputStartsWithP() && !(sug = PartyChatBox.suggestP(this.input.toString())).isEmpty()) {
            int sx = inputInnerLeft;
            int sy = inputTop - 2;
            int sw = 0;
            int rows = Math.min(6, sug.size());
            for (int i = 0; i < rows; ++i) {
                sw = Math.max(sw, tr.method_1727(sug.get(i)));
            }
            sw += 8;
            Objects.requireNonNull(tr);
            int sh = rows * Math.round(9.0f * 0.7f) + 8;
            sx = inputInnerLeft;
            sy = inputTop - sh - 4;
            if (sy < y + 2) {
                sy = y + 2;
            }
            ctx.method_25294(sx - 2, sy - 2, sx + sw + 2, sy + sh + 2, -1442840576);
            int ty = sy + 4;
            for (int i = 0; i < rows; ++i) {
                PartyChatBox.drawScaledText(ctx, tr, sug.get(i), sx + 4, ty, 12648416, 0.7f);
                Objects.requireNonNull(tr);
                ty += Math.round(9.0f * 0.7f);
            }
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double ha, double va, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        int lineH;
        int contentLeft = canvasX + 8 + 18;
        int infoTop = canvasY + 8 + 15;
        int xLeftCol = contentLeft + 120;
        int x = xLeftCol + 12 - 60;
        int y = infoTop + PartyMemberInfoBox.getPreferredHeight() + 4;
        int w = 255;
        int h = 201;
        int logTop = y + 6;
        Objects.requireNonNull(tr);
        int inputTextH = Math.round(9.0f * 0.7f);
        int inputH = inputTextH + 8;
        int logBottom = y + h - 6 - inputH - 4;
        int innerLeft = x + 6;
        int innerRight = x + w - 6;
        int innerW = innerRight - innerLeft;
        int visibleH = Math.max(0, logBottom - logTop);
        List<ClientPartyChat.Msg> msgs = ClientPartyChat.all();
        Objects.requireNonNull(tr);
        int nameH = lineH = Math.round(9.0f * 0.65f);
        int wrapTextPx = Math.max(20, (int)Math.floor((double)innerW * 0.6666666666666666) - 8);
        int bubbleMaxW = Math.max(40, (int)Math.floor((double)innerW * 0.82));
        int totalH = PartyChatBox.measureTotalHeightWrapped(tr, msgs, wrapTextPx, bubbleMaxW, lineH, nameH);
        String pinned = ClientPartyChat.Pinned.text();
        int pinBoxH = 0;
        if (pinned != null && !pinned.isBlank()) {
            List<String> pinLines = PartyChatBox.wrapLines(tr, "PINNED: " + pinned, innerW - 8);
            int n = pinLines.size();
            Objects.requireNonNull(tr);
            pinBoxH = 6 + n * Math.round(9.0f * 0.65f) + (pinLines.size() - 1) * 1;
            visibleH = Math.max(0, logBottom - (logTop += pinBoxH + 2));
        }
        if (!(mouseX >= (double)x && mouseX < (double)(x + w) && mouseY >= (double)logTop && mouseY < (double)logBottom)) {
            return false;
        }
        int maxScroll = Math.max(0, totalH - visibleH);
        if (maxScroll == 0) {
            return true;
        }
        int nominalBlock = lineH + 2 + (lineH + 4) + 4;
        int step = Math.max(12, nominalBlock);
        int delta = (int)Math.round(va * (double)step);
        this.scrollPx = Math.max(0, Math.min(maxScroll, this.scrollPx + delta));
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        boolean inside;
        int contentLeft = canvasX + 8 + 18;
        int infoTop = canvasY + 8 + 15;
        int xLeftCol = contentLeft + 120;
        int x = xLeftCol + 12 - 60;
        int y = infoTop + PartyMemberInfoBox.getPreferredHeight() + 4;
        int w = 255;
        int h = 201;
        Objects.requireNonNull(tr);
        int inputTextH = Math.round(9.0f * 0.7f);
        int inputH = inputTextH + 8;
        int inputTop = y + h - 6 - inputH;
        int inputLeft = x + 6;
        int inputRight = x + w - 6;
        this.focused = inside = mouseX >= (double)inputLeft && mouseX < (double)inputRight && mouseY >= (double)inputTop && mouseY < (double)(inputTop + inputH);
        if (this.focused) {
            this.caret = this.input.length();
            this.clearSelection();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean ctrl;
        if (!this.focused) {
            return false;
        }
        boolean shift = (modifiers & 1) != 0;
        boolean bl = ctrl = (modifiers & 2) != 0 || (modifiers & 8) != 0;
        if (ctrl && keyCode == 65) {
            this.selAnchor = 0;
            this.caret = this.input.length();
            return true;
        }
        if (ctrl && keyCode == 67) {
            if (this.hasSelection()) {
                class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            }
            return true;
        }
        if (ctrl && keyCode == 88) {
            if (this.hasSelection()) {
                class_310.method_1551().field_1774.method_1455(this.getSelectedText());
                this.deleteSelection();
            }
            return true;
        }
        if (ctrl && keyCode == 86) {
            String clip = class_310.method_1551().field_1774.method_1460();
            if (clip != null && !clip.isEmpty()) {
                this.replaceSelection(clip);
            }
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.sendIfAny();
            return true;
        }
        if (keyCode == 259) {
            if (this.hasSelection()) {
                this.deleteSelection();
            } else if (ctrl) {
                int start = this.prevWordIndex(this.caret);
                if (start < this.caret) {
                    this.input.delete(start, this.caret);
                    this.caret = start;
                }
            } else if (this.caret > 0) {
                this.input.deleteCharAt(this.caret - 1);
                --this.caret;
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.hasSelection()) {
                this.deleteSelection();
            } else if (ctrl) {
                int end = this.nextWordIndex(this.caret);
                if (end > this.caret) {
                    this.input.delete(this.caret, end);
                }
            } else if (this.caret < this.input.length()) {
                this.input.deleteCharAt(this.caret);
            }
            return true;
        }
        if (keyCode == 263) {
            int dest = ctrl ? this.prevWordIndex(this.caret) : Math.max(0, this.caret - 1);
            this.moveCaret(dest, shift);
            return true;
        }
        if (keyCode == 262) {
            int dest = ctrl ? this.nextWordIndex(this.caret) : Math.min(this.input.length(), this.caret + 1);
            this.moveCaret(dest, shift);
            return true;
        }
        if (keyCode == 268) {
            int dest = 0;
            if (ctrl) {
                dest = 0;
            }
            this.moveCaret(dest, shift);
            return true;
        }
        if (keyCode == 269) {
            int dest = this.input.length();
            this.moveCaret(dest, shift);
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (!this.focused) {
            return false;
        }
        if (chr == '\r' || chr == '\n') {
            return true;
        }
        if (Character.isISOControl(chr)) {
            return true;
        }
        this.replaceSelection(Character.toString(chr));
        return true;
    }

    private static int measureTotalHeightWrapped(class_327 tr, List<ClientPartyChat.Msg> msgs, int wrapTextPx, int bubbleMaxW, int lineH, int nameH) {
        int total = 0;
        for (int i = msgs.size() - 1; i >= 0; --i) {
            String text = msgs.get((int)i).text == null ? "" : msgs.get((int)i).text;
            List<String> lines = PartyChatBox.wrapLines(tr, text, wrapTextPx);
            int widestScaled = 0;
            for (String ln : lines) {
                widestScaled = Math.max(widestScaled, Math.round((float)tr.method_1727(ln) * 0.65f));
            }
            int bubbleW = Math.min(bubbleMaxW, widestScaled + 8);
            int bubbleH = lines.size() * lineH + (lines.size() - 1) * 1 + 4;
            total += nameH + 2 + bubbleH + 4;
        }
        return total;
    }

    private static List<String> wrapLines(class_327 tr, String text, int maxPixels) {
        ArrayList<String> out = new ArrayList<String>();
        if (text == null) {
            out.add("");
            return out;
        }
        if (maxPixels <= 4) {
            out.add(text);
            return out;
        }
        String[] paragraphs = text.split("\n", -1);
        for (int p = 0; p < paragraphs.length; ++p) {
            String s = paragraphs[p];
            int len = s.length();
            if (len == 0) {
                out.add("");
                continue;
            }
            StringBuilder line = new StringBuilder();
            int lastBreakPos = -1;
            for (int i = 0; i < len; ++i) {
                int w;
                char ch = s.charAt(i);
                line.append(ch);
                if (Character.isWhitespace(ch)) {
                    lastBreakPos = line.length();
                }
                if ((w = PartyChatBox.scaledWidth(tr, line.toString(), 0.65f)) <= maxPixels) continue;
                if (lastBreakPos > 0) {
                    String emit = line.substring(0, lastBreakPos).replaceFirst("\\s+$", "");
                    if (emit.isEmpty()) {
                        emit = line.substring(0, Math.max(1, lastBreakPos - 1));
                    }
                    out.add(emit);
                    String rem = line.substring(lastBreakPos).replaceFirst("^\\s+", "");
                    line.setLength(0);
                    line.append(rem);
                    lastBreakPos = -1;
                    continue;
                }
                int lo = 1;
                int hi = line.length();
                int best = 1;
                while (lo <= hi) {
                    int mid = lo + hi >>> 1;
                    int ww = PartyChatBox.scaledWidth(tr, line.substring(0, mid), 0.65f);
                    if (ww <= maxPixels) {
                        best = mid;
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid - 1;
                }
                out.add(line.substring(0, best));
                String rem = line.substring(best);
                line.setLength(0);
                line.append(rem);
                lastBreakPos = -1;
            }
            String tail = line.toString().replaceFirst("\\s+$", "");
            if (!tail.isEmpty() || s.endsWith(" ")) {
                out.add(tail);
            }
            if (p + 1 >= paragraphs.length || !paragraphs[p + 1].isEmpty()) continue;
            out.add("");
        }
        if (out.isEmpty()) {
            out.add("");
        }
        return out;
    }

    private boolean hasSelection() {
        return this.selAnchor != -1 && this.selAnchor != this.caret;
    }

    private int selMin() {
        return Math.min(this.selAnchor, this.caret);
    }

    private int selMax() {
        return Math.max(this.selAnchor, this.caret);
    }

    private void clearSelection() {
        this.selAnchor = -1;
    }

    private String getSelectedText() {
        if (!this.hasSelection()) {
            return "";
        }
        return this.input.substring(this.selMin(), this.selMax());
    }

    private void deleteSelection() {
        if (!this.hasSelection()) {
            return;
        }
        int a = this.selMin();
        int b = this.selMax();
        this.input.delete(a, b);
        this.caret = a;
        this.clearSelection();
    }

    private void replaceSelection(String s) {
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        this.input.insert(this.caret, s);
        this.caret += s.length();
        this.clearSelection();
    }

    private void moveCaret(int dest, boolean extendSelection) {
        dest = Math.max(0, Math.min(this.input.length(), dest));
        if (extendSelection) {
            if (this.selAnchor == -1) {
                this.selAnchor = this.caret;
            }
        } else {
            this.clearSelection();
        }
        this.caret = dest;
    }

    private int prevWordIndex(int from) {
        int i;
        for (i = Math.max(0, Math.min(this.input.length(), from)); i > 0 && Character.isWhitespace(this.input.charAt(i - 1)); --i) {
        }
        while (i > 0 && !Character.isWhitespace(this.input.charAt(i - 1))) {
            --i;
        }
        return i;
    }

    private int nextWordIndex(int from) {
        int i;
        for (i = Math.max(0, Math.min(this.input.length(), from)); i < this.input.length() && Character.isWhitespace(this.input.charAt(i)); ++i) {
        }
        while (i < this.input.length() && !Character.isWhitespace(this.input.charAt(i))) {
            ++i;
        }
        return i;
    }

    private void insertText(String s) {
        this.replaceSelection(s);
    }

    private void sendIfAny() {
        String msg = this.input.toString().trim();
        if (msg.isEmpty()) {
            return;
        }
        UUID pid = ClientPartyHudData.partyId;
        if (pid != null) {
            ClientPartyChat.send(pid, msg);
        }
        this.input.setLength(0);
        this.caret = 0;
        this.clearSelection();
        this.inputScrollPx = 0;
        this.scrollPx = 0;
    }

    private static int scaledWidth(class_327 tr, String s, float scale) {
        return Math.round((float)tr.method_1727(s) * scale);
    }

    private void ensureCaretVisible(int caretScaledX, int totalScaledW, int visibleW) {
        int margin = 2;
        int left = this.inputScrollPx;
        int right = this.inputScrollPx + visibleW;
        if (caretScaledX + margin > right) {
            this.inputScrollPx = caretScaledX + margin - visibleW;
        } else if (caretScaledX - margin < left) {
            this.inputScrollPx = Math.max(0, caretScaledX - margin);
        }
        int maxScroll = Math.max(0, totalScaledW - visibleW);
        if (this.inputScrollPx > maxScroll) {
            this.inputScrollPx = maxScroll;
        }
        if (this.inputScrollPx < 0) {
            this.inputScrollPx = 0;
        }
    }

    private static void drawScaledText(class_332 ctx, class_327 tr, String text, int x, int y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    private static void drawBorder(class_332 ctx, int x, int y, int w, int h, int argb) {
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x, y + 1, x + 1, y + h - 1, argb);
        ctx.method_25294(x + w - 1, y + 1, x + w, y + h - 1, argb);
    }

    private static void drawSoftRounded(class_332 ctx, int x, int y, int w, int h, int r, int argb) {
        r = Math.max(2, Math.min(r, Math.min(w / 2, h / 2)));
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, argb);
        ctx.method_25294(x + r - 1, y, x + w - (r - 1), y + 1, argb);
        ctx.method_25294(x + r - 1, y + h - 1, x + w - (r - 1), y + h, argb);
        ctx.method_25294(x, y + r - 1, x + 1, y + h - (r - 1), argb);
        ctx.method_25294(x + w - 1, y + r - 1, x + w, y + h - (r - 1), argb);
    }

    private boolean inputStartsWithP() {
        if (this.input.length() == 0) {
            return false;
        }
        String s = this.input.toString().trim().toLowerCase(Locale.ROOT);
        return s.startsWith("/p");
    }

    private static List<String> suggestP(String cur) {
        String low = cur.trim().toLowerCase(Locale.ROOT);
        ArrayList<String> out = new ArrayList<String>();
        for (String s : P_COMMANDS) {
            if (!s.startsWith(low)) continue;
            out.add(s);
        }
        return out;
    }
}

