/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.screen.box;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_8710;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyJoinRequests;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyMemberInfoBox;
import net.pixeldreamstudios.rpgsystems.network.party.PartyJoinRequestPayloads;

@Environment(value=EnvType.CLIENT)
public final class PartyJoinRequestBox
implements PartyBox {
    private static final class_2960 TEX_JR_ACC_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_joinreq_accept_normal.png");
    private static final class_2960 TEX_JR_ACC_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_joinreq_accept_hover.png");
    private static final class_2960 TEX_JR_DEC_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_joinreq_decline_normal.png");
    private static final class_2960 TEX_JR_DEC_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_joinreq_decline_hover.png");
    private static final int TL_BOX_W = 120;
    private static final int TL_BOX_MARGIN = 8;
    private static final int TL_BOX_OFFSET_Y = 15;
    private static final int GAP_FROM_LEFT_COLUMN = 12;
    private static final int SHIFT_LEFT = 60;
    private static final int LEFT_OF_INVITES_W = 255;
    private static final int GAP_FROM_CHAT = 6;
    private static final int BOX_W = 66;
    private static final int BOX_H = 120;
    private static final int INVITE_BOX_Y_OFFSET = -46;
    private static final int BELOW_INVITES_GAP = 8;
    private static final int PAD = 3;
    private static final float TITLE_SCALE = 0.5f;
    private static final float ROW_SCALE = 0.5f;
    private static final boolean DEBUG_BOX = false;
    private static final int BG = 1075943155;
    private static final int BORDER = -14575885;
    private static final int TITLE_COLOR = -1;
    private static final int ROW_COLOR = -1052689;
    private static final int EMPTY_COLOR = -4276546;
    private static final int BUBBLE_PAD_H = 3;
    private static final int BUBBLE_PAD_V = 2;
    private static final int BUBBLE_GAP = 3;
    private static final int BUBBLE_RADIUS = 3;
    private static final int BUBBLE_BG = -1875692749;
    private static final int BTN_W = 14;
    private static final int BTN_H = 14;
    private static final int BTN_GAP = 2;
    private int boxX;
    private int boxY;
    private int boxW;
    private int boxH;
    private int listLeft;
    private int listTop;
    private int listRight;
    private int listBottom;
    private int rowH;
    private int textHScaled;
    private int bubbleTextMax;
    private int scrollPx = 0;

    @Override
    public void render(class_332 ctx, class_327 tr, int canvasX, int canvasY, int canvasW, int canvasH) {
        int contentLeft = canvasX + 8 + 18;
        int infoTop = canvasY + 8 + 15;
        int xLeftCol = contentLeft + 120;
        this.boxX = xLeftCol + 12 - 60 + 255 + 6 - 1;
        int invitesBoxY = infoTop + PartyMemberInfoBox.getPreferredHeight() + 4 + -46;
        this.boxY = invitesBoxY + 120 + 8;
        this.boxW = 66;
        this.boxH = 120;
        String title = "Join Requests";
        int titleY = this.boxY + 3;
        int titleX = PartyJoinRequestBox.centeredScaledTextX(tr, title, this.boxX, this.boxW, 0.5f);
        PartyJoinRequestBox.drawScaledText(ctx, tr, title, titleX, titleY, -1, 0.5f);
        Objects.requireNonNull(tr);
        this.textHScaled = Math.round(9.0f * 0.5f);
        this.rowH = Math.max(6, this.textHScaled + 4);
        this.listLeft = this.boxX + 3;
        this.listRight = this.boxX + this.boxW - 3;
        this.listTop = titleY + this.textHScaled + 4;
        this.listBottom = this.boxY + this.boxH - 3;
        int buttonsTotalW = 33;
        this.bubbleTextMax = Math.max(0, this.listRight - this.listLeft - 3 - buttonsTotalW);
        List<ClientPartyJoinRequests.Req> reqs = PartyJoinRequestBox.visibleRequests();
        int totalH = Math.max(0, reqs.size() * (this.rowH + 3) - (reqs.isEmpty() ? 0 : 3));
        int visibleH = Math.max(0, this.listBottom - this.listTop);
        int maxScroll = Math.max(0, totalH - visibleH);
        if (this.scrollPx > maxScroll) {
            this.scrollPx = maxScroll;
        }
        if (this.scrollPx < 0) {
            this.scrollPx = 0;
        }
        ctx.method_44379(this.listLeft, this.listTop, this.listRight, this.listBottom);
        if (reqs.isEmpty()) {
            String empty = "No requests";
            int tw = Math.round((float)tr.method_1727(empty) * 0.5f);
            PartyJoinRequestBox.drawScaledText(ctx, tr, empty, this.boxX + (this.boxW - tw) / 2, this.listTop + Math.max(0, (visibleH - this.textHScaled) / 2), -4276546, 0.5f);
        } else {
            int y = this.listTop - this.scrollPx;
            int bubbleW = this.listRight - this.listLeft;
            for (ClientPartyJoinRequests.Req r : reqs) {
                int bx = this.listLeft;
                int by = y;
                if (by + this.rowH >= this.listTop && by <= this.listBottom - 1) {
                    PartyJoinRequestBox.drawSoftRounded(ctx, bx, by, bubbleW, this.rowH, 3, -1875692749);
                    String name = r.requesterName == null ? "Unknown" : r.requesterName;
                    String shown = PartyJoinRequestBox.ellipsize(tr, name, this.bubbleTextMax, 0.5f);
                    int ty = by + (this.rowH - this.textHScaled) / 2;
                    PartyJoinRequestBox.drawScaledText(ctx, tr, shown, bx + 3, ty + 1, -1052689, 0.5f);
                    int btnH = 14;
                    int accX = bx + bubbleW - 3 - 14;
                    int decX = accX - 16;
                    int bY = by + (this.rowH - btnH) / 2 - 1;
                    boolean overDec = PartyJoinRequestBox.isMouseOver(decX, bY, 14, btnH);
                    boolean overAcc = PartyJoinRequestBox.isMouseOver(accX, bY, 14, btnH);
                    float s = 0.5f;
                    int ox = decX + Math.round(3.5f);
                    int oy = bY + Math.round(3.5f);
                    class_4587 m2 = ctx.method_51448();
                    m2.method_22903();
                    m2.method_46416((float)ox, (float)oy, 0.0f);
                    m2.method_22905(0.5f, 0.5f, 1.0f);
                    ctx.method_25290(overDec ? TEX_JR_DEC_HOVER : TEX_JR_DEC_NORMAL, 10, 0, 0.0f, 0.0f, 14, 14, 14, 14);
                    m2.method_22909();
                    ox = accX + Math.round(3.5f);
                    oy = bY + Math.round(3.5f);
                    m2 = ctx.method_51448();
                    m2.method_22903();
                    m2.method_46416((float)ox, (float)oy, 0.0f);
                    m2.method_22905(0.5f, 0.5f, 1.0f);
                    ctx.method_25290(overAcc ? TEX_JR_ACC_HOVER : TEX_JR_ACC_NORMAL, 0, 0, 0.0f, 0.0f, 14, 14, 14, 14);
                    m2.method_22909();
                }
                if ((y += this.rowH + 3) <= this.listBottom) continue;
                break;
            }
        }
        ctx.method_44380();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        if (!PartyJoinRequestBox.isMouseOver(this.boxX, this.boxY, this.boxW, this.boxH)) {
            return false;
        }
        List<ClientPartyJoinRequests.Req> reqs = PartyJoinRequestBox.visibleRequests();
        int y = this.listTop - this.scrollPx;
        int bubbleW = this.listRight - this.listLeft;
        for (ClientPartyJoinRequests.Req r : reqs) {
            int bx = this.listLeft;
            int by = y;
            if (by + this.rowH >= this.listTop && by <= this.listBottom - 1) {
                int accX = bx + bubbleW - 3 - 14;
                int decX = accX - 2 - 14;
                int btnH = Math.max(6, this.textHScaled + 2);
                int bY = by + (this.rowH - btnH) / 2;
                if (PartyJoinRequestBox.isMouseOver(decX, bY, 14, btnH)) {
                    PartyJoinRequestBox.respond(r, false);
                    ClientPartyJoinRequests.removeLocal(r.requesterUuid);
                    return true;
                }
                if (PartyJoinRequestBox.isMouseOver(accX, bY, 14, btnH)) {
                    PartyJoinRequestBox.respond(r, true);
                    ClientPartyJoinRequests.removeLocal(r.requesterUuid);
                    return true;
                }
            }
            if ((y += this.rowH + 3) <= this.listBottom) continue;
            break;
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double ha, double va, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        if (!PartyJoinRequestBox.isMouseOver(this.listLeft, this.listTop, this.listRight - this.listLeft, this.listBottom - this.listTop)) {
            return false;
        }
        int totalH = Math.max(0, PartyJoinRequestBox.visibleRequests().size() * (this.rowH + 3) - 3);
        int visibleH = Math.max(0, this.listBottom - this.listTop);
        int maxScroll = Math.max(0, totalH - visibleH);
        int step = this.rowH + 3;
        this.scrollPx = Math.max(0, Math.min(maxScroll, this.scrollPx + (int)Math.round(va * (double)step)));
        return true;
    }

    private static void respond(ClientPartyJoinRequests.Req r, boolean accept) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1562() == null || r == null) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new PartyJoinRequestPayloads.JoinReqRespond(r.partyId, r.requesterUuid, accept));
    }

    private static String ellipsize(class_327 tr, String s, int maxPixels, float scale) {
        if (Math.round((float)tr.method_1727(s) * scale) <= maxPixels) {
            return s;
        }
        String dots = "...";
        int dw = Math.round((float)tr.method_1727(dots) * scale);
        StringBuilder b = new StringBuilder(s);
        while (b.length() > 0 && Math.round((float)tr.method_1727(b.toString()) * scale) + dw > maxPixels) {
            b.deleteCharAt(b.length() - 1);
        }
        return String.valueOf(b) + dots;
    }

    private static int centeredScaledTextX(class_327 tr, String text, int boxX, int boxW, float scale) {
        return Math.round((float)boxX + ((float)boxW - (float)tr.method_1727(text) * scale) / 2.0f);
    }

    private static void drawScaledText(class_332 ctx, class_327 tr, String text, int x, int y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    private static void drawBorder(class_332 ctx, int x, int y, int w, int h, int argb) {
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, 0);
    }

    private static void drawSoftRounded(class_332 ctx, int x, int y, int w, int h, int r, int argb) {
        r = Math.max(2, Math.min(r, Math.min(w / 2, h / 2)));
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, argb);
        ctx.method_25294(x + r - 1, y, x + w - (r - 1), y + 1, argb);
        ctx.method_25294(x + r - 1, y + h - 1, x + w - (r - 1), y + h, argb);
        ctx.method_25294(x, y + r - 1, x + 1, y + h - (r - 1), argb);
        ctx.method_25294(x + w - 1, y + r - 1, x + w, y + h - (r - 1), argb);
    }

    private static boolean isMouseOver(int x, int y, int w, int h) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return false;
        }
        double mx = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double my = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private static List<ClientPartyJoinRequests.Req> visibleRequests() {
        Set<UUID> memberIds = ClientPartyHudData.members().stream().map(m -> m.uuid).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!memberIds.isEmpty()) {
            ClientPartyJoinRequests.pruneByPartyMembers(memberIds);
        }
        return ClientPartyJoinRequests.pending();
    }
}

