/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.screen.box;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyPins;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyBox;

@Environment(value=EnvType.CLIENT)
public final class PartyMembersBox
implements PartyBox {
    private static final boolean DEBUG_BOXES = false;
    private static final int TL_BOX_W = 66;
    private static final int TL_BOX_H = 40;
    private static final int TL_BOX_MARGIN = 8;
    private static final int TL_BOX_OFFSET_Y = 15;
    private static final int BELOW_GAP = 4;
    private static final float TEXT_SCALE = 0.5f;
    private static final int ROW_H = 12;
    private static final int CONTENT_PAD_X = 6;
    private static final int CONTENT_PAD_Y = 6;
    private static final int MAX_BOX_H = 210;
    private static final int HINT_PAD_X = 4;
    private static final int HINT_PAD_Y = 3;
    private static final class_2960 PARTY_LEADER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_leader.png");
    private static final class_2960 KICK_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/kick_normal.png");
    private static final class_2960 KICK_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/kick_hover.png");
    private static final class_2960 OFFLINE_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/offline.png");
    private static final class_2960 PIN_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/pin.png");
    private static final int ICON_W = 8;
    private static final int ICON_H = 8;
    private static final int ICON_PAD_RIGHT = 3;
    private static final int KICK_W = 8;
    private static final int KICK_H = 8;
    private static final int SCROLLBAR_WIDTH = 4;
    private static final int SCROLLBAR_PAD_RIGHT = 2;
    private static final int SCROLLBAR_PAD_Y = 2;
    private static final int SCROLLBAR_TRACK_HEIGHT = -1;
    private static final int SCROLLBAR_THUMB_MIN = 10;
    private static final int SCROLLBAR_COLOR_TRACK = 0x40101010;
    private static final int SCROLLBAR_COLOR_THUMB = -1862270977;
    private static final int CONTROL_H = 0;
    private static final float HINT_SCALE = 0.55f;
    private static final float DIALOG_SCALE = 0.6f;
    private static final int DIALOG_PAD = 8;
    private static final int DIALOG_BUTTON_PAD_X = 8;
    private static final int DIALOG_BUTTON_PAD_Y = 4;
    private static final int DIALOG_LIST_MAX_ROWS = 8;
    private static final int DIALOG_BG = -803069406;
    private static final int DIALOG_BG_SHADOW = 0x60000000;
    private static final int DIALOG_BORDER = -2130706433;
    private static final int BTN_BG = -12875319;
    private static final int BTN_BG_HOVER = -11557918;
    private static final int BTN_BG_DISABLED = -9737365;
    private static final int BTN_TEXT = -1;
    private static final int DIALOG_TITLE = -1;
    private static final int DIALOG_TEXT = -1052689;
    private static final int DIALOG_BACKDROP = Integer.MIN_VALUE;
    private static final int LIST_ROW_H = 12;
    public static final int DIALOG_W_MIN = 140;
    public static final int DIALOG_W_MAX = 180;
    private static boolean texturesFiltered = false;
    private UUID selected = null;
    private int scrollPx = 0;
    private boolean draggingScrollbar = false;
    private int dragGrabOffsetY = 0;
    private List<ClientPartyHudData.Member> lastListForPins = Collections.emptyList();
    private ClientPartyHudData.Member hoverMember = null;
    private boolean hoverOverPinIcon = false;
    private ClientPartyHudData.Member hoverKickMember = null;
    private boolean hoverOverKick = false;
    private boolean hoverOverLeaderIcon = false;
    private boolean showPromoteDialog = false;
    private List<ClientPartyHudData.Member> promoteCandidates = Collections.emptyList();
    private int promoteSelectedIndex = -1;
    private int promoteListScrollPx = 0;

    @Override
    public void render(class_332 ctx, class_327 tr, int canvasX, int canvasY, int canvasW, int canvasH) {
        PartyMembersBox.ensureNearestFilters();
        int infoX = canvasX + 8 + 18;
        int infoY = canvasY + 8 + 15;
        int infoW = 66;
        int infoH = 40;
        int x = infoX;
        int y = infoY + infoH + 4;
        int w = infoW;
        int bottomMargin = 8;
        int h = Math.min(210, Math.max(0, canvasY + canvasH - bottomMargin - y));
        ArrayList<ClientPartyHudData.Member> base = new ArrayList<ClientPartyHudData.Member>(ClientPartyHudData.members());
        base.sort(Comparator.comparing(m -> m.name == null ? "" : m.name.toLowerCase(Locale.ROOT)));
        this.lastListForPins = base;
        int listTop = y + 6;
        int naturalBottom = y + h - 6 - 0;
        int minVisibleH = 192;
        int listBottom = naturalBottom;
        int availableH = naturalBottom - listTop;
        if (availableH < minVisibleH) {
            listBottom = Math.min(naturalBottom, listTop + minVisibleH);
        }
        int visibleH = Math.max(0, listBottom - listTop);
        int totalRows = base.size();
        int totalH = totalRows * 12;
        int maxScroll = Math.max(0, totalH - visibleH);
        this.scrollPx = PartyMembersBox.clampToRow(PartyMembersBox.snapToRow(this.scrollPx), 0, maxScroll);
        boolean showScrollbarLocal = totalH > visibleH;
        int rightPadForScrollbar = showScrollbarLocal ? 6 : 0;
        int startRow = this.scrollPx / 12;
        int drawY = listTop;
        UUID leaderUuid = PartyMembersBox.effectiveLeaderUuid(base);
        UUID viewerUuid = null;
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null) {
            viewerUuid = mc.field_1724.method_5667();
        }
        boolean viewerIsLeader = leaderUuid != null && leaderUuid.equals(viewerUuid);
        int mx = (int)(class_310.method_1551().field_1729.method_1603() * (double)class_310.method_1551().method_22683().method_4486() / (double)class_310.method_1551().method_22683().method_4480());
        int my = (int)(class_310.method_1551().field_1729.method_1604() * (double)class_310.method_1551().method_22683().method_4502() / (double)class_310.method_1551().method_22683().method_4507());
        this.hoverMember = null;
        this.hoverOverPinIcon = false;
        this.hoverKickMember = null;
        this.hoverOverKick = false;
        this.hoverOverLeaderIcon = false;
        for (int i = startRow; i < totalRows && drawY + 12 <= listBottom; ++i) {
            int nameRightLimit;
            int rowContentRight;
            boolean isSel;
            ClientPartyHudData.Member m2 = (ClientPartyHudData.Member)base.get(i);
            boolean bl = isSel = this.selected != null && this.selected.equals(m2.uuid);
            if (isSel) {
                ctx.method_25294(x + 2, drawY - 1, x + w - 2, drawY + 12 - 1, -2143581751);
            }
            boolean isLeaderRow = leaderUuid != null && leaderUuid.equals(m2.uuid);
            int rightElemLeft = rowContentRight = x + w - 6 - rightPadForScrollbar;
            int textTopY = drawY + 2;
            int nameStartX = x + 6;
            if (isLeaderRow) {
                int n = rowContentRight - 8;
                float f = textTopY;
                Objects.requireNonNull(tr);
                int iconY = Math.round(f + (9.0f * 0.5f - 8.0f) / 2.0f);
                ctx.method_25290(PARTY_LEADER, n, iconY, 0.0f, 0.0f, 8, 8, 8, 8);
                rightElemLeft = n;
                if (viewerIsLeader && PartyMembersBox.isMouseOver(n, iconY, 8, 8)) {
                    this.hoverOverLeaderIcon = true;
                }
            } else if (viewerIsLeader) {
                int n = rowContentRight - 8;
                float f = textTopY;
                Objects.requireNonNull(tr);
                int btnY = Math.round(f + (9.0f * 0.5f - 8.0f) / 2.0f);
                boolean overKick = PartyMembersBox.isMouseOver(n, btnY, 8, 8);
                ctx.method_25290(overKick ? KICK_HOVER : KICK_NORMAL, n, btnY, 0.0f, 0.0f, 8, 8, 8, 8);
                rightElemLeft = n;
                if (overKick) {
                    this.hoverOverKick = true;
                    this.hoverKickMember = m2;
                }
            }
            String string = m2.totalLevel >= 0 ? "Lv. " + m2.totalLevel : null;
            int levelPad = 4;
            if (!m2.online) {
                int icoX = rightElemLeft - levelPad - 8;
                float f = textTopY;
                Objects.requireNonNull(tr);
                int icoY = Math.round(f + (9.0f * 0.5f - 8.0f) / 2.0f);
                ctx.method_25290(OFFLINE_ICON, icoX, icoY, 0.0f, 0.0f, 8, 8, 8, 8);
                nameRightLimit = icoX - 3;
            } else if (string != null) {
                int lvlWpx = Math.round((float)tr.method_1727(string) * 0.5f);
                int lvlX = rightElemLeft - levelPad - lvlWpx;
                int lvlY = textTopY;
                PartyMembersBox.drawScaledText(ctx, tr, string, lvlX, lvlY, -1052689, 0.5f);
                nameRightLimit = lvlX - 3;
            } else {
                nameRightLimit = rightElemLeft - 3;
            }
            boolean isPinned = ClientPartyPins.isPinned(m2.uuid);
            int pinIconX = -1;
            int pinIconY = -1;
            if (isPinned) {
                pinIconX = nameStartX;
                float f = textTopY;
                Objects.requireNonNull(tr);
                pinIconY = Math.round(f + (9.0f * 0.5f - 8.0f) / 2.0f);
                PartyMembersBox.drawPinCrisp(ctx, pinIconX, pinIconY);
                nameStartX += 11;
            }
            int textMaxPixels = Math.max(0, nameRightLimit - nameStartX);
            String name = m2.name == null ? "Unknown" : m2.name;
            String clipped = PartyMembersBox.ellipsize(tr, name, (float)textMaxPixels / 0.5f);
            int nameColor = isPinned ? -8062 : -1;
            PartyMembersBox.drawScaledText(ctx, tr, clipped, nameStartX, textTopY, nameColor, 0.5f);
            int rowLeft = x;
            int rowRight = x + w;
            if (!this.hoverOverKick && mx >= rowLeft && mx < rowRight && my >= drawY && my < drawY + 12) {
                this.hoverMember = m2;
                if (isPinned && pinIconX >= 0) {
                    this.hoverOverPinIcon = mx >= pinIconX && mx < pinIconX + 8 && my >= pinIconY && my < pinIconY + 8;
                }
            }
            drawY += 12;
        }
        if (base.isEmpty()) {
            String none = "No members";
            int tw = Math.round((float)tr.method_1727(none) * 0.5f);
            int tx = x + (w - tw) / 2;
            Objects.requireNonNull(tr);
            int ty = y + (h - Math.round(9.0f * 0.5f)) / 2;
            PartyMembersBox.drawScaledText(ctx, tr, none, tx, ty, -4276546, 0.5f);
        }
        if (showScrollbarLocal) {
            int trackX = x + w - 2 - 4;
            int trackH = visibleH;
            int trackTop = listTop + 2;
            trackH = Math.max(0, trackH - 4);
            ctx.method_25294(trackX, trackTop, trackX + 4, trackTop + trackH, 0x40101010);
            int thumbH = Math.max(10, (int)Math.ceil((double)trackH * ((double)visibleH / (double)totalH)));
            thumbH = Math.min(thumbH, trackH);
            int thumbY = trackTop;
            if (maxScroll > 0 && trackH > thumbH) {
                double ratio = (double)this.scrollPx / (double)maxScroll;
                thumbY = trackTop + (int)Math.round((double)(trackH - thumbH) * ratio);
            }
            ctx.method_25294(trackX, thumbY, trackX + 4, thumbY + thumbH, -1862270977);
        }
        if (this.hoverOverKick && this.hoverKickMember != null) {
            String label = "Kick " + (this.hoverKickMember.name == null ? "Unknown" : this.hoverKickMember.name) + "?";
            this.drawHint(ctx, tr, label, mx, my, canvasX, canvasY, canvasW, canvasH);
        } else if (this.hoverOverLeaderIcon && viewerIsLeader) {
            String label = "Change leader?";
            this.drawHint(ctx, tr, label, mx, my, canvasX, canvasY, canvasW, canvasH);
        } else if (this.hoverMember != null) {
            String fullName;
            boolean pinned = ClientPartyPins.isPinned(this.hoverMember.uuid);
            boolean overPin = this.hoverOverPinIcon;
            boolean isSelf = false;
            class_310 mcSelf = class_310.method_1551();
            if (mcSelf != null && mcSelf.field_1724 != null) {
                isSelf = this.hoverMember.uuid != null && this.hoverMember.uuid.equals(mcSelf.field_1724.method_5667());
            }
            String string = fullName = this.hoverMember.name == null ? "Unknown" : this.hoverMember.name;
            if (overPin && pinned) {
                Integer order = ClientPartyPins.getOrder(this.hoverMember.uuid);
                String label = "Middle click to Unpin #" + order;
                int iconW = 8;
                int n = 8;
                int textW = Math.round((float)tr.method_1727(label) * 0.55f);
                Objects.requireNonNull(tr);
                int textH = Math.max(1, Math.round(9.0f * 0.55f));
                int contentH = Math.max(n, textH);
                int boxW = 4 + iconW + 3 + textW + 4;
                int boxH = 3 + contentH + 3;
                int bx = Math.min(mx + 12, canvasX + canvasW - boxW - 2);
                int by = Math.min(my + 10, canvasY + canvasH - boxH - 2);
                ctx.method_25294(bx + 2, by + 2, bx + boxW + 2, by + boxH + 2, 0x60000000);
                ctx.method_25294(bx, by, bx + boxW, by + boxH, -1071504862);
                PartyMembersBox.drawBorder(ctx, bx, by, boxW, boxH, -2130706433);
                int iconY = by + 3 + (contentH - n) / 2;
                int ix = bx + 4;
                PartyMembersBox.drawPinCrisp(ctx, ix, iconY);
                int ty = by + 3 + (contentH - textH) / 2;
                int tx = ix + iconW + 3;
                PartyMembersBox.drawScaledText(ctx, tr, label, tx, ty, -3618616, 0.55f);
            } else {
                ArrayList<Object> lines = new ArrayList<Object>();
                lines.add(fullName);
                if (!pinned && !isSelf) {
                    lines.add("Middle click to Pin #" + ClientPartyPins.nextOrder());
                }
                int maxW = 0;
                for (String string2 : lines) {
                    maxW = Math.max(maxW, Math.round((float)tr.method_1727(string2) * 0.55f));
                }
                Objects.requireNonNull(tr);
                int lineH = Math.max(1, Math.round(9.0f * 0.55f));
                int n = lines.size() * lineH + Math.max(0, lines.size() - 1);
                int boxW = 4 + maxW + 4;
                int boxH = 3 + n + 3;
                int bx = Math.min(mx + 12, canvasX + canvasW - boxW - 2);
                int by = Math.min(my + 10, canvasY + canvasH - boxH - 2);
                ctx.method_25294(bx + 2, by + 2, bx + boxW + 2, by + boxH + 2, 0x60000000);
                ctx.method_25294(bx, by, bx + boxW, by + boxH, -1071504862);
                PartyMembersBox.drawBorder(ctx, bx, by, boxW, boxH, -2130706433);
                int ty = by + 3;
                for (int i = 0; i < lines.size(); ++i) {
                    String ln = (String)lines.get(i);
                    int lw = Math.round((float)tr.method_1727(ln) * 0.55f);
                    int tx = bx + (boxW - 8 - lw) / 2 + 4;
                    int color = i == 0 ? -1 : -3618616;
                    PartyMembersBox.drawScaledText(ctx, tr, ln, tx, ty, color, 0.55f);
                    if (i + 1 >= lines.size()) continue;
                    ty += lineH + 1;
                }
            }
        }
        if (this.showPromoteDialog) {
            this.drawPromoteDialog(ctx, tr, canvasX, canvasY, canvasW, canvasH, base, leaderUuid);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        int startRow;
        int index;
        boolean viewerIsLeader;
        int minVisibleH;
        int listTop;
        if (this.showPromoteDialog) {
            return this.handlePromoteDialogClick(mouseX, mouseY, button, canvasX, canvasY, canvasW, canvasH, tr);
        }
        int infoX = canvasX + 8 + 18;
        int infoY = canvasY + 8 + 15;
        int y = infoY + 40 + 4;
        int w = 66;
        int bottomMargin = 8;
        int h = Math.min(210, Math.max(0, canvasY + canvasH - bottomMargin - y));
        int listBottom = y + h - 6 - 0;
        if (listBottom - (listTop = y + 6) < (minVisibleH = 192)) {
            listBottom = Math.min(listBottom, listTop + minVisibleH);
        }
        if (mouseX < (double)infoX || mouseX >= (double)(infoX + w) || mouseY < (double)listTop || mouseY >= (double)listBottom) {
            return false;
        }
        ArrayList<ClientPartyHudData.Member> base = new ArrayList<ClientPartyHudData.Member>(ClientPartyHudData.members());
        base.sort(Comparator.comparing(m -> m.name == null ? "" : m.name.toLowerCase(Locale.ROOT)));
        int visibleH = Math.max(0, listBottom - listTop);
        int totalH = base.size() * 12;
        int maxScroll = Math.max(0, totalH - visibleH);
        this.scrollPx = PartyMembersBox.clampToRow(PartyMembersBox.snapToRow(this.scrollPx), 0, maxScroll);
        boolean showScrollbar = totalH > visibleH;
        UUID leaderUuid = ClientPartyHudData.leaderUuid;
        UUID viewerUuid = class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5667() : null;
        boolean bl = viewerIsLeader = leaderUuid != null && leaderUuid.equals(viewerUuid);
        if (viewerIsLeader) {
            int rightPadForScrollbar = showScrollbar ? 6 : 0;
            int startRowForHit = this.scrollPx / 12;
            int drawY = listTop;
            for (int i = startRowForHit; i < base.size() && drawY + 12 <= listBottom; ++i) {
                ClientPartyHudData.Member m2 = (ClientPartyHudData.Member)base.get(i);
                boolean isLeaderRow = leaderUuid != null && leaderUuid.equals(m2.uuid);
                int textTopY = drawY + 2;
                int rowContentRight = infoX + w - 6 - rightPadForScrollbar;
                if (isLeaderRow) {
                    int iconX = rowContentRight - 8;
                    float f = textTopY;
                    Objects.requireNonNull(tr);
                    int iconY = Math.round(f + (9.0f * 0.5f - 8.0f) / 2.0f);
                    if (mouseX >= (double)iconX && mouseX < (double)(iconX + 8) && mouseY >= (double)iconY && mouseY < (double)(iconY + 8)) {
                        this.openPromoteDialog(base, leaderUuid);
                        return true;
                    }
                } else if (m2.uuid != null && viewerUuid != null && !viewerUuid.equals(m2.uuid)) {
                    int btnX = rowContentRight - 8;
                    float f = textTopY;
                    Objects.requireNonNull(tr);
                    int btnY = Math.round(f + (9.0f * 0.5f - 8.0f) / 2.0f);
                    if (mouseX >= (double)btnX && mouseX < (double)(btnX + 8) && mouseY >= (double)btnY && mouseY < (double)(btnY + 8)) {
                        class_310 mc = class_310.method_1551();
                        if (mc != null && mc.method_1562() != null && m2.name != null && !m2.name.isBlank()) {
                            mc.method_1562().method_45730("party kick " + m2.name);
                        }
                        return true;
                    }
                }
                drawY += 12;
            }
        }
        if ((index = (startRow = this.scrollPx / 12) + (int)((mouseY - (double)listTop) / 12.0)) < 0 || index >= base.size()) {
            return false;
        }
        ClientPartyHudData.Member m3 = (ClientPartyHudData.Member)base.get(index);
        if (button == 0) {
            this.selected = m3.uuid;
            ClientPartyHudData.setSelectedMember(m3.uuid);
            return true;
        }
        if (button == 2) {
            UUID self;
            UUID uUID = self = class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5667() : null;
            if (self != null && self.equals(m3.uuid)) {
                return true;
            }
            if (ClientPartyPins.isPinned(m3.uuid)) {
                ClientPartyPins.unpin(m3.uuid);
            } else {
                ClientPartyPins.pin(m3.uuid, 0, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        int minVisibleH;
        int listTop;
        if (this.showPromoteDialog) {
            return this.handlePromoteDialogScroll(mouseX, mouseY, verticalAmount, canvasX, canvasY, canvasW, canvasH, tr);
        }
        int infoX = canvasX + 8 + 18;
        int infoY = canvasY + 8 + 15;
        int infoW = 66;
        int infoH = 40;
        int x = infoX;
        int y = infoY + infoH + 4;
        int w = infoW;
        int bottomMargin = 8;
        int h = Math.min(210, Math.max(0, canvasY + canvasH - bottomMargin - y));
        int listBottom = y + h - 6 - 0;
        if (listBottom - (listTop = y + 6) < (minVisibleH = 192)) {
            listBottom = Math.min(listBottom, listTop + minVisibleH);
        }
        if (mouseX < (double)x || mouseX >= (double)(x + w) || mouseY < (double)listTop || mouseY >= (double)listBottom) {
            return false;
        }
        ArrayList<ClientPartyHudData.Member> base = new ArrayList<ClientPartyHudData.Member>(ClientPartyHudData.members());
        int visibleH = Math.max(0, listBottom - listTop);
        int totalH = base.size() * 12;
        int maxScroll = Math.max(0, totalH - visibleH);
        int delta = (int)Math.round(-verticalAmount * 12.0);
        this.scrollPx = PartyMembersBox.clampToRow(PartyMembersBox.snapToRow(this.scrollPx + delta), 0, maxScroll);
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        int minVisibleH;
        int listTop;
        if (this.showPromoteDialog) {
            return false;
        }
        if (!this.draggingScrollbar) {
            return false;
        }
        int infoX = canvasX + 8 + 18;
        int infoY = canvasY + 8 + 15;
        int infoW = 66;
        int infoH = 40;
        int x = infoX;
        int y = infoY + infoH + 4;
        int w = infoW;
        int bottomMargin = 8;
        int h = Math.min(210, Math.max(0, canvasY + canvasH - bottomMargin - y));
        int listBottom = y + h - 6 - 0;
        if (listBottom - (listTop = y + 6) < (minVisibleH = 192)) {
            listBottom = Math.min(listBottom, listTop + minVisibleH);
        }
        ArrayList<ClientPartyHudData.Member> base = new ArrayList<ClientPartyHudData.Member>(ClientPartyHudData.members());
        int visibleH = Math.max(0, listBottom - listTop);
        int totalH = base.size() * 12;
        int maxScroll = Math.max(0, totalH - visibleH);
        int trackTop = listTop + 2;
        int trackH = visibleH;
        trackH = Math.max(0, trackH - 4);
        int thumbH = Math.max(10, (int)Math.ceil((double)trackH * ((double)visibleH / (double)totalH)));
        thumbH = Math.min(thumbH, trackH);
        int newThumbY = (int)Math.round(mouseY) - this.dragGrabOffsetY;
        newThumbY = Math.max(trackTop, Math.min(trackTop + trackH - thumbH, newThumbY));
        double denom = Math.max(1.0, (double)(trackH - thumbH));
        double ratio = (double)(newThumbY - trackTop) / denom;
        this.scrollPx = PartyMembersBox.clampToRow(PartyMembersBox.snapToRow((int)Math.round(ratio * (double)maxScroll)), 0, maxScroll);
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return false;
    }

    private static int snapToRow(int px) {
        if (px <= 0) {
            return 0;
        }
        return px / 12 * 12;
    }

    private static int clampToRow(int px, int min, int max) {
        if (px < min) {
            return min;
        }
        return Math.min(px, max - max % 12);
    }

    private static void ensureNearestFilters() {
        if (texturesFiltered) {
            return;
        }
        class_1060 tm = class_310.method_1551().method_1531();
        for (class_2960 id : new class_2960[]{PARTY_LEADER, KICK_NORMAL, KICK_HOVER, OFFLINE_ICON, PIN_ICON}) {
            class_1044 t = tm.method_4619(id);
            if (t == null) continue;
            t.method_4527(false, false);
        }
        texturesFiltered = true;
    }

    private static UUID effectiveLeaderUuid(List<ClientPartyHudData.Member> list) {
        UUID leader = ClientPartyHudData.leaderUuid;
        if (leader != null) {
            for (ClientPartyHudData.Member m : list) {
                if (!m.uuid.equals(leader)) continue;
                return leader;
            }
        }
        return list.isEmpty() ? null : list.get((int)0).uuid;
    }

    private static void drawScaledText(class_332 ctx, class_327 tr, String text, int x, int y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    private static String ellipsize(class_327 tr, String s, double maxLogicalWidth) {
        if ((double)tr.method_1727(s) <= maxLogicalWidth) {
            return s;
        }
        String dots = "...";
        int dw = tr.method_1727(dots);
        StringBuilder b = new StringBuilder(s);
        while (b.length() > 0 && (double)(tr.method_1727(b.toString()) + dw) > maxLogicalWidth) {
            b.deleteCharAt(b.length() - 1);
        }
        return String.valueOf(b) + dots;
    }

    private static void drawBorder(class_332 ctx, int x, int y, int w, int h, int argb) {
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x, y + 1, x + 1, y + h - 1, argb);
        ctx.method_25294(x + w - 1, y + 1, x + w, y + h - 1, argb);
    }

    private static boolean isMouseOver(int x, int y, int w, int h) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return false;
        }
        double mx = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double my = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private static void drawPinCrisp(class_332 ctx, int x, int y) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(0.25f, 0.25f, 1.0f);
        ctx.method_25290(PIN_ICON, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        m.method_22909();
    }

    private void drawHint(class_332 ctx, class_327 tr, String label, int mx, int my, int canvasX, int canvasY, int canvasW, int canvasH) {
        int textW = Math.round((float)tr.method_1727(label) * 0.55f);
        Objects.requireNonNull(tr);
        int textH = Math.max(1, Math.round(9.0f * 0.55f));
        int boxW = 4 + textW + 4;
        int boxH = 3 + textH + 3;
        int bx = Math.min(mx + 12, canvasX + canvasW - boxW - 2);
        int by = Math.min(my + 10, canvasY + canvasH - boxH - 2);
        ctx.method_25294(bx + 2, by + 2, bx + boxW + 2, by + boxH + 2, 0x60000000);
        ctx.method_25294(bx, by, bx + boxW, by + boxH, -1071504862);
        PartyMembersBox.drawBorder(ctx, bx, by, boxW, boxH, -2130706433);
        int tx = bx + (boxW - 8 - textW) / 2 + 4;
        int ty = by + 3 + (boxH - 6 - textH) / 2;
        PartyMembersBox.drawScaledText(ctx, tr, label, tx, ty, -1, 0.55f);
    }

    private void openPromoteDialog(List<ClientPartyHudData.Member> base, UUID leaderUuid) {
        ArrayList<ClientPartyHudData.Member> cands = new ArrayList<ClientPartyHudData.Member>();
        for (ClientPartyHudData.Member m2 : base) {
            if (m2.uuid == null || m2.uuid.equals(leaderUuid)) continue;
            cands.add(m2);
        }
        cands.sort(Comparator.comparing(m -> m.name == null ? "" : m.name.toLowerCase(Locale.ROOT)));
        this.promoteCandidates = cands;
        this.promoteSelectedIndex = -1;
        this.promoteListScrollPx = 0;
        this.showPromoteDialog = true;
    }

    private void drawPromoteDialog(class_332 ctx, class_327 tr, int canvasX, int canvasY, int canvasW, int canvasH, List<ClientPartyHudData.Member> base, UUID leaderUuid) {
        boolean canPromote;
        int dialogW = Math.max(140, Math.min(180, canvasW - 32));
        Objects.requireNonNull(tr);
        int titleH = Math.max(1, Math.round(9.0f * 0.6f));
        int listRows = Math.min(8, Math.max(1, this.promoteCandidates.size()));
        int listAreaH = listRows * 12;
        Objects.requireNonNull(tr);
        int buttonsH = 8 + Math.max(1, Math.round(9.0f * 0.6f));
        int dialogH = 8 + titleH + 6 + listAreaH + 8 + buttonsH + 8;
        int dx = canvasX + (canvasW - dialogW) / 2;
        int dy = canvasY + (canvasH - dialogH) / 2;
        ctx.method_25294(dx + 2, dy + 2, dx + dialogW + 2, dy + dialogH + 2, 0x60000000);
        ctx.method_25294(dx, dy, dx + dialogW, dy + dialogH, -803069406);
        PartyMembersBox.drawBorder(ctx, dx, dy, dialogW, dialogH, -2130706433);
        String title = "Promote new leader";
        int tw = Math.round((float)tr.method_1727(title) * 0.6f);
        int tx = dx + (dialogW - tw) / 2;
        int ty = dy + 8;
        PartyMembersBox.drawScaledText(ctx, tr, title, tx, ty, -1, 0.6f);
        int listTop = ty + titleH + 6;
        int listLeft = dx + 8;
        int listRight = dx + dialogW - 8;
        int listBottom = listTop + listAreaH;
        ctx.method_25294(listLeft - 1, listTop - 1, listRight + 1, listBottom + 1, 0x20101010);
        int totalH = this.promoteCandidates.size() * 12;
        int visibleH = listAreaH;
        int maxScroll = Math.max(0, totalH - visibleH);
        this.promoteListScrollPx = PartyMembersBox.clampToRow(PartyMembersBox.snapToRow(this.promoteListScrollPx), 0, maxScroll);
        int startRow = this.promoteListScrollPx / 12;
        int drawY = listTop;
        for (int i = startRow; i < this.promoteCandidates.size() && drawY + 12 <= listBottom; ++i) {
            boolean sel;
            ClientPartyHudData.Member m = this.promoteCandidates.get(i);
            boolean bl = sel = i == this.promoteSelectedIndex;
            if (sel) {
                ctx.method_25294(listLeft, drawY, listRight, drawY + 12, -2143581751);
            }
            String name = m.name == null ? "Unknown" : m.name;
            int lw = Math.round((float)tr.method_1727(name) * 0.6f);
            int centerX = listLeft + (listRight - listLeft - lw) / 2;
            PartyMembersBox.drawScaledText(ctx, tr, name, centerX, drawY + 2, -1052689, 0.6f);
            drawY += 12;
        }
        int btnY = listBottom + 8;
        String cancelLabel = "Cancel";
        String promoteLabel = "Promote";
        int cancelW = Math.round((float)tr.method_1727(cancelLabel) * 0.6f) + 16;
        int promoteW = Math.round((float)tr.method_1727(promoteLabel) * 0.6f) + 16;
        int gap = 6;
        int totalBtnsW = cancelW + gap + promoteW;
        int cancelX = dx + (dialogW - totalBtnsW) / 2;
        int promoteX = cancelX + cancelW + gap;
        Objects.requireNonNull(tr);
        int btnH = 8 + Math.max(1, Math.round(9.0f * 0.6f));
        int mx = (int)(class_310.method_1551().field_1729.method_1603() * (double)class_310.method_1551().method_22683().method_4486() / (double)class_310.method_1551().method_22683().method_4480());
        int my = (int)(class_310.method_1551().field_1729.method_1604() * (double)class_310.method_1551().method_22683().method_4502() / (double)class_310.method_1551().method_22683().method_4507());
        boolean overCancel = mx >= cancelX && mx < cancelX + cancelW && my >= btnY && my < btnY + btnH;
        boolean overPromote = mx >= promoteX && mx < promoteX + promoteW && my >= btnY && my < btnY + btnH;
        ctx.method_25294(cancelX, btnY, cancelX + cancelW, btnY + btnH, overCancel ? -11557918 : -12875319);
        PartyMembersBox.drawBorder(ctx, cancelX, btnY, cancelW, btnH, 0x40000000);
        int cancelTextX = cancelX + (cancelW - Math.round((float)tr.method_1727(cancelLabel) * 0.6f)) / 2;
        Objects.requireNonNull(tr);
        int cancelTextY = btnY + (btnH - Math.round(9.0f * 0.6f)) / 2;
        PartyMembersBox.drawScaledText(ctx, tr, cancelLabel, cancelTextX, cancelTextY, -1, 0.6f);
        boolean bl = canPromote = this.promoteSelectedIndex >= 0 && this.promoteSelectedIndex < this.promoteCandidates.size();
        int promoteBg = canPromote ? (overPromote ? -11557918 : -12875319) : -9737365;
        ctx.method_25294(promoteX, btnY, promoteX + promoteW, btnY + btnH, promoteBg);
        PartyMembersBox.drawBorder(ctx, promoteX, btnY, promoteW, btnH, 0x40000000);
        int promoteTextX = promoteX + (promoteW - Math.round((float)tr.method_1727(promoteLabel) * 0.6f)) / 2;
        Objects.requireNonNull(tr);
        int promoteTextY = btnY + (btnH - Math.round(9.0f * 0.6f)) / 2;
        PartyMembersBox.drawScaledText(ctx, tr, promoteLabel, promoteTextX, promoteTextY, -1, 0.6f);
    }

    private boolean handlePromoteDialogClick(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        int dialogW = Math.max(140, Math.min(180, canvasW - 32));
        Objects.requireNonNull(tr);
        int titleH = Math.max(1, Math.round(9.0f * 0.6f));
        int listRows = Math.min(8, Math.max(1, this.promoteCandidates.size()));
        int listAreaH = listRows * 12;
        Objects.requireNonNull(tr);
        int buttonsH = 8 + Math.max(1, Math.round(9.0f * 0.6f));
        int dialogH = 8 + titleH + 6 + listAreaH + 8 + buttonsH + 8;
        int dx = canvasX + (canvasW - dialogW) / 2;
        int dy = canvasY + (canvasH - dialogH) / 2;
        int listTop = dy + 8 + titleH + 6;
        int listLeft = dx + 8;
        int listRight = dx + dialogW - 8;
        int listBottom = listTop + listAreaH;
        int totalH = this.promoteCandidates.size() * 12;
        int visibleH = listAreaH;
        int maxScroll = Math.max(0, totalH - visibleH);
        this.promoteListScrollPx = PartyMembersBox.clampToRow(PartyMembersBox.snapToRow(this.promoteListScrollPx), 0, maxScroll);
        if (button == 0) {
            boolean canPromote;
            if (mouseX >= (double)listLeft && mouseX < (double)listRight && mouseY >= (double)listTop && mouseY < (double)listBottom) {
                int startRow = this.promoteListScrollPx / 12;
                int index = startRow + (int)((mouseY - (double)listTop) / 12.0);
                if (index >= 0 && index < this.promoteCandidates.size()) {
                    this.promoteSelectedIndex = index;
                }
                return true;
            }
            String cancelLabel = "Cancel";
            String promoteLabel = "Promote";
            int cancelW = Math.round((float)tr.method_1727(cancelLabel) * 0.6f) + 16;
            int promoteW = Math.round((float)tr.method_1727(promoteLabel) * 0.6f) + 16;
            int gap = 6;
            int totalBtnsW = cancelW + gap + promoteW;
            int btnY = listBottom + 8;
            int cancelX = dx + (dialogW - totalBtnsW) / 2;
            int promoteX = cancelX + cancelW + gap;
            Objects.requireNonNull(tr);
            int btnH = 8 + Math.max(1, Math.round(9.0f * 0.6f));
            if (mouseX >= (double)cancelX && mouseX < (double)(cancelX + cancelW) && mouseY >= (double)btnY && mouseY < (double)(btnY + btnH)) {
                this.showPromoteDialog = false;
                return true;
            }
            boolean bl = canPromote = this.promoteSelectedIndex >= 0 && this.promoteSelectedIndex < this.promoteCandidates.size();
            if (mouseX >= (double)promoteX && mouseX < (double)(promoteX + promoteW) && mouseY >= (double)btnY && mouseY < (double)(btnY + btnH)) {
                if (canPromote) {
                    class_310 mc;
                    ClientPartyHudData.Member sel = this.promoteCandidates.get(this.promoteSelectedIndex);
                    if (sel != null && sel.name != null && !sel.name.isBlank() && (mc = class_310.method_1551()) != null && mc.method_1562() != null) {
                        mc.method_1562().method_45730("party promote " + sel.name);
                    }
                    this.showPromoteDialog = false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean handlePromoteDialogScroll(double mouseX, double mouseY, double verticalAmount, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        int dialogW = Math.max(140, Math.min(180, canvasW - 32));
        Objects.requireNonNull(tr);
        int titleH = Math.max(1, Math.round(9.0f * 0.6f));
        int listRows = Math.min(8, Math.max(1, this.promoteCandidates.size()));
        int listAreaH = listRows * 12;
        Objects.requireNonNull(tr);
        int dialogH = 8 + titleH + 6 + listAreaH + 8 + (8 + Math.max(1, Math.round(9.0f * 0.6f))) + 8;
        int dx = canvasX + (canvasW - dialogW) / 2;
        int dy = canvasY + (canvasH - dialogH) / 2;
        int listTop = dy + 8 + titleH + 6;
        int listLeft = dx + 8;
        int listRight = dx + dialogW - 8;
        int listBottom = listTop + listAreaH;
        if (mouseX < (double)listLeft || mouseX >= (double)listRight || mouseY < (double)listTop || mouseY >= (double)listBottom) {
            return false;
        }
        int totalH = this.promoteCandidates.size() * 12;
        int visibleH = listAreaH;
        int maxScroll = Math.max(0, totalH - visibleH);
        int delta = (int)Math.round(-verticalAmount * 12.0);
        this.promoteListScrollPx = PartyMembersBox.clampToRow(PartyMembersBox.snapToRow(this.promoteListScrollPx + delta), 0, maxScroll);
        return true;
    }
}

