/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_124;

public final class TitleStyleUtil {
    private TitleStyleUtil() {
    }

    public static List<Span> parseSpans(String raw) {
        if (raw == null || raw.isEmpty()) {
            ArrayList<Span> only = new ArrayList<Span>();
            only.add(new Span("", false, null, false, null, null, null, null, null, null, null, null, null, null, null));
            return only;
        }
        Stacks st = new Stacks();
        ArrayList<Span> out = new ArrayList<Span>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < raw.length()) {
            int close;
            char ch = raw.charAt(i);
            if (ch == '{' && (close = raw.indexOf(125, i)) > i) {
                String inside = raw.substring(i + 1, close).trim();
                boolean isClose = inside.startsWith("/");
                String namePayload = isClose ? inside.substring(1).trim() : inside;
                int colon = namePayload.indexOf(58);
                String name = (colon >= 0 ? namePayload.substring(0, colon) : namePayload).trim().toLowerCase();
                String payload = (colon >= 0 ? namePayload.substring(colon + 1) : "").trim();
                if (TitleStyleUtil.isKnownName(name)) {
                    if (sb.length() > 0) {
                        out.add(st.toSpan(sb.toString()));
                        sb.setLength(0);
                    }
                    if (isClose) {
                        TitleStyleUtil.applyClose(st, name);
                    } else {
                        TitleStyleUtil.applyOpen(st, name, payload);
                    }
                    i = close + 1;
                    continue;
                }
            }
            if (ch == '&' && i + 1 < raw.length()) {
                char code = Character.toLowerCase(raw.charAt(i + 1));
                if (code == 'r') {
                    if (sb.length() > 0) {
                        out.add(st.toSpan(sb.toString()));
                        sb.setLength(0);
                    }
                    st.color.clear();
                    i += 2;
                    continue;
                }
                Integer mapped = TitleStyleUtil.mapLegacyColor(code);
                if (mapped != null) {
                    if (sb.length() > 0) {
                        out.add(st.toSpan(sb.toString()));
                        sb.setLength(0);
                    }
                    st.openColor(mapped);
                    i += 2;
                    continue;
                }
            }
            sb.append(ch);
            ++i;
        }
        if (sb.length() > 0) {
            out.add(st.toSpan(sb.toString()));
        }
        if (out.isEmpty()) {
            out.add(new Span("", false, null, false, null, null, null, null, null, null, null, null, null, null, null));
        }
        return out;
    }

    private static boolean isKnownName(String n) {
        return n.equals("rainbow") || n.startsWith("rainbow") || n.equals("wiggle") || n.startsWith("wiggle") || n.equals("gradient") || n.startsWith("gradient") || n.equals("pulse") || n.startsWith("pulse") || n.equals("shake") || n.startsWith("shake") || n.equals("color") || n.startsWith("color") || n.equals("bounce") || n.startsWith("bounce") || n.equals("wave") || n.startsWith("wave") || n.equals("glitch") || n.startsWith("glitch") || n.equals("clear") || n.equals("reset");
    }

    private static void applyOpen(Stacks st, String name, String payload) {
        if (name.startsWith("rainbow")) {
            st.openRainbow(TitleStyleUtil.parseFloatSafe(payload));
            return;
        }
        if (name.startsWith("wiggle")) {
            st.openWiggle(TitleStyleUtil.readKeyedFloat(payload, "amp"), TitleStyleUtil.readKeyedFloat(payload, "speed"));
            return;
        }
        if (name.startsWith("gradient")) {
            st.openGradient(TitleStyleUtil.parseGradient(payload));
            return;
        }
        if (name.startsWith("pulse")) {
            st.openPulse(TitleStyleUtil.parseFloatSafe(payload));
            return;
        }
        if (name.startsWith("shake")) {
            st.openShake(TitleStyleUtil.parseFloatSafe(payload));
            return;
        }
        if (name.startsWith("color")) {
            st.openColor(TitleStyleUtil.parseHexSafe(payload));
            return;
        }
        if (name.startsWith("bounce")) {
            st.openBounce(TitleStyleUtil.readKeyedFloat(payload, "amp"), TitleStyleUtil.readKeyedFloat(payload, "speed"));
            return;
        }
        if (name.startsWith("wave")) {
            st.openWave(TitleStyleUtil.readKeyedFloat(payload, "amp"), TitleStyleUtil.readKeyedFloat(payload, "speed"));
            return;
        }
        if (name.startsWith("glitch")) {
            st.openGlitch(TitleStyleUtil.readKeyedFloat(payload, "intensity"));
            return;
        }
        if (name.equals("clear") || name.equals("reset")) {
            st.clearAll();
        }
    }

    private static void applyClose(Stacks st, String name) {
        if (name.equals("rainbow")) {
            st.closeRainbow();
            return;
        }
        if (name.equals("wiggle")) {
            st.closeWiggle();
            return;
        }
        if (name.equals("gradient")) {
            st.closeGradient();
            return;
        }
        if (name.equals("pulse")) {
            st.closePulse();
            return;
        }
        if (name.equals("shake")) {
            st.closeShake();
            return;
        }
        if (name.equals("color")) {
            st.closeColor();
            return;
        }
        if (name.equals("bounce")) {
            st.closeBounce();
            return;
        }
        if (name.equals("wave")) {
            st.closeWave();
            return;
        }
        if (name.equals("glitch")) {
            st.closeGlitch();
            return;
        }
        if (name.equals("clear") || name.equals("reset")) {
            st.clearAll();
        }
    }

    private static Float parseFloatSafe(String s) {
        try {
            return s == null || s.isEmpty() ? null : Float.valueOf(Float.parseFloat(s.trim()));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static Integer parseHexSafe(String s) {
        if (s == null) {
            return null;
        }
        String v = s.replace("#", "").trim();
        try {
            return (int)Long.parseLong(v, 16) & 0xFFFFFF;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static Float readKeyedFloat(String payload, String key) {
        if (payload == null) {
            return null;
        }
        for (String kv : payload.split(",")) {
            int eq = kv.indexOf(61);
            if (eq <= 0 || !key.equalsIgnoreCase(kv.substring(0, eq).trim())) continue;
            try {
                return Float.valueOf(Float.parseFloat(kv.substring(eq + 1).trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static int[] parseGradient(String payload) {
        if (payload == null || payload.isEmpty()) {
            return null;
        }
        String[] cols = payload.split(",");
        int[] out = new int[cols.length];
        int n = 0;
        for (String c : cols) {
            Integer v = TitleStyleUtil.parseHexSafe(c);
            if (v == null) continue;
            out[n++] = v;
        }
        if (n == 0) {
            return null;
        }
        if (n == out.length) {
            return out;
        }
        int[] shrunk = new int[n];
        System.arraycopy(out, 0, shrunk, 0, n);
        return shrunk;
    }

    public static Parsed parse(String raw) {
        boolean rainbow = TitleStyleUtil.tokenPayload(raw, "rainbow") != null;
        boolean wiggle = TitleStyleUtil.tokenPayload(raw, "wiggle") != null;
        Float rainbowSpeed = TitleStyleUtil.readFloatParam(raw, "rainbow");
        Float wiggleAmp = TitleStyleUtil.readKeyedParam(raw, "wiggle", "amp");
        Float wiggleSpeed = TitleStyleUtil.readKeyedParam(raw, "wiggle", "speed");
        int[] gradient = TitleStyleUtil.readGradient(raw);
        Float pulseSpeed = TitleStyleUtil.readFloatParam(raw, "pulse");
        Float shakeAmp = TitleStyleUtil.readFloatParam(raw, "shake");
        Integer hexColor = TitleStyleUtil.readHexColor(raw);
        Float bounceAmp = TitleStyleUtil.readKeyedParam(raw, "bounce", "amp");
        Float bounceSpeed = TitleStyleUtil.readKeyedParam(raw, "bounce", "speed");
        Float waveAmp = TitleStyleUtil.readKeyedParam(raw, "wave", "amp");
        Float waveSpeed = TitleStyleUtil.readKeyedParam(raw, "wave", "speed");
        Float glitchIntensity = TitleStyleUtil.readKeyedParam(raw, "glitch", "intensity");
        String s = raw.trim();
        s = TitleStyleUtil.stripDynamicTokens(s);
        Integer color = hexColor;
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '&' && i + 1 < s.length()) {
                char code = Character.toLowerCase(s.charAt(i + 1));
                if (code == 'r') {
                    color = null;
                    i += 2;
                    continue;
                }
                Integer mapped = TitleStyleUtil.mapLegacyColor(code);
                if (mapped != null) {
                    color = mapped;
                    i += 2;
                    continue;
                }
            }
            int cp = s.codePointAt(i);
            out.appendCodePoint(cp);
            i += Character.charCount(cp);
        }
        return new Parsed(out.toString(), rainbow, wiggle, color, rainbowSpeed, wiggleAmp, wiggleSpeed, gradient, pulseSpeed, shakeAmp, bounceAmp, bounceSpeed, waveAmp, waveSpeed, glitchIntensity);
    }

    private static String tokenPayload(String s, String name) {
        String open;
        String low = s.toLowerCase();
        int i = low.indexOf(open = "{" + name.toLowerCase());
        if (i < 0) {
            return null;
        }
        int end = s.indexOf(125, i);
        if (end < 0) {
            return null;
        }
        String inside = s.substring(i + 1, end);
        int colon = inside.indexOf(58);
        return colon >= 0 ? inside.substring(colon + 1).trim() : "";
    }

    private static String stripDynamicTokens(String s) {
        int end;
        int i;
        String[] names;
        for (String n : names = new String[]{"gradient", "pulse", "shake", "color", "rainbow", "wiggle", "outline", "bounce", "wave", "glitch"}) {
            int end2;
            String low;
            int i2;
            while ((i2 = (low = ((String)s).toLowerCase()).indexOf("{" + n)) >= 0 && (end2 = ((String)s).indexOf(125, i2)) >= 0) {
                s = ((String)s).substring(0, i2) + ((String)s).substring(end2 + 1);
            }
        }
        while ((i = ((String)s).indexOf("{/")) >= 0 && (end = ((String)s).indexOf(125, i)) >= 0) {
            s = ((String)s).substring(0, i) + ((String)s).substring(end + 1);
        }
        return s;
    }

    private static Integer readHexColor(String s) {
        String p = TitleStyleUtil.tokenPayload(s, "color");
        if (p == null || p.isEmpty()) {
            return null;
        }
        try {
            return (int)Long.parseLong(p.replace("#", "").trim(), 16) & 0xFFFFFF;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static Float readFloatParam(String s, String name) {
        String p = TitleStyleUtil.tokenPayload(s, name);
        if (p == null || p.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(p));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static Float readKeyedParam(String s, String name, String key) {
        String p = TitleStyleUtil.tokenPayload(s, name);
        if (p == null) {
            return null;
        }
        for (String kv : p.split(",")) {
            int eq = kv.indexOf(61);
            if (eq <= 0 || !key.equalsIgnoreCase(kv.substring(0, eq).trim())) continue;
            try {
                return Float.valueOf(Float.parseFloat(kv.substring(eq + 1).trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static int[] readGradient(String s) {
        String p = TitleStyleUtil.tokenPayload(s, "gradient");
        if (p == null || p.isEmpty()) {
            return null;
        }
        String[] cols = p.split(",");
        int[] out = new int[cols.length];
        int n = 0;
        for (String c : cols) {
            try {
                out[n++] = (int)Long.parseLong(c.replace("#", "").trim(), 16) & 0xFFFFFF;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n == 0 ? null : (n == out.length ? out : Arrays.copyOf(out, n));
    }

    public static int resolveOrWhite(Integer rgb) {
        return rgb != null ? rgb : 0xFFFFFF;
    }

    public static int rainbowRgb(long nowMs, int index) {
        float t = (float)(nowMs % 1000000L) / 1000.0f;
        float hue = TitleStyleUtil.wrap01(t * 0.18f + (float)index * 0.12f);
        return TitleStyleUtil.hsbToRgb(hue, 1.0f, 1.0f);
    }

    public static int rainbowRgb(long nowMs, int index, float speed) {
        float t = (float)(nowMs % 1000000L) / 1000.0f;
        float hue = TitleStyleUtil.wrap01(t * speed + (float)index * 0.12f);
        return TitleStyleUtil.hsbToRgb(hue, 1.0f, 1.0f);
    }

    public static float wiggleYOffsetPx(long nowMs, int index, float amplitudePx) {
        float t = (float)(nowMs % 1000000L) / 1000.0f;
        float w = (float)Math.sin(t * 5.6f + (float)index * 0.45f);
        return w * amplitudePx;
    }

    public static float bounceYOffsetPx(long nowMs, int index, float amplitudePx, float speed) {
        float t = (float)(nowMs % 1000000L) / 1000.0f;
        float v = (float)Math.sin(t * speed + (float)index * 0.55f);
        return Math.abs(v) * amplitudePx;
    }

    public static float waveXOffsetPx(long nowMs, int index, float amplitudePx, float speed) {
        float t = (float)(nowMs % 1000000L) / 1000.0f;
        float v = (float)Math.sin(t * speed + (float)index * 0.55f);
        return v * amplitudePx;
    }

    private static Integer mapLegacyColor(char code) {
        class_124 f;
        switch (code) {
            case '0': {
                class_124 class_1242 = class_124.field_1074;
                break;
            }
            case '1': {
                class_124 class_1242 = class_124.field_1058;
                break;
            }
            case '2': {
                class_124 class_1242 = class_124.field_1077;
                break;
            }
            case '3': {
                class_124 class_1242 = class_124.field_1062;
                break;
            }
            case '4': {
                class_124 class_1242 = class_124.field_1079;
                break;
            }
            case '5': {
                class_124 class_1242 = class_124.field_1064;
                break;
            }
            case '6': {
                class_124 class_1242 = class_124.field_1065;
                break;
            }
            case '7': {
                class_124 class_1242 = class_124.field_1080;
                break;
            }
            case '8': {
                class_124 class_1242 = class_124.field_1063;
                break;
            }
            case '9': {
                class_124 class_1242 = class_124.field_1078;
                break;
            }
            case 'a': {
                class_124 class_1242 = class_124.field_1060;
                break;
            }
            case 'b': {
                class_124 class_1242 = class_124.field_1075;
                break;
            }
            case 'c': {
                class_124 class_1242 = class_124.field_1061;
                break;
            }
            case 'd': {
                class_124 class_1242 = class_124.field_1076;
                break;
            }
            case 'e': {
                class_124 class_1242 = class_124.field_1054;
                break;
            }
            case 'f': {
                class_124 class_1242 = class_124.field_1068;
                break;
            }
            default: {
                class_124 class_1242 = f = null;
            }
        }
        if (f == null) {
            return null;
        }
        Integer v = f.method_532();
        return v == null ? null : Integer.valueOf(v & 0xFFFFFF);
    }

    private static float wrap01(float v) {
        float r = v % 1.0f;
        return r < 0.0f ? r + 1.0f : r;
    }

    private static int hsbToRgb(float h, float s, float b) {
        h = TitleStyleUtil.wrap01(h);
        s = TitleStyleUtil.clamp01(s);
        b = TitleStyleUtil.clamp01(b);
        float r = 0.0f;
        float g = 0.0f;
        float bl = 0.0f;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = b * (1.0f - s);
        float q = b * (1.0f - s * f);
        float t = b * (1.0f - s * (1.0f - f));
        switch (i % 6) {
            case 0: {
                r = b;
                g = t;
                bl = p;
                break;
            }
            case 1: {
                r = q;
                g = b;
                bl = p;
                break;
            }
            case 2: {
                r = p;
                g = b;
                bl = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                bl = b;
                break;
            }
            case 4: {
                r = t;
                g = p;
                bl = b;
                break;
            }
            case 5: {
                r = b;
                g = p;
                bl = q;
            }
        }
        int ri = Math.round(r * 255.0f) & 0xFF;
        int gi = Math.round(g * 255.0f) & 0xFF;
        int bi = Math.round(bl * 255.0f) & 0xFF;
        return ri << 16 | gi << 8 | bi;
    }

    public static int gradientRgb(int index, int length, int[] cols) {
        if (cols == null || cols.length == 0) {
            return 0xFFFFFF;
        }
        if (cols.length == 1) {
            return cols[0];
        }
        float t = length <= 1 ? 0.0f : (float)index / (float)(length - 1);
        float x = t * (float)(cols.length - 1);
        int i = Math.max(0, Math.min(cols.length - 2, (int)Math.floor(x)));
        float f = x - (float)i;
        int a = cols[i];
        int b = cols[i + 1];
        int ar = a >> 16 & 0xFF;
        int ag = a >> 8 & 0xFF;
        int ab = a & 0xFF;
        int br = b >> 16 & 0xFF;
        int bg = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int r = (int)((float)ar * (1.0f - f) + (float)br * f);
        int g = (int)((float)ag * (1.0f - f) + (float)bg * f);
        int bl = (int)((float)ab * (1.0f - f) + (float)bb * f);
        return r << 16 | g << 8 | bl;
    }

    public static int pulseRgb(long nowMs, int baseRgb, float speed) {
        float t = (float)(nowMs % 1000000L) / 1000.0f;
        float k = 0.5f + 0.5f * (float)Math.sin(t * ((float)Math.PI * 2) * speed);
        float mul = 0.6f + 0.4f * k;
        int r = Math.min(255, (int)((float)(baseRgb >> 16 & 0xFF) * mul));
        int g = Math.min(255, (int)((float)(baseRgb >> 8 & 0xFF) * mul));
        int b = Math.min(255, (int)((float)(baseRgb & 0xFF) * mul));
        return r << 16 | g << 8 | b;
    }

    public static float shakeXOffsetPx(long nowMs, int index, float ampPx) {
        float t = (float)(nowMs % 1000000L) / 1000.0f;
        return (float)(Math.sin((double)t * 9.0 + (double)index * 0.9) * (double)ampPx);
    }

    public static boolean glitchActive(long nowMs, int index, float intensity) {
        float p = TitleStyleUtil.clamp01(intensity * 0.35f + 0.05f);
        int frame = (int)(nowMs / 50L);
        int h = TitleStyleUtil.fastHash(index * 374761393 + frame * 668265263);
        float r = TitleStyleUtil.frac01(h);
        return r < p;
    }

    public static float glitchJitterX(long nowMs, int index, float intensity) {
        if (intensity <= 0.0f) {
            return 0.0f;
        }
        int frame = (int)(nowMs / 50L);
        int h = TitleStyleUtil.fastHash(index * 915488749 + frame * 140294673);
        float mag = 1.0f + intensity * 2.0f;
        return (TitleStyleUtil.frac01(h) - 0.5f) * 2.0f * mag;
    }

    public static float glitchJitterY(long nowMs, int index, float intensity) {
        if (intensity <= 0.0f) {
            return 0.0f;
        }
        int frame = (int)(nowMs / 50L);
        int h = TitleStyleUtil.fastHash(index * 19990303 + frame * 636413622);
        float mag = 0.5f + intensity * 1.5f;
        return (TitleStyleUtil.frac01(h) - 0.5f) * 2.0f * mag;
    }

    public static int glitchTintRgb(long nowMs, int index, int baseRgb, float intensity) {
        if (intensity <= 0.0f) {
            return baseRgb;
        }
        int frame = (int)(nowMs / 50L);
        int h = TitleStyleUtil.fastHash(index * 1103515245 + frame * 12345);
        float hue = TitleStyleUtil.frac01(h * 3);
        int tint = TitleStyleUtil.hsbToRgb(hue, 1.0f, 1.0f);
        float a = 0.35f + 0.35f * TitleStyleUtil.clamp01(intensity);
        return TitleStyleUtil.lerpRgb(baseRgb, tint, a);
    }

    private static int lerpRgb(int a, int b, float t) {
        t = TitleStyleUtil.clamp01(t);
        int ar = a >> 16 & 0xFF;
        int ag = a >> 8 & 0xFF;
        int ab = a & 0xFF;
        int br = b >> 16 & 0xFF;
        int bg = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int r = (int)((float)ar * (1.0f - t) + (float)br * t);
        int g = (int)((float)ag * (1.0f - t) + (float)bg * t);
        int bl = (int)((float)ab * (1.0f - t) + (float)bb * t);
        return r << 16 | g << 8 | bl;
    }

    private static int fastHash(int x) {
        x ^= x >>> 16;
        x *= 2146121005;
        x ^= x >>> 15;
        x *= -2073254261;
        x ^= x >>> 16;
        return x;
    }

    private static float frac01(int h) {
        return (float)(h >>> 1 & Integer.MAX_VALUE) / 2.1474836E9f;
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    public record Span(String text, boolean rainbow, Float rainbowSpeed, boolean wiggle, Float wiggleAmp, Float wiggleSpeed, int[] gradient, Integer baseRgb, Float pulseSpeed, Float shakeAmp, Float bounceAmp, Float bounceSpeed, Float waveAmp, Float waveSpeed, Float glitchIntensity) {
    }

    private static final class Stacks {
        final Deque<Float> rainbow = new ArrayDeque<Float>();
        final Deque<Wiggle> wiggle = new ArrayDeque<Wiggle>();
        final Deque<int[]> gradient = new ArrayDeque<int[]>();
        final Deque<Integer> color = new ArrayDeque<Integer>();
        final Deque<Float> pulse = new ArrayDeque<Float>();
        final Deque<Float> shake = new ArrayDeque<Float>();
        final Deque<Bounce> bounce = new ArrayDeque<Bounce>();
        final Deque<Wave> wave = new ArrayDeque<Wave>();
        final Deque<Float> glitch = new ArrayDeque<Float>();

        private Stacks() {
        }

        void clearAll() {
            this.rainbow.clear();
            this.wiggle.clear();
            this.gradient.clear();
            this.color.clear();
            this.pulse.clear();
            this.shake.clear();
            this.bounce.clear();
            this.wave.clear();
            this.glitch.clear();
        }

        Span toSpan(String text) {
            boolean rainbowOn = !this.rainbow.isEmpty();
            boolean wiggleOn = !this.wiggle.isEmpty();
            Float rainbowSpd = rainbowOn ? this.rainbow.peekLast() : null;
            Wiggle w = wiggleOn ? this.wiggle.peekLast() : null;
            Bounce b = this.bounce.isEmpty() ? null : this.bounce.peekLast();
            Wave wa = this.wave.isEmpty() ? null : this.wave.peekLast();
            return new Span(text, rainbowOn, rainbowSpd, wiggleOn, w == null ? null : w.amp, w == null ? null : w.speed, this.gradient.isEmpty() ? null : this.gradient.peekLast(), this.color.isEmpty() ? null : this.color.peekLast(), this.pulse.isEmpty() ? null : this.pulse.peekLast(), this.shake.isEmpty() ? null : this.shake.peekLast(), b == null ? null : b.amp, b == null ? null : b.speed, wa == null ? null : wa.amp, wa == null ? null : wa.speed, this.glitch.isEmpty() ? null : this.glitch.peekLast());
        }

        void openRainbow(Float speed) {
            this.rainbow.addLast(speed);
        }

        void closeRainbow() {
            if (!this.rainbow.isEmpty()) {
                this.rainbow.removeLast();
            }
        }

        void openWiggle(Float amp, Float speed) {
            this.wiggle.addLast(new Wiggle(amp, speed));
        }

        void closeWiggle() {
            if (!this.wiggle.isEmpty()) {
                this.wiggle.removeLast();
            }
        }

        void openGradient(int[] cols) {
            this.gradient.addLast(cols);
        }

        void closeGradient() {
            if (!this.gradient.isEmpty()) {
                this.gradient.removeLast();
            }
        }

        void openPulse(Float s) {
            this.pulse.addLast(s);
        }

        void closePulse() {
            if (!this.pulse.isEmpty()) {
                this.pulse.removeLast();
            }
        }

        void openShake(Float a) {
            this.shake.addLast(a);
        }

        void closeShake() {
            if (!this.shake.isEmpty()) {
                this.shake.removeLast();
            }
        }

        void openColor(Integer c) {
            this.color.addLast(c);
        }

        void closeColor() {
            if (!this.color.isEmpty()) {
                this.color.removeLast();
            }
        }

        void openBounce(Float amp, Float speed) {
            this.bounce.addLast(new Bounce(amp, speed));
        }

        void closeBounce() {
            if (!this.bounce.isEmpty()) {
                this.bounce.removeLast();
            }
        }

        void openWave(Float amp, Float speed) {
            this.wave.addLast(new Wave(amp, speed));
        }

        void closeWave() {
            if (!this.wave.isEmpty()) {
                this.wave.removeLast();
            }
        }

        void openGlitch(Float intensity) {
            this.glitch.addLast(intensity);
        }

        void closeGlitch() {
            if (!this.glitch.isEmpty()) {
                this.glitch.removeLast();
            }
        }
    }

    public record Parsed(String text, boolean rainbow, boolean wiggle, Integer baseRgb, Float rainbowSpeed, Float wiggleAmp, Float wiggleSpeed, int[] gradient, Float pulseSpeed, Float shakeAmp, Float bounceAmp, Float bounceSpeed, Float waveAmp, Float waveSpeed, Float glitchIntensity) {
    }

    private static final class Bounce {
        final Float amp;
        final Float speed;

        Bounce(Float a, Float s) {
            this.amp = a;
            this.speed = s;
        }
    }

    private static final class Wave {
        final Float amp;
        final Float speed;

        Wave(Float a, Float s) {
            this.amp = a;
            this.speed = s;
        }
    }

    private static final class Wiggle {
        final Float amp;
        final Float speed;

        Wiggle(Float a, Float s) {
            this.amp = a;
            this.speed = s;
        }
    }
}

