/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title.screen.box;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_8710;
import net.minecraft.class_9801;
import net.pixeldreamstudios.rpgsystems.client.title.TitleClientData;
import net.pixeldreamstudios.rpgsystems.client.title.TitleStyleUtil;
import net.pixeldreamstudios.rpgsystems.client.title.TitleTextureResolver;
import net.pixeldreamstudios.rpgsystems.client.title.widget.TitleButtonWidget;
import net.pixeldreamstudios.rpgsystems.mixin.client.ScreenAccessor;
import net.pixeldreamstudios.rpgsystems.network.title.TitlePayloads;
import net.pixeldreamstudios.rpgsystems.title.Title;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class TitleBox {
    private static final int LEFT_PADDING = 7;
    private static final int RIGHT_PADDING = 6;
    private static final int TOP_PADDING = 20;
    private static final int BOX_HEIGHT = 61;
    private static final int BUTTON_PADDING = 5;
    private static final int BUTTON_SIZE = 16;
    private static final class_2960 APPLY_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/apply_title_normal.png");
    private static final class_2960 APPLY_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/apply_title_hover.png");
    private static final class_2960 DISABLE_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/disable_title_normal.png");
    private static final class_2960 DISABLE_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/disable_title_hover.png");
    private static final class_2960 LOCKED_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/locked.png");
    private static final int LOCK_SIZE = 8;
    private int screenX;
    private int screenY;
    private int bgWidth;
    private int bgHeight;
    private final class_327 font;
    private Title selected;
    private TitleButtonWidget applyButton;
    private TitleButtonWidget disableButton;

    public TitleBox(int screenX, int screenY, int bgWidth, int bgHeight) {
        this.font = class_310.method_1551().field_1772;
        this.screenX = screenX;
        this.screenY = screenY;
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
        this.createButtons();
        this.updateButtonLayout();
        this.updateButtonVisibility();
    }

    public void setScreenOrigin(int screenX, int screenY) {
        this.screenX = screenX;
        this.screenY = screenY;
        this.updateButtonLayout();
    }

    public void setBackgroundSize(int bgWidth, int bgHeight) {
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
        this.updateButtonLayout();
    }

    public void setSelectedTitle(Title title) {
        this.selected = title;
        this.updateButtonVisibility();
    }

    public Title getSelectedTitle() {
        return this.selected;
    }

    public void attachToScreen(class_437 screen) {
        ScreenAccessor acc = (ScreenAccessor)screen;
        if (this.applyButton != null) {
            acc.rpgsystems$addDrawableChild(this.applyButton);
        }
        if (this.disableButton != null) {
            acc.rpgsystems$addDrawableChild(this.disableButton);
        }
        this.updateButtonLayout();
        this.updateButtonVisibility();
    }

    public void render(class_332 ctx) {
        int[] r = this.boxRect();
        int x = r[0];
        int y = r[1];
        int w = r[2];
        int h = r[3];
        if (this.selected == null) {
            String placeholder = "No title chosen";
            int tw = this.font.method_1727(placeholder);
            int tx = Math.round((float)x + (float)w / 2.0f - (float)tw / 2.0f);
            float f = (float)y + (float)h / 2.0f;
            Objects.requireNonNull(this.font);
            int ty = Math.round(f - 9.0f / 2.0f);
            ctx.method_25303(this.font, placeholder, tx, ty, -1);
            this.updateButtonLayout();
            this.updateButtonVisibility();
            return;
        }
        TitleTextureResolver.FrameInfo fi = TitleTextureResolver.currentFrame(this.selected.id);
        if (fi != null) {
            int maxW = Math.max(8, w - 16);
            int maxH = Math.max(8, h - 8);
            float scale = Math.min((float)maxW / (float)fi.frameWidth, (float)maxH / (float)fi.frameHeight);
            scale = Math.max(0.01f, scale);
            int drawW = Math.round((float)fi.frameWidth * scale);
            int drawH = Math.round((float)fi.frameHeight * scale);
            int drawX = Math.round((float)x + (float)w / 2.0f - (float)drawW / 2.0f);
            int drawY = Math.round((float)y + (float)h / 2.0f - (float)drawH / 2.0f);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)fi.textureId);
            class_4587 matrices = ctx.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)drawX + (float)drawW / 2.0f, (float)drawY + (float)drawH / 2.0f, 0.0f);
            matrices.method_22905((float)drawW, (float)drawH, 1.0f);
            TitleBox.drawQuadGuiUV(matrices.method_23760().method_23761(), fi.u0, fi.v0, fi.u1, fi.v1);
            matrices.method_22909();
        } else {
            String raw = this.selected.displayName != null ? this.selected.displayName.getString() : this.selected.id.method_12832();
            List<TitleStyleUtil.Span> spans = TitleStyleUtil.parseSpans(raw);
            int textWidth = 0;
            for (TitleStyleUtil.Span sp : spans) {
                textWidth += this.font.method_1727(sp.text());
            }
            int baseX = Math.round((float)x + (float)w / 2.0f - (float)textWidth / 2.0f);
            float f = (float)y + (float)h / 2.0f;
            Objects.requireNonNull(this.font);
            int baseY = Math.round(f - 9.0f / 2.0f);
            long nowMs = class_156.method_658();
            float advanceX = 0.0f;
            int globalIndex = 0;
            for (TitleStyleUtil.Span span : spans) {
                int cp;
                String t = span.text();
                int localLen = t.codePointCount(0, t.length());
                int localIndex = 0;
                for (int i = 0; i < t.length(); i += Character.charCount(cp)) {
                    float amp;
                    int rgb;
                    cp = t.codePointAt(i);
                    String ch = new String(Character.toChars(cp));
                    int cw = this.font.method_1727(ch);
                    int n = span.gradient() != null ? TitleStyleUtil.gradientRgb(localIndex, localLen, span.gradient()) : (span.rainbow() ? TitleStyleUtil.rainbowRgb(nowMs, globalIndex, span.rainbowSpeed() != null ? span.rainbowSpeed().floatValue() : 0.18f) : (rgb = TitleStyleUtil.resolveOrWhite(span.baseRgb())));
                    if (span.pulseSpeed() != null) {
                        rgb = TitleStyleUtil.pulseRgb(nowMs, rgb, span.pulseSpeed().floatValue());
                    }
                    float yOff = 0.0f;
                    if (span.wiggle()) {
                        amp = span.wiggleAmp() != null ? span.wiggleAmp().floatValue() : 2.0f;
                        yOff += TitleStyleUtil.wiggleYOffsetPx(nowMs, globalIndex, amp);
                    }
                    if (span.bounceAmp() != null || span.bounceSpeed() != null) {
                        amp = span.bounceAmp() != null ? span.bounceAmp().floatValue() : 0.0f;
                        float spd = span.bounceSpeed() != null ? span.bounceSpeed().floatValue() : 3.0f;
                        yOff += TitleStyleUtil.bounceYOffsetPx(nowMs, globalIndex, amp, spd);
                    }
                    float xOff = 0.0f;
                    if (span.waveAmp() != null || span.waveSpeed() != null) {
                        float amp2 = span.waveAmp() != null ? span.waveAmp().floatValue() : 0.0f;
                        float spd = span.waveSpeed() != null ? span.waveSpeed().floatValue() : 2.5f;
                        xOff += TitleStyleUtil.waveXOffsetPx(nowMs, globalIndex, amp2, spd);
                    }
                    if (span.shakeAmp() != null) {
                        xOff += TitleStyleUtil.shakeXOffsetPx(nowMs, globalIndex, span.shakeAmp().floatValue());
                    }
                    if (span.glitchIntensity() != null && TitleStyleUtil.glitchActive(nowMs, globalIndex, span.glitchIntensity().floatValue())) {
                        xOff += TitleStyleUtil.glitchJitterX(nowMs, globalIndex, span.glitchIntensity().floatValue());
                        yOff += TitleStyleUtil.glitchJitterY(nowMs, globalIndex, span.glitchIntensity().floatValue());
                        rgb = TitleStyleUtil.glitchTintRgb(nowMs, globalIndex, rgb, span.glitchIntensity().floatValue());
                    }
                    ctx.method_25303(this.font, ch, Math.round((float)baseX + advanceX + xOff), Math.round((float)baseY + yOff), 0xFF000000 | rgb & 0xFFFFFF);
                    advanceX += (float)cw;
                    ++globalIndex;
                    ++localIndex;
                }
            }
        }
        boolean unlocked = TitleClientData.getSelfUnlocked().contains(this.selected.id);
        if (!unlocked) {
            int lockX = x + w - 5 - 8;
            int lockY = y + 5;
            ctx.method_25290(LOCKED_ICON, lockX, lockY, 0.0f, 0.0f, 8, 8, 8, 8);
        }
        this.updateButtonLayout();
        this.updateButtonVisibility();
    }

    private void createButtons() {
        this.applyButton = new TitleButtonWidget(0, 0, 16, 16, APPLY_NORMAL, APPLY_HOVER, () -> {
            if (this.selected == null) {
                return;
            }
            ClientPlayNetworking.send((class_8710)new TitlePayloads.RequestSetActive(Optional.of(this.selected.id)));
        });
        this.applyButton.setDrawScale(0.75f);
        this.disableButton = new TitleButtonWidget(0, 0, 16, 16, DISABLE_NORMAL, DISABLE_HOVER, () -> ClientPlayNetworking.send((class_8710)new TitlePayloads.RequestSetActive(Optional.empty())));
        this.disableButton.setDrawScale(0.75f);
    }

    private void updateButtonLayout() {
        int[] r = this.boxRect();
        int x = r[0];
        int y = r[1];
        int w = r[2];
        int h = r[3];
        int leftBtnX = x + 5;
        int leftBtnY = y + h - 5 - 16;
        int rightBtnX = x + w - 5 - 16;
        int rightBtnY = leftBtnY;
        if (this.applyButton != null) {
            this.applyButton.method_46421(leftBtnX);
            this.applyButton.method_46419(leftBtnY);
        }
        if (this.disableButton != null) {
            this.disableButton.method_46421(rightBtnX);
            this.disableButton.method_46419(rightBtnY);
        }
    }

    private void updateButtonVisibility() {
        boolean isApplied;
        class_2960 active = TitleClientData.getSelfActive();
        boolean hasSelection = this.selected != null;
        boolean unlocked = hasSelection && TitleClientData.getSelfUnlocked().contains(this.selected.id);
        boolean bl = isApplied = hasSelection && active != null && active.equals((Object)this.selected.id);
        if (this.applyButton != null) {
            this.applyButton.setEnabled(hasSelection && unlocked && !isApplied);
            this.applyButton.setShown(hasSelection && unlocked && !isApplied);
        }
        if (this.disableButton != null) {
            this.disableButton.setEnabled(isApplied);
            this.disableButton.setShown(isApplied);
        }
    }

    private static void drawQuadGuiUV(Matrix4f mat, float u0, float v0, float u1, float v1) {
        class_289 tess = class_289.method_1348();
        class_287 buf = tess.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buf.method_22918(mat, -0.5f, 0.5f, 0.0f).method_22913(u0, v1);
        buf.method_22918(mat, 0.5f, 0.5f, 0.0f).method_22913(u1, v1);
        buf.method_22918(mat, 0.5f, -0.5f, 0.0f).method_22913(u1, v0);
        buf.method_22918(mat, -0.5f, -0.5f, 0.0f).method_22913(u0, v0);
        class_286.method_43433((class_9801)buf.method_60800());
    }

    private int[] boxRect() {
        int boxX = this.screenX + 7;
        int boxY = this.screenY + 20;
        int boxW = this.bgWidth - 7 - 6;
        int boxH = 61;
        return new int[]{boxX, boxY, boxW, boxH};
    }
}

