/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title.screen.box;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;
import net.pixeldreamstudios.rpgsystems.client.title.TitleClientData;
import net.pixeldreamstudios.rpgsystems.client.title.TitleIconRenderer;
import net.pixeldreamstudios.rpgsystems.client.title.TitleStyleUtil;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.util.SpellRender;

@Environment(value=EnvType.CLIENT)
public final class TitleDescriptionBox {
    private static final int RIGHT_PADDING = 6;
    private static final int BOTTOM_PADDING = 12;
    private static final int LEFT_BOX_WIDTH = 62;
    private static final int LEFT_BOX_LEFT_PADDING = 6;
    private static final int GUTTER = 8;
    private static final int BOX_HEIGHT = 64;
    private static final int COLOR_HEADER = -986896;
    private static final int COLOR_DESC = -2039584;
    private static final int COLOR_BONUS_TEXT = -855638017;
    private static final int COLOR_DONE = -8650885;
    private static final int COLOR_TODO = -1;
    private static final int COLOR_DIVIDER = 0x40FFFFFF;
    private static final int UI_MARGIN_Y = 2;
    private static final int BULLET_PAD = 4;
    private static final class_2960 CHECK_OFF = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/checkbox_todo.png");
    private static final class_2960 CHECK_ON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/checkbox_done.png");
    private static final class_2960 INFO_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/title/info.png");
    private static final int ICON_SIZE = 9;
    private static final int INFO_GAP = 2;
    private static final int SCROLLBAR_BORDER_COLOR = 0x66000000;
    private static final int SCROLLBAR_THUMB_COLOR = -1711276033;
    private static final int SCROLLBAR_THUMB_HOVER_COLOR = -1140850689;
    private static final int PLATE_TEXT_COLOR = -1;
    private static final int PLATE_MAIN_BG = -12956566;
    private static final int PLATE_MAIN_BR = -14734787;
    private static final int PLATE_SUB_BG = -13748408;
    private static final int PLATE_SUB_BR = -15064528;
    private static final int PLATE_TAG_BG = 857877046;
    private static final int PLATE_TAG_BR = 1721807040;
    private static final int PLATE_GAP_BELOW = 4;
    private static final int SECTION_GAP_TO_CHILD = 3;
    private static final int CATEGORY_GAP = 3;
    private int screenX;
    private int screenY;
    private int bgWidth;
    private int bgHeight;
    private final class_327 font;
    private Title current;
    private float textScale = 0.5f;
    private int scrollY = 0;
    private int maxScrollCached = 0;
    private int scrollbarOffsetX = 4;
    private int scrollbarOffsetY = 0;
    private int scrollbarWidth = 1;
    private boolean draggingScrollbar = false;
    private int dragGrabOffsetY = 0;
    private final List<HintSpot> hintSpots = new ArrayList<HintSpot>();
    private final List<MobSpot> mobSpots = new ArrayList<MobSpot>();
    private final List<TagSpot> tagSpots = new ArrayList<TagSpot>();

    private void drawDivider(class_332 ctx, int x, int y, int w) {
        ctx.method_25294(x, y, x + w, y + 1, 0x40FFFFFF);
    }

    public TitleDescriptionBox(int screenX, int screenY, int bgWidth, int bgHeight) {
        this.font = class_310.method_1551().field_1772;
        this.screenX = screenX;
        this.screenY = screenY;
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
    }

    public void setScreenOrigin(int screenX, int screenY) {
        this.screenX = screenX;
        this.screenY = screenY;
    }

    public void setBackgroundSize(int bgWidth, int bgHeight) {
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
    }

    public void setTitle(Title title) {
        this.current = title;
        this.scrollY = 0;
    }

    public void render(class_332 ctx, int mouseX, int mouseY) {
        int maxScroll;
        List<CondLine> lines;
        int boxW = this.bgWidth - 6 - 62 - 8 - 6;
        int boxX = this.screenX + this.bgWidth - 6 - boxW;
        int boxY = this.screenY + this.bgHeight - 12 - 64;
        this.hintSpots.clear();
        this.mobSpots.clear();
        this.tagSpots.clear();
        if (this.current == null) {
            this.maxScrollCached = 0;
            this.scrollY = 0;
            return;
        }
        int innerX = boxX + 4;
        int innerW = boxW - 8;
        int viewportTop = boxY + 2;
        int viewportBottom = boxY + 64 - 2;
        ctx.method_44379(innerX, viewportTop, innerX + innerW, viewportBottom);
        int y = boxY + 3;
        String rawTitle = this.current.displayName != null ? this.current.displayName.getString() : this.current.id.toString();
        TitleStyleUtil.Parsed parsed = TitleStyleUtil.parse(rawTitle);
        int headerRgb = 0xFF000000 | TitleStyleUtil.resolveOrWhite(parsed.baseRgb());
        this.drawScaled(ctx, class_2561.method_43470((String)parsed.text()).method_30937(), innerX, y - this.scrollY, headerRgb, this.textScale);
        y += this.scaled(12) + 2;
        if (this.current.description != null && !this.current.description.getString().isEmpty()) {
            int wrapWidth = Math.max(1, Math.round((float)innerW / this.textScale));
            lines = this.font.method_1728((class_5348)this.current.description, wrapWidth);
            for (class_5481 class_54812 : lines) {
                this.drawScaled(ctx, class_54812, innerX, y - this.scrollY, -2039584, this.textScale);
                y += this.scaled(9);
            }
            this.drawDivider(ctx, innerX, (y += this.scaled(4)) - this.scrollY, innerW);
            y += this.scaled(6);
        }
        if (this.current.conditions != null && !this.current.conditions.isEmpty()) {
            this.drawScaled(ctx, class_2561.method_43471((String)"title.rpgsystems.conditions").method_30937(), innerX, y - this.scrollY, -986896, this.textScale);
            y += this.scaled(10);
            int checkSizePx = this.scaled(9);
            lines = this.buildConditionLines();
            for (CondLine condLine : lines) {
                int blockH;
                boolean showInfo = condLine.hint != null;
                int infoSize = this.scaled(9);
                int infoReserve = showInfo ? infoSize + this.scaled(2) : 0;
                int textX = innerX + checkSizePx + 4;
                int availableTextW = innerW - (textX - innerX) - infoReserve;
                int startY = y;
                int lineH = this.scaled(9);
                boolean inline = condLine.inlineIcon && TitleIconRenderer.hasIcon(condLine.source) && condLine.pre != null && condLine.post != null;
                int iconSizePx = 0;
                List restLines = List.of();
                class_5481 firstPostLine = null;
                class_5481 preOT = null;
                if (inline) {
                    preOT = condLine.pre.method_30937();
                    preWpx = Math.round((float)this.font.method_30880(preOT) * this.textScale);
                    int iconGap = this.scaled(2);
                    iconSizePx = this.scaled(9);
                    int firstRemainPx = Math.max(0, availableTextW - preWpx - iconSizePx - iconGap);
                    String postRaw = condLine.post.getString();
                    int firstCut = this.cutIndexByPixelWidth(postRaw, Math.max(1, Math.round((float)firstRemainPx / this.textScale)));
                    String firstRaw = postRaw.substring(0, Math.min(firstCut, postRaw.length()));
                    String restRaw = postRaw.substring(Math.min(firstCut, postRaw.length()));
                    firstPostLine = class_2561.method_43470((String)firstRaw).method_30937();
                    int normalWrap = Math.max(1, Math.round((float)availableTextW / this.textScale));
                    restLines = restRaw.isEmpty() ? List.of() : this.font.method_1728((class_5348)class_2561.method_43470((String)restRaw), normalWrap);
                    int linesDrawn = 1 + restLines.size();
                    blockH = Math.max(checkSizePx, Math.max(iconSizePx, lineH * linesDrawn));
                } else if (condLine.mobName != null && condLine.mobId != null && condLine.pre != null && condLine.post != null) {
                    preOT = condLine.pre.method_30937();
                    preWpx = Math.round((float)this.font.method_30880(preOT) * this.textScale);
                    class_5481 mobOT = condLine.mobName.method_30937();
                    int mobWpx = Math.round((float)this.font.method_30880(mobOT) * this.textScale);
                    firstRemainPx = Math.max(0, availableTextW - preWpx - mobWpx);
                    String postRaw = condLine.post.getString();
                    int firstCut = this.cutIndexByPixelWidth(postRaw, Math.max(1, Math.round((float)firstRemainPx / this.textScale)));
                    String firstRaw = postRaw.substring(0, Math.min(firstCut, postRaw.length()));
                    String restRaw = postRaw.substring(Math.min(firstCut, postRaw.length()));
                    firstPostLine = class_2561.method_43470((String)firstRaw).method_30937();
                    normalWrap = Math.max(1, Math.round((float)availableTextW / this.textScale));
                    restLines = restRaw.isEmpty() ? List.of() : this.font.method_1728((class_5348)class_2561.method_43470((String)restRaw), normalWrap);
                    int linesDrawn = 1 + restLines.size();
                    blockH = Math.max(checkSizePx, lineH * linesDrawn);
                } else if (condLine.tagName != null && condLine.tagId != null && condLine.pre != null && condLine.post != null) {
                    preOT = condLine.pre.method_30937();
                    preWpx = Math.round((float)this.font.method_30880(preOT) * this.textScale);
                    class_5481 tagOT = condLine.tagName.method_30937();
                    int tagWpx = Math.round((float)this.font.method_30880(tagOT) * this.textScale);
                    firstRemainPx = Math.max(0, availableTextW - preWpx - tagWpx);
                    String postRaw = condLine.post.getString();
                    int firstCut = this.cutIndexByPixelWidth(postRaw, Math.max(1, Math.round((float)firstRemainPx / this.textScale)));
                    String firstRaw = postRaw.substring(0, Math.min(firstCut, postRaw.length()));
                    String restRaw = postRaw.substring(Math.min(firstCut, postRaw.length()));
                    firstPostLine = class_2561.method_43470((String)firstRaw).method_30937();
                    normalWrap = Math.max(1, Math.round((float)availableTextW / this.textScale));
                    restLines = restRaw.isEmpty() ? List.of() : this.font.method_1728((class_5348)class_2561.method_43470((String)restRaw), normalWrap);
                    int linesDrawn = 1 + restLines.size();
                    blockH = Math.max(checkSizePx, lineH * linesDrawn);
                } else {
                    int wrap = Math.max(1, Math.round((float)availableTextW / this.textScale));
                    restLines = this.font.method_1728((class_5348)condLine.text, wrap);
                    int linesDrawn = Math.max(1, restLines.size());
                    blockH = Math.max(checkSizePx, lineH * linesDrawn);
                }
                int checkY = TitleDescriptionBox.centerY(startY, this.scrollY, blockH, checkSizePx);
                class_2960 checkSprite = condLine.done ? CHECK_ON : CHECK_OFF;
                this.drawSprite(ctx, checkSprite, innerX, checkY, checkSizePx, checkSizePx);
                int ty = startY + 1;
                if (inline) {
                    int iconGap = this.scaled(2);
                    this.drawScaled(ctx, preOT, textX, ty - this.scrollY, condLine.color, this.textScale);
                    int preWpx = Math.round((float)this.font.method_30880(preOT) * this.textScale);
                    int iconX = textX + preWpx;
                    int baselineY = startY + 1 - this.scrollY;
                    int iconSize = this.scaled(9);
                    int iconY = baselineY + (lineH - iconSize) / 2 - Math.max(1, Math.round(this.textScale));
                    TitleIconRenderer.renderForCondition(ctx, condLine.source, iconX, iconY, iconSize);
                    List<class_2561> iconTip = this.iconTooltip(condLine.source);
                    if (iconTip != null && !iconTip.isEmpty()) {
                        this.hintSpots.add(new HintSpot(iconX, iconY, iconSize, iconSize, iconTip));
                    }
                    int postX = iconX + iconSize + iconGap;
                    this.drawScaled(ctx, firstPostLine, postX, ty - this.scrollY, condLine.color, this.textScale);
                    for (int i = 0; i < (restLines != null ? restLines.size() : 0); ++i) {
                        this.drawScaled(ctx, (class_5481)restLines.get(i), textX, ty + (i + 1) * lineH - this.scrollY, condLine.color, this.textScale);
                    }
                } else if (condLine.mobName != null && condLine.mobId != null && condLine.pre != null && condLine.post != null) {
                    this.drawScaled(ctx, preOT, textX, ty - this.scrollY, condLine.color, this.textScale);
                    preWpx = Math.round((float)this.font.method_30880(preOT) * this.textScale);
                    class_5250 mobStyled = condLine.mobName.method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
                    class_5481 mobOT = mobStyled.method_30937();
                    int mobWpx = Math.round((float)this.font.method_30880(mobOT) * this.textScale);
                    int mobX = textX + preWpx;
                    int mobY = ty - this.scrollY;
                    int lineH2 = Math.max(1, Math.round(9.0f * this.textScale));
                    boolean hoveringMob = mouseX >= mobX && mouseX <= mobX + mobWpx && mouseY >= mobY && mouseY <= mobY + lineH2;
                    int mobColor = hoveringMob ? condLine.color & 0xFFFFFF | 0xCC000000 : condLine.color;
                    this.drawScaled(ctx, mobOT, mobX, mobY, mobColor, this.textScale);
                    this.mobSpots.add(new MobSpot(mobX, mobY, mobWpx, lineH2, condLine.mobId, condLine.mobName));
                    postX = mobX + mobWpx;
                    this.drawScaled(ctx, firstPostLine, postX, ty - this.scrollY, condLine.color, this.textScale);
                    for (i = 0; i < (restLines != null ? restLines.size() : 0); ++i) {
                        this.drawScaled(ctx, (class_5481)restLines.get(i), textX, ty + (i + 1) * lineH - this.scrollY, condLine.color, this.textScale);
                    }
                } else if (condLine.tagName != null && condLine.tagId != null && condLine.pre != null && condLine.post != null) {
                    this.drawScaled(ctx, preOT, textX, ty - this.scrollY, condLine.color, this.textScale);
                    preWpx = Math.round((float)this.font.method_30880(preOT) * this.textScale);
                    class_5481 tagOT = condLine.tagName.method_30937();
                    int tagWpx = Math.round((float)this.font.method_30880(tagOT) * this.textScale);
                    int tagX = textX + preWpx;
                    int tagY = ty - this.scrollY;
                    this.drawScaled(ctx, tagOT, tagX, tagY, condLine.color, this.textScale);
                    int tagH = Math.max(1, Math.round(9.0f * this.textScale));
                    List<class_6880<class_1299<?>>> entries = TitleDescriptionBox.listEntriesForTag(condLine.tagId);
                    List<class_2960> ids = TitleDescriptionBox.idsOfEntries(entries);
                    List<class_2561> names = TitleDescriptionBox.namesOfEntries(entries);
                    if (!ids.isEmpty()) {
                        this.tagSpots.add(new TagSpot(tagX, tagY, tagWpx, tagH, condLine.tagId, ids, names));
                    }
                    postX = tagX + tagWpx;
                    this.drawScaled(ctx, firstPostLine, postX, ty - this.scrollY, condLine.color, this.textScale);
                    for (i = 0; i < (restLines != null ? restLines.size() : 0); ++i) {
                        this.drawScaled(ctx, (class_5481)restLines.get(i), textX, ty + (i + 1) * lineH - this.scrollY, condLine.color, this.textScale);
                    }
                } else {
                    for (int i = 0; i < (restLines != null ? restLines.size() : 0); ++i) {
                        this.drawScaled(ctx, (class_5481)restLines.get(i), textX, ty + i * lineH - this.scrollY, condLine.color, this.textScale);
                    }
                }
                if (showInfo) {
                    infoSize = this.scaled(9);
                    int badgeX = innerX + innerW - infoSize;
                    int badgeY = TitleDescriptionBox.centerY(startY, this.scrollY, blockH, infoSize);
                    this.drawSprite(ctx, INFO_ICON, badgeX, badgeY, infoSize, infoSize);
                    this.hintSpots.add(new HintSpot(badgeX, badgeY, infoSize, infoSize, List.of(condLine.hint)));
                }
                y += blockH + 2;
            }
            this.drawDivider(ctx, innerX, (y += this.scaled(4)) - this.scrollY, innerW);
            y += this.scaled(6);
        }
        boolean hasEquipped = this.hasAnyEquipped();
        boolean hasPerma = this.hasAnyPerma();
        if (hasEquipped || hasPerma) {
            y += this.drawFullWidthPill(ctx, innerX, y - this.scrollY, innerW, (class_2561)class_2561.method_43470((String)"Bonuses"), -12956566, -14734787, -1, this.textScale) + 4;
            if (hasEquipped) {
                y += this.drawCenteredPill(ctx, innerX, innerW, y - this.scrollY, (class_2561)class_2561.method_43470((String)"Equipped"), -13748408, -15064528, -1643272, this.textScale * 0.95f) + 3;
                y = this.drawEquippedSection(ctx, innerX, innerW, y);
            }
            if (hasPerma) {
                y += 3;
                y += this.drawCenteredPill(ctx, innerX, innerW, y - this.scrollY, (class_2561)class_2561.method_43470((String)"Permanent"), -13748408, -15064528, -1643272, this.textScale * 0.95f) + 3;
                y = this.drawPermaSection(ctx, innerX, innerW, y);
            }
        }
        ctx.method_44380();
        int contentHeight = y - (boxY + 3);
        int n = viewportBottom - viewportTop;
        this.maxScrollCached = maxScroll = Math.max(0, contentHeight - n);
        if (this.scrollY > this.maxScrollCached) {
            this.scrollY = this.maxScrollCached;
        }
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
        this.renderScrollbar(ctx, mouseX, mouseY, innerX, viewportTop, innerW, n, contentHeight);
    }

    private boolean hasAnyEquipped() {
        if (this.current == null) {
            return false;
        }
        for (Title.Bonus b : this.current.bonuses) {
            if (!(b.attribute != null || b.spellId != null && b.spellId.isPresent() || b.powerId != null && b.powerId.isPresent() || b.damageTarget != null && b.damageTarget.isPresent()) && (b.damageTag == null || !b.damageTag.isPresent())) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyPerma() {
        if (this.current == null) {
            return false;
        }
        for (Title.Bonus b : this.current.permaBonuses) {
            if (!(b.attribute != null || b.spellId != null && b.spellId.isPresent() || b.powerId != null && b.powerId.isPresent() || b.damageTarget != null && b.damageTarget.isPresent()) && (b.damageTag == null || !b.damageTag.isPresent())) continue;
            return true;
        }
        return false;
    }

    private int drawEquippedSection(class_332 ctx, int innerX, int innerW, int y) {
        List<class_2561> attrLines = this.formatBonusesAttributes(this.current.bonuses);
        List<class_2960> spells = this.collectIds(this.current.bonuses, true, false);
        List<class_2960> powers = this.collectIds(this.current.bonuses, false, true);
        int yy = y;
        if (!attrLines.isEmpty()) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Attributes")) + 3;
            yy = this.drawWrappedList(ctx, innerX, innerW, yy, attrLines, -855638017, this.textScale);
        }
        if (!spells.isEmpty()) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Spells")) + 3;
            yy = this.drawSpellList(ctx, innerX, innerW, yy, spells, this.textScale * 0.9f);
        }
        if (!powers.isEmpty()) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Powers")) + 3;
            yy = this.drawPowerList(ctx, innerX, innerW, yy, powers, this.textScale * 0.9f);
        }
        if (this.hasDamage(this.current.bonuses)) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Damage against")) + 3;
            yy = this.drawDamageList(ctx, innerX, innerW, yy, this.current.bonuses, this.textScale);
        }
        return yy;
    }

    private int drawPermaSection(class_332 ctx, int innerX, int innerW, int y) {
        List<class_2561> attrLines = this.formatBonusesAttributes(this.current.permaBonuses);
        List<class_2960> spells = this.collectIds(this.current.permaBonuses, true, false);
        List<class_2960> powers = this.collectIds(this.current.permaBonuses, false, true);
        int yy = y;
        if (!attrLines.isEmpty()) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Attributes")) + 3;
            yy = this.drawWrappedList(ctx, innerX, innerW, yy, attrLines, -855638017, this.textScale);
        }
        if (!spells.isEmpty()) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Spells")) + 3;
            yy = this.drawSpellList(ctx, innerX, innerW, yy, spells, this.textScale * 0.9f);
        }
        if (!powers.isEmpty()) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Powers")) + 3;
            yy = this.drawPowerList(ctx, innerX, innerW, yy, powers, this.textScale * 0.9f);
        }
        if (this.hasDamage(this.current.permaBonuses)) {
            yy += this.drawLeftTagPill(ctx, innerX, yy - this.scrollY, (class_2561)class_2561.method_43470((String)"Damage against")) + 3;
            yy = this.drawDamageList(ctx, innerX, innerW, yy, this.current.permaBonuses, this.textScale);
        }
        return yy;
    }

    private boolean hasDamage(List<Title.Bonus> list) {
        for (Title.Bonus b : list) {
            if ((b.damageTarget == null || !b.damageTarget.isPresent()) && (b.damageTag == null || !b.damageTag.isPresent())) continue;
            return true;
        }
        return false;
    }

    private int drawWrappedList(class_332 ctx, int innerX, int innerW, int y, List<class_2561> lines, int color, float scale) {
        int wrapWidth = Math.max(1, Math.round((float)innerW / scale));
        for (class_2561 t : lines) {
            List wrapped = this.font.method_1728((class_5348)t, wrapWidth);
            for (class_5481 ot : wrapped) {
                this.drawScaled(ctx, ot, innerX, y - this.scrollY, color, scale);
                Objects.requireNonNull(this.font);
                y += Math.max(1, Math.round(9.0f * scale));
            }
            y += 2;
        }
        return y;
    }

    private int drawDamageList(class_332 ctx, int innerX, int innerW, int y, List<Title.Bonus> bonuses, float scale) {
        int color = -855638017;
        int lineH = Math.max(1, Math.round(9.0f * scale));
        for (Title.Bonus b : bonuses) {
            class_5250 targetText;
            class_2960 mobId = null;
            class_2960 tagId = null;
            if (b.damageTarget != null && b.damageTarget.isPresent()) {
                mobId = b.damageTarget.get();
                targetText = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)class_7923.field_41177.method_10223(mobId)).method_5882())).method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
            } else {
                if (b.damageTag == null || !b.damageTag.isPresent()) continue;
                tagId = b.damageTag.get();
                targetText = class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(tagId.method_12832())).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
            }
            String sgn = b.damageOp == Title.DamageOp.ADDED ? (b.damageAmount >= 0.0 ? "+" : "") + TitleDescriptionBox.trim(b.damageAmount) : (b.damageAmount * 100.0 >= 0.0 ? "+" : "") + TitleDescriptionBox.trim(b.damageAmount * 100.0) + "%";
            class_5250 pre = class_2561.method_43470((String)"\u2022 ");
            class_5250 mid = class_2561.method_43470((String)" ");
            class_5250 post = class_2561.method_43470((String)(" " + sgn));
            int x = innerX;
            class_5481 preOT = pre.method_30937();
            this.drawScaled(ctx, preOT, x, y - this.scrollY, -855638017, scale);
            class_5481 mainOT = targetText.method_30937();
            int w = Math.round((float)this.font.method_30880(mainOT) * scale);
            this.drawScaled(ctx, mainOT, x += Math.round((float)this.font.method_30880(preOT) * scale), y - this.scrollY, -855638017, scale);
            Objects.requireNonNull(this.font);
            int h = Math.max(1, Math.round(9.0f * scale));
            if (mobId != null) {
                this.mobSpots.add(new MobSpot(x, y - this.scrollY, w, h, mobId, (class_2561)targetText));
            } else if (tagId != null) {
                List<class_6880<class_1299<?>>> entries = TitleDescriptionBox.listEntriesForTag(tagId);
                List<class_2960> ids = TitleDescriptionBox.idsOfEntries(entries);
                List<class_2561> names = TitleDescriptionBox.namesOfEntries(entries);
                if (!ids.isEmpty()) {
                    this.tagSpots.add(new TagSpot(x, y - this.scrollY, w, h, tagId, ids, names));
                }
            }
            this.drawScaled(ctx, mid.method_30937(), x += w, y - this.scrollY, -855638017, scale);
            this.drawScaled(ctx, post.method_30937(), x += Math.round((float)this.font.method_27525((class_5348)mid) * scale), y - this.scrollY, -855638017, scale);
            y += lineH + 2;
        }
        return y;
    }

    private int drawSpellList(class_332 ctx, int innerX, int innerW, int y, List<class_2960> spells, float scale) {
        int iconSize = Math.max(1, Math.round(12.0f * scale));
        int gap = Math.max(1, Math.round(4.0f * scale));
        Objects.requireNonNull(this.font);
        int textH = Math.max(1, Math.round(9.0f * scale));
        for (class_2960 sid : spells) {
            class_2960 icon = SpellRender.iconTexture((class_2960)sid);
            class_2561 name = this.resolveSpellName(sid);
            int blockH = Math.max(iconSize, textH);
            int iconY = y - this.scrollY + (blockH - iconSize) / 2;
            int nameY = y - this.scrollY + (blockH - textH) / 2;
            ctx.method_25290(icon, innerX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            this.drawScaled(ctx, name.method_30937(), innerX + iconSize + gap, nameY + 1, -855638017, scale);
            y += blockH + 2;
        }
        return y;
    }

    private int drawPowerList(class_332 ctx, int innerX, int innerW, int y, List<class_2960> powers, float scale) {
        int lineH = Math.max(1, Math.round(9.0f * scale));
        for (class_2960 pid : powers) {
            class_5250 line = class_2561.method_43470((String)"\u2022 ").method_10852(this.resolvePowerName(pid));
            this.drawScaled(ctx, line.method_30937(), innerX, y - this.scrollY, -855638017, scale);
            y += lineH + 2;
        }
        return y;
    }

    private int drawLeftTagPill(class_332 ctx, int x, int y, class_2561 label) {
        float scale = this.textScale * 0.9f;
        class_5481 ot = label.method_30937();
        int padX = Math.max(6, this.scaled(8));
        int padY = Math.max(2, this.scaled(3));
        int textW = Math.round((float)this.font.method_30880(ot) * scale);
        Objects.requireNonNull(this.font);
        int textH = Math.max(1, Math.round(9.0f * scale));
        int w = textW + padX * 2;
        int h = textH + padY * 2;
        int radius = Math.max(2, Math.round(4.0f * scale));
        this.drawRoundedRect(ctx, x, y, w, h, radius, 857877046, 1721807040);
        int textX = x + (w - textW) / 2;
        int textY = y + (h - textH) / 2;
        this.drawScaled(ctx, ot, textX, textY, -2694934, scale);
        return h;
    }

    private int drawFullWidthPill(class_332 ctx, int x, int y, int width, class_2561 label, int bg, int br, int textColor, float scale) {
        int padY = Math.max(2, this.scaled(3));
        Objects.requireNonNull(this.font);
        int textH = Math.max(1, Math.round(9.0f * scale));
        int h = textH + padY * 2;
        int radius = Math.max(2, Math.round(4.0f * scale));
        this.drawRoundedRect(ctx, x, y, width, h, radius, bg, br);
        class_5481 ot = label.method_30937();
        int textW = Math.round((float)this.font.method_30880(ot) * scale);
        int textX = x + (width - textW) / 2;
        int textY = y + (h - textH) / 2;
        this.drawScaled(ctx, ot, textX, textY, textColor, scale);
        return h;
    }

    private int drawCenteredPill(class_332 ctx, int innerX, int innerW, int y, class_2561 label, int bg, int br, int textColor, float scale) {
        class_5481 ot = label.method_30937();
        int padX = Math.max(6, this.scaled(8));
        int padY = Math.max(2, this.scaled(3));
        int textW = Math.round((float)this.font.method_30880(ot) * scale);
        Objects.requireNonNull(this.font);
        int textH = Math.max(1, Math.round(9.0f * scale));
        int w = textW + padX * 2;
        int h = textH + padY * 2;
        int x = innerX + (innerW - w) / 2;
        int radius = Math.max(2, Math.round(4.0f * scale));
        this.drawRoundedRect(ctx, x, y, w, h, radius, bg, br);
        int textX = x + (w - textW) / 2;
        int textY = y + (h - textH) / 2;
        this.drawScaled(ctx, ot, textX, textY, textColor, scale);
        return h;
    }

    private void drawRoundedRect(class_332 ctx, int x, int y, int w, int h, int r, int bg, int br) {
        int right = x + w;
        int bottom = y + h;
        ctx.method_25294(x + r, y, right - r, bottom, bg);
        ctx.method_25294(x, y + r, right, bottom - r, bg);
        this.drawCorner(ctx, x + r, y + r, r, true, true, bg);
        this.drawCorner(ctx, right - r - 1, y + r, r, false, true, bg);
        this.drawCorner(ctx, x + r, bottom - r - 1, r, true, false, bg);
        this.drawCorner(ctx, right - r - 1, bottom - r - 1, r, false, false, bg);
        ctx.method_49601(x, y, w, h, br);
    }

    private void drawCorner(class_332 ctx, int cx, int cy, int r, boolean left, boolean top, int color) {
        int signX = left ? -1 : 1;
        int signY = top ? -1 : 1;
        int i = 0;
        while (i < r) {
            int dx = r - i;
            int dy = i++;
            int px = cx + signX * dx;
            int py = cy + signY * dy;
            ctx.method_25294(px, py, px + 1, py + 1, color);
        }
    }

    private static int centerY(int startY, int scrollY, int blockH, int h) {
        return startY - scrollY + (blockH - h) / 2;
    }

    public void renderHints(class_332 ctx, int mouseX, int mouseY) {
        for (MobSpot mobSpot : this.mobSpots) {
            if (!mobSpot.contains(mouseX, mouseY)) continue;
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            this.drawMobTooltip(ctx, mouseX, mouseY, mobSpot);
            ctx.method_51448().method_22909();
            return;
        }
        for (TagSpot tagSpot : this.tagSpots) {
            if (!tagSpot.contains(mouseX, mouseY)) continue;
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            this.drawTagTooltip(ctx, mouseX, mouseY, tagSpot);
            ctx.method_51448().method_22909();
            return;
        }
        for (HintSpot hintSpot : this.hintSpots) {
            if (!hintSpot.contains(mouseX, mouseY)) continue;
            ctx.method_51434(this.font, hintSpot.hint, mouseX, mouseY);
            return;
        }
    }

    private void drawMobTooltip(class_332 ctx, int mouseX, int mouseY, MobSpot s) {
        String modName = TitleDescriptionBox.modNameOf(s.mobId.method_12836());
        class_2561 line1 = s.mobName;
        class_5250 line2 = class_2561.method_43470((String)modName);
        int pad = 6;
        int gapHeaderBody = 6;
        int headerTextGap = 2;
        Objects.requireNonNull(this.font);
        int textH = 9;
        int w1 = this.font.method_27525((class_5348)line1);
        int w2 = this.font.method_27525((class_5348)line2);
        int headerW = Math.max(w1, w2) + pad * 2;
        int headerH = pad + (textH * 2 + headerTextGap) + pad;
        int BASE = 40;
        class_1309 entity = TitleIconRenderer.getPreviewEntity(s.mobId);
        float eW = entity != null ? Math.max(0.1f, entity.method_17681()) : 1.0f;
        float eH = entity != null ? Math.max(0.1f, entity.method_17682()) : 1.0f;
        float excessW = Math.max(0.0f, eW - 1.0f);
        float excessH = Math.max(0.0f, eH - 1.0f);
        int previewAreaW = 40 + Math.round(40.0f * excessW);
        int previewAreaH = 40 + Math.round(40.0f * excessH);
        int bodyPad = 6;
        int bodyW = previewAreaW + bodyPad * 2;
        int bodyH = previewAreaH + bodyPad * 2;
        int tipW = Math.max(headerW, bodyW);
        int tipH = headerH + gapHeaderBody + 1 + bodyH;
        int cursorPad = 12;
        int edgePad = 4;
        class_1041 win = class_310.method_1551().method_22683();
        int sw = win.method_4486();
        int sh = win.method_4502();
        if (tipW > sw - edgePad * 2 && (bodyW = (tipW = sw - edgePad * 2)) < previewAreaW + bodyPad * 2) {
            float squeeze = (float)(previewAreaW + bodyPad * 2) / (float)Math.max(1, bodyW);
            previewAreaH = Math.round((float)previewAreaH * squeeze);
            bodyH = previewAreaH + bodyPad * 2;
        }
        if (tipH > sh - edgePad * 2) {
            tipH = sh - edgePad * 2;
            bodyH = Math.max(16, tipH - headerH - gapHeaderBody - 1);
        }
        int x = mouseX + cursorPad;
        int y = mouseY + cursorPad;
        if (x + tipW + edgePad > sw) {
            x = mouseX - cursorPad - tipW;
        }
        if (y + tipH + edgePad > sh) {
            y = mouseY - cursorPad - tipH;
        }
        x = Math.max(edgePad, Math.min(sw - tipW - edgePad, x));
        y = Math.max(edgePad, Math.min(sh - tipH - edgePad, y));
        int bg = -267382768;
        int border1 = 0x50505050;
        int border2 = -1600085856;
        ctx.method_25294(x - 1, y - 1, x + tipW + 1, y + tipH + 1, border1);
        ctx.method_25294(x, y, x + tipW, y + tipH, bg);
        ctx.method_49601(x, y, tipW, tipH, border2);
        int headerCenterX = x + tipW / 2;
        int nameY = y + pad;
        int modY = nameY + textH + headerTextGap;
        ctx.method_27534(this.font, line1, headerCenterX, nameY, -1);
        ctx.method_27534(this.font, (class_2561)line2, headerCenterX, modY, -5197648);
        int dividerY = y + headerH + gapHeaderBody / 2;
        ctx.method_25294(x + 2, dividerY, x + tipW - 2, dividerY + 1, 0x40FFFFFF);
        int bodyX = x;
        int bodyY = y + headerH + gapHeaderBody + 1;
        ctx.method_25294(bodyX + 1, bodyY + 1, bodyX + tipW - 1, bodyY + bodyH - 1, 0x8080808);
        int areaLeft = bodyX + (tipW - previewAreaW) / 2;
        int areaTop = bodyY + (bodyH - previewAreaH) / 2;
        ctx.method_49601(areaLeft, areaTop, previewAreaW, previewAreaH, 0x20202020);
        int renderLeft = areaLeft + (previewAreaW - 40) / 2;
        int renderTop = areaTop + (previewAreaH - 40) / 2;
        ctx.method_44379(areaLeft, areaTop, areaLeft + previewAreaW, areaTop + previewAreaH);
        TitleIconRenderer.renderEntityPreview(ctx, s.mobId, renderLeft, renderTop, 40);
        ctx.method_44380();
    }

    private void drawTagTooltip(class_332 ctx, int mouseX, int mouseY, TagSpot s) {
        long time = class_310.method_1551().field_1687 != null ? class_310.method_1551().field_1687.method_8510() : System.currentTimeMillis() / 50L;
        int n = Math.max(1, s.entityIds.size());
        int idx = (int)(Math.floorDiv(time, 20) % (long)n);
        class_2960 mobId = s.entityIds.get(idx);
        class_2561 mobName = s.entityNames.get(idx);
        this.drawMobTooltip(ctx, mouseX, mouseY, new MobSpot(s.x, s.y, s.w, s.h, mobId, mobName));
    }

    private static String modNameOf(String namespace) {
        if ("minecraft".equals(namespace)) {
            return "Minecraft";
        }
        Optional c = FabricLoader.getInstance().getModContainer(namespace);
        return c.map(mc -> mc.getMetadata().getName()).orElse(namespace);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int boxW = this.bgWidth - 6 - 62 - 8 - 6;
        int boxX = this.screenX + this.bgWidth - 6 - boxW;
        int boxY = this.screenY + this.bgHeight - 12 - 64;
        int innerX = boxX + 4;
        int innerW = boxW - 8;
        int viewportTop = boxY + 2;
        int viewportBottom = boxY + 64 - 2;
        if (mouseX < (double)innerX || mouseX > (double)(innerX + innerW) || mouseY < (double)viewportTop || mouseY > (double)viewportBottom) {
            return false;
        }
        if (this.maxScrollCached <= 0) {
            return false;
        }
        int before = this.scrollY;
        int step = this.scaled(12);
        if (amount > 0.0) {
            this.scrollY = Math.max(0, this.scrollY - step);
        } else if (amount < 0.0) {
            this.scrollY = Math.min(this.maxScrollCached, this.scrollY + step);
        }
        return this.scrollY != before;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int[] track = this.scrollbarTrackRect();
        int trackX = track[0];
        int trackY = track[1];
        int trackW = track[2];
        int trackH = track[3];
        if (mouseX < (double)trackX || mouseX > (double)(trackX + trackW) || mouseY < (double)trackY || mouseY > (double)(trackY + trackH)) {
            return false;
        }
        if (this.maxScrollCached <= 0) {
            return true;
        }
        int thumbH = this.scrollbarThumbHeight(trackH, this.maxScrollCached + trackH);
        int usable = Math.max(0, trackH - thumbH);
        float ratio = this.maxScrollCached == 0 ? 0.0f : (float)this.scrollY / (float)this.maxScrollCached;
        int thumbTop = trackY + Math.round((float)usable * ratio);
        int thumbBottom = thumbTop + thumbH;
        if (mouseY >= (double)thumbTop && mouseY <= (double)thumbBottom) {
            this.draggingScrollbar = true;
            this.dragGrabOffsetY = (int)Math.round(mouseY) - thumbTop;
            return true;
        }
        int page = trackH;
        this.scrollY = mouseY < (double)thumbTop ? Math.max(0, this.scrollY - page) : Math.min(this.maxScrollCached, this.scrollY + page);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.draggingScrollbar) {
            return false;
        }
        if (this.maxScrollCached <= 0) {
            return true;
        }
        int[] track = this.scrollbarTrackRect();
        int trackX = track[0];
        int trackY = track[1];
        int trackW = track[2];
        int trackH = track[3];
        int thumbH = this.scrollbarThumbHeight(trackH, this.maxScrollCached + trackH);
        int usable = Math.max(0, trackH - thumbH);
        int newTop = (int)Math.round(mouseY) - this.dragGrabOffsetY;
        newTop = Math.max(trackY, Math.min(trackY + usable, newTop));
        float ratio = usable <= 0 ? 0.0f : (float)(newTop - trackY) / (float)usable;
        this.scrollY = Math.max(0, Math.min(this.maxScrollCached, Math.round(ratio * (float)this.maxScrollCached)));
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return false;
    }

    private void drawSprite(class_332 ctx, class_2960 id, int x, int y, int w, int h) {
        ctx.method_25290(id, x, y, 0.0f, 0.0f, w, h, w, h);
    }

    private void renderScrollbar(class_332 ctx, int mouseX, int mouseY, int innerX, int viewportTop, int innerW, int viewportH, int contentHeight) {
        if (this.maxScrollCached <= 0) {
            return;
        }
        int trackW = this.scrollbarWidth;
        int trackX = innerX + innerW - trackW + this.scrollbarOffsetX;
        int trackY = viewportTop + this.scrollbarOffsetY;
        int trackH = viewportH;
        int thumbH = this.scrollbarThumbHeight(trackH, contentHeight);
        int usable = Math.max(0, trackH - thumbH);
        float ratio = this.maxScrollCached == 0 ? 0.0f : (float)this.scrollY / (float)this.maxScrollCached;
        int thumbTop = trackY + Math.round((float)usable * ratio);
        boolean hoveringThumb = mouseX >= trackX && mouseX <= trackX + trackW && mouseY >= thumbTop && mouseY <= thumbTop + thumbH;
        int thumbColor = hoveringThumb || this.draggingScrollbar ? -1140850689 : -1711276033;
        ctx.method_25294(trackX + 1, thumbTop, trackX + trackW - 1, thumbTop + thumbH, thumbColor);
        ctx.method_49601(trackX + 1, thumbTop, trackW - 2, thumbH, 0x66000000);
    }

    private int[] scrollbarTrackRect() {
        int boxW = this.bgWidth - 6 - 62 - 8 - 6;
        int boxX = this.screenX + this.bgWidth - 6 - boxW;
        int boxY = this.screenY + this.bgHeight - 12 - 64;
        int innerX = boxX + 4;
        int innerW = boxW - 8;
        int viewportTop = boxY + 2;
        int viewportBottom = boxY + 64 - 2;
        int viewportH = viewportBottom - viewportTop;
        int trackW = this.scrollbarWidth;
        int trackX = innerX + innerW - trackW + this.scrollbarOffsetX;
        int trackY = viewportTop + this.scrollbarOffsetY;
        return new int[]{trackX, trackY, trackW, viewportH};
    }

    private int scrollbarThumbHeight(int trackHeight, int contentHeight) {
        if (contentHeight <= 0) {
            return Math.max(8, trackHeight);
        }
        float visibleRatio = Math.min(1.0f, (float)trackHeight / (float)contentHeight);
        int h = Math.round((float)trackHeight * visibleRatio);
        return Math.max(8, Math.min(trackHeight, h));
    }

    private List<class_2561> formatBonusesAttributes(List<Title.Bonus> bonuses) {
        ArrayList<class_2561> out = new ArrayList<class_2561>();
        boolean ilt = TitleDescriptionBox.isIconLeadingTooltipPresent();
        for (Title.Bonus b : bonuses) {
            String raw;
            int[] span;
            String sign;
            if (b.spellId != null && b.spellId.isPresent() || b.powerId != null && b.powerId.isPresent() || b.attribute == null) continue;
            String attrKey = ((class_1320)b.attribute.comp_349()).method_26830();
            class_5250 attrName = class_2561.method_43471((String)attrKey);
            String string = sign = b.amount >= 0.0 ? "+" : "";
            if (ilt && (span = IconLeadingUtil.firstIconSpan((String)(raw = attrName.getString())))[0] >= 0) {
                String icon = raw.substring(span[0], span[1]);
                String restRaw = raw.substring(0, span[0]) + raw.substring(span[1]);
                String rest = IconLeadingUtil.stripSectionCodes((String)restRaw).replaceFirst("^\\s+", "");
                class_5250 iconText = class_2561.method_43470((String)(icon + " "));
                class_5250 restText = class_2561.method_43470((String)rest);
                if (b.operation == class_1322.class_1323.field_6328) {
                    out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleDescriptionBox.trim(b.amount) + " "))).method_10852((class_2561)restText));
                    continue;
                }
                if (b.operation == class_1322.class_1323.field_6330) {
                    out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleDescriptionBox.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (base)")));
                    continue;
                }
                out.add((class_2561)class_2561.method_43473().method_10852((class_2561)iconText).method_10852((class_2561)class_2561.method_43470((String)(sign + TitleDescriptionBox.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)restText).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
                continue;
            }
            if (b.operation == class_1322.class_1323.field_6328) {
                out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleDescriptionBox.trim(b.amount) + " "))).method_10852((class_2561)attrName));
                continue;
            }
            if (b.operation == class_1322.class_1323.field_6330) {
                out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleDescriptionBox.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (base)")));
                continue;
            }
            out.add((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)(sign + TitleDescriptionBox.trim(b.amount * 100.0) + "% "))).method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)" (total)")));
        }
        return out;
    }

    private List<class_2960> collectIds(List<Title.Bonus> bonuses, boolean spells, boolean powers) {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (Title.Bonus b : bonuses) {
            if (spells && b.spellId != null && b.spellId.isPresent()) {
                list.add(b.spellId.get());
            }
            if (!powers || b.powerId == null || !b.powerId.isPresent()) continue;
            list.add(b.powerId.get());
        }
        return list;
    }

    private class_2561 resolveSpellName(class_2960 id) {
        class_5250 t;
        String raw;
        class_2378 reg;
        class_6880.class_6883 entry;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1687 != null && (entry = (class_6880.class_6883)(reg = SpellRegistry.from((class_1937)client.field_1687)).method_55841(id).orElse(null)) != null && !(raw = (t = class_2561.method_43471((String)("spell." + id.method_12836() + "." + id.method_12832()))).getString()).equals("spell." + id.method_12836() + "." + id.method_12832())) {
            return t;
        }
        return class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(id.method_12832()));
    }

    private class_2561 resolvePowerName(class_2960 id) {
        return class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(id.method_12832()));
    }

    private static String toTitleCase(String path) {
        String nice = path.replace('_', ' ');
        String[] parts = nice.split(" ");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p.isEmpty()) continue;
            sb.append(p.substring(0, 1).toUpperCase(Locale.ROOT)).append(p.substring(1));
            if (i + 1 >= parts.length) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private List<CondLine> buildConditionLines() {
        ArrayList<CondLine> out = new ArrayList<CondLine>();
        List<TitleClientData.CondProg> progs = TitleClientData.getProgress(this.current.id);
        block18: for (int i = 0; i < this.current.conditions.size(); ++i) {
            Title.Condition c = this.current.conditions.get(i);
            long cur = 0L;
            boolean doneFlag = false;
            if (i < progs.size()) {
                cur = progs.get(i).current();
                doneFlag = progs.get(i).done();
            }
            if (c.hidden && c.hint.isPresent()) {
                int color = doneFlag ? -8650885 : -1;
                class_5250 line = class_2561.method_43470((String)c.hint.get()).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(TitleDescriptionBox.progressTail(c, cur, doneFlag));
                out.add(CondLine.text((class_2561)line, null, color, doneFlag, c));
                continue;
            }
            switch (c.type) {
                case KILL_MOBS: {
                    class_2960 mid;
                    String spec;
                    class_5250 post;
                    class_5250 tagText;
                    class_5250 pre;
                    class_2960 tagId;
                    int target = Math.max(1, c.count);
                    boolean reached = cur >= (long)target || doneFlag;
                    int color = reached ? -8650885 : -1;
                    class_5250 tail = class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")"));
                    if (c.entityTagId != null && c.entityTagId.isPresent()) {
                        tagId = c.entityTagId.get();
                        pre = class_2561.method_43470((String)("Defeat " + target + " any "));
                        tagText = class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(tagId.method_12832())).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
                        out.add(CondLine.tag((class_2561)pre, (class_2561)tagText, tagId, (class_2561)tail, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    if (c.entityType.isPresent()) {
                        class_2960 id = c.entityType.get();
                        class_2561 mobName = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)class_7923.field_41177.method_10223(id)).method_5882()));
                        class_5250 pre2 = class_2561.method_43470((String)("Defeat " + target + " "));
                        post = tail;
                        out.add(CondLine.mob((class_2561)pre2, mobName, id, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    if (c.entitySpec.isPresent()) {
                        class_5250 line;
                        spec = c.entitySpec.get();
                        mid = class_2960.method_12829((String)spec);
                        if (mid != null && class_7923.field_41177.method_10250(mid)) {
                            class_2561 mobName = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)class_7923.field_41177.method_10223(mid)).method_5882()));
                            class_5250 pre3 = class_2561.method_43470((String)("Defeat " + target + " "));
                            class_5250 post2 = tail;
                            out.add(CondLine.mob((class_2561)pre3, mobName, mid, (class_2561)post2, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                            continue block18;
                        }
                        if ("any".equalsIgnoreCase(spec)) {
                            line = class_2561.method_43469((String)"title.rpgsystems.condition.kill_any", (Object[])new Object[]{target}).method_10852((class_2561)tail);
                            out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                            continue block18;
                        }
                        if (spec.endsWith(":*")) {
                            String ns = spec.substring(0, spec.indexOf(58));
                            class_5250 line2 = class_2561.method_43470((String)("Defeat " + target + " mobs from " + ns)).method_10852((class_2561)tail);
                            out.add(CondLine.text((class_2561)line2, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                            continue block18;
                        }
                        line = class_2561.method_43470((String)("Defeat " + target + " mobs: " + spec)).method_10852((class_2561)tail);
                        out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    class_5250 line = class_2561.method_43469((String)"title.rpgsystems.condition.kill_any", (Object[])new Object[]{target}).method_10852((class_2561)tail);
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case OBTAIN_ITEM: {
                    if (!c.item.isPresent()) continue block18;
                    int target = Math.max(1, c.count);
                    boolean reached = doneFlag || cur >= (long)target;
                    int color = reached ? -8650885 : -1;
                    class_5250 pre = class_2561.method_43470((String)("Obtain " + target + " "));
                    class_5250 post = class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")"));
                    out.add(CondLine.inlineIcon((class_2561)pre, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case WALK_BLOCKS: {
                    long target = Math.max(1L, c.distance);
                    boolean reached = cur >= target || doneFlag;
                    int color = reached ? -8650885 : -1;
                    class_5250 line = class_2561.method_43469((String)"title.rpgsystems.condition.walk", (Object[])new Object[]{target}).method_10852((class_2561)class_2561.method_43470((String)(" (" + Math.min(cur, target) + "/" + target + ")")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case CRAFT_ITEM: {
                    int color;
                    int target = Math.max(1, c.count);
                    boolean reached = cur >= (long)target || doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    if (!c.item.isPresent()) continue block18;
                    class_5250 pre = class_2561.method_43470((String)("Craft " + target + " "));
                    class_5250 post = class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")"));
                    out.add(CondLine.inlineIcon((class_2561)pre, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case MINE_BLOCKS: {
                    int color;
                    class_5250 post;
                    int target = Math.max(1, c.count);
                    boolean reached = cur >= (long)target || doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    if (c.block.isPresent()) {
                        class_5250 pre = class_2561.method_43470((String)("Mine " + target + " "));
                        post = class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")"));
                        out.add(CondLine.inlineIcon((class_2561)pre, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    class_5250 line = class_2561.method_43470((String)("Mine " + target + " blocks")).method_10852((class_2561)class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case REACH_LEVEL_XP: {
                    int target = Math.max(1, c.level);
                    boolean reached = cur >= (long)target || doneFlag;
                    int color = reached ? -8650885 : -1;
                    class_5250 line = class_2561.method_43469((String)"title.rpgsystems.condition.reach_xp", (Object[])new Object[]{target}).method_10852((class_2561)class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case REACH_LEVEL_PUFFERFISH: {
                    int target = Math.max(1, c.level);
                    boolean reached = cur >= (long)target || doneFlag;
                    int color = reached ? -8650885 : -1;
                    class_5250 line = class_2561.method_43469((String)"title.rpgsystems.condition.reach_pufferfish", (Object[])new Object[]{target}).method_10852((class_2561)class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case ADVANCEMENT: {
                    boolean reached = doneFlag;
                    int color = reached ? -8650885 : -1;
                    class_5250 base = c.advancement.isPresent() ? class_2561.method_43469((String)"title.rpgsystems.condition.advancement", (Object[])new Object[]{c.advancement.get().toString()}) : class_2561.method_43469((String)"title.rpgsystems.condition.advancement", (Object[])new Object[]{""});
                    class_5250 line = base.method_10852((class_2561)class_2561.method_43470((String)(" (" + (reached ? 1 : 0) + "/1)")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case VISIT_BIOME: {
                    boolean reached = doneFlag;
                    int color = reached ? -8650885 : -1;
                    class_5250 line = c.biome.isPresent() ? class_2561.method_43470((String)"Visit ").method_10852((class_2561)class_2561.method_43471((String)("biome." + c.biome.get().method_12836() + "." + c.biome.get().method_12832()))) : class_2561.method_43470((String)"Visit a biome");
                    line = line.method_10852((class_2561)class_2561.method_43470((String)(" (" + (reached ? 1 : 0) + "/1)")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case ENTER_DIMENSION: {
                    boolean reached = doneFlag;
                    int color = reached ? -8650885 : -1;
                    class_5250 line = c.dimension.isPresent() ? class_2561.method_43470((String)("Enter " + String.valueOf(c.dimension.get()))) : class_2561.method_43470((String)"Enter a dimension");
                    line = line.method_10852((class_2561)class_2561.method_43470((String)(" (" + (reached ? 1 : 0) + "/1)")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case INTERACT_BLOCK: {
                    int color;
                    class_5250 post;
                    int target = Math.max(1, c.count);
                    boolean reached = cur >= (long)target || doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    if (c.block.isPresent()) {
                        class_5250 pre = class_2561.method_43470((String)"Interact with ");
                        post = class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")"));
                        out.add(CondLine.inlineIcon((class_2561)pre, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    class_5250 line = class_2561.method_43470((String)"Interact with a block").method_10852((class_2561)class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case INTERACT_ENTITY: {
                    int color;
                    class_5250 post;
                    class_2960 mid;
                    String spec;
                    int target = Math.max(1, c.count);
                    boolean reached = cur >= (long)target || doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    if (c.entityType.isPresent()) {
                        class_5250 pre = class_2561.method_43470((String)"Interact with ");
                        post = class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")"));
                        out.add(CondLine.inlineIcon((class_2561)pre, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    if (c.entityTagId != null && c.entityTagId.isPresent()) {
                        class_2960 tagId = c.entityTagId.get();
                        class_5250 pre = class_2561.method_43470((String)"Interact with any ");
                        class_5250 tagText = class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(tagId.method_12832())).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
                        class_5250 post3 = class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")"));
                        out.add(CondLine.tag((class_2561)pre, (class_2561)tagText, tagId, (class_2561)post3, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    Object who = c.entitySpec.isPresent() ? ("any".equalsIgnoreCase(spec = c.entitySpec.get()) ? class_2561.method_43470((String)"any entity") : (spec.endsWith(":*") ? class_2561.method_43470((String)(spec.substring(0, spec.indexOf(58)) + " entities")) : ((mid = class_2960.method_12829((String)spec)) != null && class_7923.field_41177.method_10250(mid) ? TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)class_7923.field_41177.method_10223(mid)).method_5882())) : class_2561.method_43470((String)spec)))) : class_2561.method_43470((String)"an entity");
                    class_5250 line = class_2561.method_43470((String)"Interact with ").method_10852((class_2561)who).method_10852((class_2561)class_2561.method_43470((String)(" (" + Math.min(cur, (long)target) + "/" + target + ")")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case FIND_STRUCTURE: {
                    class_2960 sid;
                    String tKey;
                    class_5250 cand;
                    int color;
                    boolean reached = doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    class_5250 what = c.structure.isPresent() ? (!(cand = class_2561.method_43471((String)(tKey = "structure." + (sid = c.structure.get()).method_12836() + "." + sid.method_12832()))).getString().equals(tKey) ? cand.method_27661() : class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(sid.method_12832()))) : class_2561.method_43470((String)"a structure");
                    class_5250 line = class_2561.method_43470((String)"Discover ").method_10852((class_2561)what).method_10852((class_2561)class_2561.method_43470((String)(" (" + (reached ? 1 : 0) + "/1)")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case DEAL_DAMAGE_TOTAL: {
                    int color;
                    class_5250 post;
                    class_5250 tagText;
                    class_5250 pre;
                    class_2960 tagId;
                    long target = Math.max(1, c.count);
                    boolean reached = cur >= target || doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    if (c.entityTagId != null && c.entityTagId.isPresent()) {
                        tagId = c.entityTagId.get();
                        pre = class_2561.method_43470((String)("Deal " + target + " total damage to any "));
                        tagText = class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(tagId.method_12832())).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
                        post = class_2561.method_43470((String)(" (" + Math.min(cur, target) + "/" + target + ")"));
                        out.add(CondLine.tag((class_2561)pre, (class_2561)tagText, tagId, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    class_5250 who = c.entitySpec.isPresent() ? class_2561.method_43470((String)c.entitySpec.get()) : c.entityType.map(t -> TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)class_7923.field_41177.method_10223(t)).method_5882()))).orElse((class_2561)class_2561.method_43470((String)"any"));
                    class_5250 line = class_2561.method_43470((String)"Deal ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(target))).method_10852((class_2561)class_2561.method_43470((String)" total damage to ")).method_10852((class_2561)who).method_10852((class_2561)class_2561.method_43470((String)" (")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Math.min(cur, target)))).method_10852((class_2561)class_2561.method_43470((String)"/")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(target))).method_10852((class_2561)class_2561.method_43470((String)")"));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case DEAL_DAMAGE_MAX: {
                    int color;
                    class_5250 post;
                    class_5250 tagText;
                    class_5250 pre;
                    class_2960 tagId;
                    long target = Math.max(1, c.count);
                    boolean reached = cur >= target || doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    if (c.entityTagId != null && c.entityTagId.isPresent()) {
                        tagId = c.entityTagId.get();
                        pre = class_2561.method_43470((String)("Deal a single hit of at least " + target + " to any "));
                        tagText = class_2561.method_43470((String)TitleDescriptionBox.toTitleCase(tagId.method_12832())).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
                        post = class_2561.method_43470((String)(" (best: " + cur + ")"));
                        out.add(CondLine.tag((class_2561)pre, (class_2561)tagText, tagId, (class_2561)post, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                        continue block18;
                    }
                    class_5250 who = c.entitySpec.isPresent() ? class_2561.method_43470((String)c.entitySpec.get()) : c.entityType.map(t -> TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)class_7923.field_41177.method_10223(t)).method_5882()))).orElse((class_2561)class_2561.method_43470((String)"any"));
                    class_5250 line = class_2561.method_43470((String)"Deal a single hit of at least ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(target))).method_10852((class_2561)class_2561.method_43470((String)" to ")).method_10852((class_2561)who).method_10852((class_2561)class_2561.method_43470((String)" (best: ")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(cur))).method_10852((class_2561)class_2561.method_43470((String)")"));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                    continue block18;
                }
                case CHECK_ATTRIBUTE: {
                    class_5250 attrName;
                    int color;
                    boolean reached = doneFlag;
                    int n = color = reached ? -8650885 : -1;
                    if (c.attributeId.isPresent()) {
                        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)c.attributeId.get());
                        class_6880.class_6883 entry = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41251).method_40264(key).orElse(null);
                        attrName = entry != null ? class_2561.method_43471((String)((class_1320)entry.comp_349()).method_26830()) : class_2561.method_43470((String)c.attributeId.get().toString());
                    } else {
                        attrName = class_2561.method_43470((String)"attribute");
                    }
                    double min = c.minValue;
                    class_5250 line = class_2561.method_43470((String)"Reach ").method_10852((class_2561)attrName).method_10852((class_2561)class_2561.method_43470((String)(" \u2265 " + TitleDescriptionBox.trim(min)))).method_10852((class_2561)class_2561.method_43470((String)(" (now: " + cur + ")")));
                    out.add(CondLine.text((class_2561)line, c.hint.map(class_2561::method_43470).orElse(null), color, reached, c));
                }
            }
        }
        return out;
    }

    private static class_2561 plainName(class_2561 t) {
        return class_2561.method_43470((String)TitleDescriptionBox.stripLeadingIconLikeChunk(t.getString()));
    }

    private static String stripLeadingIconLikeChunk(String s) {
        String head;
        boolean headHasAlnum;
        if (s == null || s.isEmpty()) {
            return "";
        }
        int firstSpace = (s = s.replaceAll("\\u00A7[0-9A-FK-ORa-fk-or]", "")).indexOf(32);
        if (firstSpace > 0 && !(headHasAlnum = (head = s.substring(0, firstSpace)).chars().anyMatch(Character::isLetterOrDigit))) {
            s = s.substring(firstSpace + 1).stripLeading();
        }
        return s;
    }

    private static class_2561 progressTail(Title.Condition c, long cur, boolean doneFlag) {
        switch (c.type) {
            case KILL_MOBS: 
            case OBTAIN_ITEM: 
            case CRAFT_ITEM: 
            case MINE_BLOCKS: 
            case INTERACT_BLOCK: 
            case INTERACT_ENTITY: {
                int target = Math.max(1, c.count);
                return class_2561.method_43470((String)("(" + Math.min(cur, (long)target) + "/" + target + ")"));
            }
            case WALK_BLOCKS: {
                long target = Math.max(1L, c.distance);
                return class_2561.method_43470((String)("(" + Math.min(cur, target) + "/" + target + ")"));
            }
            case REACH_LEVEL_XP: 
            case REACH_LEVEL_PUFFERFISH: {
                int target = Math.max(1, c.level);
                return class_2561.method_43470((String)("(" + Math.min(cur, (long)target) + "/" + target + ")"));
            }
            case ADVANCEMENT: 
            case VISIT_BIOME: 
            case ENTER_DIMENSION: 
            case FIND_STRUCTURE: {
                return class_2561.method_43470((String)("(" + (doneFlag ? 1 : 0) + "/1)"));
            }
            case DEAL_DAMAGE_TOTAL: {
                long target = Math.max(1, c.count);
                return class_2561.method_43470((String)("(" + Math.min(cur, target) + "/" + target + ")"));
            }
            case DEAL_DAMAGE_MAX: {
                return class_2561.method_43470((String)("(best: " + cur + ")"));
            }
            case CHECK_ATTRIBUTE: {
                return class_2561.method_43470((String)("(now: " + cur + ")"));
            }
        }
        return class_2561.method_43470((String)"");
    }

    private static String trim(double v) {
        String s = String.format(Locale.ROOT, "%.2f", v);
        if (s.indexOf(46) >= 0) {
            s = s.replaceAll("0+$", "").replaceAll("\\.$", "");
        }
        return s;
    }

    private int scaled(int px) {
        return Math.max(1, Math.round((float)px * this.textScale));
    }

    private void drawScaled(class_332 ctx, class_5481 text, int x, int y, int color, float scale) {
        if (scale == 1.0f) {
            ctx.method_35720(this.font, text, x, y, color);
            return;
        }
        ctx.method_51448().method_22903();
        ctx.method_51448().method_22905(scale, scale, 1.0f);
        int sx = Math.round((float)x / scale);
        int sy = Math.round((float)y / scale);
        ctx.method_35720(this.font, text, sx, sy, color);
        ctx.method_51448().method_22909();
    }

    private int cutIndexByPixelWidth(String s, int maxPxAtScale1) {
        String ch;
        int cw;
        int i;
        int cp;
        if (maxPxAtScale1 <= 0 || s.isEmpty()) {
            return 0;
        }
        int w = 0;
        for (i = 0; i < s.length() && w + (cw = this.font.method_1727(ch = new String(Character.toChars(cp = s.codePointAt(i))))) <= maxPxAtScale1; i += Character.charCount(cp)) {
            w += cw;
        }
        return i;
    }

    private List<class_2561> iconTooltip(Title.Condition c) {
        class_2960 mid;
        if (c.item.isPresent()) {
            class_2960 id = c.item.get();
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_2561 name = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)item.method_7876()));
            String mod = TitleDescriptionBox.modNameOf(id.method_12836());
            return List.of(name, class_2561.method_43470((String)mod).method_27692(class_124.field_1080));
        }
        if (c.block.isPresent()) {
            class_2960 id = c.block.get();
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
            class_2561 name = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)block.method_9539()));
            String mod = TitleDescriptionBox.modNameOf(id.method_12836());
            return List.of(name, class_2561.method_43470((String)mod).method_27692(class_124.field_1080));
        }
        if (c.entityType.isPresent()) {
            class_2960 typeId = c.entityType.get();
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(typeId);
            class_2561 name = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)type.method_5882()));
            String mod = TitleDescriptionBox.modNameOf(typeId.method_12836());
            return List.of(name, class_2561.method_43470((String)mod).method_27692(class_124.field_1080));
        }
        if (c.entitySpec.isPresent() && (mid = class_2960.method_12829((String)c.entitySpec.get())) != null && class_7923.field_41177.method_10250(mid)) {
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(mid);
            class_2561 name = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)type.method_5882()));
            String mod = TitleDescriptionBox.modNameOf(mid.method_12836());
            return List.of(name, class_2561.method_43470((String)mod).method_27692(class_124.field_1080));
        }
        return null;
    }

    private static boolean isIconLeadingTooltipPresent() {
        FabricLoader fl = FabricLoader.getInstance();
        return fl.isModLoaded("iconleadingtooltip") || fl.isModLoaded("icon-leading-tooltip");
    }

    private static List<class_6880<class_1299<?>>> listEntriesForTag(class_2960 tagId) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return List.of();
        }
        class_2378 reg = mc.field_1687.method_30349().method_30530(class_7924.field_41266);
        class_6862 tk = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)tagId);
        ArrayList out = new ArrayList();
        reg.method_40286(tk).forEach(out::add);
        return out;
    }

    private static List<class_2960> idsOfEntries(List<class_6880<class_1299<?>>> entries) {
        ArrayList<class_2960> list = new ArrayList<class_2960>(entries.size());
        for (class_6880<class_1299<?>> e : entries) {
            class_2960 id = class_7923.field_41177.method_10221((Object)((class_1299)e.comp_349()));
            if (id == null) continue;
            list.add(id);
        }
        return list;
    }

    private static List<class_2561> namesOfEntries(List<class_6880<class_1299<?>>> entries) {
        ArrayList<class_2561> list = new ArrayList<class_2561>(entries.size());
        for (class_6880<class_1299<?>> e : entries) {
            list.add(TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)e.comp_349()).method_5882())));
        }
        return list;
    }

    public static void renderMobTooltip(class_332 ctx, int mouseX, int mouseY, class_2960 mobId, class_2561 mobName) {
        MobSpot tmp = new MobSpot(0, 0, 0, 0, mobId, mobName);
        TitleDescriptionBox dummy = new TitleDescriptionBox(0, 0, 0, 0);
        dummy.drawMobTooltip(ctx, mouseX, mouseY, tmp);
    }

    public static void renderTagTooltip(class_332 ctx, int mouseX, int mouseY, class_2960 tagId) {
        List<class_6880<class_1299<?>>> entries = TitleDescriptionBox.listEntriesForTag(tagId);
        if (entries.isEmpty()) {
            return;
        }
        long time = class_310.method_1551().field_1687 != null ? class_310.method_1551().field_1687.method_8510() : System.currentTimeMillis() / 50L;
        int idx = (int)(Math.floorDiv(time, 20) % (long)entries.size());
        class_2960 mobId = class_7923.field_41177.method_10221((Object)((class_1299)entries.get(idx).comp_349()));
        if (mobId == null) {
            return;
        }
        class_2561 mobName = TitleDescriptionBox.plainName((class_2561)class_2561.method_43471((String)((class_1299)entries.get(idx).comp_349()).method_5882()));
        TitleDescriptionBox.renderMobTooltip(ctx, mouseX, mouseY, mobId, mobName);
    }

    private static final class CondLine {
        final class_2561 text;
        final class_2561 pre;
        final class_2561 post;
        final boolean inlineIcon;
        final class_2561 hint;
        final int color;
        final boolean done;
        final Title.Condition source;
        final class_2561 mobName;
        final class_2960 mobId;
        final class_2561 tagName;
        final class_2960 tagId;

        private CondLine(class_2561 text, class_2561 pre, class_2561 post, boolean inlineIcon, class_2561 hint, int color, boolean done, Title.Condition source, class_2561 mobName, class_2960 mobId, class_2561 tagName, class_2960 tagId) {
            this.text = text;
            this.pre = pre;
            this.post = post;
            this.inlineIcon = inlineIcon;
            this.hint = hint;
            this.color = color;
            this.done = done;
            this.source = source;
            this.mobName = mobName;
            this.mobId = mobId;
            this.tagName = tagName;
            this.tagId = tagId;
        }

        static CondLine text(class_2561 text, class_2561 hint, int color, boolean done, Title.Condition source) {
            return new CondLine(text, null, null, false, hint, color, done, source, null, null, null, null);
        }

        static CondLine inlineIcon(class_2561 pre, class_2561 post, class_2561 hint, int color, boolean done, Title.Condition source) {
            return new CondLine(null, pre, post, true, hint, color, done, source, null, null, null, null);
        }

        static CondLine mob(class_2561 pre, class_2561 mobName, class_2960 mobId, class_2561 post, class_2561 hint, int color, boolean done, Title.Condition source) {
            return new CondLine(null, pre, post, false, hint, color, done, source, mobName, mobId, null, null);
        }

        static CondLine tag(class_2561 pre, class_2561 tagName, class_2960 tagId, class_2561 post, class_2561 hint, int color, boolean done, Title.Condition source) {
            return new CondLine(null, pre, post, false, hint, color, done, source, null, null, tagName, tagId);
        }
    }

    private static final class HintSpot {
        final int x;
        final int y;
        final int w;
        final int h;
        final List<class_2561> hint;

        HintSpot(int x, int y, int w, int h, List<class_2561> hint) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.hint = hint;
        }

        boolean contains(double mx, double my) {
            return mx >= (double)this.x && mx <= (double)(this.x + this.w) && my >= (double)this.y && my <= (double)(this.y + this.h);
        }
    }

    private static final class MobSpot {
        final int x;
        final int y;
        final int w;
        final int h;
        final class_2960 mobId;
        final class_2561 mobName;

        MobSpot(int x, int y, int w, int h, class_2960 mobId, class_2561 mobName) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.mobId = mobId;
            this.mobName = mobName;
        }

        boolean contains(double mx, double my) {
            return mx >= (double)this.x && mx <= (double)(this.x + this.w) && my >= (double)this.y && my <= (double)(this.y + this.h);
        }
    }

    private static final class TagSpot {
        final int x;
        final int y;
        final int w;
        final int h;
        final class_2960 tagId;
        final List<class_2960> entityIds;
        final List<class_2561> entityNames;

        TagSpot(int x, int y, int w, int h, class_2960 tagId, List<class_2960> entityIds, List<class_2561> entityNames) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.tagId = tagId;
            this.entityIds = entityIds;
            this.entityNames = entityNames;
        }

        boolean contains(double mx, double my) {
            return mx >= (double)this.x && mx <= (double)(this.x + this.w) && my >= (double)this.y && my <= (double)(this.y + this.h);
        }
    }
}

