/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class RPGSystemsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "rpgsystems.json";
    private static RPGSystemsConfig INSTANCE;
    public Systems systems = new Systems();
    public Party party = new Party();

    private static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve(FILE_NAME);
    }

    public static synchronized RPGSystemsConfig get() {
        if (INSTANCE == null) {
            RPGSystemsConfig.load();
        }
        return INSTANCE;
    }

    public static synchronized void load() {
        Path p = RPGSystemsConfig.path();
        if (Files.exists(p, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(p);){
                INSTANCE = (RPGSystemsConfig)GSON.fromJson((Reader)r, RPGSystemsConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new RPGSystemsConfig();
                    RPGSystemsConfig.save();
                }
            }
            catch (Throwable t) {
                INSTANCE = new RPGSystemsConfig();
                RPGSystemsConfig.save();
            }
        } else {
            INSTANCE = new RPGSystemsConfig();
            RPGSystemsConfig.save();
        }
    }

    public static synchronized void save() {
        Path p = RPGSystemsConfig.path();
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(p, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class Systems {
        public boolean party = true;
        public boolean pet = false;
        public boolean title = true;
    }

    public static final class Party {
        public boolean logChatToConsole = true;
    }
}

