/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.client.enemy.DamageNumbersRenderer;
import net.pixeldreamstudios.rpgsystems.client.enemy.EnemyHealthBarRenderer;
import net.pixeldreamstudios.rpgsystems.client.enemy.HealingNumbersRenderer;
import net.pixeldreamstudios.rpgsystems.client.enemy.config.DamageTypeConfig;
import net.pixeldreamstudios.rpgsystems.client.enemy.config.HealingNumbersClientConfig;
import net.pixeldreamstudios.rpgsystems.network.enemy.EnemyHudPayloads;

public final class EnemyNet {
    private static final double BROADCAST_RANGE = 64.0;
    private static final double BROADCAST_RANGE_SQ = 4096.0;
    private static final long ABS_SYNC_INTERVAL_TICKS = 20L;
    private static final float ABS_EPS = 0.02f;
    private static final Map<String, Float> lastAbsSent = new HashMap<String, Float>();
    private static final Map<String, Long> lastAbsAt = new HashMap<String, Long>();

    private EnemyNet() {
    }

    public static void initCommon() {
        PayloadTypeRegistry.playS2C().register(EnemyHudPayloads.DamageNumber.ID, EnemyHudPayloads.DamageNumber.CODEC);
        PayloadTypeRegistry.playS2C().register(EnemyHudPayloads.HealingNumber.ID, EnemyHudPayloads.HealingNumber.CODEC);
        PayloadTypeRegistry.playS2C().register(EnemyHudPayloads.AbsorptionSync.ID, EnemyHudPayloads.AbsorptionSync.CODEC);
        ServerTickEvents.END_SERVER_TICK.register(server -> EnemyNet.pushNearbyAbsorption(server));
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver(EnemyHudPayloads.DamageNumber.ID, (payload, ctx) -> ctx.client().execute(() -> {
            DamageTypeConfig.seenDamageType(payload.damageTypeId());
            DamageTypeConfig cfg = DamageTypeConfig.get();
            if (!cfg.shouldShowType(payload.damageTypeId())) {
                return;
            }
            Integer override = cfg.colorOverride(payload.damageTypeId());
            int rgb = override != null ? override.intValue() : payload.rgb();
            DamageNumbersRenderer.spawn(payload.entityId(), payload.amount(), payload.crit(), payload.isPet(), rgb, payload.sourceUuid(), payload.damageTypeId());
            EnemyHealthBarRenderer.pokeOnHpChange(payload.entityId());
        }));
        ClientPlayNetworking.registerGlobalReceiver(EnemyHudPayloads.HealingNumber.ID, (payload, context) -> context.client().execute(() -> {
            HealingNumbersClientConfig cfg = HealingNumbersClientConfig.get();
            float display = cfg.amountMode == HealingNumbersClientConfig.AmountMode.APPLIED ? payload.applied() : payload.attempted();
            HealingNumbersRenderer.spawn(payload.entityId(), display, payload.isSpell(), payload.sourceUuid());
            EnemyHealthBarRenderer.pokeOnHpChange(payload.entityId());
        }));
        ClientPlayNetworking.registerGlobalReceiver(EnemyHudPayloads.AbsorptionSync.ID, (payload, ctx) -> ctx.client().execute(() -> EnemyHealthBarRenderer.onAbsorptionSync(payload.entityId(), payload.absorption())));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_5455.class_6890 rm = handler.method_29091();
            DamageTypeConfig.maybePopulateFromRegistry((class_5455)rm);
        });
    }

    public static void broadcastDamageNumber(class_1297 target, float amount, boolean crit, boolean isPet, int rgb, UUID sourceUuid, class_2960 damageTypeId) {
        if (target == null || target.method_5682() == null) {
            return;
        }
        EnemyHudPayloads.DamageNumber pkt = new EnemyHudPayloads.DamageNumber(target.method_5628(), amount, crit, isPet, rgb, sourceUuid, damageTypeId);
        EnemyNet.forNearbyPlayers(target, sp -> ServerPlayNetworking.send((class_3222)sp, (class_8710)pkt));
    }

    public static void broadcastHealingNumber(class_1297 target, float attempted, float applied, boolean isSpell, UUID sourceUuid) {
        if (target == null || target.method_5682() == null) {
            return;
        }
        EnemyHudPayloads.HealingNumber pkt = new EnemyHudPayloads.HealingNumber(target.method_5628(), attempted, applied, isSpell, sourceUuid);
        EnemyNet.forNearbyPlayers(target, sp -> ServerPlayNetworking.send((class_3222)sp, (class_8710)pkt));
    }

    private static void broadcastAbsorptionToViewer(class_3222 viewer, class_1309 target, float absorption) {
        ServerPlayNetworking.send((class_3222)viewer, (class_8710)new EnemyHudPayloads.AbsorptionSync(target.method_5628(), absorption));
    }

    private static void forNearbyPlayers(class_1297 target, Consumer<class_3222> send) {
        MinecraftServer server = target.method_5682();
        class_243 pos = target.method_19538();
        for (class_3222 sp : server.method_3760().method_14571()) {
            if (sp.method_37908() != target.method_37908() || !(sp.method_5707(pos) <= 4096.0)) continue;
            send.accept(sp);
        }
    }

    private static void pushNearbyAbsorption(MinecraftServer server) {
        for (class_3222 viewer : server.method_3760().method_14571()) {
            class_1937 world = viewer.method_37908();
            class_238 box = viewer.method_5829().method_1014(64.0);
            for (class_1309 le : world.method_8390(class_1309.class, box, e -> true)) {
                boolean timed;
                double dSq;
                if (le == viewer || le.method_31481() || (dSq = viewer.method_5858((class_1297)le)) > 4096.0) continue;
                float abs = le.method_6067();
                String key = String.valueOf(viewer.method_5667()) + ":" + le.method_5628();
                float prev = lastAbsSent.getOrDefault(key, Float.valueOf(Float.NaN)).floatValue();
                long at = lastAbsAt.getOrDefault(key, 0L);
                long now = server.method_30002().method_8510();
                boolean changed = Float.isNaN(prev) || Math.abs(abs - prev) > 0.02f;
                boolean bl = timed = now - at >= 20L;
                if (!changed && !timed) continue;
                EnemyNet.broadcastAbsorptionToViewer(viewer, le, abs);
                lastAbsSent.put(key, Float.valueOf(abs));
                lastAbsAt.put(key, now);
            }
        }
    }
}

