/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.RPGSystems;
import net.pixeldreamstudios.rpgsystems.api.PartyChatEvent;
import net.pixeldreamstudios.rpgsystems.compat.RpgManaCompat;
import net.pixeldreamstudios.rpgsystems.compat.TrbAttributesCompat;
import net.pixeldreamstudios.rpgsystems.config.RPGSystemsConfig;
import net.pixeldreamstudios.rpgsystems.network.party.PartyChatPayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartyHudPayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartyInvitePayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartyJoinRequestPayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartySettingsPayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartyStatusEffectsPayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartyStatusEffectsSync;
import net.pixeldreamstudios.rpgsystems.party.Party;
import net.pixeldreamstudios.rpgsystems.party.PartyAllies;
import net.pixeldreamstudios.rpgsystems.party.PartyPersistentState;
import net.puffish.skillsmod.SkillsMod;

public final class PartyNet {
    private static int tickCounter = 0;
    public static boolean PERSIST_PARTIES_ON_DISCONNECT = true;

    private PartyNet() {
    }

    public static void initCommon() {
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.InviteAdded.ID, PartyInvitePayloads.InviteAdded.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.InviteRemoved.ID, PartyInvitePayloads.InviteRemoved.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.InviteSent.ID, PartyInvitePayloads.InviteSent.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.InviteAccepted.ID, PartyInvitePayloads.InviteAccepted.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.InviteDeclined.ID, PartyInvitePayloads.InviteDeclined.CODEC);
        PayloadTypeRegistry.playC2S().register(PartyInvitePayloads.InviteRespond.ID, PartyInvitePayloads.InviteRespond.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.InviteJoinConfirmed.ID, PartyInvitePayloads.InviteJoinConfirmed.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.PartyLeft.ID, PartyInvitePayloads.PartyLeft.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.PartyKicked.ID, PartyInvitePayloads.PartyKicked.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyHudPayloads.PartyRosterClear.ID, PartyHudPayloads.PartyRosterClear.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyHudPayloads.PartyRosterAdd.ID, PartyHudPayloads.PartyRosterAdd.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyHudPayloads.PartyMemberVitals.ID, PartyHudPayloads.PartyMemberVitals.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyHudPayloads.PartyRosterReset.ID, PartyHudPayloads.PartyRosterReset.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyHudPayloads.PartyMemberLevel.ID, PartyHudPayloads.PartyMemberLevel.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyHudPayloads.PartyMemberOnline.ID, PartyHudPayloads.PartyMemberOnline.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyJoinRequestPayloads.JoinReqAdded.ID, PartyJoinRequestPayloads.JoinReqAdded.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyJoinRequestPayloads.JoinReqRemoved.ID, PartyJoinRequestPayloads.JoinReqRemoved.CODEC);
        PayloadTypeRegistry.playC2S().register(PartyJoinRequestPayloads.JoinReqRespond.ID, PartyJoinRequestPayloads.JoinReqRespond.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyJoinRequestPayloads.JoinAccepted.ID, PartyJoinRequestPayloads.JoinAccepted.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyJoinRequestPayloads.JoinDeclined.ID, PartyJoinRequestPayloads.JoinDeclined.CODEC);
        PayloadTypeRegistry.playC2S().register(PartyChatPayloads.ChatSend.ID, PartyChatPayloads.ChatSend.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyChatPayloads.ChatMessage.ID, PartyChatPayloads.ChatMessage.CODEC);
        PayloadTypeRegistry.playC2S().register(PartySettingsPayloads.SetAllowHelpfulNonMembers.ID, PartySettingsPayloads.SetAllowHelpfulNonMembers.CODEC);
        PayloadTypeRegistry.playC2S().register(PartySettingsPayloads.SetIgnorePartyCollision.ID, PartySettingsPayloads.SetIgnorePartyCollision.CODEC);
        PayloadTypeRegistry.playS2C().register(PartySettingsPayloads.Sync.ID, PartySettingsPayloads.Sync.CODEC);
        PayloadTypeRegistry.playC2S().register(PartyInvitePayloads.EligibleInviteesRequest.ID, PartyInvitePayloads.EligibleInviteesRequest.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyInvitePayloads.EligibleInviteesResponse.ID, PartyInvitePayloads.EligibleInviteesResponse.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyStatusEffectsPayloads.MemberEffects.ID, PartyStatusEffectsPayloads.MemberEffects.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyChatPayloads.ChatNotice.ID, PartyChatPayloads.ChatNotice.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyChatPayloads.ChatPinSet.ID, PartyChatPayloads.ChatPinSet.CODEC);
        PayloadTypeRegistry.playS2C().register(PartyChatPayloads.ChatPinClear.ID, PartyChatPayloads.ChatPinClear.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PartyInvitePayloads.EligibleInviteesRequest.ID, (payload, ctx) -> {
            class_3222 who = ctx.player();
            MinecraftServer server = who.method_5682();
            PartyPersistentState state = PartyPersistentState.get(server);
            ArrayList<UUID> uuids = new ArrayList<UUID>();
            ArrayList<String> names = new ArrayList<String>();
            for (class_3222 sp : server.method_3760().method_14571()) {
                if (sp.method_5667().equals(who.method_5667()) || state.getPartyByMember(sp.method_5667()) != null) continue;
                uuids.add(sp.method_5667());
                names.add(sp.method_7334().getName());
            }
            ServerPlayNetworking.send((class_3222)who, (class_8710)new PartyInvitePayloads.EligibleInviteesResponse(uuids, names));
        });
        ServerPlayNetworking.registerGlobalReceiver(PartySettingsPayloads.SetIgnorePartyCollision.ID, (payload, ctx) -> {
            class_3222 player = ctx.player();
            MinecraftServer server = player.method_5682();
            PartyPersistentState state = PartyPersistentState.get(server);
            Party p = state.getPartyByMember(player.method_5667());
            if (p == null) {
                return;
            }
            long now = System.currentTimeMillis();
            if (!p.leader.equals(player.method_5667())) {
                String leaderName = state.nameOf(p.leader);
                if (leaderName == null) {
                    class_3222 l = server.method_3760().method_14602(p.leader);
                    leaderName = l != null ? l.method_5477().getString() : p.leader.toString().substring(0, 8);
                }
                ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyChatPayloads.ChatNotice(p.id, "Only " + leaderName + " can change party settings.", now));
                return;
            }
            p.settings.ignorePartyCollision = payload.ignore();
            state.method_80();
            for (UUID u : p.members) {
                class_3222 sp = server.method_3760().method_14602(u);
                if (sp == null) continue;
                ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartySettingsPayloads.Sync(p.settings.allowHelpfulNonMembers, p.settings.ignorePartyCollision));
                ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartyChatPayloads.ChatNotice(p.id, "Ignore party collision: " + (p.settings.ignorePartyCollision ? "ON" : "OFF"), now));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PartySettingsPayloads.SetAllowHelpfulNonMembers.ID, (payload, ctx) -> {
            class_3222 player = ctx.player();
            MinecraftServer server = player.method_5682();
            PartyPersistentState state = PartyPersistentState.get(server);
            Party p = state.getPartyByMember(player.method_5667());
            if (p == null) {
                return;
            }
            long now = System.currentTimeMillis();
            if (!p.leader.equals(player.method_5667())) {
                String leaderName = state.nameOf(p.leader);
                if (leaderName == null) {
                    class_3222 l = server.method_3760().method_14602(p.leader);
                    leaderName = l != null ? l.method_5477().getString() : p.leader.toString().substring(0, 8);
                }
                ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyChatPayloads.ChatNotice(p.id, "Only " + leaderName + " can change party settings.", now));
                return;
            }
            p.settings.allowHelpfulNonMembers = payload.allow();
            state.method_80();
            for (UUID u : p.members) {
                class_3222 sp = server.method_3760().method_14602(u);
                if (sp == null) continue;
                ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartySettingsPayloads.Sync(p.settings.allowHelpfulNonMembers, p.settings.ignorePartyCollision));
                ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartyChatPayloads.ChatNotice(p.id, "Heal/Buff non-members: " + (p.settings.allowHelpfulNonMembers ? "ON" : "OFF"), now));
            }
        });
        AttackEntityCallback.EVENT.register((player, world, hand, target, hit) -> {
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            MinecraftServer server = world.method_8503();
            if (server == null) {
                return class_1269.field_5811;
            }
            UUID a = PartyAllies.owningPlayerUuid((class_1297)player);
            UUID b = PartyAllies.owningPlayerUuid(target);
            if (a != null && b != null && PartyAllies.sameParty(server, a, b)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            PartyPersistentState state = PartyPersistentState.get(server);
            state.rememberName(handler.field_14140.method_5667(), handler.field_14140.method_5477().getString());
            Party p = state.getPartyByMember(handler.field_14140.method_5667());
            if (p != null) {
                PartyNet.sendRosterTo(server, handler.field_14140, p);
                for (UUID u : p.members) {
                    class_3222 sp;
                    if (u.equals(handler.field_14140.method_5667()) || (sp = server.method_3760().method_14602(u)) == null) continue;
                    ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartyHudPayloads.PartyMemberOnline(handler.field_14140.method_5667(), true));
                }
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 self;
            PartyPersistentState state = PartyPersistentState.get(server);
            Party p = state.getPartyByMember((self = handler.field_14140).method_5667());
            if (p == null) {
                return;
            }
            state.rememberName(self.method_5667(), self.method_5477().getString());
            if (PERSIST_PARTIES_ON_DISCONNECT) {
                for (UUID u2 : p.members) {
                    class_3222 sp;
                    if (u2.equals(self.method_5667()) || (sp = server.method_3760().method_14602(u2)) == null) continue;
                    ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartyHudPayloads.PartyMemberOnline(self.method_5667(), false));
                }
                return;
            }
            boolean isLeader = p.leader.equals(self.method_5667());
            HashSet<UUID> members = new HashSet<UUID>(p.members);
            boolean ok = state.leave(self.method_5667());
            if (!ok) {
                return;
            }
            if (isLeader) {
                for (UUID u3 : members) {
                    class_3222 sp;
                    if (u3.equals(self.method_5667()) || (sp = server.method_3760().method_14602(u3)) == null) continue;
                    ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartyHudPayloads.PartyRosterReset());
                    sp.method_43496((class_2561)class_2561.method_43470((String)"Your party disbanded (leader left)."));
                }
            } else {
                UUID anyRemaining = members.stream().filter(u -> !u.equals(self.method_5667())).findFirst().orElse(null);
                Party remaining = state.getPartyByMember(anyRemaining);
                if (remaining != null) {
                    String name = self.method_5477().getString();
                    for (UUID u4 : remaining.members) {
                        class_3222 sp = server.method_3760().method_14602(u4);
                        if (sp == null) continue;
                        sp.method_43496((class_2561)class_2561.method_43470((String)(name + " left the party")));
                    }
                    PartyNet.broadcastRoster(server, remaining);
                }
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (++tickCounter % 10 == 0) {
                PartyNet.pushAllPartyVitals(server);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PartyInvitePayloads.InviteRespond.ID, (payload, context) -> {
            String partyName;
            class_3222 player = context.player();
            PartyPersistentState state = PartyPersistentState.get(player.method_5682());
            Party party = state.getParty(payload.partyId());
            String string = partyName = party == null || party.name.isEmpty() ? String.valueOf(payload.partyId()) : party.name;
            if (payload.accept()) {
                HashSet<UUID> invitesBefore = new HashSet<UUID>(state.invitesOf(player.method_5667()));
                Set<UUID> joinReqParties = state.partiesWithJoinRequestFrom(player.method_5667());
                boolean ok = state.accept(player.method_5667(), payload.partyId());
                if (ok) {
                    Party p2;
                    state.rememberName(player.method_5667(), player.method_5477().getString());
                    class_3222 leader = player.method_5682().method_3760().method_14602(party.leader);
                    if (leader != null) {
                        ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyInvitePayloads.InviteAccepted(player.method_5477().getString(), partyName));
                    }
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyInvitePayloads.InviteJoinConfirmed(partyName));
                    for (UUID pid : invitesBefore) {
                        class_3222 otherLeader;
                        if (pid.equals(payload.partyId()) || (p2 = state.getParty(pid)) == null || (otherLeader = player.method_5682().method_3760().method_14602(p2.leader)) == null) continue;
                        String otherPartyName = p2.name == null || p2.name.isEmpty() ? p2.id.toString() : p2.name;
                        ServerPlayNetworking.send((class_3222)otherLeader, (class_8710)new PartyInvitePayloads.InviteDeclined(player.method_5477().getString(), otherPartyName));
                    }
                    for (UUID pid : invitesBefore) {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyInvitePayloads.InviteRemoved(pid));
                    }
                    for (UUID pid : joinReqParties) {
                        class_3222 leader2;
                        p2 = state.getParty(pid);
                        if (p2 == null || (leader2 = player.method_5682().method_3760().method_14602(p2.leader)) == null) continue;
                        ServerPlayNetworking.send((class_3222)leader2, (class_8710)new PartyJoinRequestPayloads.JoinReqRemoved(pid, player.method_5667()));
                    }
                    player.method_43496((class_2561)class_2561.method_43470((String)("Joined party " + partyName)));
                    Party updated = state.getParty(payload.partyId());
                    if (updated != null) {
                        PartyNet.broadcastRoster(player.method_5682(), updated);
                        long now = System.currentTimeMillis();
                        String joinerName = player.method_5477().getString();
                        PartyChatPayloads.ChatNotice notice = new PartyChatPayloads.ChatNotice(updated.id, joinerName + " joined the party.", now);
                        for (UUID u : updated.members) {
                            class_3222 sp = player.method_5682().method_3760().method_14602(u);
                            if (sp == null) continue;
                            ServerPlayNetworking.send((class_3222)sp, (class_8710)notice);
                        }
                    }
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Accept failed"));
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyInvitePayloads.InviteRemoved(payload.partyId()));
                }
            } else {
                class_3222 leader;
                HashSet<UUID> set = new HashSet<UUID>(state.invitesOf(player.method_5667()));
                if (set.contains(payload.partyId())) {
                    state.removeInvite(player.method_5667(), payload.partyId());
                }
                if (party != null && (leader = player.method_5682().method_3760().method_14602(party.leader)) != null) {
                    ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyInvitePayloads.InviteDeclined(player.method_5477().getString(), partyName));
                }
                ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyInvitePayloads.InviteRemoved(payload.partyId()));
                player.method_43496((class_2561)class_2561.method_43470((String)("Declined invite to " + partyName)));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PartyJoinRequestPayloads.JoinReqRespond.ID, (payload, context) -> {
            class_3222 leader = context.player();
            PartyPersistentState state = PartyPersistentState.get(leader.method_5682());
            Party p = state.getParty(payload.partyId());
            if (p == null || !p.leader.equals(leader.method_5667())) {
                return;
            }
            if (payload.accept()) {
                boolean ok = state.acceptJoin(leader.method_5667(), payload.requesterUuid());
                if (!ok) {
                    return;
                }
                ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyJoinRequestPayloads.JoinReqRemoved(p.id, payload.requesterUuid()));
                String partyName = p.name == null || p.name.isEmpty() ? p.id.toString() : p.name;
                String leaderName = leader.method_5477().getString();
                class_3222 req = leader.method_5682().method_3760().method_14602(payload.requesterUuid());
                if (req != null) {
                    ServerPlayNetworking.send((class_3222)req, (class_8710)new PartyJoinRequestPayloads.JoinAccepted(leaderName, partyName));
                }
                Party updated = state.getParty(p.id);
                PartyNet.broadcastRoster(leader.method_5682(), updated);
                long now = System.currentTimeMillis();
                String joinerName = "A player";
                req = leader.method_5682().method_3760().method_14602(payload.requesterUuid());
                if (req != null) {
                    joinerName = req.method_5477().getString();
                }
                PartyChatPayloads.ChatNotice notice = new PartyChatPayloads.ChatNotice(updated.id, joinerName + " joined the party.", now);
                for (UUID u : updated.members) {
                    class_3222 sp = leader.method_5682().method_3760().method_14602(u);
                    if (sp == null) continue;
                    ServerPlayNetworking.send((class_3222)sp, (class_8710)notice);
                }
            } else {
                boolean ok = state.declineJoin(leader.method_5667(), payload.requesterUuid());
                if (!ok) {
                    return;
                }
                ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyJoinRequestPayloads.JoinReqRemoved(p.id, payload.requesterUuid()));
                class_3222 req = leader.method_5682().method_3760().method_14602(payload.requesterUuid());
                if (req != null) {
                    String partyName = p.name == null || p.name.isEmpty() ? p.id.toString() : p.name;
                    String leaderName = leader.method_5477().getString();
                    ServerPlayNetworking.send((class_3222)req, (class_8710)new PartyJoinRequestPayloads.JoinDeclined(leaderName, partyName));
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PartyChatPayloads.ChatSend.ID, (payload, context) -> {
            String raw;
            class_3222 sender = context.player();
            PartyPersistentState state = PartyPersistentState.get(sender.method_5682());
            Party p = state.getPartyByMember(sender.method_5667());
            if (p == null) {
                return;
            }
            if (!p.id.equals(payload.partyId())) {
                return;
            }
            String name = sender.method_5477().getString();
            long now = System.currentTimeMillis();
            String string = raw = payload.message() == null ? "" : payload.message().trim();
            if (raw.startsWith("/p")) {
                String sub;
                String[] parts = raw.split("\\s+", 3);
                switch (sub = parts.length >= 2 ? parts[1].toLowerCase(Locale.ROOT) : "help") {
                    case "help": {
                        String help = "Middle click member to pin members!\nClick on the crown to change party leaders!\nCheck the gear icon for settings!\nParty Chat commands:\n/p help \u2014 show this list\n/p info \u2014 party name, leader, members\n/p sharepos \u2014 share your current coords\n/p promote <member> \u2014 transfer leadership\n/p pin <text> \u2014 set a pinned banner\n/p unpin - unpins a pinned banner\n".trim();
                        PartyNet.sendNoticeTo(sender, p, help, now);
                        break;
                    }
                    case "info": {
                        String leaderName = state.nameOf(p.leader);
                        if (leaderName == null) {
                            class_3222 l = sender.method_5682().method_3760().method_14602(p.leader);
                            leaderName = l != null ? l.method_5477().getString() : PartyNet.shortId(p.leader);
                        }
                        int online = 0;
                        for (UUID u : p.members) {
                            if (sender.method_5682().method_3760().method_14602(u) == null) continue;
                            ++online;
                        }
                        String info = "Party: " + PartyNet.displayName(p) + " | Leader: " + leaderName + " | Members: " + p.members.size() + " (" + online + " online)";
                        PartyNet.sendNoticeTo(sender, p, info, now);
                        break;
                    }
                    case "sharepos": {
                        class_2338 pos = sender.method_24515();
                        String dim = sender.method_37908().method_27983().method_29177().toString();
                        String txt = name + " @ " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + " [" + dim + "]";
                        PartyNet.broadcastNotice(sender.method_5682(), p, txt, now);
                        break;
                    }
                    case "promote": {
                        if (!p.leader.equals(sender.method_5667())) {
                            PartyNet.sendNoticeTo(sender, p, "Only the party leader can promote.", now);
                            return;
                        }
                        if (parts.length < 3 || parts[2].isBlank()) {
                            PartyNet.sendNoticeTo(sender, p, "Usage: /p promote <member>", now);
                            return;
                        }
                        UUID targetUuid = PartyNet.resolveMemberFromInput(sender.method_5682(), state, p, parts[2]);
                        if (targetUuid == null || targetUuid.equals(sender.method_5667())) {
                            PartyNet.sendNoticeTo(sender, p, "Couldn't resolve a unique member for \"" + parts[2] + "\".", now);
                            return;
                        }
                        p.leader = targetUuid;
                        state.method_80();
                        String targetName = state.nameOf(targetUuid);
                        if (targetName == null) {
                            class_3222 sp = sender.method_5682().method_3760().method_14602(targetUuid);
                            targetName = sp != null ? sp.method_5477().getString() : PartyNet.shortId(targetUuid);
                        }
                        String txt = "Leadership transferred to " + targetName + ".";
                        PartyNet.broadcastNotice(sender.method_5682(), p, txt, now);
                        for (UUID u : p.members) {
                            class_3222 sp = sender.method_5682().method_3760().method_14602(u);
                            if (sp == null) continue;
                            sp.method_43496((class_2561)class_2561.method_43470((String)("[Party] " + txt)));
                        }
                        PartyNet.broadcastRoster(sender.method_5682(), p);
                        break;
                    }
                    case "pin": {
                        if (!p.leader.equals(sender.method_5667())) {
                            PartyNet.sendNoticeTo(sender, p, "Only the party leader can pin.", now);
                            return;
                        }
                        if (parts.length < 3 || parts[2].isBlank()) {
                            PartyNet.sendNoticeTo(sender, p, "Usage: /p pin <text>", now);
                            return;
                        }
                        PartyChatPayloads.ChatPinSet pin = new PartyChatPayloads.ChatPinSet(p.id, parts[2], now);
                        for (UUID u : p.members) {
                            class_3222 sp = sender.method_5682().method_3760().method_14602(u);
                            if (sp == null) continue;
                            ServerPlayNetworking.send((class_3222)sp, (class_8710)pin);
                        }
                        break;
                    }
                    case "unpin": {
                        if (!p.leader.equals(sender.method_5667())) {
                            PartyNet.sendNoticeTo(sender, p, "Only the party leader can unpin.", now);
                            return;
                        }
                        PartyChatPayloads.ChatPinClear clear = new PartyChatPayloads.ChatPinClear(p.id);
                        for (UUID u : p.members) {
                            class_3222 sp = sender.method_5682().method_3760().method_14602(u);
                            if (sp == null) continue;
                            ServerPlayNetworking.send((class_3222)sp, (class_8710)clear);
                        }
                        PartyNet.sendNoticeTo(sender, p, "Pinned banner cleared.", now);
                        break;
                    }
                    default: {
                        PartyNet.sendNoticeTo(sender, p, "Unknown subcommand. Try /p help", now);
                    }
                }
                return;
            }
            PartyChatPayloads.ChatMessage msg = new PartyChatPayloads.ChatMessage(p.id, sender.method_5667(), name, payload.message(), now);
            if (RPGSystemsConfig.get().party.logChatToConsole) {
                String partyName = p.name != null && !p.name.isBlank() ? p.name : p.id.toString();
                RPGSystems.LOGGER.info("{}: {} > {}", new Object[]{name, partyName, payload.message()});
            }
            PartyChatEvent.fire(new PartyChatEvent.Message(p.id, sender, payload.message()));
            for (UUID u : p.members) {
                class_3222 sp = sender.method_5682().method_3760().method_14602(u);
                if (sp == null) continue;
                ServerPlayNetworking.send((class_3222)sp, (class_8710)msg);
            }
        });
    }

    private static void pushAllPartyVitals(MinecraftServer server) {
        PartyPersistentState state = PartyPersistentState.get(server);
        for (class_3222 viewer : server.method_3760().method_14571()) {
            Party p = state.getPartyByMember(viewer.method_5667());
            if (p == null) continue;
            for (UUID memberId : p.members) {
                class_3222 subject = server.method_3760().method_14602(memberId);
                if (subject == null) {
                    ServerPlayNetworking.send((class_3222)viewer, (class_8710)new PartyStatusEffectsPayloads.MemberEffects(memberId, List.of()));
                    continue;
                }
                float hp = subject.method_6032();
                float max = subject.method_6063();
                int hunger = subject.method_7344().method_7586();
                float absorption = subject.method_6067();
                float staminaNow = -1.0f;
                float staminaMax = -1.0f;
                float manaNow = -1.0f;
                float manaMax = -1.0f;
                float rpgNow = -1.0f;
                float rpgMax = -1.0f;
                try {
                    float[] st = TrbAttributesCompat.readStamina((class_1657)subject);
                    staminaNow = st[0];
                    staminaMax = st[1];
                }
                catch (Throwable st) {
                    // empty catch block
                }
                try {
                    float[] ma = TrbAttributesCompat.readMana((class_1657)subject);
                    manaNow = ma[0];
                    manaMax = ma[1];
                }
                catch (Throwable ma) {
                    // empty catch block
                }
                try {
                    float[] rm = RpgManaCompat.readMana((class_1657)subject);
                    rpgNow = rm[0];
                    rpgMax = rm[1];
                }
                catch (Throwable rm) {
                    // empty catch block
                }
                ServerPlayNetworking.send((class_3222)viewer, (class_8710)new PartyHudPayloads.PartyMemberVitals(memberId, hp, max, hunger, absorption, staminaNow, staminaMax, manaNow, manaMax, rpgNow, rpgMax));
                int lvl = PartyNet.computeTotalSkillsLevel(subject);
                if (lvl >= 0) {
                    ServerPlayNetworking.send((class_3222)viewer, (class_8710)new PartyHudPayloads.PartyMemberLevel(memberId, lvl));
                }
                List<String> effIds = PartyStatusEffectsSync.snapshotEffectIds(subject);
                ServerPlayNetworking.send((class_3222)viewer, (class_8710)new PartyStatusEffectsPayloads.MemberEffects(memberId, effIds));
            }
        }
    }

    public static void broadcastNotice(MinecraftServer server, Party p, String text, long when) {
        PartyChatPayloads.ChatNotice pay = new PartyChatPayloads.ChatNotice(p.id, text, when);
        for (UUID u : p.members) {
            class_3222 sp = server.method_3760().method_14602(u);
            if (sp == null) continue;
            ServerPlayNetworking.send((class_3222)sp, (class_8710)pay);
        }
    }

    private static String shortId(UUID id) {
        return id.toString().substring(0, 8);
    }

    private static UUID resolveMemberFromInput(MinecraftServer server, PartyPersistentState state, Party p, String input) {
        if (input == null || input.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(input.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String qi = input.trim();
            String qiLower = qi.toLowerCase(Locale.ROOT);
            UUID match = null;
            int matches = 0;
            for (UUID u : p.members) {
                String name = state.nameOf(u);
                if (name == null) {
                    class_3222 sp = server.method_3760().method_14602(u);
                    name = sp != null ? sp.method_5477().getString() : PartyNet.shortId(u);
                }
                String label1 = name;
                String label2 = name + " #" + PartyNet.shortId(u);
                if (label1.equalsIgnoreCase(qi) || label2.equalsIgnoreCase(qi)) {
                    match = u;
                    ++matches;
                    continue;
                }
                if (label1.toLowerCase(Locale.ROOT).contains(qiLower) || label2.toLowerCase(Locale.ROOT).contains(qiLower)) {
                    match = u;
                    ++matches;
                }
                if (!PartyNet.shortId(u).equalsIgnoreCase(qi)) continue;
                match = u;
                ++matches;
            }
            return matches == 1 ? match : null;
        }
    }

    private static String displayName(Party p) {
        return p.name == null || p.name.isBlank() ? p.id.toString() : p.name;
    }

    private static void sendNoticeTo(class_3222 to, Party p, String text, long when) {
        ServerPlayNetworking.send((class_3222)to, (class_8710)new PartyChatPayloads.ChatNotice(p.id, text, when));
    }

    public static void broadcastRoster(MinecraftServer server, Party party) {
        String partyName = party.name == null || party.name.isEmpty() ? party.id.toString() : party.name;
        for (UUID u : party.members) {
            class_3222 sp = server.method_3760().method_14602(u);
            if (sp == null) continue;
            PartyNet.sendRosterTo(server, sp, partyName, party);
        }
    }

    public static void sendRosterTo(MinecraftServer server, class_3222 recipient, Party party) {
        String partyName = party.name == null || party.name.isEmpty() ? party.id.toString() : party.name;
        PartyNet.sendRosterTo(server, recipient, partyName, party);
    }

    private static void sendRosterTo(MinecraftServer server, class_3222 recipient, String partyName, Party party) {
        PartyPersistentState state = PartyPersistentState.get(server);
        ServerPlayNetworking.send((class_3222)recipient, (class_8710)new PartyHudPayloads.PartyRosterClear(party.id, partyName, party.leader));
        for (UUID memberId : party.members) {
            String name = PartyNet.getName(server, state, memberId);
            ServerPlayNetworking.send((class_3222)recipient, (class_8710)new PartyHudPayloads.PartyRosterAdd(party.id, memberId, name));
            class_3222 subject = server.method_3760().method_14602(memberId);
            boolean isOnline = subject != null;
            ServerPlayNetworking.send((class_3222)recipient, (class_8710)new PartyHudPayloads.PartyMemberOnline(memberId, isOnline));
            ServerPlayNetworking.send((class_3222)recipient, (class_8710)new PartySettingsPayloads.Sync(party.settings.allowHelpfulNonMembers, party.settings.ignorePartyCollision));
            if (subject != null) {
                int lvl = PartyNet.computeTotalSkillsLevel(subject);
                if (lvl >= 0) {
                    ServerPlayNetworking.send((class_3222)recipient, (class_8710)new PartyHudPayloads.PartyMemberLevel(memberId, lvl));
                }
                List<String> effIds = PartyStatusEffectsSync.snapshotEffectIds(subject);
                ServerPlayNetworking.send((class_3222)recipient, (class_8710)new PartyStatusEffectsPayloads.MemberEffects(memberId, effIds));
                continue;
            }
            ServerPlayNetworking.send((class_3222)recipient, (class_8710)new PartyStatusEffectsPayloads.MemberEffects(memberId, List.of()));
        }
    }

    public static void sendRosterWipeTo(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyHudPayloads.PartyRosterReset());
    }

    private static String getName(MinecraftServer server, PartyPersistentState state, UUID u) {
        class_3222 sp = server.method_3760().method_14602(u);
        if (sp != null) {
            String n = sp.method_5477().getString();
            state.rememberName(u, n);
            return n;
        }
        String cached = state.nameOf(u);
        return cached != null ? cached : u.toString();
    }

    public static void sendJoinReqAdded(class_3222 leader, UUID partyId, UUID requester, String requesterName) {
        ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyJoinRequestPayloads.JoinReqAdded(partyId, requester, requesterName));
    }

    public static void sendJoinReqRemoved(class_3222 leader, UUID partyId, UUID requester) {
        ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyJoinRequestPayloads.JoinReqRemoved(partyId, requester));
    }

    private static boolean puffishLoaded() {
        return FabricLoader.getInstance().isModLoaded("puffish_skills");
    }

    private static int computeTotalSkillsLevel(class_3222 player) {
        if (!PartyNet.puffishLoaded()) {
            return -1;
        }
        try {
            SkillsMod skillsMod = SkillsMod.getInstance();
            if (skillsMod == null) {
                return -1;
            }
            Collection cats = skillsMod.getUnlockedCategories(player);
            int total = 0;
            for (class_2960 id : cats) {
                Optional lvlOpt = skillsMod.getCurrentLevel(player, id);
                total += lvlOpt.orElse(0).intValue();
            }
            return total;
        }
        catch (Throwable t) {
            return -1;
        }
    }
}

