/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.party;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.network.PartyNet;
import net.pixeldreamstudios.rpgsystems.network.party.PartyHudPayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartyInvitePayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartyJoinRequestPayloads;
import net.pixeldreamstudios.rpgsystems.party.Party;
import net.pixeldreamstudios.rpgsystems.party.PartyPersistentState;

public final class PartyCommands {
    private PartyCommands() {
    }

    public static void register(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"party").requires(src -> src.method_9259(0))).then(class_2170.method_9247((String)"create").executes(ctx -> PartyCommands.create((CommandContext<class_2168>)ctx, "")))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> PartyCommands.create((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> PartyCommands.rename((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"promote").then(class_2170.method_9244((String)"member", (ArgumentType)StringArgumentType.greedyString()).suggests(PartyCommands::suggestPartyMembers).executes(ctx -> PartyCommands.promoteByLabel((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"member")))))).then(class_2170.method_9247((String)"invite").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> PartyCommands.invite((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)"accept").then(class_2170.method_9244((String)"party", (ArgumentType)StringArgumentType.greedyString()).suggests(PartyCommands::suggestInvitedParties).executes(ctx -> PartyCommands.acceptByName((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"party")))))).then(class_2170.method_9247((String)"decline").then(class_2170.method_9244((String)"party", (ArgumentType)StringArgumentType.greedyString()).suggests(PartyCommands::suggestInvitedParties).executes(ctx -> PartyCommands.declineByName((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"party")))))).then(class_2170.method_9247((String)"leave").executes(PartyCommands::leave))).then(class_2170.method_9247((String)"disband").executes(PartyCommands::disband))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"request").then(class_2170.method_9244((String)"party", (ArgumentType)StringArgumentType.greedyString()).suggests(PartyCommands::suggestParties).executes(ctx -> PartyCommands.requestJoinByName((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"party"))))).then(class_2170.method_9244((String)"partyId", (ArgumentType)class_5242.method_27643()).executes(ctx -> PartyCommands.requestJoin((CommandContext<class_2168>)ctx, class_5242.method_27645((CommandContext)ctx, (String)"partyId"))))).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> PartyCommands.requestJoinByPlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"requests").then(class_2170.method_9247((String)"accept").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> PartyCommands.acceptJoin((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)"decline").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> PartyCommands.declineJoin((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))))))).then(class_2170.method_9247((String)"kick").then(class_2170.method_9244((String)"member", (ArgumentType)StringArgumentType.greedyString()).suggests(PartyCommands::suggestPartyMembers).executes(ctx -> PartyCommands.kickByLabel((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"member"))))));
    }

    private static int promoteByLabel(CommandContext<class_2168> ctx, String label) {
        class_3222 leader = ((class_2168)ctx.getSource()).method_44023();
        if (leader == null) {
            return 0;
        }
        MinecraftServer server = leader.method_5682();
        PartyPersistentState state = PartyPersistentState.get(server);
        Party p = state.getPartyByMember(leader.method_5667());
        if (p == null) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"You are not in a party."));
            return 0;
        }
        if (!p.leader.equals(leader.method_5667())) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"Only the party leader can promote."));
            return 0;
        }
        UUID targetUuid = PartyCommands.resolveMemberFromInput(server, state, p, label);
        if (targetUuid == null || targetUuid.equals(leader.method_5667())) {
            leader.method_43496((class_2561)class_2561.method_43470((String)("Couldn\u2019t resolve a unique member for \"" + label + "\".")));
            return 0;
        }
        String targetName = state.nameOf(targetUuid);
        if (targetName == null) {
            class_3222 sp = server.method_3760().method_14602(targetUuid);
            targetName = sp != null ? sp.method_5477().getString() : PartyCommands.shortId(targetUuid);
        }
        p.leader = targetUuid;
        state.method_80();
        String txt = "Leadership transferred to " + targetName + ".";
        long now = System.currentTimeMillis();
        for (UUID u : p.members) {
            class_3222 sp = server.method_3760().method_14602(u);
            if (sp == null) continue;
            sp.method_43496((class_2561)class_2561.method_43470((String)txt));
        }
        PartyNet.broadcastNotice(server, p, txt, now);
        PartyNet.broadcastRoster(server, p);
        leader.method_43496((class_2561)class_2561.method_43470((String)("Promoted " + targetName + " to leader.")));
        return 1;
    }

    private static int kickByLabel(CommandContext<class_2168> ctx, String label) {
        class_3222 leader = ((class_2168)ctx.getSource()).method_44023();
        if (leader == null) {
            return 0;
        }
        MinecraftServer server = leader.method_5682();
        PartyPersistentState state = PartyPersistentState.get(server);
        Party p = state.getPartyByMember(leader.method_5667());
        if (p == null) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"You are not in a party."));
            return 0;
        }
        if (!p.leader.equals(leader.method_5667())) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"Only the party leader can kick members."));
            return 0;
        }
        UUID targetUuid = PartyCommands.resolveMemberFromInput(server, state, p, label);
        if (targetUuid == null || targetUuid.equals(leader.method_5667())) {
            leader.method_43496((class_2561)class_2561.method_43470((String)("Couldn\u2019t resolve a unique member for \"" + label + "\".")));
            return 0;
        }
        String targetName = state.nameOf(targetUuid);
        if (targetName == null) {
            class_3222 sp = server.method_3760().method_14602(targetUuid);
            String string = targetName = sp != null ? sp.method_5477().getString() : PartyCommands.shortId(targetUuid);
        }
        if (!state.kick(leader.method_5667(), targetUuid)) {
            leader.method_43496((class_2561)class_2561.method_43470((String)(targetName + " is not in your party.")));
            return 0;
        }
        class_3222 targetOnline = server.method_3760().method_14602(targetUuid);
        if (targetOnline != null) {
            PartyNet.sendRosterWipeTo(targetOnline);
            targetOnline.method_43496((class_2561)class_2561.method_43470((String)("You were kicked from " + PartyCommands.displayName(p) + ".")));
            ServerPlayNetworking.send((class_3222)targetOnline, (class_8710)new PartyInvitePayloads.PartyKicked(PartyCommands.displayName(p)));
        }
        String notice = targetName + " was kicked from the party.";
        long now = System.currentTimeMillis();
        for (UUID u : p.members) {
            class_3222 sp = server.method_3760().method_14602(u);
            if (sp == null) continue;
            sp.method_43496((class_2561)class_2561.method_43470((String)notice));
        }
        PartyNet.broadcastNotice(server, p, notice, now);
        PartyNet.broadcastRoster(server, p);
        leader.method_43496((class_2561)class_2561.method_43470((String)("Kicked " + targetName + ".")));
        return 1;
    }

    private static int create(CommandContext<class_2168> ctx, String name) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        Party p = state.getPartyByMember(self.method_5667());
        if (p != null) {
            self.method_43496((class_2561)class_2561.method_43470((String)"You are already in a party."));
            return 1;
        }
        String finalName = name == null || name.isBlank() ? PartyCommands.defaultPartyName(self) : name;
        Party created = state.createParty(self.method_5667(), finalName);
        self.method_43496((class_2561)class_2561.method_43470((String)("Party created: " + PartyCommands.displayName(created))));
        PartyNet.sendRosterTo(self.method_5682(), self, created);
        return 1;
    }

    private static int rename(CommandContext<class_2168> ctx, String newName) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        Party p = state.getPartyByMember(self.method_5667());
        if (p == null || !p.leader.equals(self.method_5667())) {
            self.method_43496((class_2561)class_2561.method_43470((String)"You must be the party leader to rename."));
            return 0;
        }
        String desired = newName == null ? "" : newName.trim();
        for (Party other : state.allParties()) {
            String on;
            if (other.id.equals(p.id) || (on = other.name == null ? "" : other.name.trim()).isEmpty() || !on.equalsIgnoreCase(desired)) continue;
            self.method_43496((class_2561)class_2561.method_43470((String)"That party name is already in use."));
            return 0;
        }
        boolean ok = state.renameParty(self.method_5667(), desired);
        if (!ok) {
            self.method_43496((class_2561)class_2561.method_43470((String)"You must be the party leader to rename."));
            return 0;
        }
        PartyNet.broadcastRoster(self.method_5682(), state.getPartyByMember(self.method_5667()));
        self.method_43496((class_2561)class_2561.method_43470((String)("Renamed party to " + desired + ".")));
        return 1;
    }

    private static int invite(CommandContext<class_2168> ctx, class_3222 target) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        if (Objects.equals(self.method_5667(), target.method_5667())) {
            self.method_43496((class_2561)class_2561.method_43470((String)"You cannot invite yourself."));
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        Party p = state.getPartyByMember(self.method_5667());
        if (p == null) {
            p = state.createParty(self.method_5667(), PartyCommands.defaultPartyName(self));
            PartyNet.sendRosterTo(self.method_5682(), self, p);
        }
        if (!p.leader.equals(self.method_5667())) {
            self.method_43496((class_2561)class_2561.method_43470((String)"Only the party leader can invite."));
            return 0;
        }
        boolean ok = state.invite(self.method_5667(), target.method_5667());
        if (!ok) {
            self.method_43496((class_2561)class_2561.method_43470((String)"Unable to send invite."));
            return 0;
        }
        state.rememberName(self.method_5667(), self.method_5477().getString());
        state.rememberName(target.method_5667(), target.method_5477().getString());
        String partyName = PartyCommands.displayName(p);
        ServerPlayNetworking.send((class_3222)target, (class_8710)new PartyInvitePayloads.InviteAdded(p.id, p.leader, self.method_5477().getString(), partyName));
        ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.InviteSent(self.method_5477().getString(), target.method_5477().getString(), partyName));
        self.method_43496((class_2561)class_2561.method_43470((String)("Invited " + target.method_5477().getString() + " to " + partyName + ".")));
        return 1;
    }

    private static int acceptAny(CommandContext<class_2168> ctx) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        Set<UUID> invitesBefore = Set.copyOf(state.invitesOf(self.method_5667()));
        Set<UUID> joinReqParties = state.partiesWithJoinRequestFrom(self.method_5667());
        boolean ok = state.acceptAny(self.method_5667());
        if (!ok) {
            self.method_43496((class_2561)class_2561.method_43470((String)"No valid invites to accept (they may have expired)."));
            ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyHudPayloads.PartyRosterReset());
            return 0;
        }
        Party p = state.getPartyByMember(self.method_5667());
        if (p != null) {
            class_3222 leader = self.method_5682().method_3760().method_14602(p.leader);
            if (leader != null) {
                String partyName = PartyCommands.displayName(p);
                ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyInvitePayloads.InviteAccepted(self.method_5477().getString(), partyName));
            }
            ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.InviteJoinConfirmed(PartyCommands.displayName(p)));
            self.method_43496((class_2561)class_2561.method_43470((String)("Joined " + PartyCommands.displayName(p))));
            for (UUID pid : invitesBefore) {
                ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.InviteRemoved(pid));
            }
            for (UUID pid : joinReqParties) {
                class_3222 leader2;
                Party p2 = state.getParty(pid);
                if (p2 == null || (leader2 = self.method_5682().method_3760().method_14602(p2.leader)) == null) continue;
                ServerPlayNetworking.send((class_3222)leader2, (class_8710)new PartyJoinRequestPayloads.JoinReqRemoved(pid, self.method_5667()));
            }
            PartyNet.broadcastRoster(self.method_5682(), p);
        }
        return 1;
    }

    private static int acceptSpecific(CommandContext<class_2168> ctx, UUID partyId) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        Set<UUID> invitesBefore = Set.copyOf(state.invitesOf(self.method_5667()));
        Set<UUID> joinReqParties = state.partiesWithJoinRequestFrom(self.method_5667());
        boolean ok = state.accept(self.method_5667(), partyId);
        if (!ok) {
            self.method_43496((class_2561)class_2561.method_43470((String)"Invite not found or expired."));
            ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.InviteRemoved(partyId));
            return 0;
        }
        Party p = state.getPartyByMember(self.method_5667());
        if (p != null) {
            class_3222 leader = self.method_5682().method_3760().method_14602(p.leader);
            if (leader != null) {
                String partyName = PartyCommands.displayName(p);
                ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyInvitePayloads.InviteAccepted(self.method_5477().getString(), partyName));
            }
            ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.InviteJoinConfirmed(PartyCommands.displayName(p)));
            self.method_43496((class_2561)class_2561.method_43470((String)("Joined " + PartyCommands.displayName(p))));
            for (UUID pid : invitesBefore) {
                ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.InviteRemoved(pid));
            }
            for (UUID pid : joinReqParties) {
                class_3222 leader2;
                Party p2 = state.getParty(pid);
                if (p2 == null || (leader2 = self.method_5682().method_3760().method_14602(p2.leader)) == null) continue;
                ServerPlayNetworking.send((class_3222)leader2, (class_8710)new PartyJoinRequestPayloads.JoinReqRemoved(pid, self.method_5667()));
            }
            PartyNet.broadcastRoster(self.method_5682(), p);
        }
        return 1;
    }

    private static int declineAny(CommandContext<class_2168> ctx) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        Set<UUID> invites = state.invitesOf(self.method_5667());
        if (invites.isEmpty()) {
            self.method_43496((class_2561)class_2561.method_43470((String)"You have no invites."));
            return 0;
        }
        for (UUID pid : invites) {
            PartyCommands.declineInternal(self, state, pid);
        }
        return 1;
    }

    private static int declineSpecific(CommandContext<class_2168> ctx, UUID partyId) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        if (!state.removeInvite(self.method_5667(), partyId)) {
            self.method_43496((class_2561)class_2561.method_43470((String)"Invite not found or expired."));
            return 0;
        }
        PartyCommands.declineNotify(self, state, partyId);
        return 1;
    }

    private static void declineInternal(class_3222 self, PartyPersistentState state, UUID partyId) {
        if (state.removeInvite(self.method_5667(), partyId)) {
            PartyCommands.declineNotify(self, state, partyId);
        }
    }

    private static void declineNotify(class_3222 self, PartyPersistentState state, UUID partyId) {
        Party p = state.getParty(partyId);
        if (p != null) {
            String partyName = PartyCommands.displayName(p);
            class_3222 leader = self.method_5682().method_3760().method_14602(p.leader);
            if (leader != null) {
                ServerPlayNetworking.send((class_3222)leader, (class_8710)new PartyInvitePayloads.InviteDeclined(self.method_5477().getString(), partyName));
            }
            ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.InviteRemoved(partyId));
            self.method_43496((class_2561)class_2561.method_43470((String)("Declined invite to " + partyName + ".")));
        }
    }

    private static int leave(CommandContext<class_2168> ctx) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        MinecraftServer server = self.method_5682();
        PartyPersistentState state = PartyPersistentState.get(server);
        Party p = state.getPartyByMember(self.method_5667());
        if (p == null) {
            self.method_43496((class_2561)class_2561.method_43470((String)"You are not in a party."));
            return 0;
        }
        String partyName = PartyCommands.displayName(p);
        boolean isLeader = p.leader.equals(self.method_5667());
        Set<UUID> membersSnapshot = Set.copyOf(p.members);
        boolean ok = state.leave(self.method_5667());
        if (!ok) {
            return 0;
        }
        if (isLeader) {
            for (UUID u2 : membersSnapshot) {
                class_3222 sp;
                if (u2.equals(self.method_5667()) || (sp = server.method_3760().method_14602(u2)) == null) continue;
                ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartyHudPayloads.PartyRosterReset());
                sp.method_43496((class_2561)class_2561.method_43470((String)"Your party disbanded (leader left)."));
            }
            self.method_43496((class_2561)class_2561.method_43470((String)"You disbanded the party."));
        } else {
            UUID anyRemaining = membersSnapshot.stream().filter(u -> !u.equals(self.method_5667())).findFirst().orElse(null);
            Party remaining = state.getPartyByMember(anyRemaining);
            if (remaining != null) {
                String name = self.method_5477().getString();
                for (UUID u3 : remaining.members) {
                    class_3222 sp = server.method_3760().method_14602(u3);
                    if (sp == null) continue;
                    sp.method_43496((class_2561)class_2561.method_43470((String)(name + " left the party.")));
                }
                PartyNet.broadcastRoster(server, remaining);
            }
            self.method_43496((class_2561)class_2561.method_43470((String)"You left the party."));
        }
        ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyInvitePayloads.PartyLeft(partyName));
        PartyNet.sendRosterWipeTo(self);
        return 1;
    }

    private static int disband(CommandContext<class_2168> ctx) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        MinecraftServer server = self.method_5682();
        PartyPersistentState state = PartyPersistentState.get(server);
        Party p = state.getPartyByMember(self.method_5667());
        if (p == null) {
            self.method_43496((class_2561)class_2561.method_43470((String)"You are not in a party."));
            return 0;
        }
        if (!p.leader.equals(self.method_5667())) {
            self.method_43496((class_2561)class_2561.method_43470((String)"Only the party leader can disband."));
            return 0;
        }
        Set<UUID> inviteTargets = state.targetsInvitedBy(p.id);
        Set<UUID> reqs = state.joinRequestsOf(p.id);
        Set<UUID> members = Set.copyOf(p.members);
        boolean ok = state.disband(self.method_5667());
        if (!ok) {
            return 0;
        }
        for (UUID t : inviteTargets) {
            class_3222 target = server.method_3760().method_14602(t);
            if (target == null) continue;
            ServerPlayNetworking.send((class_3222)target, (class_8710)new PartyInvitePayloads.InviteRemoved(p.id));
        }
        for (UUID requester : reqs) {
            ServerPlayNetworking.send((class_3222)self, (class_8710)new PartyJoinRequestPayloads.JoinReqRemoved(p.id, requester));
        }
        for (UUID u : members) {
            class_3222 sp = server.method_3760().method_14602(u);
            if (sp == null || u.equals(self.method_5667())) continue;
            ServerPlayNetworking.send((class_3222)sp, (class_8710)new PartyHudPayloads.PartyRosterReset());
            sp.method_43496((class_2561)class_2561.method_43470((String)"Your party disbanded."));
        }
        self.method_43496((class_2561)class_2561.method_43470((String)"Party disbanded."));
        PartyNet.sendRosterWipeTo(self);
        return 1;
    }

    private static int requestJoin(CommandContext<class_2168> ctx, UUID partyId) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        boolean ok = state.requestJoin(self.method_5667(), partyId);
        if (!ok) {
            self.method_43496((class_2561)class_2561.method_43470((String)"Unable to send join request."));
            return 0;
        }
        Party p = state.getParty(partyId);
        if (p == null) {
            return 0;
        }
        class_3222 leader = self.method_5682().method_3760().method_14602(p.leader);
        if (leader != null) {
            PartyNet.sendJoinReqAdded(leader, p.id, self.method_5667(), self.method_5477().getString());
            leader.method_43496((class_2561)class_2561.method_43470((String)(self.method_5477().getString() + " requested to join " + PartyCommands.displayName(p) + ".")));
        }
        self.method_43496((class_2561)class_2561.method_43470((String)"Join request sent."));
        return 1;
    }

    private static int requestJoinByPlayer(CommandContext<class_2168> ctx, class_3222 target) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(self.method_5682());
        Party targetParty = state.getPartyByMember(target.method_5667());
        if (targetParty == null) {
            self.method_43496((class_2561)class_2561.method_43470((String)(target.method_5477().getString() + " is not in a party.")));
            return 0;
        }
        return PartyCommands.requestJoin(ctx, targetParty.id);
    }

    private static int acceptJoin(CommandContext<class_2168> ctx, class_3222 requester) {
        class_3222 leader = ((class_2168)ctx.getSource()).method_44023();
        if (leader == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(leader.method_5682());
        boolean ok = state.acceptJoin(leader.method_5667(), requester.method_5667());
        if (!ok) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"No matching join request."));
            return 0;
        }
        Party p = state.getPartyByMember(leader.method_5667());
        if (p != null) {
            PartyNet.sendJoinReqRemoved(leader, p.id, requester.method_5667());
            class_3222 req = leader.method_5682().method_3760().method_14602(requester.method_5667());
            if (req != null) {
                ServerPlayNetworking.send((class_3222)req, (class_8710)new PartyJoinRequestPayloads.JoinAccepted(leader.method_5477().getString(), PartyCommands.displayName(p)));
                req.method_43496((class_2561)class_2561.method_43470((String)("Your join request was accepted. You joined " + PartyCommands.displayName(p) + ".")));
            }
            PartyNet.broadcastRoster(leader.method_5682(), p);
            leader.method_43496((class_2561)class_2561.method_43470((String)("Accepted join request from " + requester.method_5477().getString() + ".")));
        }
        return 1;
    }

    private static int declineJoin(CommandContext<class_2168> ctx, class_3222 requester) {
        class_3222 leader = ((class_2168)ctx.getSource()).method_44023();
        if (leader == null) {
            return 0;
        }
        PartyPersistentState state = PartyPersistentState.get(leader.method_5682());
        boolean ok = state.declineJoin(leader.method_5667(), requester.method_5667());
        if (!ok) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"No matching join request."));
            return 0;
        }
        Party p = state.getPartyByMember(leader.method_5667());
        if (p != null) {
            PartyNet.sendJoinReqRemoved(leader, p.id, requester.method_5667());
            class_3222 req = leader.method_5682().method_3760().method_14602(requester.method_5667());
            if (req != null) {
                ServerPlayNetworking.send((class_3222)req, (class_8710)new PartyJoinRequestPayloads.JoinDeclined(leader.method_5477().getString(), PartyCommands.displayName(p)));
                req.method_43496((class_2561)class_2561.method_43470((String)"Your join request was declined."));
            }
            leader.method_43496((class_2561)class_2561.method_43470((String)("Declined join request from " + requester.method_5477().getString() + ".")));
        }
        return 1;
    }

    private static int kick(CommandContext<class_2168> ctx, class_3222 target) {
        class_3222 leader = ((class_2168)ctx.getSource()).method_44023();
        if (leader == null) {
            return 0;
        }
        MinecraftServer server = leader.method_5682();
        PartyPersistentState state = PartyPersistentState.get(server);
        Party p = state.getPartyByMember(leader.method_5667());
        if (p == null) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"You are not in a party."));
            return 0;
        }
        if (!p.leader.equals(leader.method_5667())) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"Only the party leader can kick members."));
            return 0;
        }
        if (target.method_5667().equals(leader.method_5667())) {
            leader.method_43496((class_2561)class_2561.method_43470((String)"You cannot kick yourself (use /party leave)."));
            return 0;
        }
        if (!state.kick(leader.method_5667(), target.method_5667())) {
            leader.method_43496((class_2561)class_2561.method_43470((String)(target.method_5477().getString() + " is not in your party.")));
            return 0;
        }
        PartyNet.sendRosterWipeTo(target);
        target.method_43496((class_2561)class_2561.method_43470((String)("You were kicked from " + PartyCommands.displayName(p) + ".")));
        for (UUID u : p.members) {
            class_3222 sp = server.method_3760().method_14602(u);
            if (sp == null) continue;
            sp.method_43496((class_2561)class_2561.method_43470((String)(target.method_5477().getString() + " was kicked from the party.")));
        }
        PartyNet.broadcastRoster(server, p);
        return 1;
    }

    private static String defaultPartyName(class_3222 self) {
        String base = self.method_5477().getString();
        return base.endsWith("s") ? base + "' Party" : base + "'s Party";
    }

    private static String shortId(UUID id) {
        return id.toString().substring(0, 8);
    }

    private static CompletableFuture<Suggestions> suggestParties(CommandContext<class_2168> c, SuggestionsBuilder b) {
        Party sp;
        MinecraftServer server = ((class_2168)c.getSource()).method_9211();
        PartyPersistentState state = PartyPersistentState.get(server);
        class_3222 self = ((class_2168)c.getSource()).method_44023();
        UUID selfPartyId = null;
        if (self != null && (sp = state.getPartyByMember(self.method_5667())) != null) {
            selfPartyId = sp.id;
        }
        LinkedHashSet<Object> labels = new LinkedHashSet<Object>();
        for (Party p : state.allParties()) {
            if (selfPartyId != null && p.id.equals(selfPartyId)) continue;
            String leader = state.nameOf(p.leader);
            if (leader == null) {
                class_3222 sp2 = server.method_3760().method_14602(p.leader);
                leader = sp2 != null ? sp2.method_5477().getString() : PartyCommands.shortId(p.leader);
            }
            String name = PartyCommands.displayName(p);
            labels.add(name);
            labels.add(name + " (" + leader + ")");
            labels.add(name + " #" + PartyCommands.shortId(p.id));
        }
        return class_2172.method_9265(labels, (SuggestionsBuilder)b);
    }

    private static UUID resolvePartyFromInput(MinecraftServer server, PartyPersistentState state, String input) {
        if (input == null || input.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(input.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String qi = input.trim();
            String qiLower = qi.toLowerCase(Locale.ROOT);
            UUID match = null;
            int matches = 0;
            for (Party p : state.allParties()) {
                String name = PartyCommands.displayName(p);
                String leader = state.nameOf(p.leader);
                if (leader == null) {
                    class_3222 sp = server.method_3760().method_14602(p.leader);
                    leader = sp != null ? sp.method_5477().getString() : PartyCommands.shortId(p.leader);
                }
                String labelPlain = name;
                String labelLeader = name + " (" + leader + ")";
                String labelShort = name + " #" + PartyCommands.shortId(p.id);
                if (labelPlain.equalsIgnoreCase(qi) || labelLeader.equalsIgnoreCase(qi) || labelShort.equalsIgnoreCase(qi)) {
                    match = p.id;
                    ++matches;
                    continue;
                }
                if (!labelLeader.toLowerCase(Locale.ROOT).contains(qiLower)) continue;
                match = p.id;
                ++matches;
            }
            return matches == 1 ? match : null;
        }
    }

    private static CompletableFuture<Suggestions> suggestInvitedParties(CommandContext<class_2168> c, SuggestionsBuilder b) {
        class_3222 self = ((class_2168)c.getSource()).method_44023();
        if (self == null) {
            return Suggestions.empty();
        }
        MinecraftServer server = self.method_5682();
        PartyPersistentState state = PartyPersistentState.get(server);
        for (UUID pid : state.invitesOf(self.method_5667())) {
            Party p = state.getParty(pid);
            if (p == null) continue;
            String name = PartyCommands.displayName(p);
            String leader = state.nameOf(p.leader);
            if (leader == null) {
                class_3222 sp = server.method_3760().method_14602(p.leader);
                leader = sp != null ? sp.method_5477().getString() : PartyCommands.shortId(p.leader);
            }
            b.suggest(name);
            b.suggest(name + " (" + leader + ")");
            b.suggest(name + " #" + PartyCommands.shortId(p.id));
        }
        return b.buildFuture();
    }

    private static UUID resolveInvitedPartyFromInput(MinecraftServer server, PartyPersistentState state, class_3222 self, String input) {
        if (input == null || input.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(input.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String qi = input.trim();
            String qiLower = qi.toLowerCase(Locale.ROOT);
            UUID match = null;
            int matches = 0;
            for (UUID pid : state.invitesOf(self.method_5667())) {
                Party p = state.getParty(pid);
                if (p == null) continue;
                String name = PartyCommands.displayName(p);
                String leader = state.nameOf(p.leader);
                if (leader == null) {
                    class_3222 sp = server.method_3760().method_14602(p.leader);
                    leader = sp != null ? sp.method_5477().getString() : PartyCommands.shortId(p.leader);
                }
                String labelPlain = name;
                String labelLeader = name + " (" + leader + ")";
                String labelShort = name + " #" + PartyCommands.shortId(p.id);
                if (labelPlain.equalsIgnoreCase(qi) || labelLeader.equalsIgnoreCase(qi) || labelShort.equalsIgnoreCase(qi)) {
                    match = p.id;
                    ++matches;
                    continue;
                }
                if (!labelLeader.toLowerCase(Locale.ROOT).contains(qiLower)) continue;
                match = p.id;
                ++matches;
            }
            return matches == 1 ? match : null;
        }
    }

    private static int requestJoinByName(CommandContext<class_2168> ctx, String userInput) {
        PartyPersistentState state;
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        MinecraftServer server = self.method_5682();
        UUID partyId = PartyCommands.resolvePartyFromInput(server, state = PartyPersistentState.get(server), userInput);
        if (partyId == null) {
            self.method_43496((class_2561)class_2561.method_43470((String)("Couldn\u2019t find a unique party for \"" + userInput + "\". Use Tab to pick from the suggestions.")));
            return 0;
        }
        return PartyCommands.requestJoin(ctx, partyId);
    }

    private static String displayName(Party p) {
        return p.name == null || p.name.isBlank() ? p.id.toString() : p.name;
    }

    private static CompletableFuture<Suggestions> suggestPartyMembers(CommandContext<class_2168> c, SuggestionsBuilder b) {
        class_3222 leader = ((class_2168)c.getSource()).method_44023();
        if (leader == null) {
            return Suggestions.empty();
        }
        MinecraftServer server = leader.method_5682();
        PartyPersistentState state = PartyPersistentState.get(server);
        Party p = state.getPartyByMember(leader.method_5667());
        if (p == null || !p.leader.equals(leader.method_5667())) {
            return Suggestions.empty();
        }
        for (UUID u : p.members) {
            if (u.equals(leader.method_5667())) continue;
            String name = state.nameOf(u);
            if (name == null) {
                class_3222 sp = server.method_3760().method_14602(u);
                name = sp != null ? sp.method_5477().getString() : PartyCommands.shortId(u);
            }
            b.suggest(name);
            b.suggest(name + " #" + PartyCommands.shortId(u));
            b.suggest(u.toString());
        }
        return b.buildFuture();
    }

    private static UUID resolveMemberFromInput(MinecraftServer server, PartyPersistentState state, Party p, String input) {
        if (input == null || input.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(input.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String qi = input.trim();
            String qiLower = qi.toLowerCase(Locale.ROOT);
            UUID match = null;
            int matches = 0;
            for (UUID u : p.members) {
                String name = state.nameOf(u);
                if (name == null) {
                    class_3222 sp = server.method_3760().method_14602(u);
                    name = sp != null ? sp.method_5477().getString() : PartyCommands.shortId(u);
                }
                String label1 = name;
                String label2 = name + " #" + PartyCommands.shortId(u);
                if (label1.equalsIgnoreCase(qi) || label2.equalsIgnoreCase(qi)) {
                    match = u;
                    ++matches;
                    continue;
                }
                if (label1.toLowerCase(Locale.ROOT).contains(qiLower) || label2.toLowerCase(Locale.ROOT).contains(qiLower)) {
                    match = u;
                    ++matches;
                }
                if (!PartyCommands.shortId(u).equalsIgnoreCase(qi)) continue;
                match = u;
                ++matches;
            }
            return matches == 1 ? match : null;
        }
    }

    private static int acceptByName(CommandContext<class_2168> ctx, String userInput) {
        PartyPersistentState state;
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        MinecraftServer server = self.method_5682();
        UUID partyId = PartyCommands.resolveInvitedPartyFromInput(server, state = PartyPersistentState.get(server), self, userInput);
        if (partyId == null) {
            self.method_43496((class_2561)class_2561.method_43470((String)("Couldn\u2019t find a unique invite for \"" + userInput + "\". Use Tab to pick from your invite list.")));
            return 0;
        }
        return PartyCommands.acceptSpecific(ctx, partyId);
    }

    private static int declineByName(CommandContext<class_2168> ctx, String userInput) {
        PartyPersistentState state;
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        if (self == null) {
            return 0;
        }
        MinecraftServer server = self.method_5682();
        UUID partyId = PartyCommands.resolveInvitedPartyFromInput(server, state = PartyPersistentState.get(server), self, userInput);
        if (partyId == null) {
            self.method_43496((class_2561)class_2561.method_43470((String)("Couldn\u2019t find a unique invite for \"" + userInput + "\". Use Tab to pick from your invite list.")));
            return 0;
        }
        return PartyCommands.declineSpecific(ctx, partyId);
    }
}

