/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.party;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.party.Party;

public final class PartyPersistentState
extends class_18 {
    public static final String KEY = "rpgsystems_parties";
    public static final class_18.class_8645<PartyPersistentState> TYPE = new class_18.class_8645(PartyPersistentState::new, PartyPersistentState::fromNbt, null);
    public static final long INVITE_TTL_MS = 60000L;
    private final Map<UUID, Party> parties = new HashMap<UUID, Party>();
    private final Map<UUID, UUID> membership = new HashMap<UUID, UUID>();
    private final Map<UUID, Set<UUID>> pendingInvites = new HashMap<UUID, Set<UUID>>();
    private final Map<UUID, String> lastKnownNames = new HashMap<UUID, String>();
    private final Map<UUID, Set<UUID>> joinRequests = new HashMap<UUID, Set<UUID>>();
    private final Map<String, Long> inviteTimes = new HashMap<String, Long>();

    public static PartyPersistentState get(MinecraftServer server) {
        class_26 mgr = server.method_3847(class_1937.field_25179).method_17983();
        return (PartyPersistentState)mgr.method_17924(TYPE, KEY);
    }

    private static PartyPersistentState fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        PartyPersistentState s = new PartyPersistentState();
        class_2499 partyList = nbt.method_10554("Parties", 10);
        for (int i = 0; i < partyList.size(); ++i) {
            Party p = Party.fromNbt(partyList.method_10602(i));
            s.parties.put(p.id, p);
            for (UUID u : p.members) {
                s.membership.put(u, p.id);
            }
        }
        class_2499 invitesList = nbt.method_10554("Invites", 10);
        for (int i = 0; i < invitesList.size(); ++i) {
            class_2487 tag = invitesList.method_10602(i);
            UUID target = tag.method_25926("Target");
            HashSet<UUID> set = new HashSet<UUID>();
            class_2499 ids = tag.method_10554("Ids", 10);
            for (int j = 0; j < ids.size(); ++j) {
                set.add(ids.method_10602(j).method_25926("V"));
            }
            if (set.isEmpty()) continue;
            s.pendingInvites.put(target, set);
        }
        class_2499 names = nbt.method_10554("Names", 10);
        for (int i = 0; i < names.size(); ++i) {
            class_2487 row = names.method_10602(i);
            s.lastKnownNames.put(row.method_25926("U"), row.method_10558("N"));
        }
        class_2499 jr = nbt.method_10554("JoinRequests", 10);
        for (int i = 0; i < jr.size(); ++i) {
            class_2487 row = jr.method_10602(i);
            UUID partyId = row.method_25926("Party");
            HashSet<UUID> reqs = new HashSet<UUID>();
            class_2499 rs = row.method_10554("Reqs", 10);
            for (int j = 0; j < rs.size(); ++j) {
                reqs.add(rs.method_10602(j).method_25926("U"));
            }
            if (reqs.isEmpty()) continue;
            s.joinRequests.put(partyId, reqs);
        }
        class_2499 times = nbt.method_10554("InviteTimes", 10);
        for (int i = 0; i < times.size(); ++i) {
            class_2487 row = times.method_10602(i);
            UUID target = row.method_25926("Target");
            UUID party = row.method_25926("Party");
            long when = row.method_10537("Time");
            s.inviteTimes.put(PartyPersistentState.inviteKey(target, party), when);
        }
        return s;
    }

    public boolean sameParty(UUID a, UUID b) {
        UUID pa = this.membership.get(a);
        return pa != null && pa.equals(this.membership.get(b));
    }

    public Party createParty(UUID leader, String name) {
        if (this.membership.containsKey(leader)) {
            return this.getPartyByMember(leader);
        }
        Party p = new Party(UUID.randomUUID(), leader, name == null ? "" : name);
        this.parties.put(p.id, p);
        this.membership.put(leader, p.id);
        this.method_80();
        return p;
    }

    public Party getParty(UUID id) {
        return this.parties.get(id);
    }

    public Party getPartyByMember(UUID player) {
        UUID pid = this.membership.get(player);
        return pid == null ? null : this.parties.get(pid);
    }

    public boolean kick(UUID leader, UUID target) {
        Party p = this.getPartyByMember(leader);
        if (p == null || !p.leader.equals(leader)) {
            return false;
        }
        if (leader.equals(target)) {
            return false;
        }
        if (!p.members.remove(target)) {
            return false;
        }
        this.membership.remove(target);
        this.purgeRequesterFromJoinRequests(target);
        this.method_80();
        return true;
    }

    public Collection<Party> allParties() {
        return Collections.unmodifiableCollection(this.parties.values());
    }

    public boolean invite(UUID inviter, UUID target) {
        Party p = this.getPartyByMember(inviter);
        if (p == null) {
            return false;
        }
        if (!p.isMember(inviter)) {
            return false;
        }
        if (inviter.equals(target)) {
            return false;
        }
        if (p.isMember(target)) {
            return false;
        }
        if (this.membership.containsKey(target)) {
            return false;
        }
        long now = System.currentTimeMillis();
        this.purgeExpiredInvitesFor(target, now);
        Set set = this.pendingInvites.computeIfAbsent(target, k -> new HashSet());
        if (set.contains(p.id)) {
            return false;
        }
        set.add(p.id);
        this.inviteTimes.put(PartyPersistentState.inviteKey(target, p.id), now);
        this.method_80();
        return true;
    }

    public Set<UUID> targetsInvitedBy(UUID partyId) {
        HashSet<UUID> out = new HashSet<UUID>();
        for (Map.Entry<UUID, Set<UUID>> e : this.pendingInvites.entrySet()) {
            if (e.getValue() == null || !e.getValue().contains(partyId)) continue;
            out.add(e.getKey());
        }
        return out;
    }

    public Set<UUID> partiesWithJoinRequestFrom(UUID requester) {
        HashSet<UUID> out = new HashSet<UUID>();
        for (Map.Entry<UUID, Set<UUID>> e : this.joinRequests.entrySet()) {
            if (e.getValue() == null || !e.getValue().contains(requester)) continue;
            out.add(e.getKey());
        }
        return out;
    }

    public boolean acceptAny(UUID target) {
        this.purgeExpiredInvitesFor(target, System.currentTimeMillis());
        Set invites = this.pendingInvites.getOrDefault(target, Collections.emptySet());
        UUID chosen = invites.stream().findFirst().orElse(null);
        if (chosen == null) {
            return false;
        }
        return this.accept(target, chosen);
    }

    public boolean accept(UUID target, UUID partyId) {
        if (this.membership.containsKey(target)) {
            return false;
        }
        Party p = this.parties.get(partyId);
        if (p == null) {
            return false;
        }
        Set<UUID> set = this.pendingInvites.get(target);
        if (set == null || !set.contains(partyId)) {
            return false;
        }
        Long when = this.inviteTimes.get(PartyPersistentState.inviteKey(target, partyId));
        if (when != null && System.currentTimeMillis() - when > 60000L) {
            set.remove(partyId);
            if (set.isEmpty()) {
                this.pendingInvites.remove(target);
            }
            this.inviteTimes.remove(PartyPersistentState.inviteKey(target, partyId));
            this.method_80();
            return false;
        }
        p.members.add(target);
        this.membership.put(target, p.id);
        this.pendingInvites.remove(target);
        this.inviteTimes.remove(PartyPersistentState.inviteKey(target, partyId));
        this.purgeRequesterFromJoinRequests(target);
        this.method_80();
        return true;
    }

    public boolean leave(UUID player) {
        Party p = this.getPartyByMember(player);
        if (p == null) {
            return false;
        }
        if (p.leader.equals(player)) {
            this.parties.remove(p.id);
            for (UUID u : new HashSet<UUID>(p.members)) {
                this.membership.remove(u);
            }
            this.purgePartyFromInvites(p.id);
            this.purgePartyFromJoinRequests(p.id);
        } else {
            p.members.remove(player);
            this.membership.remove(player);
        }
        this.method_80();
        return true;
    }

    public boolean renameParty(UUID requester, String newName) {
        Party p = this.getPartyByMember(requester);
        if (p == null || !p.leader.equals(requester)) {
            return false;
        }
        p.name = newName;
        this.method_80();
        return true;
    }

    public boolean disband(UUID requester) {
        Party p = this.getPartyByMember(requester);
        if (p == null) {
            return false;
        }
        if (!p.leader.equals(requester)) {
            return false;
        }
        this.parties.remove(p.id);
        for (UUID u : new HashSet<UUID>(p.members)) {
            this.membership.remove(u);
        }
        this.purgePartyFromInvites(p.id);
        this.purgePartyFromJoinRequests(p.id);
        this.method_80();
        return true;
    }

    public boolean removeInvite(UUID target, UUID partyId) {
        Set<UUID> set = this.pendingInvites.get(target);
        if (set == null) {
            return false;
        }
        boolean removed = set.remove(partyId);
        if (set.isEmpty()) {
            this.pendingInvites.remove(target);
        }
        this.inviteTimes.remove(PartyPersistentState.inviteKey(target, partyId));
        if (removed) {
            this.method_80();
        }
        return removed;
    }

    public Set<UUID> invitesOf(UUID target) {
        this.purgeExpiredInvitesFor(target, System.currentTimeMillis());
        Set<UUID> s = this.pendingInvites.get(target);
        return s == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<UUID>(s));
    }

    public void rememberName(UUID uuid, String name) {
        if (uuid == null || name == null || name.isBlank()) {
            return;
        }
        String prev = this.lastKnownNames.put(uuid, name);
        if (!name.equals(prev)) {
            this.method_80();
        }
    }

    public String nameOf(UUID uuid) {
        return this.lastKnownNames.get(uuid);
    }

    public boolean requestJoin(UUID requester, UUID partyId) {
        if (this.membership.containsKey(requester)) {
            return false;
        }
        Party p = this.parties.get(partyId);
        if (p == null) {
            return false;
        }
        if (p.isMember(requester)) {
            return false;
        }
        Set set = this.joinRequests.computeIfAbsent(partyId, k -> new HashSet());
        if (!set.add(requester)) {
            return false;
        }
        this.method_80();
        return true;
    }

    public Set<UUID> joinRequestsOf(UUID partyId) {
        Set<UUID> s = this.joinRequests.get(partyId);
        return s == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<UUID>(s));
    }

    public boolean acceptJoin(UUID leader, UUID requester) {
        Party p = this.getPartyByMember(leader);
        if (p == null || !p.leader.equals(leader)) {
            return false;
        }
        Set<UUID> set = this.joinRequests.get(p.id);
        if (set == null || !set.contains(requester)) {
            return false;
        }
        if (this.membership.containsKey(requester)) {
            set.remove(requester);
            this.cleanJoinRequestsBucket(p.id);
            this.method_80();
            return false;
        }
        set.remove(requester);
        this.cleanJoinRequestsBucket(p.id);
        p.members.add(requester);
        this.membership.put(requester, p.id);
        this.pendingInvites.remove(requester);
        this.purgeRequesterFromJoinRequests(requester);
        this.method_80();
        return true;
    }

    public boolean declineJoin(UUID leader, UUID requester) {
        Party p = this.getPartyByMember(leader);
        if (p == null || !p.leader.equals(leader)) {
            return false;
        }
        Set<UUID> set = this.joinRequests.get(p.id);
        if (set == null || !set.remove(requester)) {
            return false;
        }
        this.cleanJoinRequestsBucket(p.id);
        this.method_80();
        return true;
    }

    private void purgePartyFromInvites(UUID partyId) {
        Iterator<Map.Entry<UUID, Set<UUID>>> it = this.pendingInvites.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Set<UUID>> e = it.next();
            Set<UUID> set = e.getValue();
            set.remove(partyId);
            this.inviteTimes.remove(PartyPersistentState.inviteKey(e.getKey(), partyId));
            if (!set.isEmpty()) continue;
            it.remove();
        }
    }

    private void purgePartyFromJoinRequests(UUID partyId) {
        this.joinRequests.remove(partyId);
    }

    private void purgeRequesterFromJoinRequests(UUID requester) {
        for (Set<UUID> set : this.joinRequests.values()) {
            set.remove(requester);
        }
        this.cleanJoinRequestsBuckets();
    }

    private void cleanJoinRequestsBucket(UUID partyId) {
        Set<UUID> set = this.joinRequests.get(partyId);
        if (set != null && set.isEmpty()) {
            this.joinRequests.remove(partyId);
        }
    }

    private void cleanJoinRequestsBuckets() {
        this.joinRequests.entrySet().removeIf(e -> e.getValue() == null || ((Set)e.getValue()).isEmpty());
    }

    private void purgeExpiredInvitesFor(UUID target, long now) {
        Set<UUID> set = this.pendingInvites.get(target);
        if (set == null || set.isEmpty()) {
            return;
        }
        boolean changed = false;
        Iterator<UUID> it = set.iterator();
        while (it.hasNext()) {
            UUID partyId = it.next();
            Long when = this.inviteTimes.get(PartyPersistentState.inviteKey(target, partyId));
            if (when == null || now - when <= 60000L) continue;
            it.remove();
            this.inviteTimes.remove(PartyPersistentState.inviteKey(target, partyId));
            changed = true;
        }
        if (changed) {
            if (set.isEmpty()) {
                this.pendingInvites.remove(target);
            }
            this.method_80();
        }
    }

    private static String inviteKey(UUID target, UUID partyId) {
        return String.valueOf(target) + "#" + String.valueOf(partyId);
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 partyList = new class_2499();
        for (Party party : this.parties.values()) {
            partyList.add((Object)party.toNbt());
        }
        nbt.method_10566("Parties", (class_2520)partyList);
        class_2499 invitesList = new class_2499();
        for (Map.Entry<UUID, Set<UUID>> entry : this.pendingInvites.entrySet()) {
            class_2487 class_24872 = new class_2487();
            class_24872.method_25927("Target", entry.getKey());
            class_2499 class_24992 = new class_2499();
            for (UUID v : entry.getValue()) {
                class_2487 c = new class_2487();
                c.method_25927("V", v);
                class_24992.add((Object)c);
            }
            class_24872.method_10566("Ids", (class_2520)class_24992);
            invitesList.add((Object)class_24872);
        }
        nbt.method_10566("Invites", (class_2520)invitesList);
        class_2499 class_24993 = new class_2499();
        for (Map.Entry<UUID, String> entry : this.lastKnownNames.entrySet()) {
            class_2487 class_24873 = new class_2487();
            class_24873.method_25927("U", entry.getKey());
            class_24873.method_10582("N", entry.getValue());
            class_24993.add((Object)class_24873);
        }
        nbt.method_10566("Names", (class_2520)class_24993);
        class_2499 class_24994 = new class_2499();
        for (Map.Entry<UUID, Set<UUID>> entry : this.joinRequests.entrySet()) {
            class_2487 row = new class_2487();
            row.method_25927("Party", entry.getKey());
            class_2499 rs = new class_2499();
            for (UUID u : entry.getValue()) {
                class_2487 c = new class_2487();
                c.method_25927("U", u);
                rs.add((Object)c);
            }
            row.method_10566("Reqs", (class_2520)rs);
            class_24994.add((Object)row);
        }
        nbt.method_10566("JoinRequests", (class_2520)class_24994);
        class_2499 class_24995 = new class_2499();
        for (Map.Entry<String, Long> e : this.inviteTimes.entrySet()) {
            String[] parts = e.getKey().split("#", 2);
            if (parts.length != 2) continue;
            try {
                UUID target = UUID.fromString(parts[0]);
                UUID party = UUID.fromString(parts[1]);
                class_2487 row = new class_2487();
                row.method_25927("Target", target);
                row.method_25927("Party", party);
                row.method_10544("Time", e.getValue().longValue());
                class_24995.add((Object)row);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        nbt.method_10566("InviteTimes", (class_2520)class_24995);
        return nbt;
    }
}

