/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.api.TitleApi;
import net.pixeldreamstudios.rpgsystems.network.TitleNet;
import net.pixeldreamstudios.rpgsystems.network.title.TitlePayloads;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;
import net.pixeldreamstudios.rpgsystems.title.TitlesPersistentState;

public final class TitleCommands {
    private TitleCommands() {
    }

    public static void register(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"titles").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"give").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(TitleCommands::suggestTitles).executes(ctx -> TitleCommands.give((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2232.method_9443((CommandContext)ctx, (String)"id"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(TitleCommands::suggestTitles).executes(ctx -> TitleCommands.remove((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2232.method_9443((CommandContext)ctx, (String)"id"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(TitleCommands::suggestTitles).executes(ctx -> TitleCommands.reset((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2232.method_9443((CommandContext)ctx, (String)"id"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(TitleCommands::suggestTitles).executes(ctx -> TitleCommands.applySelf((CommandContext<class_2168>)ctx, class_2232.method_9443((CommandContext)ctx, (String)"id"))))).then(class_2170.method_9247((String)"none").executes(TitleCommands::clearSelf)))).then(class_2170.method_9247((String)"condition_check").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(TitleCommands::suggestTitles).executes(ctx -> TitleCommands.conditionCheck((CommandContext<class_2168>)ctx, class_2232.method_9443((CommandContext)ctx, (String)"id"))))));
    }

    private static int conditionCheck(CommandContext<class_2168> ctx, class_2960 id) {
        boolean granted;
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        Title t = TitleRegistry.get(id);
        if (t == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown title: " + String.valueOf(id))));
            return 0;
        }
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(self.method_5667());
        class_2487 tag = pt.progress.get(id.toString());
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77[ titles ] Checking \u00a7f" + String.valueOf(id))), false);
        boolean allMet = true;
        for (int i = 0; i < t.conditions.size(); ++i) {
            Title.Condition c = t.conditions.get(i);
            long cur = tag == null ? 0L : tag.method_10537("c" + i);
            boolean dn = tag != null && tag.method_10577("done_" + i);
            boolean met = false;
            switch (c.type) {
                case OBTAIN_ITEM: 
                case ADVANCEMENT: 
                case REACH_LEVEL: 
                case REACH_LEVEL_XP: 
                case REACH_LEVEL_PUFFERFISH: 
                case VISIT_BIOME: 
                case ENTER_DIMENSION: 
                case INTERACT_BLOCK: 
                case INTERACT_ENTITY: 
                case CHECK_ATTRIBUTE: 
                case FIND_STRUCTURE: {
                    met = dn;
                    break;
                }
                case KILL_MOBS: {
                    met = cur >= (long)Math.max(1, c.count);
                    break;
                }
                case WALK_BLOCKS: {
                    met = cur >= Math.max(1L, c.distance);
                    break;
                }
                case CRAFT_ITEM: {
                    met = cur >= (long)Math.max(1, c.count);
                    break;
                }
                case MINE_BLOCKS: {
                    met = cur >= (long)Math.max(1, c.count);
                    break;
                }
                case DEAL_DAMAGE_TOTAL: 
                case DEAL_DAMAGE_MAX: {
                    met = cur >= (long)Math.max(1, c.count);
                }
            }
            allMet &= met;
            Object targetTxt = switch (c.type) {
                default -> throw new MatchException(null, null);
                case Title.Condition.Type.WALK_BLOCKS -> String.valueOf(Math.max(1L, c.distance));
                case Title.Condition.Type.REACH_LEVEL, Title.Condition.Type.REACH_LEVEL_XP, Title.Condition.Type.REACH_LEVEL_PUFFERFISH -> String.valueOf(Math.max(1, c.level));
                case Title.Condition.Type.CHECK_ATTRIBUTE -> "\u2265 " + c.minValue;
                case Title.Condition.Type.OBTAIN_ITEM, Title.Condition.Type.ADVANCEMENT, Title.Condition.Type.VISIT_BIOME, Title.Condition.Type.ENTER_DIMENSION, Title.Condition.Type.INTERACT_BLOCK, Title.Condition.Type.INTERACT_ENTITY, Title.Condition.Type.FIND_STRUCTURE, Title.Condition.Type.KILL_MOBS, Title.Condition.Type.CRAFT_ITEM, Title.Condition.Type.MINE_BLOCKS, Title.Condition.Type.DEAL_DAMAGE_TOTAL, Title.Condition.Type.DEAL_DAMAGE_MAX -> String.valueOf(Math.max(1, c.count));
            };
            String line = String.format("\u00a77 %2d) \u00a7f%-22s \u00a77cur=%s  done=%s  target=%s  %s", i + 1, c.type.name().toLowerCase(Locale.ROOT), cur, dn, targetTxt, met ? "\u00a7a[OK]" : "\u00a7c[NO]");
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)line), false);
        }
        boolean hasTitle = pt.unlocked.contains(id.toString());
        if (allMet && !hasTitle && (granted = TitleApi.grant(self, id))) {
            state.method_80();
            TitleCommands.syncSelfTo(server, self);
            TitleNet.syncProgressTo(server, self);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aAll conditions met. Granted " + String.valueOf(id))), false);
            return 1;
        }
        boolean finalAllMet = allMet;
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)(finalAllMet ? "\u00a7aAll conditions met. (already unlocked)" : "\u00a7eNot all conditions are met.")), false);
        return allMet ? 1 : 0;
    }

    private static int give(CommandContext<class_2168> ctx, class_3222 target, class_2960 id) {
        boolean ok = TitleApi.grant(target, id);
        if (!ok) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown title or already unlocked: " + String.valueOf(id))));
            return 0;
        }
        TitleCommands.syncSelfTo(((class_2168)ctx.getSource()).method_9211(), target);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Granted title " + String.valueOf(id) + " to " + target.method_5477().getString())), true);
        return 1;
    }

    private static int remove(CommandContext<class_2168> ctx, class_3222 target, class_2960 id) {
        boolean ok = TitleApi.revoke(target, id);
        if (!ok) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Title not found or not unlocked: " + String.valueOf(id))));
            return 0;
        }
        TitleApi.clearProgress(target, id);
        TitleNet.syncSelfTo(((class_2168)ctx.getSource()).method_9211(), target);
        TitleCommands.broadcastActiveToAll(((class_2168)ctx.getSource()).method_9211(), target.method_5667(), TitleCommands.activeOf(((class_2168)ctx.getSource()).method_9211(), target.method_5667()));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed and wiped progress for title " + String.valueOf(id) + " from " + target.method_5477().getString())), true);
        return 1;
    }

    private static int reset(CommandContext<class_2168> ctx, class_3222 target, class_2960 id) {
        boolean had = TitleApi.clearProgress(target, id);
        TitleNet.syncSelfTo(((class_2168)ctx.getSource()).method_9211(), target);
        if (had) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Reset progress for title " + String.valueOf(id) + " on " + target.method_5477().getString())), true);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No progress found for title: " + String.valueOf(id))));
        return 0;
    }

    private static int applySelf(CommandContext<class_2168> ctx, class_2960 id) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        boolean ok = TitleApi.setActive(self, Optional.of(id));
        if (!ok) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("You have not unlocked: " + String.valueOf(id))));
            return 0;
        }
        TitleCommands.syncSelfTo(((class_2168)ctx.getSource()).method_9211(), self);
        TitleCommands.broadcastActiveToAll(((class_2168)ctx.getSource()).method_9211(), self.method_5667(), Optional.of(id));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Applied title " + String.valueOf(id))), false);
        return 1;
    }

    private static int clearSelf(CommandContext<class_2168> ctx) {
        class_3222 self = ((class_2168)ctx.getSource()).method_44023();
        boolean ok = TitleApi.setActive(self, Optional.empty());
        if (!ok) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to clear active title"));
            return 0;
        }
        TitleCommands.syncSelfTo(((class_2168)ctx.getSource()).method_9211(), self);
        TitleCommands.broadcastActiveToAll(((class_2168)ctx.getSource()).method_9211(), self.method_5667(), Optional.empty());
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared active title"), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestTitles(CommandContext<class_2168> ctx, SuggestionsBuilder b) {
        for (class_2960 id : TitleRegistry.all().keySet()) {
            b.suggest(id.toString());
        }
        return b.buildFuture();
    }

    private static Optional<class_2960> activeOf(MinecraftServer server, UUID uuid) {
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(uuid);
        return Optional.ofNullable(pt.active == null ? null : class_2960.method_60654((String)pt.active));
    }

    private static void syncSelfTo(MinecraftServer server, class_3222 player) {
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        ArrayList<class_2960> unlocked = new ArrayList<class_2960>();
        for (String s : pt.unlocked) {
            unlocked.add(class_2960.method_60654((String)s));
        }
        Optional<Object> active = Optional.ofNullable(pt.active == null ? null : class_2960.method_60654((String)pt.active));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TitlePayloads.SyncSelf(unlocked, active));
    }

    private static void broadcastActiveToAll(MinecraftServer server, UUID playerUuid, Optional<class_2960> active) {
        TitlePayloads.SyncActive pkt = new TitlePayloads.SyncActive(playerUuid, active);
        for (class_3222 sp : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)sp, (class_8710)pkt);
        }
    }
}

