/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.accessor.LivingEntityRawDamageAccess;
import net.pixeldreamstudios.rpgsystems.api.TitleApi;
import net.pixeldreamstudios.rpgsystems.network.TitleNet;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;
import net.pixeldreamstudios.rpgsystems.title.TitlesPersistentState;
import net.puffish.skillsmod.SkillsMod;

public final class TitleConditionEvents {
    private static final Map<UUID, class_243> LAST_POS = new HashMap<UUID, class_243>();
    private static final Map<UUID, class_5321<class_1937>> LAST_DIM = new HashMap<UUID, class_5321<class_1937>>();
    private static final int INVENTORY_CHECK_INTERVAL = 20;
    private static int tickCounter = 0;

    private TitleConditionEvents() {
    }

    public static void register() {
        ServerTickEvents.START_SERVER_TICK.register(TitleConditionEvents::onServerTick);
        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register(TitleConditionEvents::onKill);
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
            class_1297 attacker = source.method_5529();
            if (!(attacker instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)attacker;
            if (!(entity instanceof class_1309)) {
                return;
            }
            class_1309 victim = entity;
            MinecraftServer server = player.method_5682();
            TitlesPersistentState state = TitlesPersistentState.get(server);
            TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
            boolean changed = false;
            long amt = Math.max(0L, (long)Math.round(Math.max(baseDamageTaken, damageTaken)));
            for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
                class_2960 id = e.getKey();
                Title t = e.getValue();
                if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
                for (int idx = 0; idx < t.conditions.size(); ++idx) {
                    int target;
                    boolean nowDone;
                    long next;
                    Title.Condition c = t.conditions.get(idx);
                    if (c.type != Title.Condition.Type.DEAL_DAMAGE_TOTAL && c.type != Title.Condition.Type.DEAL_DAMAGE_MAX || !TitleConditionEvents.matchesEntitySpec(victim, c) || !TitleConditionEvents.matchesNbt(victim, c)) continue;
                    class_2487 tag = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                    long prev = tag.method_10537("c" + idx);
                    long l = next = c.type == Title.Condition.Type.DEAL_DAMAGE_TOTAL ? prev + amt : Math.max(prev, amt);
                    if (next != prev) {
                        tag.method_10544("c" + idx, next);
                        changed = true;
                    }
                    boolean bl = nowDone = next >= (long)(target = Math.max(1, c.count));
                    if (nowDone == tag.method_10577("done_" + idx)) continue;
                    tag.method_10556("done_" + idx, nowDone);
                    changed = true;
                }
            }
            if (changed) {
                state.method_80();
                TitleNet.syncProgressTo(server, player);
                TitleConditionEvents.checkCompletionAndGrant(server, player, state, pt);
            }
        });
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> TitleConditionEvents.onUseBlock(player, world, hand, hit));
        UseEntityCallback.EVENT.register((player, world, hand, entity, hit) -> TitleConditionEvents.onUseEntity(player, world, hand, entity, hit));
    }

    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (!(player instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 sp = (class_3222)player;
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 sw = (class_3218)world;
        MinecraftServer server = sw.method_8503();
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(sp.method_5667());
        boolean changed = false;
        class_2338 pos = hit.method_17777();
        class_2248 b = world.method_8320(pos).method_26204();
        class_2960 bid = class_7923.field_41175.method_10221((Object)b);
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                boolean match;
                Title.Condition c = t.conditions.get(idx);
                if (c.type != Title.Condition.Type.INTERACT_BLOCK || !(match = c.block.map(arg_0 -> ((class_2960)bid).equals(arg_0)).orElse(true).booleanValue())) continue;
                class_2487 tag = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                long next = tag.method_10537("c" + idx) + 1L;
                tag.method_10544("c" + idx, next);
                if (next >= (long)Math.max(1, c.count)) {
                    tag.method_10556("done_" + idx, true);
                }
                state.method_80();
                changed = true;
            }
        }
        if (changed) {
            TitleNet.syncProgressTo(server, sp);
            TitleConditionEvents.checkCompletionAndGrant(server, sp, state, pt);
        }
        return class_1269.field_5811;
    }

    private static class_1269 onUseEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hit) {
        if (!(player instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 sp = (class_3222)player;
        if (!(entity instanceof class_1309)) {
            return class_1269.field_5811;
        }
        class_1309 le = (class_1309)entity;
        MinecraftServer server = sp.method_5682();
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(sp.method_5667());
        boolean changed = false;
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                Title.Condition c = t.conditions.get(idx);
                if (c.type != Title.Condition.Type.INTERACT_ENTITY || !TitleConditionEvents.matchesEntitySpec(le, c) || !TitleConditionEvents.matchesNbt(le, c)) continue;
                class_2487 tag = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                long next = tag.method_10537("c" + idx) + 1L;
                tag.method_10544("c" + idx, next);
                if (next >= (long)Math.max(1, c.count)) {
                    tag.method_10556("done_" + idx, true);
                }
                state.method_80();
                changed = true;
            }
        }
        if (changed) {
            TitleNet.syncProgressTo(server, sp);
            TitleConditionEvents.checkCompletionAndGrant(server, sp, state, pt);
        }
        return class_1269.field_5811;
    }

    private static void onServerTick(MinecraftServer server) {
        ++tickCounter;
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean changed;
            boolean structureChanged;
            boolean attrChanged;
            boolean changed2;
            TitlesPersistentState state = TitlesPersistentState.get(server);
            TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
            class_243 last = LAST_POS.get(player.method_5667());
            class_243 now = player.method_19538();
            if (last == null) {
                LAST_POS.put(player.method_5667(), now);
            } else {
                boolean changed3;
                double dx = now.field_1352 - last.field_1352;
                double dy = now.field_1351 - last.field_1351;
                double dz = now.field_1350 - last.field_1350;
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (player.method_24828() && (changed3 = TitleConditionEvents.accumulateProgressWalk(state, pt, dist))) {
                    TitleNet.syncProgressTo(server, player);
                }
                LAST_POS.put(player.method_5667(), now);
            }
            class_5321 curDim = player.method_37908().method_27983();
            class_5321<class_1937> prevDim = LAST_DIM.put(player.method_5667(), (class_5321<class_1937>)curDim);
            if (prevDim == null) {
                LAST_DIM.put(player.method_5667(), (class_5321<class_1937>)curDim);
            } else if (!prevDim.equals((Object)curDim) && (changed2 = TitleConditionEvents.onDimensionChanged(server, player, state, pt, (class_5321<class_1937>)curDim))) {
                TitleNet.syncProgressTo(server, player);
            }
            boolean biomeChanged = TitleConditionEvents.updateVisitBiome(server, player, state, pt);
            if (biomeChanged) {
                TitleNet.syncProgressTo(server, player);
            }
            if (attrChanged = TitleConditionEvents.updateAttributeChecks(server, player, state, pt)) {
                TitleNet.syncProgressTo(server, player);
            }
            if (structureChanged = TitleConditionEvents.updateFindStructure(server, player, state, pt)) {
                TitleNet.syncProgressTo(server, player);
            }
            if (tickCounter % 20 == 0 && (changed = TitleConditionEvents.checkPeriodic(server, player, state, pt))) {
                TitleNet.syncProgressTo(server, player);
            }
            TitleConditionEvents.checkCompletionAndGrant(server, player, state, pt);
        }
        if (tickCounter > 1000000) {
            tickCounter = 0;
        }
    }

    private static void onKill(class_3218 world, class_1297 killer, class_1309 killed) {
        LivingEntityRawDamageAccess acc;
        UUID a;
        if (!(killer instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)killer;
        MinecraftServer server = world.method_8503();
        TitlesPersistentState state = TitlesPersistentState.get(server);
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        float lastRaw = 0.0f;
        if (killed instanceof LivingEntityRawDamageAccess && (a = (acc = (LivingEntityRawDamageAccess)killed).rpgsystems$getLastRawDamageAttacker()) != null && a.equals(player.method_5667())) {
            lastRaw = acc.rpgsystems$getLastRawDamageAmount();
        }
        long lastAmt = Math.max(0L, (long)Math.round(lastRaw));
        boolean changed = false;
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                int target;
                boolean nowDone;
                long next;
                Title.Condition c = t.conditions.get(idx);
                if (c.type == Title.Condition.Type.KILL_MOBS) {
                    if (!TitleConditionEvents.matchesEntitySpec(killed, c) || !TitleConditionEvents.matchesNbt(killed, c)) continue;
                    TitleConditionEvents.incrementProgress(pt, id, idx, 1L);
                    state.method_80();
                    changed = true;
                }
                if (c.type != Title.Condition.Type.DEAL_DAMAGE_TOTAL && c.type != Title.Condition.Type.DEAL_DAMAGE_MAX || lastAmt <= 0L || !TitleConditionEvents.matchesEntitySpec(killed, c) || !TitleConditionEvents.matchesNbt(killed, c)) continue;
                class_2487 tag = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                long prev = tag.method_10537("c" + idx);
                long l = next = c.type == Title.Condition.Type.DEAL_DAMAGE_TOTAL ? prev + lastAmt : Math.max(prev, lastAmt);
                if (next != prev) {
                    tag.method_10544("c" + idx, next);
                    state.method_80();
                    changed = true;
                }
                boolean bl = nowDone = next >= (long)(target = Math.max(1, c.count));
                if (nowDone == tag.method_10577("done_" + idx)) continue;
                tag.method_10556("done_" + idx, nowDone);
                state.method_80();
                changed = true;
            }
        }
        if (changed) {
            TitleNet.syncProgressTo(server, player);
        }
        TitleConditionEvents.checkCompletionAndGrant(server, player, state, pt);
    }

    private static boolean onDimensionChanged(MinecraftServer server, class_3222 player, TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt, class_5321<class_1937> curDim) {
        boolean changed = false;
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                Title.Condition c = t.conditions.get(idx);
                if (c.type != Title.Condition.Type.ENTER_DIMENSION) continue;
                if (c.dimension.isPresent()) {
                    if (!curDim.method_29177().equals((Object)c.dimension.get())) continue;
                    TitleConditionEvents.markDone(pt, id, idx);
                    state.method_80();
                    changed = true;
                    continue;
                }
                TitleConditionEvents.markDone(pt, id, idx);
                state.method_80();
                changed = true;
            }
        }
        return changed;
    }

    private static boolean updateVisitBiome(MinecraftServer server, class_3222 player, TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt) {
        boolean changed = false;
        class_2338 pos = player.method_24515();
        class_6880 biomeEntry = player.method_37908().method_23753(pos);
        class_2960 biomeId = biomeEntry.method_40230().map(k -> k.method_29177()).orElse(null);
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                Title.Condition c = t.conditions.get(idx);
                if (c.type != Title.Condition.Type.VISIT_BIOME) continue;
                if (c.biome.isPresent()) {
                    if (biomeId == null || !biomeId.equals((Object)c.biome.get())) continue;
                    TitleConditionEvents.markDone(pt, id, idx);
                    state.method_80();
                    changed = true;
                    continue;
                }
                TitleConditionEvents.markDone(pt, id, idx);
                state.method_80();
                changed = true;
            }
        }
        return changed;
    }

    private static boolean updateAttributeChecks(MinecraftServer server, class_3222 player, TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt) {
        boolean changed = false;
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                class_1324 inst;
                class_5321 key;
                class_6880 entry;
                Title.Condition c = t.conditions.get(idx);
                if (c.type != Title.Condition.Type.CHECK_ATTRIBUTE || c.attributeId.isEmpty() || (entry = (class_6880)class_7923.field_41190.method_40264(key = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)c.attributeId.get())).orElse(null)) == null || (inst = player.method_5996(entry)) == null) continue;
                double value = inst.method_6194();
                class_2487 tag = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                tag.method_10544("c" + idx, Math.round(value));
                boolean meets = value >= c.minValue;
                boolean prevDone = tag.method_10577("done_" + idx);
                if (meets == prevDone) continue;
                tag.method_10556("done_" + idx, meets);
                state.method_80();
                changed = true;
            }
        }
        return changed;
    }

    private static boolean updateFindStructure(MinecraftServer server, class_3222 player, TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt) {
        boolean changed = false;
        class_3218 sw = player.method_51469();
        class_5138 accessor = sw.method_27056();
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                Title.Condition c = t.conditions.get(idx);
                if (c.type != Title.Condition.Type.FIND_STRUCTURE) continue;
                boolean inside = false;
                if (c.structure.isPresent()) {
                    class_5321 skey = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)c.structure.get());
                    class_6880 sentry = server.method_30611().method_30530(class_7924.field_41246).method_40264(skey).orElse(null);
                    if (sentry != null) {
                        class_3449 start = accessor.method_28388(player.method_24515(), (class_3195)sentry.comp_349());
                        boolean bl = inside = start != null && start.method_16657();
                    }
                }
                if (!inside && !c.structure.isEmpty()) continue;
                TitleConditionEvents.markDone(pt, id, idx);
                state.method_80();
                changed = true;
            }
        }
        return changed;
    }

    private static boolean matchesEntitySpec(class_1309 target, Title.Condition c) {
        if (c.entityTagId != null && c.entityTagId.isPresent()) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)c.entityTagId.get());
            return target.method_5864().method_20210(tagKey);
        }
        if (c.entityType.isPresent()) {
            class_1299 wanted = (class_1299)class_7923.field_41177.method_10223(c.entityType.get());
            return target.method_5864() == wanted;
        }
        if (c.entitySpec.isEmpty()) {
            return true;
        }
        String spec = c.entitySpec.get().trim();
        if (spec.isEmpty() || "any".equalsIgnoreCase(spec)) {
            return true;
        }
        class_2960 id = class_7923.field_41177.method_10221((Object)target.method_5864());
        if (id == null) {
            return false;
        }
        if (spec.startsWith("#")) {
            class_2960 tagId = class_2960.method_12829((String)spec.substring(1));
            if (tagId == null) {
                return false;
            }
            class_6862 tk = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)tagId);
            return target.method_5864().method_20210(tk);
        }
        if (spec.endsWith(":*")) {
            int idx = spec.indexOf(58);
            String ns = idx >= 0 ? spec.substring(0, idx) : spec;
            return id.method_12836().equals(ns);
        }
        class_2960 targetId = class_2960.method_12829((String)spec);
        return targetId != null && id.equals((Object)targetId);
    }

    private static boolean matchesNbt(class_1309 entity, Title.Condition c) {
        if (c.nbtQuery.isEmpty()) {
            return true;
        }
        String query = c.nbtQuery.get();
        if (query.startsWith("tag:")) {
            String wanted = query.substring("tag:".length());
            return entity.method_5752().contains(wanted);
        }
        class_2487 tag = new class_2487();
        entity.method_5647(tag);
        return tag.toString().contains(query);
    }

    private static boolean accumulateProgressWalk(TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt, double distance) {
        boolean changed = false;
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                Title.Condition c = t.conditions.get(idx);
                if (c.type != Title.Condition.Type.WALK_BLOCKS || c.distance <= 0L) continue;
                TitleConditionEvents.incrementProgress(pt, id, idx, Math.round(distance));
                state.method_80();
                changed = true;
            }
        }
        return changed;
    }

    private static boolean checkPeriodic(MinecraftServer server, class_3222 player, TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt) {
        boolean changed = false;
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id)) continue;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                int target;
                class_2487 tag;
                long prev;
                Title.Condition c = t.conditions.get(idx);
                if (c.type == Title.Condition.Type.OBTAIN_ITEM && c.item.isPresent()) {
                    boolean nowDone;
                    class_1792 wanted = (class_1792)class_7923.field_41178.method_10223(c.item.get());
                    int haveNow = player.method_31548().method_18861(wanted);
                    int target2 = Math.max(1, c.count);
                    class_2487 tag2 = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                    long prevBest = tag2.method_10537("c" + idx);
                    long newBest = Math.max(prevBest, (long)haveNow);
                    boolean prevDone = tag2.method_10577("done_" + idx);
                    boolean bl = nowDone = prevDone || newBest >= (long)target2;
                    if (newBest != prevBest) {
                        tag2.method_10544("c" + idx, newBest);
                        changed = true;
                    }
                    if (nowDone != prevDone) {
                        tag2.method_10556("done_" + idx, nowDone);
                        changed = true;
                    }
                    if (changed) {
                        state.method_80();
                    }
                }
                if (c.type == Title.Condition.Type.ADVANCEMENT && c.advancement.isPresent()) {
                    class_2960 advId = c.advancement.get();
                    class_8779 adv = server.method_3851().method_12896(advId);
                    if (adv != null && player.method_14236().method_12882(adv).method_740()) {
                        TitleConditionEvents.markDone(pt, id, idx);
                        state.method_80();
                        changed = true;
                    }
                }
                if (c.type == Title.Condition.Type.REACH_LEVEL_XP || c.type == Title.Condition.Type.REACH_LEVEL) {
                    int lvl = player.field_7520;
                    class_2487 tag3 = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                    tag3.method_10544("c" + idx, (long)lvl);
                    if (lvl >= c.level) {
                        tag3.method_10556("done_" + idx, true);
                        state.method_80();
                        changed = true;
                    }
                }
                if (c.type == Title.Condition.Type.REACH_LEVEL_PUFFERFISH) {
                    int lvl = TitleConditionEvents.computeTotalSkillsLevel(player);
                    class_2487 tag4 = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487());
                    tag4.method_10544("c" + idx, (long)Math.max(0, lvl));
                    boolean meets = lvl >= 0 && lvl >= c.level;
                    boolean prevDone = tag4.method_10577("done_" + idx);
                    if (meets != prevDone) {
                        tag4.method_10556("done_" + idx, meets);
                        state.method_80();
                        changed = true;
                    }
                }
                if (c.type == Title.Condition.Type.CRAFT_ITEM && c.item.isPresent()) {
                    int target3;
                    class_2487 tag5;
                    long prev2;
                    class_1792 it = (class_1792)class_7923.field_41178.method_10223(c.item.get());
                    int crafted = player.method_14248().method_15025(class_3468.field_15370.method_14956((Object)it));
                    if ((long)crafted > (prev2 = (tag5 = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487())).method_10537("c" + idx))) {
                        tag5.method_10544("c" + idx, (long)crafted);
                        changed = true;
                    }
                    if (crafted >= (target3 = Math.max(1, c.count))) {
                        tag5.method_10556("done_" + idx, true);
                        changed = true;
                    }
                    if (changed) {
                        state.method_80();
                    }
                }
                if (c.type != Title.Condition.Type.MINE_BLOCKS) continue;
                int minedTotal = 0;
                if (c.block.isPresent()) {
                    class_2248 b = (class_2248)class_7923.field_41175.method_10223(c.block.get());
                    minedTotal = player.method_14248().method_15025(class_3468.field_15427.method_14956((Object)b));
                }
                if ((long)minedTotal > (prev = (tag = pt.progress.computeIfAbsent(id.toString(), k -> new class_2487())).method_10537("c" + idx))) {
                    tag.method_10544("c" + idx, (long)minedTotal);
                    changed = true;
                }
                if (minedTotal >= (target = Math.max(1, c.count))) {
                    tag.method_10556("done_" + idx, true);
                    changed = true;
                }
                if (!changed) continue;
                state.method_80();
            }
        }
        return changed;
    }

    private static void checkCompletionAndGrant(MinecraftServer server, class_3222 player, TitlesPersistentState state, TitlesPersistentState.PlayerTitles pt) {
        for (Map.Entry<class_2960, Title> e : TitleConditionEvents.snapshotTitleEntries()) {
            class_2960 id = e.getKey();
            Title t = e.getValue();
            if (TitleConditionEvents.isAlreadyUnlocked(pt, id) || t.conditions.isEmpty()) continue;
            boolean allMet = true;
            for (int idx = 0; idx < t.conditions.size(); ++idx) {
                if (TitleConditionEvents.isConditionMet(pt, id, idx, t.conditions.get(idx))) continue;
                allMet = false;
                break;
            }
            if (!allMet) continue;
            boolean granted = TitleApi.grant(player, id);
            state.method_80();
            TitleNet.syncSelfTo(server, player);
            TitleNet.syncProgressTo(server, player);
        }
    }

    private static boolean isConditionMet(TitlesPersistentState.PlayerTitles pt, class_2960 titleId, int idx, Title.Condition c) {
        class_2487 tag = pt.progress.get(titleId.toString());
        if (tag != null && tag.method_10577("done_" + idx)) {
            return true;
        }
        long current = tag == null ? 0L : tag.method_10537("c" + idx);
        return switch (c.type) {
            default -> throw new MatchException(null, null);
            case Title.Condition.Type.OBTAIN_ITEM, Title.Condition.Type.ADVANCEMENT, Title.Condition.Type.REACH_LEVEL, Title.Condition.Type.REACH_LEVEL_XP, Title.Condition.Type.REACH_LEVEL_PUFFERFISH, Title.Condition.Type.VISIT_BIOME, Title.Condition.Type.ENTER_DIMENSION, Title.Condition.Type.INTERACT_BLOCK, Title.Condition.Type.INTERACT_ENTITY, Title.Condition.Type.CHECK_ATTRIBUTE, Title.Condition.Type.FIND_STRUCTURE -> {
                if (tag != null && tag.method_10577("done_" + idx)) {
                    yield true;
                }
                yield false;
            }
            case Title.Condition.Type.KILL_MOBS -> {
                if (current >= (long)Math.max(1, c.count)) {
                    yield true;
                }
                yield false;
            }
            case Title.Condition.Type.WALK_BLOCKS -> {
                if (current >= Math.max(1L, c.distance)) {
                    yield true;
                }
                yield false;
            }
            case Title.Condition.Type.CRAFT_ITEM -> {
                if (current >= (long)Math.max(1, c.count)) {
                    yield true;
                }
                yield false;
            }
            case Title.Condition.Type.MINE_BLOCKS -> {
                if (current >= (long)Math.max(1, c.count)) {
                    yield true;
                }
                yield false;
            }
            case Title.Condition.Type.DEAL_DAMAGE_TOTAL, Title.Condition.Type.DEAL_DAMAGE_MAX -> current >= (long)Math.max(1, c.count);
        };
    }

    private static void incrementProgress(TitlesPersistentState.PlayerTitles pt, class_2960 titleId, int idx, long inc) {
        class_2487 tag = pt.progress.computeIfAbsent(titleId.toString(), k -> new class_2487());
        long cur = tag.method_10537("c" + idx);
        tag.method_10544("c" + idx, cur + inc);
    }

    private static void markDone(TitlesPersistentState.PlayerTitles pt, class_2960 titleId, int idx) {
        class_2487 tag = pt.progress.computeIfAbsent(titleId.toString(), k -> new class_2487());
        tag.method_10556("done_" + idx, true);
    }

    private static boolean isAlreadyUnlocked(TitlesPersistentState.PlayerTitles pt, class_2960 titleId) {
        return pt.unlocked.contains(titleId.toString());
    }

    private static boolean puffishLoaded() {
        return FabricLoader.getInstance().isModLoaded("puffish_skills");
    }

    private static int computeTotalSkillsLevel(class_3222 player) {
        if (!TitleConditionEvents.puffishLoaded()) {
            return -1;
        }
        try {
            SkillsMod mod = SkillsMod.getInstance();
            if (mod == null) {
                return -1;
            }
            int total = 0;
            for (class_2960 cat : mod.getUnlockedCategories(player)) {
                total += mod.getCurrentLevel(player, cat).orElse(0).intValue();
            }
            return total;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private static List<Map.Entry<class_2960, Title>> snapshotTitleEntries() {
        Map<class_2960, Title> map = TitleRegistry.all();
        ArrayList<Map.Entry<class_2960, Title>> list = new ArrayList<Map.Entry<class_2960, Title>>(map.size());
        map.forEach((id, t) -> list.add(Map.entry(id, t)));
        return list;
    }
}

