/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public final class TitlesPersistentState
extends class_18 {
    public static final String KEY = "rpgsystems_titles";
    public static final class_18.class_8645<TitlesPersistentState> TYPE = new class_18.class_8645(TitlesPersistentState::new, TitlesPersistentState::fromNbt, null);
    private final Map<UUID, PlayerTitles> data = new HashMap<UUID, PlayerTitles>();

    public static TitlesPersistentState get(MinecraftServer server) {
        return (TitlesPersistentState)server.method_3847(class_1937.field_25179).method_17983().method_17924(TYPE, KEY);
    }

    private static TitlesPersistentState fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        TitlesPersistentState s = new TitlesPersistentState();
        class_2499 players = nbt.method_10554("Players", 10);
        for (int i = 0; i < players.size(); ++i) {
            class_2487 row = players.method_10602(i);
            UUID u = row.method_25926("Uuid");
            PlayerTitles pt = new PlayerTitles();
            class_2499 unlocked = row.method_10554("Unlocked", 8);
            for (int j = 0; j < unlocked.size(); ++j) {
                pt.unlocked.add(unlocked.method_10608(j));
            }
            if (row.method_10573("Active", 8)) {
                pt.active = row.method_10558("Active");
            }
            if (row.method_10573("Progress", 10)) {
                class_2487 prog = row.method_10562("Progress");
                for (String key : prog.method_10541()) {
                    pt.progress.put(key, prog.method_10562(key));
                }
            }
            if (row.method_10573("PermaDisabled", 9)) {
                class_2499 dl = row.method_10554("PermaDisabled", 8);
                for (int j = 0; j < dl.size(); ++j) {
                    pt.permaDisabledGroups.add(dl.method_10608(j));
                }
            }
            s.data.put(u, pt);
        }
        return s;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2499 players = new class_2499();
        for (Map.Entry<UUID, PlayerTitles> e : this.data.entrySet()) {
            class_2487 row = new class_2487();
            row.method_25927("Uuid", e.getKey());
            class_2499 unlocked = new class_2499();
            for (String id : e.getValue().unlocked) {
                unlocked.add((Object)class_2519.method_23256((String)id));
            }
            row.method_10566("Unlocked", (class_2520)unlocked);
            if (e.getValue().active != null) {
                row.method_10582("Active", e.getValue().active);
            }
            if (!e.getValue().progress.isEmpty()) {
                class_2487 prog = new class_2487();
                for (Map.Entry<String, class_2487> p : e.getValue().progress.entrySet()) {
                    prog.method_10566(p.getKey(), (class_2520)p.getValue());
                }
                row.method_10566("Progress", (class_2520)prog);
            }
            if (!e.getValue().permaDisabledGroups.isEmpty()) {
                class_2499 dl = new class_2499();
                for (String k : e.getValue().permaDisabledGroups) {
                    dl.add((Object)class_2519.method_23256((String)k));
                }
                row.method_10566("PermaDisabled", (class_2520)dl);
            }
            players.add((Object)row);
        }
        nbt.method_10566("Players", (class_2520)players);
        return nbt;
    }

    public PlayerTitles getOrCreate(UUID uuid) {
        return this.data.computeIfAbsent(uuid, u -> new PlayerTitles());
    }

    public static final class PlayerTitles {
        public final Set<String> unlocked = new HashSet<String>();
        public final Map<String, class_2487> progress = new HashMap<String, class_2487>();
        public String active;
        public final Set<String> permaDisabledGroups = new HashSet<String>();
    }
}

