/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title.power;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.title.power.TitlePower;

public final class PowerRegistry {
    private static final Map<class_2960, TitlePower> POWERS = new HashMap<class_2960, TitlePower>();
    private static final Map<class_2960, Set<UUID>> ACTIVE = new HashMap<class_2960, Set<UUID>>();
    private static boolean registeredTick = false;

    private PowerRegistry() {
    }

    public static void register(TitlePower power) {
        Objects.requireNonNull(power, "power");
        class_2960 id = power.id();
        POWERS.put(id, power);
        ACTIVE.computeIfAbsent(id, k -> new HashSet());
    }

    public static Optional<TitlePower> get(class_2960 id) {
        return Optional.ofNullable(POWERS.get(id));
    }

    public static void activate(class_2960 powerId, class_3222 player) {
        TitlePower power = POWERS.get(powerId);
        if (power == null) {
            return;
        }
        Set set = ACTIVE.computeIfAbsent(powerId, k -> new HashSet());
        if (set.add(player.method_5667())) {
            power.onActivate(player);
        }
    }

    public static void deactivate(class_2960 powerId, class_3222 player) {
        TitlePower power = POWERS.get(powerId);
        if (power == null) {
            return;
        }
        Set<UUID> set = ACTIVE.get(powerId);
        if (set != null && set.remove(player.method_5667())) {
            power.onDeactivate(player);
        }
    }

    public static void registerServerTick() {
        if (registeredTick) {
            return;
        }
        registeredTick = true;
        ServerTickEvents.START_SERVER_TICK.register(PowerRegistry::onServerTick);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.field_14140;
            UUID uuid = player.method_5667();
            for (Map.Entry<class_2960, Set<UUID>> e : ACTIVE.entrySet()) {
                TitlePower p;
                if (!e.getValue().remove(uuid) || (p = POWERS.get(e.getKey())) == null) continue;
                p.onDeactivate(player);
            }
        });
    }

    private static void onServerTick(MinecraftServer server) {
        for (Map.Entry<class_2960, Set<UUID>> e : ACTIVE.entrySet()) {
            class_2960 id = e.getKey();
            TitlePower power = POWERS.get(id);
            if (power == null) continue;
            HashSet<class_3222> players = new HashSet<class_3222>();
            Iterator<UUID> it = e.getValue().iterator();
            while (it.hasNext()) {
                UUID uuid = it.next();
                class_3222 sp = server.method_3760().method_14602(uuid);
                if (sp == null) {
                    it.remove();
                    continue;
                }
                players.add(sp);
            }
            if (players.isEmpty()) continue;
            power.onServerTick(server, players);
        }
    }

    public static boolean isActive(class_2960 powerId, UUID uuid) {
        Set<UUID> set = ACTIVE.get(powerId);
        return set != null && set.contains(uuid);
    }
}

