/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.util;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1282;

public final class DamageCritLinks {
    private static final Map<class_1282, Info> MAP = new WeakHashMap<class_1282, Info>();

    private DamageCritLinks() {
    }

    public static void link(class_1282 src, Kind kind, Integer colorOverride) {
        if (src == null || kind == null) {
            return;
        }
        MAP.put(src, new Info(kind, colorOverride));
    }

    public static Info consume(class_1282 src) {
        if (src == null) {
            return Info.none();
        }
        Info i = MAP.remove(src);
        return i == null ? Info.none() : i;
    }

    public static void clear(class_1282 src) {
        if (src != null) {
            MAP.remove(src);
        }
    }

    public static final class Info {
        public final Kind kind;
        public final Integer colorOverride;

        public Info(Kind kind, Integer colorOverride) {
            this.kind = kind;
            this.colorOverride = colorOverride;
        }

        public boolean isCrit() {
            return this.kind != Kind.NONE;
        }

        public boolean isMagic() {
            return this.kind == Kind.MAGIC;
        }

        public static Info none() {
            return new Info(Kind.NONE, null);
        }
    }

    public static enum Kind {
        NONE,
        MELEE,
        MAGIC;

    }
}

