/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.pixeldreamstudios.rpgsystems.title.PermaGroupKey;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitlesPersistentState;
import net.pixeldreamstudios.rpgsystems.title.power.PowerRegistry;

public final class TitlePowerBonusUtil {
    private static final Map<UUID, Set<class_2960>> PERMA_INSTALLED = new HashMap<UUID, Set<class_2960>>();

    private TitlePowerBonusUtil() {
    }

    public static void installTitlePowers(class_3222 player, class_2960 titleId, List<class_2960> powers) {
        if (powers == null || powers.isEmpty()) {
            TitlePowerBonusUtil.uninstallEquippedTitlePowers(player, titleId, Collections.emptyList());
            return;
        }
        for (class_2960 pid : powers) {
            PowerRegistry.activate(pid, player);
        }
    }

    public static void uninstallEquippedTitlePowers(class_3222 player, class_2960 titleId, List<class_2960> equippedPowerIds) {
        for (class_2960 pid : equippedPowerIds) {
            PowerRegistry.deactivate(pid, player);
        }
    }

    public static void uninstallTitlePowers(class_3222 player, Title t) {
        for (Title.Bonus b : t.bonuses) {
            if (b.powerId == null || !b.powerId.isPresent()) continue;
            PowerRegistry.deactivate(b.powerId.get(), player);
        }
    }

    public static void rebuildPermaTitlePowers(class_3222 player, Collection<Title> unlockedTitles) {
        UUID key = player.method_5667();
        Set previous = PERMA_INSTALLED.getOrDefault(key, Collections.emptySet());
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        Set<String> disabled = pt.permaDisabledGroups;
        HashSet<class_2960> desired = new HashSet<class_2960>();
        if (unlockedTitles != null) {
            for (Title t : unlockedTitles) {
                for (Title.Bonus b : t.permaBonuses) {
                    class_2960 pid;
                    String gk;
                    if (b.powerId == null || !b.powerId.isPresent() || disabled.contains(gk = PermaGroupKey.power(pid = b.powerId.get()))) continue;
                    desired.add(pid);
                }
            }
        }
        for (class_2960 pid : previous) {
            if (desired.contains(pid)) continue;
            PowerRegistry.deactivate(pid, player);
        }
        for (class_2960 pid : desired) {
            if (previous.contains(pid)) continue;
            PowerRegistry.activate(pid, player);
        }
        PERMA_INSTALLED.put(key, desired);
    }

    public static void rebuildAllTitlePowers(class_3222 player, Title equipped, Collection<Title> unlockedTitles) {
        if (equipped != null) {
            List<class_2960> equippedPowerIds = equipped.bonuses.stream().filter(b -> b.powerId != null && b.powerId.isPresent()).map(b -> b.powerId.get()).collect(Collectors.toList());
            TitlePowerBonusUtil.installTitlePowers(player, equipped.id, equippedPowerIds);
        }
        TitlePowerBonusUtil.rebuildPermaTitlePowers(player, unlockedTitles);
    }
}

