/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class MiscClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "rpgsystems_misc_client.json";
    private static MiscClientConfig INSTANCE;
    public int inviteHudX = 0;
    public int inviteHudY = 10;
    public int joinRequestHudX = 0;
    public int joinRequestHudY = 10;
    public int inviteInventoryX = 8;
    public int inviteInventoryY = 8;
    public int handledTitlesBtnOffsetX = 64;
    public int handledTitlesBtnOffsetY = 67;
    public int handledPartyBtnOffsetX = 28;
    public int handledPartyBtnOffsetY = 67;

    private static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve(FILE_NAME);
    }

    public static synchronized MiscClientConfig get() {
        if (INSTANCE == null) {
            MiscClientConfig.load();
        }
        return INSTANCE;
    }

    public static synchronized void load() {
        Path p = MiscClientConfig.path();
        if (Files.exists(p, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(p);){
                INSTANCE = (MiscClientConfig)GSON.fromJson((Reader)r, MiscClientConfig.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (INSTANCE == null) {
            INSTANCE = new MiscClientConfig();
        }
        MiscClientConfig.save();
    }

    public static synchronized void save() {
        try {
            Files.createDirectories(MiscClientConfig.path().getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(MiscClientConfig.path(), new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resetDefaults() {
        this.inviteHudX = 0;
        this.inviteHudY = 10;
        this.joinRequestHudX = 0;
        this.joinRequestHudY = 10;
        this.inviteInventoryX = 8;
        this.inviteInventoryY = 8;
        this.handledTitlesBtnOffsetX = 64;
        this.handledTitlesBtnOffsetY = 67;
        this.handledPartyBtnOffsetX = 28;
        this.handledPartyBtnOffsetY = 67;
    }
}

