/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.pixeldreamstudios.rpgsystems.client.enemy.config.DamageNumbersClientConfig;
import net.pixeldreamstudios.rpgsystems.client.enemy.config.DamageTypeConfig;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class DamageNumbersRenderer {
    private static final int LIFETIME_TICKS = 26;
    private static final float BASE_RISE_PER_SEC = 0.8f;
    private static final float DRIFT_PER_SEC = 0.35f;
    private static final float HORIZONTAL_JITTER = 0.18f;
    private static final float FORWARD_OFFSET = 0.55f;
    private static final float ROTATE_AMPLITUDE_DEG = 6.0f;
    private static final int POP_TICKS = 6;
    private static final float POP_OVERSHOOT = 1.2f;
    private static final float BASE_SCALE = 0.025f;
    private static final float DIST_SCALE_MULT = 0.035f;
    private static final float CRIT_SCALE_MULT = 1.15f;
    private static final float Y_EXTRA = 0.15f;
    private static final float ANCHOR_FRACTION = 0.72f;
    private static final int MAX_ACTIVE = 256;
    private static final List<Floating> ACTIVE = new ArrayList<Floating>();

    private DamageNumbersRenderer() {
    }

    public static void init() {
        WorldRenderEvents.AFTER_ENTITIES.register(DamageNumbersRenderer::onRender);
        ClientPlayConnectionEvents.JOIN.register((h, s, c) -> ACTIVE.clear());
        ClientPlayConnectionEvents.DISCONNECT.register((h, c) -> ACTIVE.clear());
    }

    public static void spawn(int entityId, float amount, boolean crit, boolean isPet, int rgbFromServer, UUID sourceUuid, class_2960 damageTypeId) {
        int finalRgb;
        class_310 mc = class_310.method_1551();
        DamageNumbersClientConfig cfg = DamageNumbersClientConfig.get();
        DamageTypeConfig cfgDT = DamageTypeConfig.get();
        if (!cfg.enabled || mc == null || mc.field_1687 == null) {
            return;
        }
        if (cfg.showMode == DamageNumbersClientConfig.ShowMode.NONE) {
            return;
        }
        if (cfg.showMode == DamageNumbersClientConfig.ShowMode.PLAYERS_ONLY) {
            boolean allowed;
            boolean fromPlayer = sourceUuid != null && mc.field_1687.method_18470(sourceUuid) != null;
            boolean bl = allowed = fromPlayer || isPet;
            if (!allowed) {
                return;
            }
        }
        if (isPet && !cfg.showPetDamage) {
            return;
        }
        if (cfg.onlyShowPartyDamage && !DamageNumbersRenderer.isFromMyParty(sourceUuid)) {
            return;
        }
        if (damageTypeId != null && !cfgDT.shouldShowType(damageTypeId)) {
            return;
        }
        Integer override = damageTypeId != null ? cfgDT.colorOverride(damageTypeId) : null;
        int n = finalRgb = override != null ? override : rgbFromServer;
        if (ACTIVE.size() >= 256) {
            ACTIVE.remove(0);
        }
        ACTIVE.add(new Floating(mc, entityId, amount, crit, isPet, finalRgb, sourceUuid, mc.field_1687.method_8510()));
    }

    private static void onRender(WorldRenderContext context) {
        if (ACTIVE.isEmpty()) {
            return;
        }
        DamageNumbersClientConfig cfg = DamageNumbersClientConfig.get();
        if (!cfg.enabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null || mc.field_1690.field_1842) {
            return;
        }
        class_638 world = context.world();
        class_4184 camera = context.camera();
        class_4597 consumers = context.consumers();
        if (world == null || camera == null || consumers == null) {
            return;
        }
        long now = world.method_8510();
        float tickDelta = mc.method_60646().method_60637(false);
        class_243 camPos = camera.method_19326();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        double maxDistSq = cfg.viewDistanceSq();
        for (int i = ACTIVE.size() - 1; i >= 0; --i) {
            double dz;
            double dx;
            Floating f = ACTIVE.get(i);
            class_1297 e = world.method_8469(f.entityId);
            class_1309 living = e instanceof class_1309 ? (class_1309)e : null;
            int ageTicks = (int)(now - f.spawnTick);
            if (ageTicks >= 26) {
                ACTIVE.remove(i);
                continue;
            }
            if (living != null && f.needsBootstrap()) {
                f.bootstrapFromEntity(living);
            }
            if (f.needsBootstrap() || (dx = f.baseX - camPos.field_1352) * dx + (dz = f.baseZ - camPos.field_1350) * dz > maxDistSq) continue;
            float tLife = ((float)ageTicks + tickDelta) / 26.0f;
            float riseEase = DamageNumbersRenderer.easeOutCubic(tLife);
            float rise = riseEase * 0.8f;
            float drift = ((float)ageTicks + tickDelta) / 20.0f * 0.35f;
            class_243 toCam = new class_243(camPos.field_1352 - f.baseX, 0.0, camPos.field_1350 - f.baseZ);
            if (toCam.method_1027() < 1.0E-6) {
                toCam = new class_243(0.0, 0.0, 1.0);
            }
            class_243 dir = toCam.method_1029();
            class_243 perp = new class_243(-dir.field_1350, 0.0, dir.field_1352).method_1029().method_1021((double)f.jitter);
            class_243 pos = new class_243(f.baseX, f.baseY + (double)rise, f.baseZ).method_1019(dir.method_1021((double)0.55f)).method_1019(perp.method_1021(1.0 + (double)drift));
            float alpha = DamageNumbersRenderer.computeAlpha(ageTicks, tickDelta);
            float dist = (float)Math.sqrt(dx * dx + dz * dz);
            float distScale = 0.025f * (1.0f + dist * 0.035f);
            float popMul = 1.0f;
            float popT = DamageNumbersRenderer.clamp01(((float)ageTicks + tickDelta) / 6.0f);
            if (popT < 1.0f) {
                float popEase = DamageNumbersRenderer.easeOutCubic(1.0f - popT);
                popMul = 1.0f + 0.20000005f * popEase;
            }
            float critMul = f.crit ? 1.15f : 1.0f;
            float scale = distScale * popMul * critMul;
            float tilt = (float)Math.sin((f.seed + (float)ageTicks + tickDelta) * 0.35f) * 6.0f;
            int rgb = f.rgb;
            if (f.crit) {
                alpha = DamageNumbersRenderer.clamp01(alpha * 1.05f);
            }
            DamageNumbersRenderer.drawTextAt((int)(alpha * 255.0f), rgb, f.displayText, pos, camera, context.matrixStack(), context.consumers(), scale, tilt);
        }
    }

    private static boolean isFromMyParty(UUID sourceUuid) {
        if (sourceUuid == null) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return false;
        }
        if (sourceUuid.equals(mc.field_1724.method_5667())) {
            return true;
        }
        return ClientPartyHudData.isInMyParty(sourceUuid);
    }

    private static void drawTextAt(int alpha255, int rgb, String text, class_243 pos, class_4184 camera, class_4587 ms, class_4597 vcp, float scale, float tiltDeg) {
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        class_243 cam = camera.method_19326();
        ms.method_22903();
        ms.method_22904(pos.field_1352 - cam.field_1352, pos.field_1351 - cam.field_1351, pos.field_1350 - cam.field_1350);
        ms.method_22907(camera.method_23767());
        ms.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        ms.method_22907(class_7833.field_40718.rotationDegrees(tiltDeg));
        ms.method_22905(-scale, -scale, scale);
        int widthPixels = tr.method_1727(text);
        float x = (float)(-widthPixels) / 2.0f;
        float y = 0.0f;
        int a = alpha255 & 0xFF;
        int argb = a << 24 | rgb & 0xFFFFFF;
        int light = class_765.method_23687((int)15, (int)15);
        Matrix4f mat = ms.method_23760().method_23761();
        tr.method_27521(text, x, y, argb, true, mat, vcp, class_327.class_6415.field_33993, 0, light);
        ms.method_22909();
    }

    private static float computeAlpha(int ageTicks, float tickDelta) {
        float t = ((float)ageTicks + tickDelta) / 26.0f;
        float in = DamageNumbersRenderer.clamp01(((float)ageTicks + tickDelta) / 4.0f);
        float out = DamageNumbersRenderer.clamp01(1.0f - t);
        return DamageNumbersRenderer.clamp01(DamageNumbersRenderer.easeOutCubic(in) * DamageNumbersRenderer.easeOutCubic(out) * 1.05f);
    }

    private static float easeOutCubic(float x) {
        float inv = 1.0f - DamageNumbersRenderer.clamp01(x);
        return 1.0f - inv * inv * inv;
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static final class Floating {
        final int entityId;
        final String displayText;
        final boolean crit;
        final boolean pet;
        final int rgb;
        final UUID sourceUuid;
        final long spawnTick;
        final float jitter;
        final float seed;
        double baseX = Double.NaN;
        double baseY = Double.NaN;
        double baseZ = Double.NaN;

        Floating(class_310 mc, int entityId, float amount, boolean crit, boolean pet, int rgb, UUID sourceUuid, long spawnTick) {
            class_1297 e;
            this.entityId = entityId;
            String base = Floating.formatAmount(amount);
            this.displayText = crit ? base + "!" : base;
            this.crit = crit;
            this.pet = pet;
            this.rgb = rgb;
            this.sourceUuid = sourceUuid;
            this.spawnTick = spawnTick;
            this.jitter = (float)((Math.random() - 0.5) * 2.0 * (double)0.18f);
            this.seed = (float)Math.random() * 10000.0f;
            if (mc.field_1687 != null && (e = mc.field_1687.method_8469(entityId)) instanceof class_1309) {
                class_1309 living = (class_1309)e;
                this.bootstrapFromEntity(living);
            }
        }

        static String formatAmount(float amount) {
            long rounded;
            float abs = Math.abs(amount);
            if (Math.abs(abs - (float)(rounded = (long)Math.round(abs))) < 0.005f) {
                return Long.toString(rounded);
            }
            String s = String.format(Locale.ROOT, "%.2f", Float.valueOf(abs));
            int dot = s.indexOf(46);
            if (dot >= 0) {
                int end;
                for (end = s.length(); end > dot + 1 && s.charAt(end - 1) == '0'; --end) {
                }
                if (end == dot + 1) {
                    end = dot;
                }
                s = s.substring(0, end);
            }
            return s;
        }

        boolean needsBootstrap() {
            return Double.isNaN(this.baseX) || Double.isNaN(this.baseY) || Double.isNaN(this.baseZ);
        }

        void bootstrapFromEntity(class_1309 living) {
            class_238 b = living.method_5829();
            double height = b.method_17940();
            double anchorY = b.field_1322 + height * (double)0.72f;
            this.baseX = living.method_23317();
            this.baseY = anchorY + (double)0.15f;
            this.baseZ = living.method_23321();
        }
    }
}

