/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import net.pixeldreamstudios.rpgsystems.client.enemy.config.EnemyHudClientConfig;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class EnemyHealthBarRenderer {
    private static final class_2960 TEX_BAR = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/enemy/hp_bar.png");
    private static final class_2960 TEX_BORDER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/enemy/hp_border.png");
    private static final class_2960 TEX_ABSORB = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/enemy/absorption_bar.png");
    private static final float BASE_W_PX = 192.0f;
    private static final float BASE_H_PX = 44.0f;
    private static final float BASE_SCALE = 2.0f;
    private static final float BASE_WORLD_W = 0.9f;
    private static final float MIN_ALPHA_FAR = 0.25f;
    private static final int VISIBLE_TICKS = 100;
    private static final int FADE_IN_TICKS = 8;
    private static final int FADE_OUT_TICKS = 12;
    private static final float DRAIN_RATE_PER_SEC = 0.6f;
    private static final float Y_OFFSET = 0.3f;
    private static final double MAX_DISTANCE_SQ = 2304.0;
    private static final float MIN_SLIVER_TEXELS = 2.0f;
    private static final float MIN_SLIVER_PCT = 0.010416667f;
    private static final Map<Integer, HudState> HUD = new ConcurrentHashMap<Integer, HudState>();
    private static final Map<Integer, Float> ABS_RAW = new ConcurrentHashMap<Integer, Float>();

    private EnemyHealthBarRenderer() {
    }

    public static void onAbsorptionSync(int entityId, float absorptionRaw) {
        ABS_RAW.put(entityId, Float.valueOf(absorptionRaw));
    }

    public static void init() {
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (!world.field_9236) {
                return class_1269.field_5811;
            }
            if (!EnemyHudClientConfig.get().showHealthbarOnNearbyHpChanges) {
                return class_1269.field_5811;
            }
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1724 != player) {
                return class_1269.field_5811;
            }
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                if (EnemyHealthBarRenderer.isInvisibleToClient(living)) {
                    return class_1269.field_5811;
                }
                long now = world.method_8510();
                float pct = EnemyHealthBarRenderer.clamp01((float)((double)living.method_6032() / Math.max(1.0E-6, (double)living.method_6063())));
                HUD.compute(entity.method_5628(), (k, st) -> st == null ? new HudState(now, pct) : EnemyHealthBarRenderer.setHitTime(st, now));
            }
            return class_1269.field_5811;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            HUD.clear();
            ABS_RAW.clear();
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            HUD.clear();
            ABS_RAW.clear();
        });
        WorldRenderEvents.LAST.register(context -> {
            class_638 world = context.world();
            class_4587 matrices = context.matrixStack();
            class_4184 camera = context.camera();
            if (world == null) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (client == null || client.field_1690.field_1842) {
                return;
            }
            class_243 camPos = camera.method_19326();
            float tickDelta = client.method_60646().method_60637(false);
            long nowTick = world.method_8510();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            for (class_1297 entity : world.method_18112()) {
                float maxDist;
                class_238 box;
                double distSq;
                float visAlpha;
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                if (!living.method_5805()) {
                    HUD.remove(entity.method_5628());
                    ABS_RAW.remove(entity.method_5628());
                    continue;
                }
                if (living instanceof class_1657 && client.field_1724 != null && living.method_5628() == client.field_1724.method_5628()) continue;
                if (EnemyHealthBarRenderer.isInvisibleToClient(living)) {
                    HUD.remove(entity.method_5628());
                    ABS_RAW.remove(entity.method_5628());
                    continue;
                }
                HudState st = HUD.get(entity.method_5628());
                if (st == null) continue;
                long sinceFirst = nowTick - st.firstShownTick;
                long sinceHit = nowTick - st.lastHitTick;
                if (sinceFirst <= 8L) {
                    visAlpha = EnemyHealthBarRenderer.clamp01((float)sinceFirst / 8.0f);
                } else if (sinceHit <= 100L) {
                    visAlpha = 1.0f;
                } else if (sinceHit <= 112L) {
                    visAlpha = EnemyHealthBarRenderer.clamp01(1.0f - (float)(sinceHit - 100L) / 12.0f);
                } else {
                    HUD.remove(entity.method_5628());
                    ABS_RAW.remove(entity.method_5628());
                    continue;
                }
                if (visAlpha <= 0.01f || (distSq = entity.method_5649(camPos.field_1352, camPos.field_1351, camPos.field_1350)) > 2304.0) continue;
                float instantPct = EnemyHealthBarRenderer.clamp01((float)((double)living.method_6032() / Math.max(1.0E-6, (double)living.method_6063())));
                long dtTicks = Math.max(0L, nowTick - st.lastWorldTick);
                if (dtTicks > 0L) {
                    float absInstantPct;
                    float dtSec = (float)dtTicks / 20.0f;
                    if (instantPct + 5.0E-4f < st.lastInstantPct) {
                        st.delayedDamagePct = Math.max(st.delayedDamagePct, st.lastInstantPct);
                        st.delayedHealPct = instantPct;
                    } else if (instantPct - 5.0E-4f > st.lastInstantPct) {
                        st.delayedHealPct = Math.min(st.delayedHealPct, st.lastInstantPct);
                        st.delayedDamagePct = instantPct;
                    }
                    st.delayedDamagePct = st.delayedDamagePct > instantPct ? Math.max(instantPct, st.delayedDamagePct - 0.6f * dtSec) : instantPct;
                    st.delayedHealPct = st.delayedHealPct < instantPct ? Math.min(instantPct, st.delayedHealPct + 0.6f * dtSec) : instantPct;
                    st.lastInstantPct = instantPct;
                    float maxHp = Math.max(1.0E-6f, living.method_6063());
                    float raw = ABS_RAW.getOrDefault(entity.method_5628(), Float.valueOf(0.0f)).floatValue();
                    st.absInstantPct = absInstantPct = EnemyHealthBarRenderer.clamp01(raw / maxHp);
                    if (absInstantPct + 5.0E-4f < st.lastAbsInstant) {
                        st.absDelayedPct = Math.max(st.absDelayedPct, st.lastAbsInstant);
                    }
                    st.absDelayedPct = st.absDelayedPct > absInstantPct ? Math.max(absInstantPct, st.absDelayedPct - 0.6f * dtSec) : absInstantPct;
                    st.lastAbsInstant = absInstantPct;
                    st.lastWorldTick = nowTick;
                }
                if (instantPct <= 0.0f && st.delayedDamagePct <= 0.0f && st.delayedHealPct <= 0.0f && st.absInstantPct <= 0.0f && st.absDelayedPct <= 0.0f || !EnemyHealthBarRenderer.isOnScreen(context, box = living.method_5829())) continue;
                int extra = Math.max(0, (int)Math.floor(box.method_17940() - 2.0));
                float dynScale = 2.0f + (float)extra;
                float worldW = 0.9f * dynScale;
                float worldH = worldW * 0.22916667f;
                float dist = (float)Math.sqrt(distSq);
                float t = EnemyHealthBarRenderer.clamp01(dist / (maxDist = (float)Math.sqrt(2304.0)));
                float nearFactor = 1.0f - t;
                float distanceAlpha = 0.25f + 0.75f * nearFactor;
                float finalAlpha = EnemyHealthBarRenderer.clamp01(visAlpha * distanceAlpha);
                if (finalAlpha <= 0.01f) continue;
                double ex = EnemyHealthBarRenderer.lerp(tickDelta, living.field_6014, living.method_23317());
                double ey = EnemyHealthBarRenderer.lerp(tickDelta, living.field_6036, living.method_23318());
                double ez = EnemyHealthBarRenderer.lerp(tickDelta, living.field_5969, living.method_23321());
                double head = box.method_17940() + (double)0.3f;
                matrices.method_22903();
                matrices.method_22904(ex - camPos.field_1352, ey - camPos.field_1351 + head, ez - camPos.field_1350);
                EnemyHealthBarRenderer.faceCamera(matrices, camera);
                matrices.method_22905(worldW, worldH, 1.0f);
                EnemyHealthBarRenderer.drawBars(matrices, instantPct, st.delayedDamagePct, st.delayedHealPct, st.absInstantPct, st.absDelayedPct, finalAlpha);
                matrices.method_22909();
            }
        });
    }

    private static boolean isInvisibleToClient(class_1309 living) {
        class_746 viewer;
        class_310 mc = class_310.method_1551();
        class_746 class_7462 = viewer = mc != null ? mc.field_1724 : null;
        if (living.method_5767()) {
            return true;
        }
        if (viewer != null && living.method_5756((class_1657)viewer)) {
            return true;
        }
        return living.method_6059(class_1294.field_5905);
    }

    private static HudState setHitTime(HudState st, long now) {
        st.lastHitTick = now;
        return st;
    }

    public static void pokeOnHpChange(int targetEntityId) {
        if (!EnemyHudClientConfig.get().showHealthbarOnNearbyHpChanges) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_1297 e = mc.field_1687.method_8469(targetEntityId);
        if (!(e instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)e;
        if (living instanceof class_1657 && living.method_5628() == mc.field_1724.method_5628()) {
            return;
        }
        if (EnemyHealthBarRenderer.isInvisibleToClient(living)) {
            HUD.remove(living.method_5628());
            ABS_RAW.remove(living.method_5628());
            return;
        }
        double dSq = living.method_5858((class_1297)mc.field_1724);
        if (dSq > 2304.0) {
            return;
        }
        long now = mc.field_1687.method_8510();
        float pct = EnemyHealthBarRenderer.clamp01((float)((double)living.method_6032() / Math.max(1.0E-6, (double)living.method_6063())));
        HUD.compute(living.method_5628(), (k, st) -> st == null ? new HudState(now, pct) : EnemyHealthBarRenderer.setHitTime(st, now));
    }

    private static boolean isOnScreen(WorldRenderContext context, class_238 box) {
        class_4604 frustum = context.frustum();
        return frustum == null || frustum.method_23093(box);
    }

    private static void faceCamera(class_4587 matrices, class_4184 camera) {
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
    }

    private static void drawBars(class_4587 matrices, float instantPct, float delayedDamagePct, float delayedHealPct, float absInstantPct, float absDelayedPct, float alpha) {
        float x1;
        float x0;
        float absInstDraw;
        float absDmgFrom;
        float x12;
        float x02;
        float healTo;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
        float halfW = 0.5f;
        float halfH = 0.5f;
        float onePx = 0.022727273f;
        float barTop = halfH - onePx;
        float barBot = -halfH - onePx;
        float Z_BORDER = -1.0E-4f;
        float Z_HP = -3.0E-4f;
        float Z_ABS = -6.0E-4f;
        int light = class_765.method_23687((int)15, (int)15);
        Matrix4f mat = matrices.method_23760().method_23761();
        float leftX = -halfW;
        float rightX = halfW;
        float width = rightX - leftX;
        float vTop = 1.0f;
        float vBot = 0.0f;
        float instDrawPct = instantPct > 0.0f ? EnemyHealthBarRenderer.clamp01(Math.max(instantPct, 0.010416667f)) : 0.0f;
        float dmgFrom = Math.max(instDrawPct, delayedDamagePct);
        if (dmgFrom - instDrawPct > 0.010416667f) {
            float x03 = rightX - width * dmgFrom;
            float x13 = rightX - width * instDrawPct;
            EnemyHealthBarRenderer.drawTexturedQuadZ(TEX_BAR, mat, x03, barBot, x13, barTop, dmgFrom, vTop, instDrawPct, vBot, light, 1.0f, 0.35f, 0.35f, alpha, -3.0E-4f);
        }
        if (instDrawPct - (healTo = Math.min(instDrawPct, Math.max(delayedHealPct, 0.0f))) > 0.010416667f) {
            x02 = rightX - width * instDrawPct;
            x12 = rightX - width * healTo;
            EnemyHealthBarRenderer.drawTexturedQuadZ(TEX_BAR, mat, x02, barBot, x12, barTop, instDrawPct, vTop, healTo, vBot, light, 0.35f, 1.0f, 0.35f, alpha, -3.0E-4f);
        }
        if (instDrawPct > 0.0f) {
            x02 = rightX - width * instDrawPct;
            x12 = rightX;
            EnemyHealthBarRenderer.drawTexturedQuadZ(TEX_BAR, mat, x02, barBot, x12, barTop, instDrawPct, vTop, 0.0f, vBot, light, 1.0f, 1.0f, 1.0f, alpha, -3.0E-4f);
        }
        if ((absDmgFrom = Math.max(absInstDraw = absInstantPct > 0.0f ? EnemyHealthBarRenderer.clamp01(Math.max(absInstantPct, 0.010416667f)) : 0.0f, absDelayedPct)) - absInstDraw > 0.010416667f) {
            x0 = rightX - width * absDmgFrom;
            x1 = rightX - width * absInstDraw;
            EnemyHealthBarRenderer.drawTexturedQuadZ(TEX_ABSORB, mat, x0, barBot, x1, barTop, absDmgFrom, vTop, absInstDraw, vBot, light, 1.0f, 0.35f, 0.35f, alpha, -6.0E-4f);
        }
        if (absInstDraw > 0.0f) {
            x0 = rightX - width * absInstDraw;
            x1 = rightX;
            EnemyHealthBarRenderer.drawTexturedQuadZ(TEX_ABSORB, mat, x0, barBot, x1, barTop, absInstDraw, vTop, 0.0f, vBot, light, 1.0f, 1.0f, 1.0f, alpha * 0.75f, -6.0E-4f);
        }
        EnemyHealthBarRenderer.drawTexturedQuadZ(TEX_BORDER, mat, leftX, -halfH, rightX, halfH, 1.0f, vTop, 0.0f, vBot, light, 1.0f, 1.0f, 1.0f, alpha, -1.0E-4f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
    }

    private static void drawTexturedQuadZ(class_2960 tex, Matrix4f mat, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, int light, float r, float g, float b, float a, float z) {
        RenderSystem.setShader(class_757::method_34548);
        RenderSystem.setShaderTexture((int)0, (class_2960)tex);
        class_289 tess = class_289.method_1348();
        class_287 buf = tess.method_60827(class_293.class_5596.field_27382, class_290.field_20888);
        buf.method_22918(mat, x0, y1, z).method_22915(r, g, b, a).method_22913(u0, v1).method_60803(light);
        buf.method_22918(mat, x1, y1, z).method_22915(r, g, b, a).method_22913(u1, v1).method_60803(light);
        buf.method_22918(mat, x1, y0, z).method_22915(r, g, b, a).method_22913(u1, v0).method_60803(light);
        buf.method_22918(mat, x0, y0, z).method_22915(r, g, b, a).method_22913(u0, v0).method_60803(light);
        class_286.method_43433((class_9801)buf.method_60800());
    }

    private static void drawTexturedQuad(class_2960 tex, Matrix4f mat, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, int light, float r, float g, float b, float a) {
        RenderSystem.setShader(class_757::method_34548);
        RenderSystem.setShaderTexture((int)0, (class_2960)tex);
        class_289 tess = class_289.method_1348();
        class_287 buf = tess.method_60827(class_293.class_5596.field_27382, class_290.field_20888);
        buf.method_22918(mat, x0, y1, 0.0f).method_22915(r, g, b, a).method_22913(u0, v1).method_60803(light);
        buf.method_22918(mat, x1, y1, 0.0f).method_22915(r, g, b, a).method_22913(u1, v1).method_60803(light);
        buf.method_22918(mat, x1, y0, 0.0f).method_22915(r, g, b, a).method_22913(u1, v0).method_60803(light);
        buf.method_22918(mat, x0, y0, 0.0f).method_22915(r, g, b, a).method_22913(u0, v0).method_60803(light);
        class_286.method_43433((class_9801)buf.method_60800());
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static double lerp(float t, double a, double b) {
        return a + (b - a) * (double)t;
    }

    public static float getNameYOffset(class_1309 living, float tickDelta) {
        float visAlpha;
        HudState st = HUD.get(living.method_5628());
        if (st == null) {
            return 0.0f;
        }
        long nowTick = living.method_37908().method_8510();
        long sinceFirst = nowTick - st.firstShownTick;
        long sinceHit = nowTick - st.lastHitTick;
        if (sinceFirst <= 8L) {
            visAlpha = EnemyHealthBarRenderer.clamp01((float)sinceFirst / 8.0f);
        } else if (sinceHit <= 100L) {
            visAlpha = 1.0f;
        } else if (sinceHit <= 112L) {
            visAlpha = EnemyHealthBarRenderer.clamp01(1.0f - (float)(sinceHit - 100L) / 12.0f);
        } else {
            return 0.0f;
        }
        class_238 box = living.method_5829();
        int extra = Math.max(0, (int)Math.floor(box.method_17940() - 2.0));
        float dynScale = 2.0f + (float)extra;
        float worldW = 0.9f * dynScale;
        float worldH = worldW * 0.22916667f;
        float padding = 0.025f;
        return visAlpha * (worldH + padding);
    }

    private static final class HudState {
        long firstShownTick;
        long lastHitTick;
        long lastWorldTick;
        float delayedDamagePct;
        float delayedHealPct;
        float lastInstantPct;
        float absInstantPct;
        float absDelayedPct;
        float lastAbsInstant;

        HudState(long nowTick, float pct) {
            this.firstShownTick = nowTick;
            this.lastHitTick = nowTick;
            this.lastWorldTick = nowTick;
            this.delayedDamagePct = pct;
            this.delayedHealPct = pct;
            this.lastInstantPct = pct;
            this.absInstantPct = 0.0f;
            this.absDelayedPct = 0.0f;
            this.lastAbsInstant = 0.0f;
        }
    }
}

