/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.pixeldreamstudios.rpgsystems.client.enemy.config.HealingNumbersClientConfig;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class HealingNumbersRenderer {
    private static final int LIFETIME_TICKS = 26;
    private static final float BASE_RISE_PER_SEC = 0.7f;
    private static final float DRIFT_PER_SEC = 0.3f;
    private static final float HORIZONTAL_JITTER = 0.16f;
    private static final float FORWARD_OFFSET = 0.5f;
    private static final float ROTATE_AMPLITUDE_DEG = 5.0f;
    private static final int POP_TICKS = 6;
    private static final float POP_OVERSHOOT = 1.15f;
    private static final float BASE_SCALE = 0.0235f;
    private static final float DIST_SCALE_MULT = 0.032f;
    private static final float Y_EXTRA = 0.12f;
    private static final float ANCHOR_FRACTION = 0.7f;
    private static final int MAX_ACTIVE = 256;
    private static final List<Floating> ACTIVE = new ArrayList<Floating>();

    private HealingNumbersRenderer() {
    }

    public static void init() {
        WorldRenderEvents.AFTER_ENTITIES.register(HealingNumbersRenderer::onRender);
        ClientPlayConnectionEvents.JOIN.register((h, s, c) -> ACTIVE.clear());
        ClientPlayConnectionEvents.DISCONNECT.register((h, c) -> ACTIVE.clear());
    }

    public static void spawn(int entityId, float amount, boolean isSpell, UUID sourceUuid) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        HealingNumbersClientConfig cfg = HealingNumbersClientConfig.get();
        if (cfg.mode == HealingNumbersClientConfig.Mode.NONE) {
            return;
        }
        if (ACTIVE.size() >= 256) {
            ACTIVE.remove(0);
        }
        ACTIVE.add(new Floating(mc, entityId, amount, isSpell, sourceUuid, mc.field_1687.method_8510()));
    }

    private static void onRender(WorldRenderContext context) {
        if (ACTIVE.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null || mc.field_1690.field_1842) {
            return;
        }
        class_638 world = context.world();
        class_4184 camera = context.camera();
        class_4597 consumers = context.consumers();
        if (world == null || camera == null || consumers == null) {
            return;
        }
        long now = world.method_8510();
        float tickDelta = mc.method_60646().method_60637(false);
        class_243 camPos = camera.method_19326();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        for (int i = ACTIVE.size() - 1; i >= 0; --i) {
            Floating f = ACTIVE.get(i);
            class_1297 e = world.method_8469(f.entityId);
            class_1309 living = e instanceof class_1309 ? (class_1309)e : null;
            int ageTicks = (int)(now - f.spawnTick);
            if (ageTicks >= 26) {
                ACTIVE.remove(i);
                continue;
            }
            if (living != null && f.needsBootstrap()) {
                f.bootstrapFromEntity(living);
            }
            if (f.needsBootstrap()) continue;
            float tLife = ((float)ageTicks + tickDelta) / 26.0f;
            float rise = HealingNumbersRenderer.easeOutCubic(tLife) * 0.7f;
            float drift = ((float)ageTicks + tickDelta) / 20.0f * 0.3f;
            class_243 toCam = new class_243(camPos.field_1352 - f.baseX, 0.0, camPos.field_1350 - f.baseZ);
            if (toCam.method_1027() < 1.0E-6) {
                toCam = new class_243(0.0, 0.0, 1.0);
            }
            class_243 dir = toCam.method_1029();
            class_243 perp = new class_243(-dir.field_1350, 0.0, dir.field_1352).method_1029().method_1021((double)f.jitter);
            class_243 pos = new class_243(f.baseX, f.baseY + (double)rise, f.baseZ).method_1019(dir.method_1021(0.5)).method_1019(perp.method_1021(1.0 + (double)drift));
            float alpha = HealingNumbersRenderer.computeAlpha(ageTicks, tickDelta);
            double dx = f.baseX - camPos.field_1352;
            double dz = f.baseZ - camPos.field_1350;
            float dist = (float)Math.sqrt(dx * dx + dz * dz);
            float distScale = 0.0235f * (1.0f + dist * 0.032f);
            float popMul = 1.0f;
            float popT = HealingNumbersRenderer.clamp01(((float)ageTicks + tickDelta) / 6.0f);
            if (popT < 1.0f) {
                float popEase = HealingNumbersRenderer.easeOutCubic(1.0f - popT);
                popMul = 1.0f + 0.14999998f * popEase;
            }
            float scale = distScale * popMul;
            float tilt = (float)Math.sin((f.seed + (float)ageTicks + tickDelta) * 0.33f) * 5.0f;
            int rgb = f.isSpell ? 7528703 : 9106826;
            HealingNumbersRenderer.drawTextAt((int)(alpha * 255.0f), rgb, f.displayText, pos, camera, context.matrixStack(), context.consumers(), scale, tilt);
        }
    }

    private static boolean isFromMyParty(UUID sourceUuid) {
        if (sourceUuid == null) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return false;
        }
        if (sourceUuid.equals(mc.field_1724.method_5667())) {
            return true;
        }
        try {
            Class<?> c = Class.forName("net.pixeldreamstudios.rpgsystems.client.ClientPartyHudData");
            try {
                Field f = c.getField("memberUuids");
                Object o = f.get(null);
                if (o instanceof Set) {
                    Set set = (Set)o;
                    return set.contains(sourceUuid);
                }
            }
            catch (NoSuchFieldException f) {
                // empty catch block
            }
            try {
                Method m = c.getMethod("isInMyParty", UUID.class);
                Object r = m.invoke(null, sourceUuid);
                if (r instanceof Boolean) {
                    Boolean b = (Boolean)r;
                    return b;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void drawTextAt(int alpha255, int rgb, String text, class_243 pos, class_4184 camera, class_4587 ms, class_4597 vcp, float scale, float tiltDeg) {
        class_310 mc = class_310.method_1551();
        class_327 tr = mc.field_1772;
        class_243 cam = camera.method_19326();
        ms.method_22903();
        ms.method_22904(pos.field_1352 - cam.field_1352, pos.field_1351 - cam.field_1351, pos.field_1350 - cam.field_1350);
        ms.method_22907(camera.method_23767());
        ms.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        ms.method_22907(class_7833.field_40718.rotationDegrees(tiltDeg));
        ms.method_22905(-scale, -scale, scale);
        int widthPixels = tr.method_1727(text);
        float x = (float)(-widthPixels) / 2.0f;
        float y = 0.0f;
        int a = alpha255 & 0xFF;
        int argb = a << 24 | rgb & 0xFFFFFF;
        int light = class_765.method_23687((int)15, (int)15);
        Matrix4f mat = ms.method_23760().method_23761();
        tr.method_27521(text, x, y, argb, true, mat, vcp, class_327.class_6415.field_33993, 0, light);
        ms.method_22909();
    }

    private static float computeAlpha(int ageTicks, float tickDelta) {
        float t = ((float)ageTicks + tickDelta) / 26.0f;
        float in = HealingNumbersRenderer.clamp01(((float)ageTicks + tickDelta) / 4.0f);
        float out = HealingNumbersRenderer.clamp01(1.0f - t);
        return HealingNumbersRenderer.clamp01(HealingNumbersRenderer.easeOutCubic(in) * HealingNumbersRenderer.easeOutCubic(out) * 1.05f);
    }

    private static float easeOutCubic(float x) {
        float inv = 1.0f - HealingNumbersRenderer.clamp01(x);
        return 1.0f - inv * inv * inv;
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static final class Floating {
        final int entityId;
        final String displayText;
        final boolean isSpell;
        final UUID sourceUuid;
        final long spawnTick;
        final float jitter;
        final float seed;
        double baseX = Double.NaN;
        double baseY = Double.NaN;
        double baseZ = Double.NaN;

        Floating(class_310 mc, int entityId, float amount, boolean isSpell, UUID sourceUuid, long spawnTick) {
            class_1297 e;
            this.entityId = entityId;
            this.displayText = Floating.formatAmount(amount);
            this.isSpell = isSpell;
            this.sourceUuid = sourceUuid;
            this.spawnTick = spawnTick;
            this.jitter = (float)((Math.random() - 0.5) * 2.0 * (double)0.16f);
            this.seed = (float)Math.random() * 10000.0f;
            if (mc.field_1687 != null && (e = mc.field_1687.method_8469(entityId)) instanceof class_1309) {
                class_1309 living = (class_1309)e;
                this.bootstrapFromEntity(living);
            }
        }

        static String formatAmount(float amount) {
            long rounded;
            float abs = Math.abs(amount);
            if (Math.abs(abs - (float)(rounded = (long)Math.round(abs))) < 0.005f) {
                return "+" + Long.toString(rounded);
            }
            String s = String.format(Locale.ROOT, "+%.2f", Float.valueOf(abs));
            int dot = s.indexOf(46);
            if (dot >= 0) {
                int end;
                for (end = s.length(); end > dot + 1 && s.charAt(end - 1) == '0'; --end) {
                }
                if (end == dot + 1) {
                    end = dot;
                }
                s = s.substring(0, end);
            }
            return s;
        }

        boolean needsBootstrap() {
            return Double.isNaN(this.baseX) || Double.isNaN(this.baseY) || Double.isNaN(this.baseZ);
        }

        void bootstrapFromEntity(class_1309 living) {
            class_238 box = living.method_5829();
            double height = box.method_17940();
            double anchorY = box.field_1322 + height * (double)0.7f;
            this.baseX = living.method_23317();
            this.baseY = anchorY + (double)0.12f;
            this.baseZ = living.method_23321();
        }
    }
}

