/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.enemy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7924;

public final class DamageTypeConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("rpgsystems").resolve("damage_types_client.json");
    private static final class_2960 GENERIC_KILL = class_2960.method_60655((String)"minecraft", (String)"generic_kill");
    public Map<String, Boolean> showByDamageType = new LinkedHashMap<String, Boolean>();
    public Map<String, String> colorByDamageType = new LinkedHashMap<String, String>();
    private static DamageTypeConfig INSTANCE;

    private DamageTypeConfig() {
    }

    public static DamageTypeConfig get() {
        if (INSTANCE == null) {
            boolean needSave = false;
            try {
                if (Files.exists(FILE, new LinkOption[0])) {
                    INSTANCE = (DamageTypeConfig)GSON.fromJson(Files.readString(FILE), DamageTypeConfig.class);
                    if (INSTANCE == null) {
                        INSTANCE = new DamageTypeConfig();
                        needSave = true;
                    }
                    if (DamageTypeConfig.INSTANCE.showByDamageType == null || DamageTypeConfig.INSTANCE.colorByDamageType == null) {
                        INSTANCE = DamageTypeConfig.ensureMaps(INSTANCE);
                        needSave = true;
                    }
                } else {
                    INSTANCE = new DamageTypeConfig();
                    needSave = true;
                }
            }
            catch (Exception e) {
                INSTANCE = new DamageTypeConfig();
                needSave = true;
            }
            if (DamageTypeConfig.ensureDefaultGenericKill(INSTANCE)) {
                needSave = true;
            }
            if (needSave) {
                DamageTypeConfig.save();
            }
        }
        return INSTANCE;
    }

    private static DamageTypeConfig ensureMaps(DamageTypeConfig cfg) {
        if (cfg.showByDamageType == null) {
            cfg.showByDamageType = new LinkedHashMap<String, Boolean>();
        }
        if (cfg.colorByDamageType == null) {
            cfg.colorByDamageType = new LinkedHashMap<String, String>();
        }
        return cfg;
    }

    private static boolean ensureDefaultGenericKill(DamageTypeConfig cfg) {
        String key = GENERIC_KILL.toString();
        if (!cfg.showByDamageType.containsKey(key)) {
            cfg.showByDamageType.put(key, Boolean.FALSE);
            return true;
        }
        return false;
    }

    public static void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            Files.writeString(FILE, (CharSequence)GSON.toJson((Object)DamageTypeConfig.get()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean shouldShowType(class_2960 id) {
        String key = id.toString();
        Boolean b = this.showByDamageType.get(key);
        if (b != null) {
            return b;
        }
        return !id.equals((Object)GENERIC_KILL);
    }

    public static void maybePopulateFromRegistry(class_5455 rm) {
        try {
            DamageTypeConfig cfg = DamageTypeConfig.get();
            class_2378 reg = rm.method_30530(class_7924.field_42534);
            for (class_2960 id : reg.method_10235()) {
                boolean def = !id.equals((Object)GENERIC_KILL);
                cfg.showByDamageType.putIfAbsent(id.toString(), def);
            }
            DamageTypeConfig.ensureDefaultGenericKill(cfg);
            DamageTypeConfig.save();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void seenDamageType(class_2960 id) {
        boolean def;
        DamageTypeConfig cfg = DamageTypeConfig.get();
        boolean bl = def = !id.equals((Object)GENERIC_KILL);
        if (cfg.showByDamageType.putIfAbsent(id.toString(), def) == null) {
            DamageTypeConfig.save();
        }
    }

    public Integer colorOverride(class_2960 id) {
        String raw = this.colorByDamageType.get(id.toString());
        if (raw == null) {
            return null;
        }
        try {
            String s = raw.trim();
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
            }
            int rgb = (int)Long.parseLong(s, 16);
            return rgb & 0xFFFFFF;
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

