/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.pixeldreamstudios.rpgsystems.network.party.PartyHudPayloads;
import net.pixeldreamstudios.rpgsystems.network.party.PartySettingsPayloads;

@Environment(value=EnvType.CLIENT)
public final class ClientPartyHudData {
    public static UUID partyId = null;
    public static String partyName = "";
    public static UUID leaderUuid = null;
    public static final Set<UUID> memberUuids = new HashSet<UUID>();
    private static final Map<UUID, Member> MEMBERS = new LinkedHashMap<UUID, Member>();
    public static UUID selectedMemberUuid = null;
    private static final PartySettingsClient SETTINGS = new PartySettingsClient();

    public static boolean isInMyParty(UUID id) {
        if (id == null) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null && id.equals(mc.field_1724.method_5667())) {
            return true;
        }
        return MEMBERS.containsKey(id);
    }

    public static Collection<Member> members() {
        return MEMBERS.values();
    }

    public static void setSelectedMember(UUID uuid) {
        selectedMemberUuid = uuid;
    }

    public static boolean allowHelpfulNonMembers() {
        return ClientPartyHudData.SETTINGS.allowHelpfulNonMembers;
    }

    public static boolean ignorePartyCollision() {
        return ClientPartyHudData.SETTINGS.ignorePartyCollision;
    }

    public static Member getSelectedOrDefault() {
        Member m;
        if (selectedMemberUuid != null && (m = MEMBERS.get(selectedMemberUuid)) != null) {
            return m;
        }
        if (leaderUuid != null && (m = MEMBERS.get(leaderUuid)) != null) {
            return m;
        }
        return MEMBERS.values().stream().findFirst().orElse(null);
    }

    public static Member getByUuid(UUID id) {
        return id == null ? null : MEMBERS.get(id);
    }

    public static void initClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(PartyHudPayloads.PartyRosterClear.ID, (payload, ctx) -> {
            partyId = payload.partyId();
            partyName = payload.partyName();
            leaderUuid = payload.leaderUuid();
            MEMBERS.clear();
        });
        ClientPlayNetworking.registerGlobalReceiver(PartyHudPayloads.PartyMemberOnline.ID, (payload, ctx) -> ctx.client().execute(() -> {
            Member m = MEMBERS.get(payload.memberUuid());
            if (m != null) {
                m.online = payload.online();
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(PartyHudPayloads.PartyRosterAdd.ID, (payload, ctx) -> {
            if (!Objects.equals(partyId, payload.partyId())) {
                return;
            }
            MEMBERS.put(payload.memberUuid(), new Member(payload.memberUuid(), payload.memberName()));
        });
        ClientPlayNetworking.registerGlobalReceiver(PartyHudPayloads.PartyMemberVitals.ID, (payload, ctx) -> ctx.client().execute(() -> {
            Member m = MEMBERS.get(payload.memberUuid());
            if (m != null) {
                m.health = payload.health();
                m.maxHealth = payload.maxHealth();
                m.hunger = payload.hunger();
                m.absorption = payload.absorption();
                m.staminaNow = payload.staminaNow();
                m.staminaMax = payload.staminaMax();
                m.manaNow = payload.manaNow();
                m.manaMax = payload.manaMax();
                m.rpgManaNow = payload.rpgManaNow();
                m.rpgManaMax = payload.rpgManaMax();
                m.online = true;
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(PartyHudPayloads.PartyMemberLevel.ID, (payload, ctx) -> ctx.client().execute(() -> ClientPartyHudData.setMemberLevel(payload.memberUuid(), payload.totalLevel())));
        ClientPlayNetworking.registerGlobalReceiver(PartySettingsPayloads.Sync.ID, (payload, ctx) -> ctx.client().execute(() -> {
            ClientPartyHudData.SETTINGS.allowHelpfulNonMembers = payload.allowHelpfulNonMembers();
            ClientPartyHudData.SETTINGS.ignorePartyCollision = payload.ignorePartyCollision();
        }));
        ClientPlayNetworking.registerGlobalReceiver(PartyHudPayloads.PartyRosterReset.ID, (payload, ctx) -> ClientPartyHudData.clearAll());
    }

    public static void clearAll() {
        partyId = null;
        partyName = "";
        leaderUuid = null;
        selectedMemberUuid = null;
        ClientPartyHudData.SETTINGS.allowHelpfulNonMembers = false;
        ClientPartyHudData.SETTINGS.ignorePartyCollision = true;
        MEMBERS.clear();
    }

    public static List<Member> membersSortedExcludingSelf() {
        class_310 mc = class_310.method_1551();
        UUID self = mc != null && mc.field_1724 != null ? mc.field_1724.method_5667() : null;
        return MEMBERS.values().stream().filter(m -> m.online).filter(m -> self == null || !m.uuid.equals(self)).sorted(Comparator.comparing(m -> m.name.toLowerCase(Locale.ROOT))).toList();
    }

    public static void setMemberLevel(UUID uuid, int level) {
        Member m = MEMBERS.get(uuid);
        if (m != null) {
            m.totalLevel = level;
        }
    }

    public static boolean isMember(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return MEMBERS.containsKey(uuid);
    }

    public static boolean isSameParty(UUID a, UUID b) {
        if (partyId == null || a == null || b == null) {
            return false;
        }
        boolean aInParty = ClientPartyHudData.isInMyParty(a);
        boolean bInParty = ClientPartyHudData.isInMyParty(b);
        return aInParty && bInParty;
    }

    public static final class PartySettingsClient {
        public boolean allowHelpfulNonMembers = false;
        public boolean ignorePartyCollision = true;
    }

    public static final class Member {
        public final UUID uuid;
        public String name;
        public float health = -1.0f;
        public float maxHealth = 20.0f;
        public int hunger = -1;
        public int totalLevel = -1;
        public boolean online = false;
        public float absorption = 0.0f;
        public float staminaNow = -1.0f;
        public float staminaMax = -1.0f;
        public float manaNow = -1.0f;
        public float manaMax = -1.0f;
        public float rpgManaNow = -1.0f;
        public float rpgManaMax = -1.0f;

        public Member(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        public float hpPct() {
            return this.maxHealth <= 0.0f ? 0.0f : Math.max(0.0f, Math.min(1.0f, this.health / this.maxHealth));
        }

        public float hungerPct() {
            return Math.max(0.0f, Math.min(1.0f, (float)this.hunger / 20.0f));
        }
    }
}

