/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.hud;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_745;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import net.pixeldreamstudios.rpgsystems.RPGSystems;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyPins;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyStatusEffects;
import net.pixeldreamstudios.rpgsystems.client.party.config.PartyHudClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.hud.OriginalHud;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyHudRenderer;
import net.pixeldreamstudios.rpgsystems.client.party.hud.SimpleHud;
import net.pixeldreamstudios.rpgsystems.compat.RpgManaCompat;
import net.pixeldreamstudios.rpgsystems.compat.TrbAttributesCompat;
import net.pixeldreamstudios.rpgsystems.network.party.PartyStatusEffectsPayloads;

@Environment(value=EnvType.CLIENT)
public final class PartyHud
implements HudRenderCallback {
    public static final class_2960 PARTY_BG = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud.png");
    public static final class_2960 PARTY_BG_LEADER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud_leader.png");
    public static final class_2960 ARROW_UP = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/up.png");
    public static final class_2960 ARROW_DOWN = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/down.png");
    public static final class_2960 ARROW_LEFT = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/left.png");
    public static final class_2960 ARROW_RIGHT = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/right.png");
    public static final class_2960 LEADER_ICON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/party_leader.png");
    public static final int ARROW_W = 11;
    public static final int ARROW_H = 11;
    public static final boolean DEBUG_FORCE_DUMMY = false;
    public static final int DEBUG_DUMMY_COUNT = 10;
    public static final class_2960 TEX_BAR_OUTLINE_HUD = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/bar_outline_hud.png");
    public static final class_2960 TEX_HP_FILL_HUD = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/health_bar_hud.png");
    public static final class_2960 TEX_ABSORB_FILL_HUD = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/absorption_bar_hud.png");
    public static final class_2960 TEX_MANA_FILL_HUD = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/mana_bar_hud.png");
    public static final class_2960 TEX_HUNGER_FILL_HUD = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/hunger_bar_hud.png");
    public static final int HUD_TEX_SRC_W = 108;
    public static final int HUD_TEX_SRC_H = 8;
    private static boolean bgFiltered = false;
    private static boolean hudBarTexturesFiltered = false;
    private static final boolean staminaAvailableCached = FabricLoader.getInstance().isModLoaded("staminaattributes");
    private static final boolean manaAvailableCached = FabricLoader.getInstance().isModLoaded("manaattributes");
    private static final boolean rpgManaAvailableCached = FabricLoader.getInstance().isModLoaded("rpgmana");
    private static final Map<UUID, class_745> DUMMIES = new HashMap<UUID, class_745>();
    private static final PartyHudRenderer ORIGINAL = new OriginalHud();
    private static final PartyHudRenderer SIMPLE = new SimpleHud();
    public static final class_2960 SIMPLE_OUTLINE = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_hud/party_hud_outline_simple.png");
    public static final int SIMPLE_OUTLINE_TEX_W = 92;
    public static final int SIMPLE_OUTLINE_TEX_H = 18;

    public static void init() {
        HudRenderCallback.EVENT.register((Object)new PartyHud());
        ClientPlayNetworking.registerGlobalReceiver(PartyStatusEffectsPayloads.MemberEffects.ID, (payload, context) -> {
            ArrayList<class_2960> ids = new ArrayList<class_2960>();
            for (String s : payload.effectIds()) {
                try {
                    ids.add(class_2960.method_60654((String)s));
                }
                catch (Throwable throwable) {}
            }
            context.client().execute(() -> ClientPartyStatusEffects.update(payload.memberId(), ids));
        });
    }

    public void onHudRender(class_332 ctx, class_9779 tickCounter) {
        PartyHudClientConfig cfg = PartyHudClientConfig.get();
        if (!cfg.hudEnabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1690.field_1842 || mc.field_1724 == null) {
            return;
        }
        PartyHud.ensureBgNearest();
        PartyHud.ensureHudBarTexturesNearest();
        PartyHudRenderer renderer = cfg.hudStyle == PartyHudClientConfig.HudStyle.SIMPLE ? SIMPLE : ORIGINAL;
        renderer.render(ctx, tickCounter, cfg);
    }

    public static void ensureBgNearest() {
        class_1044 so;
        class_1044 ld;
        class_1044 a4;
        class_1044 a3;
        class_1044 a2;
        class_1044 a1;
        class_1044 tL;
        if (bgFiltered) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_1060 tm = mc.method_1531();
        class_1044 t = tm.method_4619(PARTY_BG);
        if (t != null) {
            t.method_4527(false, false);
        }
        if ((tL = tm.method_4619(PARTY_BG_LEADER)) != null) {
            tL.method_4527(false, false);
        }
        if ((a1 = tm.method_4619(ARROW_UP)) != null) {
            a1.method_4527(false, false);
        }
        if ((a2 = tm.method_4619(ARROW_DOWN)) != null) {
            a2.method_4527(false, false);
        }
        if ((a3 = tm.method_4619(ARROW_LEFT)) != null) {
            a3.method_4527(false, false);
        }
        if ((a4 = tm.method_4619(ARROW_RIGHT)) != null) {
            a4.method_4527(false, false);
        }
        if ((ld = tm.method_4619(LEADER_ICON)) != null) {
            ld.method_4527(false, false);
        }
        if ((so = tm.method_4619(SIMPLE_OUTLINE)) != null) {
            so.method_4527(false, false);
        }
        bgFiltered = true;
    }

    public static void ensureHudBarTexturesNearest() {
        class_1044 g;
        class_1044 m;
        class_1044 a;
        class_1044 h;
        if (hudBarTexturesFiltered) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_1060 tm = mc.method_1531();
        class_1044 o = tm.method_4619(TEX_BAR_OUTLINE_HUD);
        if (o != null) {
            o.method_4527(false, false);
        }
        if ((h = tm.method_4619(TEX_HP_FILL_HUD)) != null) {
            h.method_4527(false, false);
        }
        if ((a = tm.method_4619(TEX_ABSORB_FILL_HUD)) != null) {
            a.method_4527(false, false);
        }
        if ((m = tm.method_4619(TEX_MANA_FILL_HUD)) != null) {
            m.method_4527(false, false);
        }
        if ((g = tm.method_4619(TEX_HUNGER_FILL_HUD)) != null) {
            g.method_4527(false, false);
        }
        hudBarTexturesFiltered = true;
    }

    public static List<ClientPartyHudData.Member> partyMembers() {
        UUID leaderForSort;
        ArrayList<ClientPartyHudData.Member> list;
        PartyHudClientConfig cfg = PartyHudClientConfig.get();
        boolean useDummy = false;
        if (useDummy) {
            UUID leaderDummy;
            int count = 10;
            list = new ArrayList(count);
            leaderForSort = leaderDummy = UUID.nameUUIDFromBytes("rpgsystems:dummy:leader".getBytes(StandardCharsets.UTF_8));
            for (int i = 0; i < count; ++i) {
                boolean isLeader = i == 6;
                UUID uuid = isLeader ? leaderDummy : UUID.nameUUIDFromBytes(("rpgsystems:dummy:" + i).getBytes(StandardCharsets.UTF_8));
                String name = isLeader ? "Leader_Dummy" : "Dummy_" + (i + 1);
                ClientPartyHudData.Member m = new ClientPartyHudData.Member(uuid, name);
                m.online = true;
                m.totalLevel = (i + 1) * 3;
                m.maxHealth = 20.0f;
                m.health = 10.0f + (float)(i % 11);
                m.absorption = i % 3 == 0 ? 2.0f : 0.0f;
                m.hunger = 12 + i % 8;
                m.staminaMax = 20.0f;
                m.staminaNow = 10.0f + (float)(i % 10);
                m.manaMax = 20.0f;
                m.manaNow = 8.0f + (float)(i % 12);
                m.rpgManaMax = 20.0f;
                m.rpgManaNow = 6.0f + (float)(i % 14);
                list.add(m);
            }
        } else {
            leaderForSort = ClientPartyHudData.leaderUuid;
            list = new ArrayList<ClientPartyHudData.Member>(ClientPartyHudData.membersSortedExcludingSelf());
        }
        int limit = cfg.maxVisiblePartyHuds;
        return ClientPartyPins.orderedForHud(list, leaderForSort, limit);
    }

    public static List<RenderBar> collectBars(UUID uuid, PartyHudClientConfig cfg, int hpColor, int hungerColor, int staminaColor, int manaColor, int rpgManaColor) {
        float now;
        float pct;
        ArrayList<RenderBar> out = new ArrayList<RenderBar>();
        ClientPartyHudData.Member mem = ClientPartyHudData.getByUuid(uuid);
        if (cfg.showHpBar) {
            pct = 0.0f;
            float absPct = 0.0f;
            int now2 = -1;
            int max = -1;
            if (mem != null) {
                max = Math.round(mem.maxHealth);
                pct = mem.maxHealth > 0.0f ? mem.health / mem.maxHealth : 0.0f;
                absPct = mem.maxHealth > 0.0f ? mem.absorption / mem.maxHealth : 0.0f;
                now2 = Math.round(mem.health + mem.absorption);
            }
            String txt = now2 >= 0 && max > 0 ? now2 + " / " + max : "?? / ??";
            out.add(new RenderBar(Kind.HP, pct, absPct, txt, hpColor));
        }
        if (cfg.showHungerBar) {
            pct = mem != null && mem.hunger >= 0 ? Math.max(0.0f, Math.min(1.0f, (float)mem.hunger / 20.0f)) : 0.0f;
            String txt = mem != null && mem.hunger >= 0 ? mem.hunger + " / 20" : "?? / 20";
            out.add(new RenderBar(Kind.HUNGER, pct, 0.0f, txt, hungerColor));
        }
        if (cfg.showStaminaBar && staminaAvailableCached) {
            now = -1.0f;
            float max = -1.0f;
            if (mem != null && mem.staminaMax > 0.0f) {
                now = mem.staminaNow;
                max = mem.staminaMax;
            } else {
                StackedValue v = PartyHud.queryTracked(uuid, true);
                now = v.now;
                max = v.max;
            }
            float pct2 = max > 0.0f ? now / max : 0.0f;
            String txt = now >= 0.0f && max > 0.0f ? (int)now + " / " + (int)max : "?? / ??";
            out.add(new RenderBar(Kind.STAMINA, pct2, 0.0f, txt, staminaColor));
        }
        if (cfg.showManaBar && manaAvailableCached) {
            now = -1.0f;
            float max = -1.0f;
            if (mem != null && mem.manaMax > 0.0f) {
                now = mem.manaNow;
                max = mem.manaMax;
            } else {
                StackedValue v = PartyHud.queryTracked(uuid, false);
                now = v.now;
                max = v.max;
            }
            float pct3 = max > 0.0f ? now / max : 0.0f;
            String txt = max > 0.0f ? (int)now + " / " + (int)max : "?? / ??";
            out.add(new RenderBar(Kind.MANA, pct3, 0.0f, txt, manaColor));
        }
        if (cfg.showRpgManaBar && rpgManaAvailableCached) {
            now = -1.0f;
            float max = -1.0f;
            if (mem != null && mem.rpgManaMax > 0.0f) {
                now = mem.rpgManaNow;
                max = mem.rpgManaMax;
            } else {
                StackedValue v = PartyHud.queryRpgMana(uuid);
                now = v.now;
                max = v.max;
            }
            float pct4 = max > 0.0f ? now / max : 0.0f;
            String txt = max > 0.0f ? (int)now + " / " + (int)max : "?? / ??";
            out.add(new RenderBar(Kind.RPGMANA, pct4, 0.0f, txt, rpgManaColor));
        }
        return out;
    }

    public static void drawHudBarSmart(class_332 ctx, int x, int y, int w, int h, RenderBar b) {
        switch (b.kind.ordinal()) {
            case 0: {
                float hp = PartyHud.clamp01(b.pct);
                float abs = PartyHud.clamp01(b.extraPct);
                PartyHud.drawHudTexturedSegment(ctx, TEX_HP_FILL_HUD, x, y, w, h, 0.0f, hp);
                if (abs > 0.0f) {
                    PartyHud.drawHudTexturedSegmentWithAlpha(ctx, TEX_ABSORB_FILL_HUD, x, y, w, h, 0.0f, abs, 0.75f);
                }
                PartyHud.drawHudTexturedWhole(ctx, TEX_BAR_OUTLINE_HUD, x, y, w, h);
                break;
            }
            case 1: {
                PartyHud.drawHudTexturedSegment(ctx, TEX_HUNGER_FILL_HUD, x, y, w, h, 0.0f, PartyHud.clamp01(b.pct));
                PartyHud.drawHudTexturedWhole(ctx, TEX_BAR_OUTLINE_HUD, x, y, w, h);
                break;
            }
            case 3: 
            case 4: {
                PartyHud.drawHudTexturedSegment(ctx, TEX_MANA_FILL_HUD, x, y, w, h, 0.0f, PartyHud.clamp01(b.pct));
                PartyHud.drawHudTexturedWhole(ctx, TEX_BAR_OUTLINE_HUD, x, y, w, h);
                break;
            }
            case 2: {
                PartyHud.drawBarPretty(ctx, x, y, w, h, PartyHud.clamp01(b.pct), -12698050, 0, b.color);
            }
        }
    }

    public static void drawHudTexturedWhole(class_332 ctx, class_2960 tex, int x, int y, int w, int h) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905((float)w / 108.0f, (float)h / 8.0f, 1.0f);
        ctx.method_25290(tex, 0, 0, 0.0f, 0.0f, 108, 8, 108, 8);
        m.method_22909();
    }

    public static void drawHudTexturedSegment(class_332 ctx, class_2960 tex, int x, int y, int w, int h, float startPct, float endPct) {
        float s = Math.max(0.0f, Math.min(1.0f, startPct));
        float e = Math.max(0.0f, Math.min(1.0f, endPct));
        if (e <= s) {
            return;
        }
        int srcU = Math.round(108.0f * s);
        int srcW = Math.max(0, Math.round(108.0f * (e - s)));
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905((float)w / 108.0f, (float)h / 8.0f, 1.0f);
        ctx.method_25290(tex, srcU, 0, (float)srcU, 0.0f, srcW, 8, 108, 8);
        m.method_22909();
    }

    public static void drawHudTexturedSegmentWithAlpha(class_332 ctx, class_2960 tex, int x, int y, int w, int h, float startPct, float endPct, float alpha) {
        float s = Math.max(0.0f, Math.min(1.0f, startPct));
        float e = Math.max(0.0f, Math.min(1.0f, endPct));
        if (e <= s) {
            return;
        }
        int srcU = Math.round(108.0f * s);
        int srcW = Math.max(0, Math.round(108.0f * (e - s)));
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905((float)w / 108.0f, (float)h / 8.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.max(0.0f, Math.min(1.0f, alpha)));
        ctx.method_25290(tex, srcU, 0, (float)srcU, 0.0f, srcW, 8, 108, 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        m.method_22909();
    }

    public static void drawBarPretty(class_332 ctx, int x, int y, int w, int h, float pct, int bgARGB, int borderARGB, int fillARGB) {
        if (w <= 0 || h <= 0) {
            return;
        }
        ctx.method_25294(x, y, x + w, y + h, bgARGB);
        int iw = Math.max(0, Math.round((float)w * Math.max(0.0f, Math.min(1.0f, pct))));
        if (iw > 0) {
            ctx.method_25294(x, y, x + iw, y + h, fillARGB);
        }
    }

    public static void drawScaledText(class_332 ctx, class_327 tr, String text, int x, int y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    public static void drawScaledTextF(class_332 ctx, class_327 tr, String text, float x, float y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416(x, y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    public static String ellipsizeScaled(class_327 tr, String s, int maxPx, float scale) {
        if (Math.round((float)tr.method_1727(s) * scale) <= maxPx) {
            return s;
        }
        String dots = "...";
        int dw = Math.round((float)tr.method_1727(dots) * scale);
        StringBuilder b = new StringBuilder(s);
        while (b.length() > 0 && Math.round((float)tr.method_1727(b.toString()) * scale) + dw > maxPx) {
            b.deleteCharAt(b.length() - 1);
        }
        return String.valueOf(b) + dots;
    }

    public static class_2960 pickArrow(UUID uuid) {
        double ar;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null || mc.field_1687 == null) {
            return null;
        }
        class_746 self = mc.field_1724;
        class_1657 target = mc.field_1687.method_18470(uuid);
        if (target == null) {
            return null;
        }
        double dx = target.method_23317() - self.method_23317();
        double dz = target.method_23321() - self.method_23321();
        double yawRad = Math.toRadians(self.method_36454());
        double forwardDot = -Math.sin(yawRad) * dx + Math.cos(yawRad) * dz;
        double rightDot = Math.cos(yawRad) * dx + Math.sin(yawRad) * dz;
        double af = Math.abs(forwardDot);
        if (af >= (ar = Math.abs(rightDot))) {
            return forwardDot >= 0.0 ? ARROW_UP : ARROW_DOWN;
        }
        return rightDot >= 0.0 ? ARROW_LEFT : ARROW_RIGHT;
    }

    public static class_1657 getRenderablePlayer(UUID uuid, String fallbackName) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return null;
        }
        class_638 world = mc.field_1687;
        if (world == null) {
            return null;
        }
        class_1657 live = world.method_18470(uuid);
        if (live != null) {
            return live;
        }
        class_745 cached = DUMMIES.get(uuid);
        if (cached != null && cached.field_17892 == world) {
            return cached;
        }
        class_634 nh = mc.method_1562();
        GameProfile profile = null;
        if (nh != null && nh.method_2871(uuid) != null) {
            profile = nh.method_2871(uuid).method_2966();
        }
        if (profile == null) {
            profile = new GameProfile(uuid, fallbackName != null ? fallbackName : uuid.toString());
        }
        class_745 dummy = new class_745(world, profile);
        dummy.field_6283 = 180.0f;
        DUMMIES.put(uuid, dummy);
        return dummy;
    }

    public static boolean isLeader(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return Objects.equals(ClientPartyHudData.leaderUuid, uuid);
    }

    public static void drawTextureScaled(class_332 ctx, class_2960 tex, int x, int y, int w, int h, int texW, int texH, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_25290(tex, 0, 0, 0.0f, 0.0f, w, h, texW, texH);
        m.method_22909();
    }

    public static void drawBorder(class_332 ctx, int x, int y, int w, int h, int argb) {
        if (w <= 0 || h <= 0) {
            return;
        }
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x, y + 1, x + 1, y + h - 1, argb);
        ctx.method_25294(x + w - 1, y + 1, x + w, y + h - 1, argb);
    }

    public static float clamp01(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    public static StackedValue queryTracked(UUID uuid, boolean stamina) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return new StackedValue(-1.0f, -1.0f);
        }
        if (stamina && !staminaAvailableCached) {
            return new StackedValue(-1.0f, -1.0f);
        }
        if (!stamina && !manaAvailableCached) {
            return new StackedValue(-1.0f, -1.0f);
        }
        class_1657 e = mc.field_1687.method_18470(uuid);
        if (e == null) {
            return new StackedValue(-1.0f, -1.0f);
        }
        if (stamina) {
            float[] pair = TrbAttributesCompat.readStamina(e);
            return new StackedValue(pair[0], pair[1]);
        }
        float[] pair = TrbAttributesCompat.readMana(e);
        return new StackedValue(pair[0], pair[1]);
    }

    public static StackedValue queryRpgMana(UUID uuid) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return new StackedValue(-1.0f, -1.0f);
        }
        if (!rpgManaAvailableCached) {
            return new StackedValue(-1.0f, -1.0f);
        }
        class_1657 e = mc.field_1687.method_18470(uuid);
        if (e == null) {
            return new StackedValue(-1.0f, -1.0f);
        }
        float[] pair = RpgManaCompat.readMana(e);
        return new StackedValue(pair[0], pair[1]);
    }

    public static void log(String msg) {
        try {
            RPGSystems.LOGGER.info("[PartyHud] " + msg);
        }
        catch (Throwable t) {
            System.out.println("[PartyHud] " + msg);
        }
    }

    public static final class RenderBar {
        public final Kind kind;
        public final float pct;
        public final float extraPct;
        public final String text;
        public final int color;

        public RenderBar(Kind kind, float pct, float extraPct, String text, int color) {
            this.kind = kind;
            this.pct = PartyHud.clamp01(pct);
            this.extraPct = PartyHud.clamp01(extraPct);
            this.text = text;
            this.color = color;
        }
    }

    public static enum Kind {
        HP,
        HUNGER,
        STAMINA,
        MANA,
        RPGMANA;

    }

    public static final class StackedValue {
        public final float now;
        public final float max;

        public StackedValue(float now, float max) {
            this.now = now;
            this.max = max;
        }
    }
}

