/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.screen;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyChatBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyInfoBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyInviteBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyJoinRequestBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyMemberInfoBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyMembersBox;

@Environment(value=EnvType.CLIENT)
public final class PartyScreen
extends class_437 {
    private static final int TEXTURE_W = 450;
    private static final int TEXTURE_H = 300;
    private static final int DEST_W = 450;
    private static final int DEST_H = 300;
    private static final class_2960 BG = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/party_screen.png");
    private int canvasX;
    private int canvasY;
    private PartyBox[] boxes;

    public PartyScreen() {
        super((class_2561)class_2561.method_43470((String)"Party"));
    }

    protected void method_25426() {
        this.ensureNearestFilter();
        this.computeCanvas();
        this.boxes = new PartyBox[]{new PartyMemberInfoBox(), new PartyChatBox(), new PartyInviteBox(), new PartyJoinRequestBox(), new PartyMembersBox(), new PartyInfoBox()};
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.computeCanvas();
    }

    private void computeCanvas() {
        this.canvasX = (this.field_22789 - 450) / 2;
        this.canvasY = (this.field_22790 - 300) / 2;
    }

    private void ensureNearestFilter() {
        class_1060 tm = class_310.method_1551().method_1531();
        class_1044 tex = tm.method_4619(BG);
        if (tex != null) {
            tex.method_4527(false, false);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.computeCanvas();
        context.method_25290(BG, this.canvasX, this.canvasY, 0.0f, 0.0f, 450, 300, 450, 300);
        class_327 tr = this.field_22793;
        if (this.boxes != null) {
            for (PartyBox box : this.boxes) {
                box.render(context, tr, this.canvasX, this.canvasY, 450, 300);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.boxes != null) {
            for (PartyBox box : this.boxes) {
                if (!box.mouseClicked(mouseX, mouseY, button, this.canvasX, this.canvasY, 450, 300, this.field_22793)) continue;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.boxes != null) {
            for (PartyBox box : this.boxes) {
                if (!box.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount, this.canvasX, this.canvasY, 450, 300, this.field_22793)) continue;
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.boxes != null) {
            for (PartyBox box : this.boxes) {
                if (!box.mouseDragged(mouseX, mouseY, button, deltaX, deltaY, this.canvasX, this.canvasY, 450, 300, this.field_22793)) continue;
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.boxes != null) {
            for (PartyBox box : this.boxes) {
                if (!box.mouseReleased(mouseX, mouseY, button, this.canvasX, this.canvasY, 450, 300, this.field_22793)) continue;
                return true;
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.boxes != null) {
            for (PartyBox box : this.boxes) {
                if (!box.keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.boxes != null) {
            for (PartyBox box : this.boxes) {
                if (!box.charTyped(chr, modifiers)) continue;
                return true;
            }
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25421() {
        return false;
    }
}

