/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.screen.box;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.client.gui.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.PlayerPermissions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_8710;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.CompatCommandHelper;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyBox;
import net.pixeldreamstudios.rpgsystems.network.party.PartySettingsPayloads;
import net.pixeldreamstudios.rpgsystems.party.FTBTeamsIntegration;

@Environment(value=EnvType.CLIENT)
public final class PartyInfoBox
implements PartyBox {
    private static final class_2960 DIVIDER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/divider.png");
    private static final class_2960 LEAVE_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/leave_normal.png");
    private static final class_2960 LEAVE_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/leave_hover.png");
    private static final class_2960 SETTINGS_BUTTON = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/settings_button.png");
    private static final boolean DEBUG_BOXES = false;
    private static final boolean DEBUG_GEAR_SLOT = false;
    private static final int TL_BOX_W = 66;
    private static final int TL_BOX_H = 40;
    private static final int TL_BOX_MARGIN = 8;
    private static final int TL_BOX_OFFSET_Y = 15;
    private static final float TEXT_SCALE = 0.5f;
    private static final int BTN_W = 8;
    private static final int BTN_H = 8;
    private static final int BTN_GAP = 2;
    private static final int GEAR_W = 16;
    private static final int GEAR_H = 16;
    private static final int GEAR_PAD = 2;
    private int gearX = -1;
    private int gearY = -1;
    private int gearW = 0;
    private int gearH = 0;
    private static boolean filterSet = false;
    private static boolean showSettings = false;
    private static final float SETTINGS_TEXT_SCALE = 0.55f;
    private static final int SETTINGS_BG = -1610612736;
    private static final int SETTINGS_BORDER = -2130706433;
    private static final int SETTINGS_CHECK_BG = -14013910;
    private static final int SETTINGS_CHECK_TICK = -14564514;
    private static final int SETTINGS_ROW_H = 12;
    private static final String OPT_HELPFUL_NONMEMBERS = "Heal/Buff non-members";
    private static final String OPT_IGNORE_COLLISION = "Ignore party collision";
    private static final LinkedHashMap<String, Boolean> SETTINGS = new LinkedHashMap();
    private int overlayX = 0;
    private int overlayY = 0;
    private int overlayW = 0;
    private int overlayH = 0;
    private static final int GEAR_SPIN_DURATION_MS = 300;
    private static long gearAnimStartMs;
    private static int gearAnimDir;
    private static float gearAnimAngle;
    private int settingsPanelGearX = -1;
    private int settingsPanelGearY = -1;
    private static final int SETTINGS_GEAR_SIZE = 12;

    @Override
    public void render(class_332 ctx, class_327 tr, int canvasX, int canvasY, int canvasW, int canvasH) {
        boolean hoverLeave;
        int topLineY;
        PartyInfoBox.ensureFilters();
        int x = canvasX + 8 + 18;
        int y = canvasY + 8 + 15;
        int w = 66;
        int h = 40;
        String partyNameRaw = ClientPartyHudData.partyName != null && !ClientPartyHudData.partyName.isBlank() ? ClientPartyHudData.partyName : "Party";
        String leaderNameRaw = this.getLeaderName();
        float s = 0.5f;
        Objects.requireNonNull(tr);
        int fontH = 9;
        int scaledFontH = Math.round((float)fontH * s);
        int dividerH = 2;
        String partyName = PartyInfoBox.ellipsizeScaled(tr, partyNameRaw, w - 4, s);
        int partyX = PartyInfoBox.centeredScaledTextX(tr, partyName, x, w, s);
        int partyY = topLineY = y + (h - (scaledFontH + 2 + dividerH + 2 + scaledFontH)) / 2;
        PartyInfoBox.drawScaledText(ctx, tr, partyName, partyX, partyY - 5, -1, s);
        int divW = w - 16;
        int divX = x + (w - divW) / 2;
        int divY = partyY + scaledFontH + 2;
        ctx.method_25290(DIVIDER, divX, divY, 0.0f, 0.0f, divW, dividerH + 3, divW, dividerH + 3);
        int leaderTextAreaW = w - 10;
        String leaderName = PartyInfoBox.ellipsizeScaled(tr, leaderNameRaw, leaderTextAreaW - 4, s);
        int leaderTextX = PartyInfoBox.centeredScaledTextXWithinWidth(tr, leaderName, x, leaderTextAreaW, s);
        int leaderTextY = divY + dividerH + 2 + 5;
        PartyInfoBox.drawScaledText(ctx, tr, leaderName, leaderTextX, leaderTextY, -1052689, s);
        int leaderTextWpx = Math.round((float)tr.method_1727(leaderName) * s);
        int btnX = leaderTextX + leaderTextWpx + 2;
        int btnTopBaseline = leaderTextY;
        int btnY = btnTopBaseline + (scaledFontH - 8) / 2;
        if (btnX + 8 > x + w) {
            btnX = x + w - 8;
        }
        ctx.method_25290((hoverLeave = PartyInfoBox.isMouseOver(btnX, btnY, 8, 8)) ? LEAVE_HOVER : LEAVE_NORMAL, btnX, btnY, 0.0f, 0.0f, 4, 7, 4, 7);
        if (gearAnimDir != 0) {
            long now = System.currentTimeMillis();
            float t = (float)(now - gearAnimStartMs) / 300.0f;
            if (t >= 1.0f) {
                gearAnimAngle = 0.0f;
                gearAnimDir = 0;
            } else {
                gearAnimAngle = (float)gearAnimDir * 360.0f * t;
            }
        }
        this.gearW = 16;
        this.gearH = 16;
        this.gearX = x + w - 2 - this.gearW;
        int desiredGearY = btnY + (8 - this.gearH) / 2;
        this.gearY = Math.max(y + 2, Math.min(y + h - 2 - this.gearH, desiredGearY));
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)this.gearX + (float)this.gearW / 2.0f, (float)this.gearY + (float)this.gearH / 2.0f, 0.0f);
        if (gearAnimAngle != 0.0f) {
            m.method_22907(class_7833.field_40718.rotationDegrees(gearAnimAngle));
        }
        m.method_22905(0.75f, 0.75f, 1.0f);
        ctx.method_25290(SETTINGS_BUTTON, -this.gearW / 2, -this.gearH / 2, 0.0f, 0.0f, this.gearW, this.gearH, 16, 16);
        m.method_22909();
        SETTINGS.put(OPT_HELPFUL_NONMEMBERS, ClientPartyHudData.allowHelpfulNonMembers());
        SETTINGS.put(OPT_IGNORE_COLLISION, ClientPartyHudData.ignorePartyCollision());
        if (showSettings) {
            int rows = Math.max(1, SETTINGS.size());
            int innerPad = 6;
            int rowGap = 2;
            int listH = rows * 12 + (rows - 1) * rowGap;
            int titleH = 12;
            int boxW = 158;
            int boxH = innerPad + titleH + 4 + listH + innerPad;
            int bx = Math.min(canvasX + canvasW - 8 - boxW, Math.max(x, this.gearX + this.gearW + 4));
            int by = Math.max(canvasY + 8, Math.min(y, canvasY + canvasH - 8 - boxH));
            by = Math.min(by + 40, canvasY + canvasH - 8 - boxH);
            this.overlayX = bx;
            this.overlayY = by;
            this.overlayW = boxW;
            this.overlayH = boxH;
            ctx.method_25294(bx, by, bx + boxW, by + boxH, -1610612736);
            PartyInfoBox.drawBorder(ctx, bx, by, boxW, boxH, -2130706433);
            int titleTextX = bx + innerPad;
            PartyInfoBox.drawScaledText(ctx, tr, "Settings", titleTextX, by + innerPad, -1, 0.55f);
            this.settingsPanelGearX = bx + boxW - innerPad - 12;
            this.settingsPanelGearY = by + innerPad;
            boolean hoverSettingsGear = PartyInfoBox.isMouseOver(this.settingsPanelGearX, this.settingsPanelGearY, 12, 12);
            m.method_22903();
            m.method_46416((float)this.settingsPanelGearX + 6.0f, (float)this.settingsPanelGearY + 6.0f, 0.0f);
            m.method_22905(0.6f, 0.6f, 1.0f);
            int gearColor = hoverSettingsGear ? -1 : -5592406;
            ctx.method_25290(SETTINGS_BUTTON, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            m.method_22909();
            int listTop = by + innerPad + titleH + 4;
            int cx0 = bx + innerPad;
            int tx0 = cx0 + 12 + 6;
            int yRow = listTop;
            for (Map.Entry<String, Boolean> e : SETTINGS.entrySet()) {
                int cbX = cx0;
                int cbY = yRow + 1;
                int cbS = 10;
                ctx.method_25294(cbX, cbY, cbX + cbS, cbY + cbS, -14013910);
                PartyInfoBox.drawBorder(ctx, cbX, cbY, cbS, cbS, -1);
                if (Boolean.TRUE.equals(e.getValue())) {
                    ctx.method_25294(cbX + 2, cbY + 2, cbX + cbS - 2, cbY + cbS - 2, -14564514);
                }
                PartyInfoBox.drawScaledText(ctx, tr, e.getKey(), tx0, yRow + 3, -1052689, 0.55f);
                yRow += 14;
            }
        } else {
            this.overlayH = 0;
            this.overlayW = 0;
            this.settingsPanelGearY = -1;
            this.settingsPanelGearX = -1;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        if (showSettings) {
            int listTop;
            boolean clickedInside;
            boolean bl = clickedInside = mouseX >= (double)this.overlayX && mouseX < (double)(this.overlayX + this.overlayW) && mouseY >= (double)this.overlayY && mouseY < (double)(this.overlayY + this.overlayH);
            if (this.settingsPanelGearX >= 0 && this.settingsPanelGearY >= 0 && mouseX >= (double)this.settingsPanelGearX && mouseX < (double)(this.settingsPanelGearX + 12) && mouseY >= (double)this.settingsPanelGearY && mouseY < (double)(this.settingsPanelGearY + 12)) {
                if (FabricLoader.getInstance().isModLoaded("ftbteams") && FTBTeamsIntegration.isEnabled()) {
                    this.openFTBTeamsPropertyConfig();
                }
                return true;
            }
            if (!clickedInside) {
                showSettings = false;
                PartyInfoBox.startGearSpin(-1);
                return true;
            }
            int innerPad = 6;
            int titleH = 12;
            int rowGap = 2;
            int yRow = listTop = this.overlayY + innerPad + titleH + 4;
            for (Map.Entry<String, Boolean> e : SETTINGS.entrySet()) {
                int rowTop = yRow;
                int rowBottom = yRow + 12;
                if (mouseY >= (double)rowTop && mouseY < (double)rowBottom) {
                    boolean currentVal = Boolean.TRUE.equals(e.getValue());
                    boolean newVal = !currentVal;
                    boolean leader = PartyInfoBox.isLocalPlayerLeader();
                    if (OPT_HELPFUL_NONMEMBERS.equals(e.getKey())) {
                        if (ClientPartyHudData.partyId != null) {
                            ClientPlayNetworking.send((class_8710)new PartySettingsPayloads.SetAllowHelpfulNonMembers(newVal));
                        }
                    } else if (OPT_IGNORE_COLLISION.equals(e.getKey()) && ClientPartyHudData.partyId != null) {
                        ClientPlayNetworking.send((class_8710)new PartySettingsPayloads.SetIgnorePartyCollision(newVal));
                    }
                    if (leader) {
                        SETTINGS.put(e.getKey(), newVal);
                    }
                    return true;
                }
                yRow += 12 + rowGap;
            }
            return true;
        }
        int x = canvasX + 8 + 18;
        int y = canvasY + 8 + 15;
        int w = 66;
        int h = 40;
        float s = 0.5f;
        Objects.requireNonNull(tr);
        int fontH = 9;
        int scaledFontH = Math.round((float)fontH * s);
        int dividerH = 2;
        String leaderNameRaw = this.getLeaderName();
        int topLineY = y + (h - (scaledFontH + 2 + dividerH + 2 + scaledFontH)) / 2;
        int divY = topLineY + scaledFontH + 2;
        int leaderTextAreaW = w - 10;
        String leaderName = PartyInfoBox.ellipsizeScaled(tr, leaderNameRaw, leaderTextAreaW - 4, s);
        int leaderTextX = PartyInfoBox.centeredScaledTextXWithinWidth(tr, leaderName, x, leaderTextAreaW, s);
        int leaderTextY = divY + dividerH + 2 + 5;
        int leaderTextWpx = Math.round((float)tr.method_1727(leaderName) * s);
        int btnX = leaderTextX + leaderTextWpx + 2;
        int btnY = leaderTextY + (scaledFontH - 8) / 2;
        if (btnX + 8 > x + w) {
            btnX = x + w - 8;
        }
        this.gearW = 16;
        this.gearH = 16;
        this.gearX = x + w - 2 - this.gearW;
        int desiredGearY = btnY + (8 - this.gearH) / 2;
        this.gearY = Math.max(y + 2, Math.min(y + h - 2 - this.gearH, desiredGearY));
        if (mouseX >= (double)this.gearX && mouseX < (double)(this.gearX + this.gearW) && mouseY >= (double)this.gearY && mouseY < (double)(this.gearY + this.gearH)) {
            boolean opening;
            showSettings = opening = !showSettings;
            PartyInfoBox.startGearSpin(opening ? 1 : -1);
            return true;
        }
        if (PartyInfoBox.isMouseOver(btnX, btnY, 8, 8)) {
            class_310 mc = class_310.method_1551();
            CompatCommandHelper.sendLeaveCommand();
            if (mc != null) {
                mc.method_1507(null);
            }
            return true;
        }
        return false;
    }

    private void openFTBTeamsPropertyConfig() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        ClientTeamManager manager = FTBTeamsAPI.api().getClientManager();
        if (manager == null) {
            return;
        }
        Team team = manager.selfTeam();
        if (team == null) {
            return;
        }
        TeamPropertyCollection properties = team.getProperties();
        TeamRank playerRank = team.getRankForPlayer(mc.field_1724.method_5667());
        boolean canModify = playerRank.isNoneOrBetter() || playerRank.isOfficerOrBetter();
        PlayerPermissions permissions = new PlayerPermissions(canModify, canModify, canModify);
        MyTeamScreen myTeamScreen = new MyTeamScreen(properties, permissions);
        myTeamScreen.openGui();
    }

    private static void startGearSpin(int dir) {
        gearAnimDir = dir;
        gearAnimStartMs = System.currentTimeMillis();
        gearAnimAngle = 0.0f;
    }

    private static boolean isLocalPlayerLeader() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return false;
        }
        if (ClientPartyHudData.leaderUuid == null) {
            return true;
        }
        return mc.field_1724.method_5667().equals(ClientPartyHudData.leaderUuid);
    }

    private static void ensureFilters() {
        if (filterSet) {
            return;
        }
        class_1060 tm = class_310.method_1551().method_1531();
        for (class_2960 id : new class_2960[]{DIVIDER, LEAVE_NORMAL, LEAVE_HOVER, SETTINGS_BUTTON}) {
            class_1044 tex = tm.method_4619(id);
            if (tex == null) continue;
            tex.method_4527(false, false);
        }
        filterSet = true;
    }

    private static String ellipsizeScaled(class_327 tr, String s, int maxPx, float scale) {
        if (Math.round((float)tr.method_1727(s) * scale) <= maxPx) {
            return s;
        }
        String dots = "...";
        int dw = Math.round((float)tr.method_1727(dots) * scale);
        StringBuilder b = new StringBuilder(s);
        while (b.length() > 0 && Math.round((float)tr.method_1727(b.toString()) * scale) + dw > maxPx) {
            b.deleteCharAt(b.length() - 1);
        }
        return String.valueOf(b) + dots;
    }

    private static int centeredScaledTextX(class_327 tr, String text, int boxX, int boxW, float scale) {
        return Math.round((float)boxX + ((float)boxW - (float)tr.method_1727(text) * scale) / 2.0f);
    }

    private static int centeredScaledTextXWithinWidth(class_327 tr, String text, int leftX, int width, float scale) {
        return Math.round((float)leftX + ((float)width - (float)tr.method_1727(text) * scale) / 2.0f);
    }

    private String getLeaderName() {
        class_310 mc;
        if (ClientPartyHudData.leaderUuid != null) {
            for (ClientPartyHudData.Member m : ClientPartyHudData.members()) {
                if (!m.uuid.equals(ClientPartyHudData.leaderUuid)) continue;
                return m.name;
            }
        }
        return (mc = class_310.method_1551()) != null && mc.field_1724 != null ? mc.field_1724.method_5477().getString() : "";
    }

    private static void drawScaledText(class_332 ctx, class_327 tr, String text, int x, int y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    private static boolean isMouseOver(int x, int y, int w, int h) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return false;
        }
        double mx = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double my = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private static void drawBorder(class_332 ctx, int x, int y, int w, int h, int argb) {
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x, y + 1, x + 1, y + h - 1, argb);
        ctx.method_25294(x + w - 1, y + 1, x + w, y + h - 1, argb);
    }

    static {
        SETTINGS.put(OPT_HELPFUL_NONMEMBERS, ClientPartyHudData.allowHelpfulNonMembers());
        SETTINGS.put(OPT_IGNORE_COLLISION, ClientPartyHudData.ignorePartyCollision());
        gearAnimStartMs = 0L;
        gearAnimDir = 0;
        gearAnimAngle = 0.0f;
    }
}

