/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.party.screen.box;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_8710;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyInvites;
import net.pixeldreamstudios.rpgsystems.client.party.CompatCommandHelper;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyBox;
import net.pixeldreamstudios.rpgsystems.client.party.screen.box.PartyMemberInfoBox;
import net.pixeldreamstudios.rpgsystems.network.party.PartyInvitePayloads;

@Environment(value=EnvType.CLIENT)
public final class PartyInviteBox
implements PartyBox {
    private static final int TL_BOX_W = 120;
    private static final int TL_BOX_MARGIN = 8;
    private static final int TL_BOX_OFFSET_Y = 15;
    private static final int GAP_FROM_LEFT_COLUMN = 12;
    private static final int SHIFT_LEFT = 60;
    private static final int LEFT_OF_INVITES_W = 255;
    private static final int GAP_FROM_CHAT = 6;
    private static final int BOX_W = 66;
    private static final int BOX_H = 120;
    private static final int PAD = 3;
    private static final float TITLE_SCALE = 0.5f;
    private static final float ROW_SCALE = 0.5f;
    private static final int BG = 1075943155;
    private static final int BORDER = -14575885;
    private static final int TITLE_COLOR = -1;
    private static final int ROW_COLOR = -1052689;
    private static final int EMPTY_COLOR = -4276546;
    private static final int BTN_W = 14;
    private static final int BTN_H = 14;
    private static final int INPUT_BG = 0x40101010;
    private static final int INPUT_BORDER = -2130706433;
    private static final int LIST_BG = -535818224;
    private static final int LIST_BORDER = -1862270977;
    private static final int HOVER_BG = -2144097537;
    private static final int BUTTON_BG = -2144036645;
    private static final int BUTTON_BG_HOVER = -1607165733;
    private static final String PLACEHOLDER = "Select\u2026";
    private static final int BUBBLE_PAD_H = 3;
    private static final int BUBBLE_PAD_V = 2;
    private static final int BUBBLE_GAP = 3;
    private static final int BUBBLE_RADIUS = 3;
    private static final int BUBBLE_BG = -1875692749;
    private static final long INVITE_TTL_MS = 60000L;
    private boolean dropdownOpen = false;
    private String selectedName = null;
    private List<String> candidates = List.of();
    private int listScroll = 0;
    private int invitesScrollPx = 0;
    private int boxX;
    private int boxY;
    private int boxW;
    private int boxH;
    private int ddX;
    private int ddY;
    private int ddW;
    private int ddH;
    private int btnX;
    private int btnY;
    private int btnW;
    private int btnH;
    private int listX;
    private int listY;
    private int listW;
    private int listH;
    private int listRowH;
    private static final class_2960 TEX_SEND_NORMAL = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_invite_send_normal.png");
    private static final class_2960 TEX_SEND_HOVER = class_2960.method_60655((String)"rpg-systems", (String)"textures/gui/button/party_invite_send_hover.png");
    private int invitesLeft;
    private int invitesTop;
    private int invitesRight;
    private int invitesBottom;
    private int bubbleH;
    private int bubbleW;
    private int bubbleTextMax;
    private int textHScaled;

    @Override
    public void render(class_332 ctx, class_327 tr, int canvasX, int canvasY, int canvasW, int canvasH) {
        int contentLeft = canvasX + 8 + 18;
        int infoTop = canvasY + 8 + 15;
        int xLeftCol = contentLeft + 120;
        this.boxX = xLeftCol + 12 - 60 + 255 + 6 - 1;
        this.boxY = infoTop + PartyMemberInfoBox.getPreferredHeight() + 4 - 46;
        this.boxW = 66;
        this.boxH = 120;
        String title = "Invites Sent";
        int titleY = this.boxY + 3;
        int titleX = PartyInviteBox.centeredScaledTextX(tr, title, this.boxX, this.boxW, 0.5f);
        PartyInviteBox.drawScaledText(ctx, tr, title, titleX, titleY, -1, 0.5f);
        Objects.requireNonNull(tr);
        int titleHpx = Math.round(9.0f * 0.5f);
        int topAfterTitle = titleY + titleHpx + 4;
        Objects.requireNonNull(tr);
        this.textHScaled = Math.round(9.0f * 0.5f);
        float BTN_VIS_SCALE = 0.5f;
        int scaledBtnH = Math.max(6, Math.round(7.0f));
        this.ddH = Math.max(scaledBtnH, this.textHScaled + 2);
        this.ddX = this.boxX + 3;
        this.ddY = topAfterTitle;
        this.ddW = Math.max(10, this.boxX + this.boxW - 3 - 14 - 2 - this.ddX);
        this.btnW = 14;
        this.btnH = 14;
        this.btnX = this.boxX + this.boxW - 3 - this.btnW;
        this.btnY = this.ddY + (this.ddH - 14) / 2 - 1;
        ctx.method_25294(this.ddX, this.ddY, this.ddX + this.ddW, this.ddY + this.ddH, 0x40101010);
        PartyInviteBox.drawBorder(ctx, this.ddX, this.ddY, this.ddW, this.ddH, -2130706433);
        String shown = this.selectedName == null || this.selectedName.isBlank() ? PLACEHOLDER : this.selectedName;
        int shownColor = this.selectedName == null ? -4276546 : -1052689;
        PartyInviteBox.drawScaledText(ctx, tr, PartyInviteBox.ellipsize(tr, shown, this.ddW - 4, 0.5f), this.ddX + 2, this.ddY + (this.ddH - this.textHScaled) / 2 + 1, shownColor, 0.5f);
        boolean hoverBtn = PartyInviteBox.isMouseOver(this.btnX, this.btnY, this.btnW, this.btnH);
        int ox = this.btnX + Math.round(((float)this.btnW - (float)this.btnW * 0.5f) / 2.0f);
        int oy = this.btnY + Math.round(((float)this.btnH - (float)this.btnH * 0.5f) / 2.0f);
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)ox, (float)oy, 0.0f);
        m.method_22905(0.5f, 0.5f, 1.0f);
        ctx.method_25290(hoverBtn ? TEX_SEND_HOVER : TEX_SEND_NORMAL, 0, 0, 0.0f, 0.0f, this.btnW, this.btnH, this.btnW, this.btnH);
        m.method_22909();
        int listTopFixed = this.ddY + this.ddH + 3;
        this.invitesLeft = this.boxX + 3;
        this.invitesRight = this.boxX + this.boxW - 3;
        this.invitesTop = listTopFixed;
        this.invitesBottom = this.boxY + this.boxH - 3;
        this.bubbleW = Math.max(0, this.invitesRight - this.invitesLeft);
        this.bubbleTextMax = Math.max(0, this.bubbleW - 6);
        this.bubbleH = Math.max(6, this.textHScaled + 4);
        List<ClientPartyInvites.Sent> sent = PartyInviteBox.visibleInvites();
        long now = System.currentTimeMillis();
        int visibleH = Math.max(0, this.invitesBottom - this.invitesTop);
        int count = sent.size();
        int totalH = count == 0 ? 0 : count * (this.bubbleH + 3) - 3;
        int maxScrollPx = Math.max(0, totalH - visibleH);
        if (this.invitesScrollPx > maxScrollPx) {
            this.invitesScrollPx = maxScrollPx;
        }
        if (this.invitesScrollPx < 0) {
            this.invitesScrollPx = 0;
        }
        ctx.method_44379(this.invitesLeft, this.invitesTop, this.invitesRight, this.invitesBottom);
        if (sent.isEmpty()) {
            String empty = "No invites sent";
            int tw = Math.round((float)tr.method_1727(empty) * 0.5f);
            PartyInviteBox.drawScaledText(ctx, tr, empty, this.boxX + (this.boxW - tw) / 2, this.invitesTop + Math.max(0, (visibleH - this.textHScaled) / 2), -4276546, 0.5f);
        } else {
            int yCursor = this.invitesTop - this.invitesScrollPx;
            for (ClientPartyInvites.Sent s : sent) {
                int bx = this.invitesLeft;
                int by = yCursor;
                if (by + this.bubbleH >= this.invitesTop && by <= this.invitesBottom - 1) {
                    PartyInviteBox.drawSoftRounded(ctx, bx, by, this.bubbleW, this.bubbleH, 3, -1875692749);
                    long rem = Math.max(0L, 60000L - (now - s.createdAt));
                    String timeTxt = PartyInviteBox.formatMmSs(rem);
                    int timeW = Math.round((float)tr.method_1727(timeTxt) * 0.5f);
                    int nameMaxPx = Math.max(0, this.bubbleTextMax - timeW - 4);
                    String nameTxt = PartyInviteBox.ellipsize(tr, s.targetName == null ? "Unknown" : s.targetName, nameMaxPx, 0.5f);
                    int txName = bx + 3;
                    int ty = by + (this.bubbleH - this.textHScaled) / 2;
                    PartyInviteBox.drawScaledText(ctx, tr, nameTxt, txName, ty, -1052689, 0.5f);
                    int txTime = bx + this.bubbleW - 3 - Math.round(timeW);
                    PartyInviteBox.drawScaledText(ctx, tr, timeTxt, txTime, ty, -1052689, 0.5f);
                }
                if ((yCursor += this.bubbleH + 3) <= this.invitesBottom) continue;
                break;
            }
        }
        ctx.method_44380();
        this.candidates = PartyInviteBox.getInvitableNames();
        if (this.selectedName != null && this.candidates.stream().noneMatch(n -> n.equalsIgnoreCase(this.selectedName))) {
            this.selectedName = null;
        }
        if (this.dropdownOpen) {
            Objects.requireNonNull(tr);
            int textH = Math.round(9.0f * 0.5f);
            this.listRowH = Math.max(6, textH + 2);
            int maxRows = Math.max(3, Math.min(8, this.boxY + this.boxH - 3 - (this.ddY + this.ddH + 2)) / this.listRowH);
            this.listX = this.ddX;
            this.listY = this.ddY + this.ddH + 2;
            this.listW = this.ddW;
            this.listH = Math.min(this.candidates.size(), maxRows) * this.listRowH + 2;
            ctx.method_25294(this.listX, this.listY, this.listX + this.listW, this.listY + this.listH, -535818224);
            PartyInviteBox.drawBorder(ctx, this.listX, this.listY, this.listW, this.listH, -1862270977);
            int maxScroll = Math.max(0, this.candidates.size() - maxRows);
            if (this.listScroll > maxScroll) {
                this.listScroll = maxScroll;
            }
            if (this.listScroll < 0) {
                this.listScroll = 0;
            }
            ctx.method_44379(this.listX + 1, this.listY + 1, this.listX + this.listW - 1, this.listY + this.listH - 1);
            int drawY = this.listY + 1;
            for (int i = 0; i < Math.min(maxRows, this.candidates.size() - this.listScroll); ++i) {
                int idx = this.listScroll + i;
                String name = this.candidates.get(idx);
                int rowTop = drawY + i * this.listRowH;
                boolean hover = PartyInviteBox.isMouseOver(this.listX + 1, rowTop, this.listW - 2, this.listRowH);
                if (hover) {
                    ctx.method_25294(this.listX + 1, rowTop, this.listX + this.listW - 1, rowTop + this.listRowH, -2144097537);
                }
                PartyInviteBox.drawScaledText(ctx, tr, PartyInviteBox.ellipsize(tr, name, this.listW - 6, 0.5f), this.listX + 3, rowTop + (this.listRowH - this.textHScaled) / 2, -1, 0.5f);
            }
            ctx.method_44380();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        if (!PartyInviteBox.isMouseOver(this.boxX, this.boxY, this.boxW, this.boxH)) {
            return false;
        }
        if (PartyInviteBox.isMouseOver(this.btnX, this.btnY, this.btnW, this.btnH)) {
            if (this.selectedName != null && !this.selectedName.isBlank()) {
                PartyInviteBox.sendInvite(this.selectedName);
                this.selectedName = null;
                this.dropdownOpen = false;
            }
            return true;
        }
        if (PartyInviteBox.isMouseOver(this.ddX, this.ddY, this.ddW, this.ddH)) {
            boolean bl = this.dropdownOpen = !this.dropdownOpen;
            if (this.dropdownOpen) {
                PartyInviteBox.requestEligibleFromServer();
            }
            return true;
        }
        if (this.dropdownOpen && PartyInviteBox.isMouseOver(this.listX, this.listY, this.listW, this.listH)) {
            int relY = (int)mouseY - this.listY - 1;
            int idx = this.listScroll + relY / this.listRowH;
            if (idx >= 0 && idx < this.candidates.size()) {
                this.selectedName = this.candidates.get(idx);
                this.dropdownOpen = false;
            }
            return true;
        }
        if (this.dropdownOpen) {
            this.dropdownOpen = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double ha, double va, int canvasX, int canvasY, int canvasW, int canvasH, class_327 tr) {
        if (this.dropdownOpen && PartyInviteBox.isMouseOver(this.listX, this.listY, this.listW, this.listH)) {
            int maxRows = Math.max(3, this.listH > 0 ? (this.listH - 2) / Math.max(1, this.listRowH) : 0);
            int maxScroll = Math.max(0, this.candidates.size() - maxRows);
            if (maxScroll > 0) {
                this.listScroll = Math.max(0, Math.min(maxScroll, this.listScroll - (int)Math.signum(va)));
            }
            return true;
        }
        if (PartyInviteBox.isMouseOver(this.invitesLeft, this.invitesTop, this.invitesRight - this.invitesLeft, this.invitesBottom - this.invitesTop)) {
            int step = this.bubbleH + 3;
            int count = PartyInviteBox.visibleInvites().size();
            int totalH = Math.max(0, count * (this.bubbleH + 3) - 3);
            int visibleH = Math.max(0, this.invitesBottom - this.invitesTop);
            int maxScrollPx = Math.max(0, totalH - visibleH);
            this.invitesScrollPx = Math.max(0, Math.min(maxScrollPx, this.invitesScrollPx + (int)Math.round(va * (double)step)));
            return true;
        }
        return false;
    }

    private static String formatMmSs(long ms) {
        long sec = Math.max(0L, (ms + 999L) / 1000L);
        long m = sec / 60L;
        long s = sec % 60L;
        return m + ":" + (String)(s < 10L ? "0" + s : String.valueOf(s));
    }

    private static void drawScaledText(class_332 ctx, class_327 tr, String text, int x, int y, int color, float scale) {
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_46416((float)x, (float)y, 0.0f);
        m.method_22905(scale, scale, 1.0f);
        ctx.method_51433(tr, text, 0, 0, color, false);
        m.method_22909();
    }

    private static int centeredScaledTextX(class_327 tr, String text, int boxX, int boxW, float scale) {
        return Math.round((float)boxX + ((float)boxW - (float)tr.method_1727(text) * scale) / 2.0f);
    }

    private static String ellipsize(class_327 tr, String s, int maxPixels, float scale) {
        if (Math.round((float)tr.method_1727(s) * scale) <= maxPixels) {
            return s;
        }
        String dots = "...";
        int dw = Math.round((float)tr.method_1727(dots) * scale);
        StringBuilder b = new StringBuilder(s);
        while (b.length() > 0 && Math.round((float)tr.method_1727(b.toString()) * scale) + dw > maxPixels) {
            b.deleteCharAt(b.length() - 1);
        }
        return String.valueOf(b) + dots;
    }

    private static void drawBorder(class_332 ctx, int x, int y, int w, int h, int argb) {
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, 0);
    }

    private static void drawSoftRounded(class_332 ctx, int x, int y, int w, int h, int r, int argb) {
        r = Math.max(2, Math.min(r, Math.min(w / 2, h / 2)));
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, argb);
        ctx.method_25294(x + r - 1, y, x + w - (r - 1), y + 1, argb);
        ctx.method_25294(x + r - 1, y + h - 1, x + w - (r - 1), y + h, argb);
        ctx.method_25294(x, y + r - 1, x + 1, y + h - (r - 1), argb);
        ctx.method_25294(x + w - 1, y + r - 1, x + w, y + h - (r - 1), argb);
    }

    private static boolean isMouseOver(int x, int y, int w, int h) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return false;
        }
        double mx = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double my = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private static List<String> getInvitableNames() {
        Set<String> eligible = ClientPartyInvites.eligibleNames();
        Set alreadyInvited = ClientPartyInvites.sent().stream().map(s -> s.targetName == null ? "" : s.targetName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        Set myPartyLower = ClientPartyHudData.members().stream().map(m -> m.name == null ? "" : m.name.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        List<String> out = eligible.stream().filter(n -> !alreadyInvited.contains(n.toLowerCase(Locale.ROOT))).filter(n -> !myPartyLower.contains(n.toLowerCase(Locale.ROOT))).sorted(String.CASE_INSENSITIVE_ORDER).toList();
        return out;
    }

    private static void sendInvite(String targetName) {
        if (targetName == null || targetName.isBlank()) {
            return;
        }
        CompatCommandHelper.sendInviteCommand(targetName);
    }

    private static List<ClientPartyInvites.Sent> visibleInvites() {
        ArrayList<ClientPartyInvites.Sent> sent = new ArrayList<ClientPartyInvites.Sent>(ClientPartyInvites.sent());
        Set partyNamesLower = ClientPartyHudData.members().stream().map(m -> m.name == null ? "" : m.name.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        if (!partyNamesLower.isEmpty()) {
            sent.removeIf(s -> s.targetName != null && partyNamesLower.contains(s.targetName.toLowerCase(Locale.ROOT)));
        }
        return sent;
    }

    private static void requestEligibleFromServer() {
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.method_1562() != null) {
            ClientPlayNetworking.send((class_8710)new PartyInvitePayloads.EligibleInviteesRequest());
        }
    }
}

