/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2960;
import net.pixeldreamstudios.rpgsystems.network.title.TitlePayloads;

public final class TitleClientData {
    private static final Set<class_2960> selfUnlocked = new HashSet<class_2960>();
    private static class_2960 selfActive;
    private static final Map<UUID, class_2960> othersActive;
    private static Set<String> PERMA_DISABLED;
    private static final Map<class_2960, List<CondProg>> selfProgress;

    private TitleClientData() {
    }

    public static void setPermaDisabled(Set<String> s) {
        PERMA_DISABLED = s;
    }

    public static Set<String> getPermaDisabled() {
        return PERMA_DISABLED;
    }

    public static void clear() {
        selfUnlocked.clear();
        selfActive = null;
        othersActive.clear();
        selfProgress.clear();
        PERMA_DISABLED.clear();
    }

    public static void setSelf(Collection<class_2960> unlocked, class_2960 active) {
        selfUnlocked.clear();
        selfUnlocked.addAll(unlocked);
        selfActive = active;
    }

    public static void setActive(UUID player, class_2960 active) {
        othersActive.put(player, active);
    }

    public static Set<class_2960> getSelfUnlocked() {
        return Collections.unmodifiableSet(selfUnlocked);
    }

    public static class_2960 getSelfActive() {
        return selfActive;
    }

    public static class_2960 getActive(UUID player) {
        return othersActive.get(player);
    }

    public static void setProgress(List<TitlePayloads.SyncProgress.TitleProgress> list) {
        selfProgress.clear();
        for (TitlePayloads.SyncProgress.TitleProgress tp : list) {
            ArrayList<CondProg> conds = new ArrayList<CondProg>(tp.conditions().size());
            for (TitlePayloads.SyncProgress.CondProg cp : tp.conditions()) {
                conds.add(new CondProg(cp.current(), cp.done()));
            }
            selfProgress.put(tp.id(), conds);
        }
    }

    public static List<CondProg> getProgress(class_2960 titleId) {
        return selfProgress.getOrDefault(titleId, Collections.emptyList());
    }

    static {
        othersActive = new HashMap<UUID, class_2960>();
        PERMA_DISABLED = new LinkedHashSet<String>();
        selfProgress = new HashMap<class_2960, List<CondProg>>();
    }

    public record CondProg(long current, boolean done) {
    }
}

