/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.title;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import net.pixeldreamstudios.rpgsystems.title.Title;

@Environment(value=EnvType.CLIENT)
public final class TitleIconRenderer {
    private static final Map<class_2960, class_1799> ITEM_CACHE = new HashMap<class_2960, class_1799>();
    private static final Map<class_2960, class_1309> ENTITY_CACHE = new HashMap<class_2960, class_1309>();

    private TitleIconRenderer() {
    }

    public static boolean hasIcon(Title.Condition c) {
        if (c.item.isPresent() || c.block.isPresent()) {
            return true;
        }
        class_2960 mobId = TitleIconRenderer.resolveEntityId(c);
        return mobId != null;
    }

    public static boolean renderForCondition(class_332 ctx, Title.Condition c, int x, int y, int sizePx) {
        class_2960 id;
        class_1792 blockItem;
        if (sizePx <= 0) {
            return false;
        }
        if (c.item.isPresent()) {
            return TitleIconRenderer.drawItem(ctx, c.item.get(), x, y, sizePx);
        }
        if (c.block.isPresent() && (blockItem = ((class_2248)class_7923.field_41175.method_10223(id = c.block.get())).method_8389()) != null) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)blockItem);
            return TitleIconRenderer.drawItem(ctx, itemId, x, y, sizePx);
        }
        class_2960 mobId = TitleIconRenderer.resolveEntityId(c);
        if (mobId != null) {
            return TitleIconRenderer.drawEntityIcon(ctx, mobId, x, y, sizePx);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawMob(class_332 context, int x, int y, int scale, int mouseX, int mouseY, class_1309 entity) {
        class_310 client = class_310.method_1551();
        class_898 dispatcher = client.method_1561();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 100.0);
        matrices.method_22905((float)scale, (float)(-scale), (float)scale);
        float yOff = 0.5f + entity.method_17682() * 0.5f;
        matrices.method_22904(0.0, (double)(-yOff), 0.0);
        try {
            dispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrices, (class_4597)context.method_51450(), 0xF000F0);
        }
        catch (Throwable t) {
            class_327 renderer = client.field_1772;
            int textWidth = renderer.method_1727("Can't render mob");
            context.method_27535(renderer, (class_2561)class_2561.method_43470((String)"Can't render mob"), x - textWidth / 2, y - 10, 0xFF5555);
        }
        finally {
            matrices.method_22909();
        }
    }

    private static boolean drawItem(class_332 ctx, class_2960 itemId, int x, int y, int sizePx) {
        if (!class_7923.field_41178.method_10250(itemId)) {
            return false;
        }
        class_1799 stack = ITEM_CACHE.computeIfAbsent(itemId, id -> new class_1799((class_1935)class_7923.field_41178.method_10223(id)));
        if (stack.method_7960()) {
            return false;
        }
        float s = (float)sizePx / 16.0f;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)x, (float)y, 0.0f);
        ctx.method_51448().method_22905(s, s, 1.0f);
        ctx.method_51427(stack, 0, 0);
        ctx.method_51448().method_22909();
        return true;
    }

    private static boolean drawEntityIcon(class_332 ctx, class_2960 entityTypeId, int x, int y, int sizePx) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return false;
        }
        if (!class_7923.field_41177.method_10250(entityTypeId)) {
            return false;
        }
        class_1309 entity = ENTITY_CACHE.get(entityTypeId);
        if (entity == null) {
            class_1299 et = (class_1299)class_7923.field_41177.method_10223(entityTypeId);
            class_1297 created = et.method_5883((class_1937)mc.field_1687);
            if (!(created instanceof class_1309)) {
                return false;
            }
            entity = (class_1309)created;
            ENTITY_CACHE.put(entityTypeId, entity);
        }
        int cx = x + Math.round((float)sizePx * 0.5f);
        int cy = y + Math.round((float)sizePx * 0.95f);
        float scaleDivisor = 4.0f;
        float scaleBoost = 1.0f;
        int scale = Math.max(1, Math.round((float)sizePx / scaleDivisor * scaleBoost));
        TitleIconRenderer.drawMob(ctx, cx, cy, scale, 0, 0, entity);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renderEntityPreview(class_332 ctx, class_2960 entityTypeId, int x, int y, int sizePx) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return false;
        }
        class_1309 entity = TitleIconRenderer.getPreviewEntity(entityTypeId);
        if (entity == null) {
            return false;
        }
        int cx = x + Math.round((float)sizePx * 0.5f);
        int cy = y + Math.round((float)sizePx * 0.5f);
        int scale = Math.max(1, Math.round((float)sizePx / 4.0f));
        float tickDelta = mc.method_60646().method_60637(false);
        float t = (float)mc.field_1687.method_8510() + tickDelta;
        float angle = t * 2.5f % 360.0f;
        class_898 dispatcher = mc.method_1561();
        class_4587 m = ctx.method_51448();
        m.method_22903();
        m.method_22904((double)cx, (double)cy, 120.0);
        m.method_22905((float)scale, (float)(-scale), (float)scale);
        m.method_22907(class_7833.field_40716.rotationDegrees(angle));
        float yOff = 0.5f + entity.method_17682() * 0.5f;
        m.method_22904(0.0, (double)(-yOff), 0.0);
        try {
            dispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, m, (class_4597)ctx.method_51450(), 0xF000F0);
        }
        catch (Throwable ignored) {
            class_327 r = mc.field_1772;
            int w = r.method_1727("Can't render mob");
            ctx.method_27535(r, (class_2561)class_2561.method_43470((String)"Can't render mob"), cx - w / 2, cy - scale * 12, 0xFF5555);
        }
        finally {
            m.method_22909();
        }
        return true;
    }

    public static class_1309 getPreviewEntity(class_2960 entityTypeId) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return null;
        }
        if (!class_7923.field_41177.method_10250(entityTypeId)) {
            return null;
        }
        class_1309 entity = ENTITY_CACHE.get(entityTypeId);
        if (entity == null) {
            class_1299 et = (class_1299)class_7923.field_41177.method_10223(entityTypeId);
            class_1297 created = et.method_5883((class_1937)mc.field_1687);
            if (!(created instanceof class_1309)) {
                return null;
            }
            entity = (class_1309)created;
            ENTITY_CACHE.put(entityTypeId, entity);
        }
        return entity;
    }

    private static class_2960 resolveEntityId(Title.Condition c) {
        class_2960 maybe;
        if (c.entityType.isPresent()) {
            return c.entityType.get();
        }
        if (c.entitySpec.isPresent() && (maybe = class_2960.method_12829((String)c.entitySpec.get())) != null && class_7923.field_41177.method_10250(maybe)) {
            return maybe;
        }
        return null;
    }
}

