/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.mixin;

import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.party.FTBTeamsIntegration;
import net.pixeldreamstudios.rpgsystems.party.Party;
import net.pixeldreamstudios.rpgsystems.party.PartyAllies;
import net.pixeldreamstudios.rpgsystems.party.PartyPersistentState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class EntityCollisionServerMixin {
    private static boolean samePartyAndIgnore(class_1297 a, class_1297 b) {
        if (a == null || b == null) {
            return false;
        }
        MinecraftServer server = a.method_5682();
        if (server == null) {
            return false;
        }
        UUID ownerA = PartyAllies.owningPlayerUuid(a);
        UUID ownerB = PartyAllies.owningPlayerUuid(b);
        if (ownerA == null || ownerB == null) {
            return false;
        }
        if (!PartyAllies.sameParty(server, ownerA, ownerB)) {
            return false;
        }
        if (FabricLoader.getInstance().isModLoaded("ftbteams") && FTBTeamsIntegration.isEnabled()) {
            FTBTeamsIntegration.FTBPartyData ftbData;
            class_3222 owner;
            class_3222 pb;
            FTBTeamsIntegration.FTBPartyData ftbData2;
            if (a instanceof class_3222) {
                class_3222 pa = (class_3222)a;
                FTBTeamsIntegration.FTBPartyData ftbData3 = FTBTeamsIntegration.getPartyDataForPlayer(pa);
                if (ftbData3 != null) {
                    return ftbData3.settings.ignorePartyCollision;
                }
            } else if (b instanceof class_3222 && (ftbData2 = FTBTeamsIntegration.getPartyDataForPlayer(pb = (class_3222)b)) != null) {
                return ftbData2.settings.ignorePartyCollision;
            }
            if ((owner = server.method_3760().method_14602(ownerA)) != null && (ftbData = FTBTeamsIntegration.getPartyDataForPlayer(owner)) != null) {
                return ftbData.settings.ignorePartyCollision;
            }
            return false;
        }
        PartyPersistentState state = PartyPersistentState.get(server);
        Party party = state.getPartyByMember(ownerA);
        if (party == null) {
            return false;
        }
        return party.settings.ignorePartyCollision;
    }

    @Inject(method={"collidesWith(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void rpg$noPartyCollision_collidesWith(class_1297 other, CallbackInfoReturnable<Boolean> cir) {
        class_1297 self = (class_1297)this;
        if (!self.method_37908().field_9236 && EntityCollisionServerMixin.samePartyAndIgnore(self, other)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"pushAwayFrom(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rpg$noPartyCollision_pushAwayFrom(class_1297 other, CallbackInfo ci) {
        class_1297 self = (class_1297)this;
        if (!self.method_37908().field_9236 && EntityCollisionServerMixin.samePartyAndIgnore(self, other)) {
            ci.cancel();
        }
    }
}

