/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.mixin.pet;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.pixeldreamstudios.rpgsystems.pet.PetOwnable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1308.class})
public abstract class MobEntityPetMixin
implements PetOwnable {
    @Unique
    private static final class_2940<Boolean> RPGS_IS_PET = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Optional<UUID>> RPGS_OWNER = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13313);
    @Unique
    private static final class_2940<String> RPGS_PET_NAME = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13326);

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void rpgsystems$initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(RPGS_IS_PET, (Object)false);
        builder.method_56912(RPGS_OWNER, Optional.empty());
        builder.method_56912(RPGS_PET_NAME, (Object)"");
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void rpgsystems$read(class_2487 nbt, CallbackInfo ci) {
        class_2945 dt = ((class_1308)this).method_5841();
        if (nbt.method_10545("RPGS_Pet")) {
            dt.method_12778(RPGS_IS_PET, (Object)nbt.method_10577("RPGS_Pet"));
        }
        if (nbt.method_25928("RPGS_Owner")) {
            dt.method_12778(RPGS_OWNER, Optional.of(nbt.method_25926("RPGS_Owner")));
        } else {
            dt.method_12778(RPGS_OWNER, Optional.empty());
        }
        if (nbt.method_10573("RPGS_Name", 8)) {
            dt.method_12778(RPGS_PET_NAME, (Object)nbt.method_10558("RPGS_Name"));
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void rpgsystems$write(class_2487 nbt, CallbackInfo ci) {
        class_2945 dt = ((class_1308)this).method_5841();
        if (((Boolean)dt.method_12789(RPGS_IS_PET)).booleanValue()) {
            nbt.method_10556("RPGS_Pet", true);
        }
        Optional owner = (Optional)dt.method_12789(RPGS_OWNER);
        owner.ifPresent(uuid -> nbt.method_25927("RPGS_Owner", uuid));
        String name = (String)dt.method_12789(RPGS_PET_NAME);
        if (!name.isEmpty()) {
            nbt.method_10582("RPGS_Name", name);
        }
    }

    @Override
    public boolean rpgsystems$isPet() {
        return (Boolean)((class_1308)this).method_5841().method_12789(RPGS_IS_PET);
    }

    @Override
    public void rpgsystems$setPet(boolean pet) {
        ((class_1308)this).method_5841().method_12778(RPGS_IS_PET, (Object)pet);
    }

    @Override
    public UUID rpgsystems$getOwnerUuid() {
        return ((Optional)((class_1308)this).method_5841().method_12789(RPGS_OWNER)).orElse(null);
    }

    @Override
    public void rpgsystems$setOwnerUuid(UUID owner) {
        ((class_1308)this).method_5841().method_12778(RPGS_OWNER, Optional.ofNullable(owner));
    }

    @Override
    public String rpgsystems$getPetName() {
        return (String)((class_1308)this).method_5841().method_12789(RPGS_PET_NAME);
    }

    @Override
    public void rpgsystems$setPetName(String name) {
        ((class_1308)this).method_5841().method_12778(RPGS_PET_NAME, (Object)(name == null ? "" : name));
    }
}

