/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.party;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.network.party.PartyChatPayloads;
import net.pixeldreamstudios.rpgsystems.party.FTBTeamsIntegration;

public final class FTBTeamsChatBridge {
    public static void register() {
        if (!FTBTeamsIntegration.isEnabled()) {
            return;
        }
    }

    public static void sendToFTBTeams(class_3222 sender, String message) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return;
        }
        Optional teamOpt = FTBTeamsAPI.api().getManager().getTeamForPlayer(sender);
        if (teamOpt.isPresent() && ((Team)teamOpt.get()).isPartyTeam()) {
            Team team = (Team)teamOpt.get();
            team.sendMessage(sender.method_5667(), message);
        }
    }

    public static void forwardToRPGSystems(MinecraftServer server, Team team, UUID senderId, String message) {
        if (!team.isPartyTeam()) {
            return;
        }
        long now = System.currentTimeMillis();
        String senderName = FTBTeamsChatBridge.getSenderName(server, senderId);
        for (class_3222 member : team.getOnlineMembers()) {
            PartyChatPayloads.ChatMessage payload = new PartyChatPayloads.ChatMessage(team.getId(), senderId, senderName, message, now);
            ServerPlayNetworking.send((class_3222)member, (class_8710)payload);
        }
    }

    private static String getSenderName(MinecraftServer server, UUID senderId) {
        if (senderId == null || senderId.equals(class_156.field_25140)) {
            return "Party";
        }
        class_3222 player = server.method_3760().method_14602(senderId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return "Unknown";
    }
}

