/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.party;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.RPGSystems;
import net.pixeldreamstudios.rpgsystems.config.RPGSystemsConfig;
import net.pixeldreamstudios.rpgsystems.network.PartyNet;
import net.pixeldreamstudios.rpgsystems.network.party.PartyStatusEffectsPayloads;
import net.pixeldreamstudios.rpgsystems.party.PartyPersistentState;
import net.pixeldreamstudios.rpgsystems.party.PartySettings;
import org.jetbrains.annotations.Nullable;

public final class FTBTeamsIntegration {
    private static boolean ftbTeamsLoaded = false;

    public static void init() {
        ftbTeamsLoaded = FabricLoader.getInstance().isModLoaded("ftbteams");
        if (ftbTeamsLoaded) {
            RPGSystems.LOGGER.info("[FTB Teams Integration] FTB Teams mod detected!");
        } else {
            RPGSystems.LOGGER.info("[FTB Teams Integration] FTB Teams mod not found, using native party system.");
        }
    }

    public static boolean isEnabled() {
        boolean enabled;
        boolean bl = enabled = ftbTeamsLoaded && RPGSystemsConfig.get().party.useFTBTeams;
        if (ftbTeamsLoaded && !enabled) {
            RPGSystems.LOGGER.debug("[FTB Teams Integration] FTB Teams is loaded but integration is disabled in config.");
        }
        return enabled;
    }

    @Nullable
    public static FTBPartyData getPartyDataForPlayer(class_3222 player) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return null;
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamForPlayer(player);
            if (teamOpt.isEmpty()) {
                return null;
            }
            Team team = (Team)teamOpt.get();
            if (!team.isPartyTeam()) {
                return null;
            }
            UUID partyId = team.getId();
            String partyName = (String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME);
            UUID leaderUuid = team.getOwner();
            Set members = team.getMembers();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                RPGSystems.LOGGER.warn("[FTB Teams Integration] Server is null for player {}", (Object)player.method_5477().getString());
                return null;
            }
            PartyPersistentState state = PartyPersistentState.get(server);
            PartySettings settings = state.getFTBPartySettings(partyId);
            FTBPartyData data = new FTBPartyData(partyId, partyName, leaderUuid, members, settings);
            return data;
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error getting party data for player {}", (Object)player.method_5477().getString(), (Object)e);
            return null;
        }
    }

    @Nullable
    public static FTBPartyData getPartyDataForPlayerId(MinecraftServer server, UUID playerId) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return null;
        }
        if (server == null) {
            return null;
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamForPlayerID(playerId);
            if (teamOpt.isEmpty()) {
                return null;
            }
            Team team = (Team)teamOpt.get();
            if (!team.isPartyTeam()) {
                return null;
            }
            UUID partyId = team.getId();
            String partyName = (String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME);
            UUID leaderUuid = team.getOwner();
            Set members = team.getMembers();
            PartyPersistentState state = PartyPersistentState.get(server);
            PartySettings settings = state.getFTBPartySettings(partyId);
            return new FTBPartyData(partyId, partyName, leaderUuid, members, settings);
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error getting party data for player ID {}", (Object)playerId, (Object)e);
            return null;
        }
    }

    public static boolean isInSameParty(class_3222 player1, class_3222 player2) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return false;
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional team1 = manager.getTeamForPlayer(player1);
            Optional team2 = manager.getTeamForPlayer(player2);
            if (team1.isEmpty() || team2.isEmpty()) {
                return false;
            }
            Team t1 = (Team)team1.get();
            Team t2 = (Team)team2.get();
            if (!t1.isPartyTeam() || !t2.isPartyTeam()) {
                return false;
            }
            boolean sameParty = t1.getId().equals(t2.getId());
            return sameParty;
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error checking if players are in same party", (Throwable)e);
            return false;
        }
    }

    @Nullable
    public static UUID getPartyIdForPlayer(class_3222 player) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return null;
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamForPlayer(player);
            if (teamOpt.isEmpty()) {
                return null;
            }
            Team team = (Team)teamOpt.get();
            if (!team.isPartyTeam()) {
                return null;
            }
            UUID partyId = team.getId();
            return partyId;
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error getting party ID for player {}", (Object)player.method_5477().getString(), (Object)e);
            return null;
        }
    }

    public static List<UUID> getPartyMembers(MinecraftServer server, UUID partyId) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return Collections.emptyList();
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamByID(partyId);
            if (teamOpt.isEmpty()) {
                return Collections.emptyList();
            }
            Team team = (Team)teamOpt.get();
            if (!team.isPartyTeam()) {
                return Collections.emptyList();
            }
            ArrayList<UUID> members = new ArrayList<UUID>(team.getMembers());
            return members;
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error getting party members for party {}", (Object)partyId, (Object)e);
            return Collections.emptyList();
        }
    }

    public static boolean updatePartySettings(MinecraftServer server, UUID partyId, PartySettings settings) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return false;
        }
        if (server == null || partyId == null || settings == null) {
            return false;
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamByID(partyId);
            if (teamOpt.isEmpty()) {
                RPGSystems.LOGGER.warn("[FTB Teams Integration] Party {} not found", (Object)partyId);
                return false;
            }
            Team team = (Team)teamOpt.get();
            if (!team.isPartyTeam()) {
                RPGSystems.LOGGER.warn("[FTB Teams Integration] Team {} is not a party", (Object)partyId);
                return false;
            }
            PartyPersistentState state = PartyPersistentState.get(server);
            state.updateFTBPartySettings(partyId, settings);
            RPGSystems.LOGGER.info("[FTB Teams Integration] Updated settings for party {}", (Object)partyId);
            return true;
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error updating party settings for {}", (Object)partyId, (Object)e);
            return false;
        }
    }

    public static boolean updatePartySettingsForPlayer(class_3222 player, PartySettings settings) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return false;
        }
        if (player == null || settings == null) {
            return false;
        }
        UUID partyId = FTBTeamsIntegration.getPartyIdForPlayer(player);
        if (partyId == null) {
            RPGSystems.LOGGER.warn("[FTB Teams Integration] Player {} is not in a party", (Object)player.method_5477().getString());
            return false;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        return FTBTeamsIntegration.updatePartySettings(server, partyId, settings);
    }

    @Nullable
    public static PartySettings getPartySettings(MinecraftServer server, UUID partyId) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return null;
        }
        if (server == null || partyId == null) {
            return null;
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamByID(partyId);
            if (teamOpt.isEmpty()) {
                return null;
            }
            Team team = (Team)teamOpt.get();
            if (!team.isPartyTeam()) {
                return null;
            }
            PartyPersistentState state = PartyPersistentState.get(server);
            return state.getFTBPartySettings(partyId);
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error getting party settings for {}", (Object)partyId, (Object)e);
            return null;
        }
    }

    public static boolean isPartyLeader(class_3222 player) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return false;
        }
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamForPlayer(player);
            if (teamOpt.isEmpty()) {
                return false;
            }
            Team team = (Team)teamOpt.get();
            if (!team.isPartyTeam()) {
                return false;
            }
            return team.getOwner().equals(player.method_5667());
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error checking if player is leader", (Throwable)e);
            return false;
        }
    }

    public static void cleanupPartySettings(MinecraftServer server, UUID partyId) {
        if (!FTBTeamsIntegration.isEnabled()) {
            return;
        }
        if (server == null || partyId == null) {
            return;
        }
        try {
            PartyPersistentState state = PartyPersistentState.get(server);
            state.removeFTBPartySettings(partyId);
            RPGSystems.LOGGER.info("[FTB Teams Integration] Cleaned up settings for disbanded party {}", (Object)partyId);
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams Integration] Error cleaning up party settings for {}", (Object)partyId, (Object)e);
        }
    }

    public static void pushAllVitals(MinecraftServer server) {
        for (class_3222 viewer : server.method_3760().method_14571()) {
            FTBPartyData ftbData = FTBTeamsIntegration.getPartyDataForPlayer(viewer);
            if (ftbData == null) continue;
            for (UUID memberId : ftbData.members) {
                class_3222 subject = server.method_3760().method_14602(memberId);
                if (subject == null) {
                    ServerPlayNetworking.send((class_3222)viewer, (class_8710)new PartyStatusEffectsPayloads.MemberEffects(memberId, List.of()));
                    continue;
                }
                PartyNet.pushVitalsForMember(viewer, subject, memberId);
            }
        }
    }

    public static class FTBPartyData {
        public final UUID partyId;
        public final String partyName;
        public final UUID leaderUuid;
        public final Set<UUID> members;
        public final PartySettings settings;

        public FTBPartyData(UUID partyId, String partyName, UUID leaderUuid, Set<UUID> members, PartySettings settings) {
            this.partyId = partyId;
            this.partyName = partyName;
            this.leaderUuid = leaderUuid;
            this.members = new HashSet<UUID>(members);
            this.settings = settings;
        }

        public String toString() {
            return "FTBPartyData{partyId=" + String.valueOf(this.partyId) + ", partyName='" + this.partyName + "', leaderUuid=" + String.valueOf(this.leaderUuid) + ", memberCount=" + this.members.size() + ", allowHelpfulNonMembers=" + this.settings.allowHelpfulNonMembers + ", ignorePartyCollision=" + this.settings.ignorePartyCollision + "}";
        }
    }
}

