/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.party;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.pixeldreamstudios.rpgsystems.RPGSystems;
import net.pixeldreamstudios.rpgsystems.network.party.PartyInvitePayloads;

public final class FTBTeamsJoinRequests {
    private static final Map<UUID, Set<UUID>> REQUESTS = new ConcurrentHashMap<UUID, Set<UUID>>();

    private FTBTeamsJoinRequests() {
    }

    public static void addRequest(UUID teamId, UUID playerUuid) {
        REQUESTS.computeIfAbsent(teamId, k -> ConcurrentHashMap.newKeySet()).add(playerUuid);
        RPGSystems.LOGGER.debug("[FTB Teams Join Requests] Player {} requested to join team {}", (Object)playerUuid, (Object)teamId);
    }

    public static void removeRequest(UUID teamId, UUID playerUuid) {
        Set<UUID> requests = REQUESTS.get(teamId);
        if (requests != null) {
            requests.remove(playerUuid);
            if (requests.isEmpty()) {
                REQUESTS.remove(teamId);
            }
        }
    }

    public static Set<UUID> getRequests(UUID teamId) {
        return REQUESTS.getOrDefault(teamId, Collections.emptySet());
    }

    public static void clearRequestsForPlayer(UUID playerUuid) {
        REQUESTS.values().forEach(set -> set.remove(playerUuid));
    }

    public static void clearRequestsForTeam(UUID teamId) {
        REQUESTS.remove(teamId);
    }

    public static boolean hasRequest(UUID teamId, UUID playerUuid) {
        Set<UUID> requests = REQUESTS.get(teamId);
        return requests != null && requests.contains(playerUuid);
    }

    public static void acceptRequest(MinecraftServer server, UUID teamId, UUID requesterUuid) {
        class_3222 requester = server.method_3760().method_14602(requesterUuid);
        if (requester == null) {
            FTBTeamsJoinRequests.removeRequest(teamId, requesterUuid);
            return;
        }
        TeamManager ftbManager = FTBTeamsAPI.api().getManager();
        ftbManager.getTeamByID(teamId).ifPresent(team -> {
            class_3222 leader;
            if (team.isPartyTeam() && (leader = server.method_3760().method_14602(team.getOwner())) != null) {
                leader.method_5682().method_3734().method_44252(leader.method_5671(), "ftbteams party invite " + requester.method_5477().getString());
                leader.method_43496((class_2561)class_2561.method_43470((String)("Sent invite to " + requester.method_5477().getString())));
                requester.method_43496((class_2561)class_2561.method_43470((String)"Your join request was approved. Accept the invite to join!"));
            }
        });
        FTBTeamsJoinRequests.removeRequest(teamId, requesterUuid);
    }

    private static String urlEncodeName(String name) {
        if (name == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(name, StandardCharsets.UTF_8);
            encoded = encoded.replace("%27", "_").replace("%20", "_").replace("+", "_").replace("%", "_");
            return encoded;
        }
        catch (Exception e) {
            return name.replace("'", "_").replace(" ", "_").replace("%", "_");
        }
    }

    public static void handleFTBTeamsInviteResponse(class_3222 player, PartyInvitePayloads.InviteRespond payload) {
        try {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            Optional teamOpt = manager.getTeamByID(payload.partyId());
            if (teamOpt.isPresent()) {
                Team team = (Team)teamOpt.get();
                String shortTeamId = team.getId().toString().substring(0, 8);
                String displayName = (String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME);
                String encodedName = FTBTeamsJoinRequests.urlEncodeName(displayName);
                String teamIdentifier = encodedName + "#" + shortTeamId;
                if (payload.accept()) {
                    player.method_5682().method_3734().method_44252(player.method_5671(), "ftbteams party join " + teamIdentifier);
                } else {
                    player.method_5682().method_3734().method_44252(player.method_5671(), "ftbteams party decline " + teamIdentifier);
                }
            } else if (payload.accept()) {
                player.method_5682().method_3734().method_44252(player.method_5671(), "ftbteams party join " + String.valueOf(payload.partyId()));
            } else {
                player.method_5682().method_3734().method_44252(player.method_5671(), "ftbteams party decline " + String.valueOf(payload.partyId()));
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PartyInvitePayloads.InviteRemoved(payload.partyId()));
        }
        catch (Exception e) {
            RPGSystems.LOGGER.error("[FTB Teams] Error handling invite response", (Throwable)e);
        }
    }
}

