/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.party;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.pixeldreamstudios.rpgsystems.party.PartySettings;

public final class Party {
    public final UUID id;
    public UUID leader;
    public String name;
    public final Set<UUID> members = new HashSet<UUID>();
    public final PartySettings settings = new PartySettings();

    public Party(UUID id, UUID leader, String name) {
        this.id = id;
        this.leader = leader;
        this.name = name == null ? "" : name;
        this.members.add(leader);
    }

    public boolean isMember(UUID uuid) {
        return this.members.contains(uuid);
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927("Id", this.id);
        nbt.method_25927("Leader", this.leader);
        nbt.method_10582("Name", this.name);
        class_2499 list = new class_2499();
        for (UUID u : this.members) {
            class_2487 tag = new class_2487();
            tag.method_25927("U", u);
            list.add((Object)tag);
        }
        nbt.method_10566("Members", (class_2520)list);
        nbt.method_10566("Settings", (class_2520)this.settings.toNbt());
        return nbt;
    }

    public static Party fromNbt(class_2487 nbt) {
        UUID id = nbt.method_25926("Id");
        UUID leader = nbt.method_25926("Leader");
        String name = nbt.method_10545("Name") ? nbt.method_10558("Name") : "";
        Party p = new Party(id, leader, name);
        class_2499 list = nbt.method_10554("Members", 10);
        for (int i = 0; i < list.size(); ++i) {
            p.members.add(list.method_10602(i).method_25926("U"));
        }
        if (nbt.method_10545("Settings")) {
            PartySettings loaded = PartySettings.fromNbt(nbt.method_10562("Settings"));
            p.settings.allowHelpfulNonMembers = loaded.allowHelpfulNonMembers;
            p.settings.ignorePartyCollision = loaded.ignorePartyCollision;
        }
        return p;
    }
}

