/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public final class Title {
    public final class_2960 id;
    public final class_2561 displayName;
    public final class_2561 description;
    public final boolean hidden;
    public final List<Bonus> bonuses;
    public final List<Bonus> permaBonuses;
    public final List<Condition> conditions;

    private Title(class_2960 id, class_2561 displayName, class_2561 description, List<Bonus> bonuses, List<Bonus> permaBonuses, List<Condition> conditions, boolean hidden) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.hidden = hidden;
        this.bonuses = Collections.unmodifiableList(new ArrayList<Bonus>(bonuses));
        this.permaBonuses = Collections.unmodifiableList(new ArrayList<Bonus>(permaBonuses));
        this.conditions = Collections.unmodifiableList(new ArrayList<Condition>(conditions));
    }

    public static Builder builder(class_2960 id, class_2561 displayName) {
        return new Builder(id, displayName);
    }

    public static final class Builder {
        private final class_2960 id;
        private final class_2561 displayName;
        private class_2561 description = class_2561.method_43473();
        private final List<Bonus> bonuses = new ArrayList<Bonus>();
        private final List<Bonus> permaBonuses = new ArrayList<Bonus>();
        private final List<Condition> conditions = new ArrayList<Condition>();
        private boolean hidden = false;

        private Builder(class_2960 id, class_2561 displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        public Builder description(class_2561 description) {
            this.description = description;
            return this;
        }

        public Builder add(class_6880<class_1320> attribute, double amount, class_1322.class_1323 operation) {
            this.bonuses.add(Bonus.forAttribute(attribute, amount, operation));
            return this;
        }

        public Builder addDamageBonus(class_2960 target, double amount, DamageOp op) {
            this.bonuses.add(Bonus.forDamage(target, amount, op));
            return this;
        }

        public Builder addDamageBonusTag(class_2960 tag, double amount, DamageOp op) {
            this.bonuses.add(Bonus.forDamageTag(tag, amount, op));
            return this;
        }

        public Builder addSpell(class_2960 spellId) {
            this.bonuses.add(Bonus.forSpell(spellId));
            return this;
        }

        public Builder addPower(class_2960 powerId) {
            this.bonuses.add(Bonus.forPower(powerId));
            return this;
        }

        public Builder addPerma(class_6880<class_1320> attribute, double amount, class_1322.class_1323 operation) {
            this.permaBonuses.add(Bonus.forAttribute(attribute, amount, operation));
            return this;
        }

        public Builder addPermaDamageBonus(class_2960 target, double amount, DamageOp op) {
            this.permaBonuses.add(Bonus.forDamage(target, amount, op));
            return this;
        }

        public Builder addPermaDamageBonusTag(class_2960 tag, double amount, DamageOp op) {
            this.permaBonuses.add(Bonus.forDamageTag(tag, amount, op));
            return this;
        }

        public Builder addPermaSpell(class_2960 spellId) {
            this.permaBonuses.add(Bonus.forSpell(spellId));
            return this;
        }

        public Builder addPermaPower(class_2960 powerId) {
            this.permaBonuses.add(Bonus.forPower(powerId));
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder addCondition(Condition c) {
            this.conditions.add(c);
            return this;
        }

        public Title build() {
            return new Title(this.id, this.displayName, this.description, this.bonuses, this.permaBonuses, this.conditions, this.hidden);
        }
    }

    public static final class Condition {
        public final Type type;
        public final Optional<class_2960> item;
        public final Optional<class_2960> entityType;
        public final Optional<class_2960> advancement;
        public final long distance;
        public final int count;
        public final Optional<String> hint;
        public final boolean hidden;
        public final Optional<String> entitySpec;
        public final Optional<String> nbtQuery;
        public final int level;
        public final Optional<class_2960> block;
        public final Optional<class_2960> biome;
        public final Optional<class_2960> dimension;
        public final Optional<class_2960> structure;
        public final Optional<class_2960> attributeId;
        public final Optional<class_2960> entityTagId;
        public final double minValue;

        public Condition(Type type, Optional<class_2960> item, Optional<class_2960> entityType, Optional<class_2960> advancement, long distance, int count, Optional<String> hint, boolean hidden, Optional<String> entitySpec, Optional<String> nbtQuery, int level, Optional<class_2960> block, Optional<class_2960> biome, Optional<class_2960> dimension, Optional<class_2960> structure, Optional<class_2960> attributeId, double minValue, Optional<class_2960> entityTagId) {
            this.type = type;
            this.item = item;
            this.entityType = entityType;
            this.advancement = advancement;
            this.distance = distance;
            this.count = count;
            this.hint = hint;
            this.hidden = hidden;
            this.entitySpec = entitySpec;
            this.nbtQuery = nbtQuery;
            this.level = level;
            this.block = block;
            this.biome = biome;
            this.dimension = dimension;
            this.structure = structure;
            this.attributeId = attributeId;
            this.minValue = minValue;
            this.entityTagId = entityTagId;
        }

        public static enum Type {
            OBTAIN_ITEM,
            KILL_MOBS,
            ADVANCEMENT,
            WALK_BLOCKS,
            REACH_LEVEL,
            REACH_LEVEL_XP,
            REACH_LEVEL_PUFFERFISH,
            CRAFT_ITEM,
            MINE_BLOCKS,
            VISIT_BIOME,
            ENTER_DIMENSION,
            INTERACT_BLOCK,
            INTERACT_ENTITY,
            FIND_STRUCTURE,
            DEAL_DAMAGE_TOTAL,
            DEAL_DAMAGE_MAX,
            CHECK_ATTRIBUTE;

        }
    }

    public static final class Bonus {
        public final class_6880<class_1320> attribute;
        public final double amount;
        public final class_1322.class_1323 operation;
        public final Optional<class_2960> damageTarget;
        public final Optional<class_2960> damageTag;
        public final DamageOp damageOp;
        public final double damageAmount;
        public final Optional<class_2960> spellId;
        public final Optional<class_2960> powerId;

        private Bonus(class_6880<class_1320> attribute, double amount, class_1322.class_1323 operation) {
            this.attribute = attribute;
            this.amount = amount;
            this.operation = operation;
            this.spellId = Optional.empty();
            this.powerId = Optional.empty();
            this.damageTarget = Optional.empty();
            this.damageTag = Optional.empty();
            this.damageOp = null;
            this.damageAmount = 0.0;
        }

        private Bonus(class_2960 spellOrPower, boolean isSpell) {
            this.attribute = null;
            this.amount = 0.0;
            this.operation = null;
            this.spellId = isSpell ? Optional.of(spellOrPower) : Optional.empty();
            this.powerId = isSpell ? Optional.empty() : Optional.of(spellOrPower);
            this.damageTarget = Optional.empty();
            this.damageTag = Optional.empty();
            this.damageOp = null;
            this.damageAmount = 0.0;
        }

        private Bonus(Optional<class_2960> target, Optional<class_2960> tag, double amount, DamageOp op) {
            this.attribute = null;
            this.amount = 0.0;
            this.operation = null;
            this.spellId = Optional.empty();
            this.powerId = Optional.empty();
            this.damageTarget = target;
            this.damageTag = tag;
            this.damageOp = op;
            this.damageAmount = amount;
        }

        public static Bonus forDamage(class_2960 target, double amount, DamageOp op) {
            return new Bonus(Optional.of(target), Optional.empty(), amount, op);
        }

        public static Bonus forDamageTag(class_2960 tag, double amount, DamageOp op) {
            return new Bonus(Optional.empty(), Optional.of(tag), amount, op);
        }

        public static Bonus forAttribute(class_6880<class_1320> attribute, double amount, class_1322.class_1323 operation) {
            return new Bonus(attribute, amount, operation);
        }

        public static Bonus forSpell(class_2960 spellId) {
            return new Bonus(spellId, true);
        }

        public static Bonus forPower(class_2960 powerId) {
            return new Bonus(powerId, false);
        }
    }

    public static enum DamageOp {
        ADDED,
        MULTIPLIED;

    }
}

