/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.pixeldreamstudios.rpgsystems.title.Title;

public final class TitleRegistry {
    private static final Map<class_2960, Title> TITLES = new LinkedHashMap<class_2960, Title>();

    private TitleRegistry() {
    }

    public static Title register(Title title) {
        Objects.requireNonNull(title, "title");
        if (TITLES.containsKey(title.id)) {
            throw new IllegalStateException("Duplicate title id " + String.valueOf(title.id));
        }
        TITLES.put(title.id, title);
        return title;
    }

    public static void replaceAll(Map<class_2960, Title> newTitles) {
        TITLES.clear();
        TITLES.putAll(newTitles);
    }

    public static Title get(class_2960 id) {
        return TITLES.get(id);
    }

    public static Map<class_2960, Title> all() {
        return Collections.unmodifiableMap(TITLES);
    }

    public static void bootstrapFallback() {
        if (!TITLES.isEmpty()) {
            return;
        }
        TitleRegistry.register(Title.builder(class_2960.method_60655((String)"rpg-systems", (String)"novice"), (class_2561)class_2561.method_43471((String)"title.rpgsystems.novice")).description((class_2561)class_2561.method_43471((String)"title.rpgsystems.novice.desc")).add((class_6880<class_1320>)class_5134.field_23716, 2.0, class_1322.class_1323.field_6328).build());
    }
}

