/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.title.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1320;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.pixeldreamstudios.rpgsystems.RPGSystems;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitleRegistry;
import net.pixeldreamstudios.rpgsystems.title.data.TitleData;

public final class TitlesDataReloader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public TitlesDataReloader() {
        super(GSON, "title");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, Title> loaded = new HashMap<class_2960, Title>();
        prepared.forEach((fileId, json) -> {
            try {
                class_6880 entry;
                class_5321 key;
                boolean hiddenTitle;
                String leaf;
                JsonObject root = json != null && json.isJsonObject() ? json.getAsJsonObject() : null;
                boolean enabled = true;
                if (root != null && root.has("enabled")) {
                    enabled = root.get("enabled").getAsBoolean();
                }
                if (!enabled) {
                    RPGSystems.LOGGER.info("Skipping disabled title json {}", fileId);
                    return;
                }
                TitleData data = (TitleData)TitleData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
                String path = fileId.method_12832();
                int slash = path.lastIndexOf(47);
                String string = leaf = slash >= 0 ? path.substring(slash + 1) : path;
                if (leaf.endsWith(".json")) {
                    leaf = leaf.substring(0, leaf.length() - 5);
                }
                class_2960 id = class_2960.method_60655((String)fileId.method_12836(), (String)leaf);
                Title.Builder b = Title.builder(id, (class_2561)class_2561.method_43470((String)data.name().orElse(leaf)));
                data.description().ifPresent(desc -> b.description((class_2561)class_2561.method_43470((String)desc)));
                boolean bl = hiddenTitle = root != null && root.has("hidden") && root.get("hidden").getAsBoolean();
                if (hiddenTitle) {
                    b.hidden(true);
                }
                for (TitleData.Bonus group : data.bonuses()) {
                    for (TitleData.AttrBonus ab : group.attributes()) {
                        key = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)ab.id());
                        entry = (class_6880)class_7923.field_41190.method_40264(key).orElseThrow(() -> new IllegalArgumentException("Unknown attribute: " + String.valueOf(ab.id())));
                        b.add((class_6880<class_1320>)entry, ab.amount(), ab.operation());
                    }
                    for (class_2960 spell : group.spells()) {
                        b.addSpell(spell);
                    }
                    for (class_2960 power : group.powers()) {
                        b.addPower(power);
                    }
                    for (TitleData.DamageBonus db : group.damageBonuses()) {
                        if (db.id().isPresent()) {
                            b.addDamageBonus(db.id().get(), db.amount(), db.operation() == TitleData.DamageOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                            continue;
                        }
                        if (!db.tag().isPresent()) continue;
                        b.addDamageBonusTag(db.tag().get(), db.amount(), db.operation() == TitleData.DamageOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                    }
                }
                for (TitleData.Bonus group : data.permaBonuses()) {
                    for (TitleData.AttrBonus ab : group.attributes()) {
                        key = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)ab.id());
                        entry = (class_6880)class_7923.field_41190.method_40264(key).orElseThrow(() -> new IllegalArgumentException("Unknown attribute: " + String.valueOf(ab.id())));
                        b.addPerma((class_6880<class_1320>)entry, ab.amount(), ab.operation());
                    }
                    for (class_2960 spell : group.spells()) {
                        b.addPermaSpell(spell);
                    }
                    for (class_2960 power : group.powers()) {
                        b.addPermaPower(power);
                    }
                    for (TitleData.DamageBonus db : group.damageBonuses()) {
                        if (db.id().isPresent()) {
                            b.addPermaDamageBonus(db.id().get(), db.amount(), db.operation() == TitleData.DamageOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                            continue;
                        }
                        if (!db.tag().isPresent()) continue;
                        b.addPermaDamageBonusTag(db.tag().get(), db.amount(), db.operation() == TitleData.DamageOp.MULTIPLIED ? Title.DamageOp.MULTIPLIED : Title.DamageOp.ADDED);
                    }
                }
                for (TitleData.Condition jc : data.conditions()) {
                    Title.Condition.Type t = switch (jc.type()) {
                        default -> throw new MatchException(null, null);
                        case TitleData.ConditionType.OBTAIN_ITEM -> Title.Condition.Type.OBTAIN_ITEM;
                        case TitleData.ConditionType.KILL_MOBS -> Title.Condition.Type.KILL_MOBS;
                        case TitleData.ConditionType.ADVANCEMENT -> Title.Condition.Type.ADVANCEMENT;
                        case TitleData.ConditionType.WALK_BLOCKS -> Title.Condition.Type.WALK_BLOCKS;
                        case TitleData.ConditionType.REACH_LEVEL -> Title.Condition.Type.REACH_LEVEL;
                        case TitleData.ConditionType.REACH_LEVEL_XP -> Title.Condition.Type.REACH_LEVEL_XP;
                        case TitleData.ConditionType.REACH_LEVEL_PUFFERFISH -> Title.Condition.Type.REACH_LEVEL_PUFFERFISH;
                        case TitleData.ConditionType.CRAFT_ITEM -> Title.Condition.Type.CRAFT_ITEM;
                        case TitleData.ConditionType.MINE_BLOCKS -> Title.Condition.Type.MINE_BLOCKS;
                        case TitleData.ConditionType.VISIT_BIOME -> Title.Condition.Type.VISIT_BIOME;
                        case TitleData.ConditionType.ENTER_DIMENSION -> Title.Condition.Type.ENTER_DIMENSION;
                        case TitleData.ConditionType.INTERACT_BLOCK -> Title.Condition.Type.INTERACT_BLOCK;
                        case TitleData.ConditionType.INTERACT_ENTITY -> Title.Condition.Type.INTERACT_ENTITY;
                        case TitleData.ConditionType.FIND_STRUCTURE -> Title.Condition.Type.FIND_STRUCTURE;
                        case TitleData.ConditionType.DEAL_DAMAGE_TOTAL -> Title.Condition.Type.DEAL_DAMAGE_TOTAL;
                        case TitleData.ConditionType.DEAL_DAMAGE_MAX -> Title.Condition.Type.DEAL_DAMAGE_MAX;
                        case TitleData.ConditionType.CHECK_ATTRIBUTE -> Title.Condition.Type.CHECK_ATTRIBUTE;
                    };
                    b.addCondition(new Title.Condition(t, jc.item(), jc.entityType(), jc.advancement(), jc.distance().orElse(0L), jc.count().orElse(0), jc.hint(), jc.hidden().orElse(false), jc.entity(), jc.nbt(), jc.level().orElse(0), jc.block(), jc.biome(), jc.dimension(), jc.structure(), jc.attribute(), jc.min().orElse(0.0), jc.entityTag()));
                }
                loaded.put(id, b.build());
            }
            catch (Exception ex) {
                RPGSystems.LOGGER.error("Failed to parse title json {}: {}", fileId, (Object)ex.toString());
            }
        });
        TitleRegistry.replaceAll(loaded);
        TitleRegistry.bootstrapFallback();
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"rpg-systems", (String)"titles_data_reloader");
    }
}

