/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.util;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.pixeldreamstudios.rpgsystems.util.DamageCritLinks;

public final class DamageCritPending {
    private static final Map<class_1309, Pending> PENDING = new WeakHashMap<class_1309, Pending>();
    private static final int TTL_TICKS = 2;

    private DamageCritPending() {
    }

    public static void addMagic(class_1309 target, class_1297 attacker, Integer colorOverride, long nowTick) {
        if (target == null || attacker == null) {
            return;
        }
        PENDING.put(target, new Pending(attacker.method_5667(), colorOverride, nowTick + 2L));
    }

    public static DamageCritLinks.Info consumeIfMatches(class_1282 source, class_1309 target, long nowTick) {
        if (source == null || target == null) {
            return DamageCritLinks.Info.none();
        }
        Pending p = PENDING.get(target);
        if (p == null) {
            return DamageCritLinks.Info.none();
        }
        if (nowTick > p.expiresAtTick) {
            PENDING.remove(target);
            return DamageCritLinks.Info.none();
        }
        class_1297 atk = source.method_5529();
        if (atk == null || !atk.method_5667().equals(p.attackerUuid)) {
            return DamageCritLinks.Info.none();
        }
        PENDING.remove(target);
        return new DamageCritLinks.Info(DamageCritLinks.Kind.MAGIC, p.colorOverride);
    }

    public static void clearFor(class_1309 target) {
        if (target != null) {
            PENDING.remove(target);
        }
    }

    private static final class Pending {
        final UUID attackerUuid;
        final Integer colorOverride;
        final long expiresAtTick;

        Pending(UUID attackerUuid, Integer colorOverride, long expiresAtTick) {
            this.attackerUuid = attackerUuid;
            this.colorOverride = colorOverride;
            this.expiresAtTick = expiresAtTick;
        }
    }
}

