/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.pixeldreamstudios.rpgsystems.title.PermaGroupKey;
import net.pixeldreamstudios.rpgsystems.title.Title;
import net.pixeldreamstudios.rpgsystems.title.TitlesPersistentState;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.container.SpellContainerSource;

public final class TitleSpellBonusUtil {
    private TitleSpellBonusUtil() {
    }

    public static void installTitleSpells(class_3222 player, class_2960 titleId, Collection<class_2960> spellIds) {
        if (spellIds == null || spellIds.isEmpty()) {
            TitleSpellBonusUtil.uninstallTitleSpells(player, titleId);
            return;
        }
        class_1937 world = player.method_37908();
        ArrayList<String> install = new ArrayList<String>();
        for (class_2960 id : spellIds) {
            class_6880.class_6883 ref = SpellRegistry.from((class_1937)world).method_55841(id).orElse(null);
            if (ref == null) continue;
            Spell s = (Spell)ref.comp_349();
            install.add(id.toString());
        }
        LinkedHashMap serverSide = ((SpellContainerSource.Owner)player).serverSideSpellContainers();
        String base = "title/" + titleId.toString();
        serverSide.keySet().removeIf(k -> k.startsWith(base + "/"));
        if (!install.isEmpty()) {
            SpellContainer container = new SpellContainer(SpellContainer.ContentType.ANY, true, "", 0, install);
            serverSide.put(base + "/any", container);
        }
        SpellContainerSource.setDirtyServerSide((class_1657)player);
        SpellContainerSource.syncServerSideContainers((class_1657)player);
    }

    public static void uninstallTitleSpells(class_3222 player, class_2960 titleId) {
        LinkedHashMap serverSide = ((SpellContainerSource.Owner)player).serverSideSpellContainers();
        String base = "title/" + titleId.toString();
        serverSide.keySet().removeIf(k -> k.startsWith(base + "/"));
        SpellContainerSource.setDirtyServerSide((class_1657)player);
        SpellContainerSource.syncServerSideContainers((class_1657)player);
    }

    public static void rebuildPermaTitleSpells(class_3222 player, Collection<Title> unlockedTitles) {
        LinkedHashMap serverSide = ((SpellContainerSource.Owner)player).serverSideSpellContainers();
        String permaKey = "title/perma/any";
        TitlesPersistentState state = TitlesPersistentState.get(player.method_5682());
        TitlesPersistentState.PlayerTitles pt = state.getOrCreate(player.method_5667());
        Set<String> disabled = pt.permaDisabledGroups;
        HashSet<String> install = new HashSet<String>();
        if (unlockedTitles != null) {
            class_1937 world = player.method_37908();
            for (Title t : unlockedTitles) {
                for (Title.Bonus b : t.permaBonuses) {
                    class_6880.class_6883 ref;
                    class_2960 id;
                    String key;
                    if (b.spellId == null || !b.spellId.isPresent() || disabled.contains(key = PermaGroupKey.spell(id = b.spellId.get())) || (ref = (class_6880.class_6883)SpellRegistry.from((class_1937)world).method_55841(id).orElse(null)) == null) continue;
                    install.add(id.toString());
                }
            }
        }
        serverSide.remove(permaKey);
        if (!install.isEmpty()) {
            SpellContainer container = new SpellContainer(SpellContainer.ContentType.ANY, true, "", 0, new ArrayList(install));
            serverSide.put(permaKey, container);
        }
        SpellContainerSource.setDirtyServerSide((class_1657)player);
        SpellContainerSource.syncServerSideContainers((class_1657)player);
    }

    public static void rebuildAllTitleSpells(class_3222 player, Title equipped, Collection<Title> unlockedTitles) {
        if (equipped != null) {
            List<class_2960> equippedSpellIds = equipped.bonuses.stream().filter(b -> b.spellId != null && b.spellId.isPresent()).map(b -> b.spellId.get()).collect(Collectors.toList());
            TitleSpellBonusUtil.installTitleSpells(player, equipped.id, equippedSpellIds);
        }
        TitleSpellBonusUtil.rebuildPermaTitleSpells(player, unlockedTitles);
    }
}

