/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.pixeldreamstudios.rpgsystems.client.config.MiscOptionsScreen;
import net.pixeldreamstudios.rpgsystems.client.enemy.configui.DamageNumbersScreen;
import net.pixeldreamstudios.rpgsystems.client.enemy.configui.EnemyHudsScreen;
import net.pixeldreamstudios.rpgsystems.client.enemy.configui.HealingNumbersScreen;
import net.pixeldreamstudios.rpgsystems.client.party.configui.PartyHudOptionsScreen;
import net.pixeldreamstudios.rpgsystems.client.party.configui.PartyMemberInfoOptionsScreen;
import net.pixeldreamstudios.rpgsystems.client.title.configui.TitlesOptionsScreen;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigsScreen
extends class_437 {
    private final class_437 parent;
    private double navScroll = 0.0;
    private VerticalColumn navColumn;

    public ClientConfigsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Client Options"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.build();
    }

    private void build() {
        this.method_37067();
        int buttonH = 20;
        int top = 56;
        int colW = 220;
        int colH = Math.max(28, this.field_22790 - 56 - 24);
        this.navColumn = new VerticalColumn(this.field_22789 / 2 - colW / 2, 56, colW, colH, () -> this.navScroll, s -> {
            this.navScroll = s;
        });
        class_4185 partyHudBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Party HUD"), b -> this.field_22787.method_1507((class_437)new PartyHudOptionsScreen(this))).method_46437(colW - 8, 20).method_46433(0, 0).method_46431();
        class_4185 memberInfoBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Member Info"), b -> this.field_22787.method_1507((class_437)new PartyMemberInfoOptionsScreen(this))).method_46437(colW - 8, 20).method_46433(0, 0).method_46431();
        class_4185 enemyHudsBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Enemy HUDs"), b -> this.field_22787.method_1507((class_437)new EnemyHudsScreen(this))).method_46437(colW - 8, 20).method_46433(0, 0).method_46431();
        class_4185 damageBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Damage Numbers"), b -> this.field_22787.method_1507((class_437)new DamageNumbersScreen(this))).method_46437(colW - 8, 20).method_46433(0, 0).method_46431();
        class_4185 healingBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Healing Numbers"), b -> this.field_22787.method_1507((class_437)new HealingNumbersScreen(this))).method_46437(colW - 8, 20).method_46433(0, 0).method_46431();
        class_4185 titlesBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Titles"), b -> this.field_22787.method_1507((class_437)new TitlesOptionsScreen(this))).method_46437(colW - 8, 20).method_46433(0, 0).method_46431();
        class_4185 miscBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Misc UI Positions"), b -> this.field_22787.method_1507((class_437)new MiscOptionsScreen(this))).method_46437(colW - 8, 20).method_46433(0, 0).method_46431();
        this.navColumn.setButtons(partyHudBtn, memberInfoBtn, enemyHudsBtn, damageBtn, healingBtn, titlesBtn, miscBtn);
        this.method_37063((class_364)this.navColumn);
    }

    public void method_25410(class_310 mc, int w, int h) {
        if (this.navColumn != null) {
            this.navScroll = this.navColumn.getScroll();
        }
        super.method_25410(mc, w, h);
        this.build();
    }

    public boolean method_25401(double mouseX, double mouseY, double horiz, double vert) {
        if (this.navColumn != null && this.navColumn.method_25405(mouseX, mouseY)) {
            return this.navColumn.method_25401(mouseX, mouseY, horiz, vert);
        }
        return super.method_25401(mouseX, mouseY, vert, horiz);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx, mouseX, mouseY, delta);
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 18, 0xFFFFFF);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Open a section to configure"), this.field_22789 / 2, 36, 0xAAAAAA);
    }

    private static final class VerticalColumn
    extends class_339 {
        private final List<class_4185> children = new ArrayList<class_4185>();
        private double scroll;
        private int contentHeight;
        private final DoubleSupplier getInitialScroll;
        private final DoubleConsumer onScrollChanged;

        VerticalColumn(int x, int y, int w, int h, DoubleSupplier initialScroll, DoubleConsumer onScrollChanged) {
            super(x, y, w, h, (class_2561)class_2561.method_43473());
            this.getInitialScroll = initialScroll;
            this.onScrollChanged = onScrollChanged;
            this.scroll = this.clamp(initialScroll.getAsDouble());
        }

        void setButtons(class_4185 ... btns) {
            this.children.clear();
            Collections.addAll(this.children, btns);
            this.layout();
        }

        double getScroll() {
            return this.scroll;
        }

        void setScroll(double s) {
            this.scroll = this.clamp(s);
            this.layout();
        }

        private void layout() {
            int y = this.method_46427() + 4 - (int)Math.round(this.scroll);
            int spacing = 8;
            this.contentHeight = 0;
            for (class_4185 b : this.children) {
                b.method_46421(this.method_46426() + 4);
                b.method_46419(y);
                y += b.method_25364() + spacing;
                this.contentHeight += b.method_25364() + spacing;
            }
            if (!this.children.isEmpty()) {
                this.contentHeight -= spacing;
            }
        }

        private int maxScroll() {
            return Math.max(0, this.contentHeight - this.method_25364());
        }

        private double clamp(double s) {
            int max = this.maxScroll();
            if (s < 0.0) {
                return 0.0;
            }
            if (s > (double)max) {
                return max;
            }
            return s;
        }

        protected void method_47399(class_6382 b) {
        }

        protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
            this.scroll = this.clamp(this.scroll == 0.0 ? this.getInitialScroll.getAsDouble() : this.scroll);
            ctx.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364());
            for (class_4185 b : this.children) {
                b.method_25394(ctx, mouseX, mouseY, delta);
            }
            ctx.method_44380();
        }

        public boolean method_25402(double mx, double my, int button) {
            if (!this.method_25405(mx, my)) {
                return false;
            }
            for (class_4185 b : this.children) {
                if (!b.method_25402(mx, my, button)) continue;
                return true;
            }
            return true;
        }

        public boolean method_25406(double mx, double my, int button) {
            boolean any = false;
            for (class_4185 b : this.children) {
                any |= b.method_25406(mx, my, button);
            }
            return any;
        }

        public boolean method_25401(double mx, double my, double horiz, double vert) {
            if (!this.method_25405(mx, my)) {
                return false;
            }
            this.scroll = this.clamp(this.scroll - vert * 18.0);
            this.onScrollChanged.accept(this.scroll);
            this.layout();
            return true;
        }
    }
}

