/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.pixeldreamstudios.rpgsystems.client.ClientConfigLoad;
import net.pixeldreamstudios.rpgsystems.client.enemy.DamageNumbersRenderer;
import net.pixeldreamstudios.rpgsystems.client.enemy.EnemyHealthBarRenderer;
import net.pixeldreamstudios.rpgsystems.client.enemy.HealingNumbersRenderer;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyChat;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHighlighter;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyHudData;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyInvites;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyJoinRequests;
import net.pixeldreamstudios.rpgsystems.client.party.ClientPartyStatusEffects;
import net.pixeldreamstudios.rpgsystems.client.party.CompatCommandHelper;
import net.pixeldreamstudios.rpgsystems.client.party.config.PartyHudClientConfig;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyHud;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyInviteHud;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyInviteInventoryUi;
import net.pixeldreamstudios.rpgsystems.client.party.hud.PartyJoinRequestHud;
import net.pixeldreamstudios.rpgsystems.client.party.screen.PartyScreen;
import net.pixeldreamstudios.rpgsystems.client.title.TitlePlayerRenderer;
import net.pixeldreamstudios.rpgsystems.client.title.TitlePowersClient;
import net.pixeldreamstudios.rpgsystems.client.title.TitleTextureResolver;
import net.pixeldreamstudios.rpgsystems.compat.showbuild.ShowBuildCompatNetClient;
import net.pixeldreamstudios.rpgsystems.config.RPGSystemsConfig;
import net.pixeldreamstudios.rpgsystems.network.EnemyNet;
import net.pixeldreamstudios.rpgsystems.network.SystemNet;
import net.pixeldreamstudios.rpgsystems.network.TitleNet;
import net.pixeldreamstudios.rpgsystems.network.TitlePowerNet;
import net.pixeldreamstudios.rpgsystems.network.party.PartyJoinRequestPayloads;
import net.pixeldreamstudios.rpgsystems.party.FTBTeamsIntegration;

@Environment(value=EnvType.CLIENT)
public final class RPGSystemsClient
implements ClientModInitializer {
    private static class_304 openPartyScreen;
    private static class_304 highlightParty;
    private static class_304 togglePartyHud;

    public void onInitializeClient() {
        ClientConfigLoad.init();
        SystemNet.registerClient();
        ClientPartyInvites.initClientReceivers();
        ClientPartyHudData.initClientReceivers();
        ClientPartyChat.initClientReceivers();
        ClientPartyJoinRequests.initClientReceivers();
        PartyHud.init();
        PartyInviteHud.init();
        PartyInviteInventoryUi.init();
        PartyJoinRequestHud.init();
        ClientPartyHighlighter.init();
        if (FabricLoader.getInstance().isModLoaded("showmeyourbuild")) {
            ShowBuildCompatNetClient.initClient();
        }
        EnemyNet.initClient();
        EnemyHealthBarRenderer.init();
        DamageNumbersRenderer.init();
        HealingNumbersRenderer.init();
        if (RPGSystemsConfig.get().systems.title) {
            TitleNet.registerClient();
            TitlePlayerRenderer.init();
            TitlePowerNet.registerClient();
            TitlePowersClient.init();
        }
        openPartyScreen = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.rpgsystems.open_party", class_3675.class_307.field_1668, 80, "key.categories.multiplayer"));
        highlightParty = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.rpgsystems.highlight_party", class_3675.class_307.field_1668, 72, "key.categories.multiplayer"));
        togglePartyHud = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.rpgsystems.toggle_party_hud", class_3675.class_307.field_1668, 79, "key.categories.multiplayer"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (openPartyScreen.method_1436()) {
                class_3966 ehr;
                class_1297 patt0$temp;
                boolean hasParty = ClientPartyHudData.partyId != null;
                class_310 mc = class_310.method_1551();
                class_239 hit = mc.field_1765;
                boolean acted = false;
                if (hit != null && hit.method_17783() == class_239.class_240.field_1331 && (patt0$temp = (ehr = (class_3966)hit).method_17782()) instanceof class_1657) {
                    class_1657 target = (class_1657)patt0$temp;
                    if (mc.field_1724 != null && !target.method_5667().equals(mc.field_1724.method_5667()) && mc.method_1562() != null) {
                        if (hasParty) {
                            CompatCommandHelper.sendInviteCommand(target.method_5477().getString());
                            acted = true;
                        } else if (FabricLoader.getInstance().isModLoaded("ftbteams") && FTBTeamsIntegration.isEnabled()) {
                            RPGSystemsClient.sendFTBTeamsJoinRequest(target);
                            acted = true;
                        } else {
                            mc.method_1562().method_45730("party request player " + target.method_5477().getString());
                            acted = true;
                        }
                    }
                }
                if (acted || !hasParty || mc.field_1755 != null) continue;
                mc.method_1507((class_437)new PartyScreen());
            }
            while (highlightParty.method_1436()) {
                ClientPartyHighlighter.toggle();
            }
            while (togglePartyHud.method_1436()) {
                PartyHudClientConfig cfg = PartyHudClientConfig.get();
                cfg.hudEnabled = !cfg.hudEnabled;
                PartyHudClientConfig.save();
                if (client.field_1724 == null) continue;
                client.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Party HUD " + (cfg.hudEnabled ? "enabled" : "disabled"))));
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            ClientPartyHudData.clearAll();
            ClientPartyInvites.clearAll();
            ClientPartyJoinRequests.clearAll();
            ClientPartyChat.clearAll();
            ClientPartyStatusEffects.clearAll();
            ClientPartyHighlighter.disable();
            if (RPGSystemsConfig.get().systems.title) {
                TitleTextureResolver.clear();
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ClientPartyHudData.clearAll();
            ClientPartyInvites.clearAll();
            ClientPartyJoinRequests.clearAll();
            ClientPartyChat.clearAll();
            ClientPartyStatusEffects.clearAll();
            ClientPartyHighlighter.disable();
            if (RPGSystemsConfig.get().systems.title) {
                TitleTextureResolver.clear();
            }
        });
    }

    private static void sendFTBTeamsJoinRequest(class_1657 target) {
        class_310 mc = class_310.method_1551();
        if (mc.method_1562() != null) {
            ClientPlayNetworking.send((class_8710)new PartyJoinRequestPayloads.FTBTeamsJoinRequest(target.method_5667()));
        }
    }
}

